jQuery( document ).ready( function( $ ) {

	$( document ).on( 'click', '.js-reset-page', function() {
		if ( confirm( 'Are you sure you want to reset the content of this page?' ) ) {
			$( this ).text( wpj_vars.please_wait_seconds );

			$.ajax({
				type: "POST",
				url: wpj_vars.ajaxurl,
				data: {
					action : 'reset_page_action',
					post_id: getUrlParameter( 'post' ),
					with_update: 1
				},
				success: function( msg ) {
					location.reload();
				}
			});
		}
	});

	$( document ).on( 'change', '.js-import-page-content', function() {
		if ( confirm( 'Are you sure you want to change the content of this page to the content of the "' + $( this ).find( 'option:selected' ).text() + '" page?' ) ) {
			$( '<span class="spinner compiler-colours-spinner" style="visibility: visible; margin-top: -26px; margin-right: 4px;"></span>' ).insertAfter( $( this ) );
			$( this ).attr( 'disabled', true );

			$.ajax({
				type: "POST",
				url: wpj_vars.ajaxurl,
				data: {
					action : 'reset_page_action',
					post_id: getUrlParameter( 'post' ),
					post_title: $( this ).find( 'option:selected' ).text().replace( 'Single ', '' ),
					with_update: 1
				},
				success: function( msg ) {
					location.reload();
				}
			});
		}
	});

});