/* DROPZONE */

if ( typeof Dropzone == 'function' ) Dropzone.autoDiscover = false;

// Call the dropzone init function
( function ( $ ) {
	$.fn.wpjDropzoneUploaderInit = function() {
		if ( $( '.dropzone' )[0] ) {
			$( '.dropzone' ).each( function() {
				var default_nr = $( this ).attr( 'data-maxnrofpictures' );
				var max_size   = $( this ).attr( 'data-maxsize' );
				var wrapper_id = $( this ).attr( 'id' );

				wpj_init_dropzone_images_uploader( default_nr, max_size, wrapper_id );
			});
		}
	}
} ( jQuery ) );

function wpj_init_dropzone_images_uploader( default_nr, max_size, wrapper_id ) {

	if ( jQuery( '#' + wrapper_id )[0] ) {

		var uploader_purpose = jQuery( '#' + wrapper_id ).attr( 'data-media-type' );

		// remove new image box
		if ( jQuery( '#' + wrapper_id ).attr( 'data-maxnrofpictures' )[0] ) {
			if ( jQuery( '#' + wrapper_id + ' .dz-preview.dz-image-preview.dz-complete' ).length >= jQuery( '#' + wrapper_id ).attr( 'data-maxnrofpictures' ) ) {
				jQuery( "#" + wrapper_id ).addClass( 'max-nr-of-pictures' );
			}
		}

		if ( wpj_vars.allow_video_portfolio == 1 ) {
			var accepted = 'image/*, video/*';
		} else {
			var accepted = 'image/*';
		}

		var images_dropzone = new Dropzone( '#' + wrapper_id, {

			url: wpj_vars.theme_path + '/lib/uploaders/dropzone.php',

			maxFiles       : default_nr,
			maxFilesize    : max_size,
			acceptedFiles  : accepted,
			addRemoveLinks : false,
			thumbnailWidth : uploader_purpose == 'cover' ? 980 : 150,
			thumbnailHeight: uploader_purpose == 'cover' ? 180 : 150,
			clickable      : Hooks.apply_filters( 'wpj_dropzone_clickable_classes_filter', ['#' + wrapper_id] ),

			dictDefaultMessage          : '',
			dictFallbackMessage         : wpj_vars.dictFallbackMessage,
			dictFallbackText            : wpj_vars.dictFallbackText,
			dictFileTooBig              : wpj_vars.dictFileTooBig,
			dictInvalidFileType         : wpj_vars.dictInvalidFileType,
			dictResponseError           : wpj_vars.dictResponseError,
			dictCancelUpload            : wpj_vars.dictCancelUpload,
			dictCancelUploadConfirmation: wpj_vars.dictCancelUploadConfirmation,
			dictRemoveFile              : wpj_vars.dictRemoveFile,
			dictRemoveFileConfirmation  : null,
			dictMaxFilesExceeded        : wpj_vars.dictMaxFilesExceeded,

			accept: function( file, done ) {
				done();
			},

			init: function() {
				this.on( 'addedfile', function() {
					if ( uploader_purpose == 'cover' && this.files[1] != null ) {
						this.removeFile( this.files[0] );
					}
				});

				this.on( 'sending', function( data, xhr, form_data ) {
					form_data.append( 'pid', jQuery( '#' + wrapper_id ).attr( 'data-pid' ) );
					form_data.append( 'uploader_purpose', uploader_purpose );

					// remove new image box
					if ( jQuery( '#' + wrapper_id ).attr( 'data-maxnrofpictures' )[0] ) {
						if ( jQuery( '#' + wrapper_id + ' .dz-preview.dz-image-preview.dz-complete' ).length >= jQuery( '#' + wrapper_id ).attr( 'data-maxnrofpictures' ) ) {
							jQuery( "#" + wrapper_id ).addClass( 'max-nr-of-pictures' );
						}
					}
				});

				this.on( 'success', function( file, response ) {
					// parse response
					var response = jQuery.parseJSON( response );

					if ( response.error !== false ) {

						// remove success class
						jQuery( file.previewElement ).removeClass( 'dz-success' );

						// add error class
						jQuery( file.previewElement ).addClass( 'dz-error' );

						// append error message
						jQuery( file.previewElement ).find( '.dz-error-message > span' ).append( response.error );

						// add file-wrapper class
						jQuery( file.previewElement ).addClass( 'file-wrapper' );

					} else {

						// add data-id attribute
						jQuery( file.previewElement ).attr( 'data-id', response.id );

						// add id attribute
						jQuery( file.previewElement ).attr( 'id', response.id );

						// image full url
						jQuery( file.previewElement ).attr( 'data-url', response.full_url );

						// image thumb url
						jQuery( file.previewElement ).attr( 'data-url-thumb', response.thumb_url );

						// add file-wrapper class
						jQuery( file.previewElement ).addClass( 'file-wrapper' );

					}

					// add remove image corner
					if ( response.id !== 0 )
						jQuery( file.previewElement ).append( '<a data-attachment-id="' + response.id + '" data-media-type="' + uploader_purpose + '" class="js-delete-file delete-file delete-image cursor-pointer"><i class="x icon"></i></a>' );

					else
						jQuery( file.previewElement ).append( '<a href="javascript: void(0);" onclick="jQuery( this ).parents( \'.dz-image-wrapper\' ).remove();" class="js-delete-file delete-file delete-image cursor-pointer"><i class="x icon"></i></a>' );

					// add parent wrapper
					jQuery( file.previewElement ).wrap( '<div class="dz-image-wrapper"></div>' );
				});

				this.on( 'error', function( file, errorMessage, xhr ) {
					// add remove image corner
					jQuery( file.previewElement ).append( '<a data-media-type="' + uploader_purpose + '" class="js-delete-file delete-file delete-image cursor-pointer"><i class="x icon"></i></a>' );

					// add file-wrapper class
					jQuery( file.previewElement ).addClass( 'file-wrapper' );
				});

				this.on( 'complete', function( data, xhr, form_data ) {
					// add or remove new image box
					if ( jQuery( '#' + wrapper_id ).attr( 'data-maxnrofpictures' )[0] ) {
						if ( jQuery( '#' + wrapper_id + ' .dz-preview.dz-image-preview.dz-complete' ).length >= jQuery( '#' + wrapper_id ).attr( 'data-maxnrofpictures' ) )
							jQuery( "#" + wrapper_id ).addClass( 'max-nr-of-pictures' );

						else
							jQuery( "#" + wrapper_id ).removeClass( 'max-nr-of-pictures' );

					}
				});
			}
		});

	}

}

// Display new image box
Hooks.add_action( 'wpj_before_file_removal', wpj_display_dropzone_upload_box, 2 );
function wpj_display_dropzone_upload_box( attachment_id, media_type ) {
	if ( media_type == 'cover' )
		var wrapper_id = jQuery( '.images-uploader-wrapper' ).attr( 'id' );
	else
		var wrapper_id = jQuery( '.cover-uploader-wrapper' ).attr( 'id' );

	if ( wrapper_id && jQuery( '#' + wrapper_id ).attr( 'data-maxnrofpictures' )[0] ) {
		if ( jQuery( '#' + wrapper_id + ' .dz-preview.dz-image-preview.dz-complete' ).length <= jQuery( '#' + wrapper_id ).attr( 'data-maxnrofpictures' ) ) {
			jQuery( "#" + wrapper_id ).removeClass( 'max-nr-of-pictures' );
		}
	}
}