jQuery( document ).ready( function( $ ) {

	var actions = new Map();

	actions.set( "js-as-keep-all-jobs",          { action: "as_make_seller_user_with_job_action"        } );
	actions.set( "js-as-buyer-empty-user-type",  { action: "as_make_buyer_user_with_empty_type_action"  } );
	actions.set( "js-as-seller-empty-user-type", { action: "as_make_seller_user_with_empty_type_action" } );
	actions.set( "js-as-newsletter-lists",       { action: "as_create_newsletter_lists_action"          } );

	actions.forEach( ( action_json, button_class ) => {
		$( document ).on( 'click', '.' + button_class, function() {
			var this_element = $( this );

			this_element.text( 'Sync in progress ...' );
			this_element.addClass( 'disabled' );

			$.ajax({
				type   : "POST",
				url    : wpj_vars.ajaxurl,
				data   : { action: action_json.action },
				success: function() {
					this_element.text( 'Sync' );
					this_element.removeClass( 'disabled' );
				}
			});

		});
	});

	if ( $( '.username.column-username' )[0] ) {
		$( '.username.column-username' ).each( function() {
			if ( $( this ).siblings( '.column-wpjobster_user_type' ).text() == 'Pending Seller' )
				$( this ).find( 'strong' ).append( ' — Pending' );
		});
	}

});