jQuery( document ).ready( function( $ ) {

	$( document ).on( 'click', '.js-job-deactivated', function( e ) {
		$.ajax({
			type: "POST",
			url: wpj_vars.ajaxurl,
			data: { action: 'as_remove_deactivation_reason_action' },
			success: function( data ) {}
		});
	});

	$( document ).on( 'click', '.js-as-become-a-seller-button', function( e ) {
		$( '.ui.message' ).fadeOut( 'slow' );

		if ( wpj_vars.enable_cv_verification == 'no' ) {
			$( '.cv-row-wrapper' ).remove();
		}

		if ( wpj_vars.enable_utility_bill_verification == 'no' ) {
			$( '.utility-bill-row-wrapper' ).remove();
		}

		if ( wpj_vars.enable_national_id_verification == 'no' || ! wpj_vars.display_national_id ) {
			$( '.national-id-row-wrapper' ).remove();
		}

		if ( wpj_vars.enable_company_reg_verification == 'no' || ! wpj_vars.display_company_reg ) {
			$( '.company-row-wrapper' ).remove();
		}

		if ( wpj_vars.enable_linkedin_verification == 'no' ) {
			$( '.linkedin-row-wrapper' ).remove();
		}

		if ( $( '.uploadifive-button' )[0] || $( '.linkedin-row-wrapper' )[0] || $( '.as_ac_linkedin_wrapper' )[0] ) {
			$( '.js-as-become-a-seller-wrapper' ).fadeOut( 'slow', function() {
				$( '.js-as-account-verification-wrapper' ).fadeIn( 'slow' );
			});

		} else {
			$.ajax({
				type   : "POST",
				url    : wpj_vars.ajaxurl,
				data   : "action=as_save_account_verification_info_action&",
				success: function( data ) {
					changeURL( wpj_vars.site_URL );
				}
			});

		}
	});

	$( document ).on( 'click', '.js-save-account-verification-info', function( e ) {
		var $this = $( this );

		$.ajax({
			type   : "POST",
			url    : wpj_vars.ajaxurl,
			data   : "action=as_save_account_verification_info_action&" + $( this ).parents( 'form' ).serialize(),
			success: function( data ) {
				if ( data ) changeURL( wpj_vars.site_URL );
				else $this.notify( wpj_vars.media_blank, { position: 'top center', className: 'error' } );
			}
		});
	});

});

Hooks.add_action( 'wpj_after_form_added_to_page_builder', wpj_as_add_form_to_seller_account_verification_page );
function wpj_as_add_form_to_seller_account_verification_page() {
	if ( jQuery( '.js-as-account-verification-wrapper' )[0] && jQuery( '.kt-inside-inner-col' )[0] )
		jQuery( '.js-as-account-verification-wrapper' ).find( '.kt-inside-inner-col:first > *' ).wrapAll( '<form method="POST"></form>' );
}