jQuery( document ).ready( function( $ ) {

	$( document ).on( 'click', '.js-referral-url-copy', function( e ) {
		e.preventDefault();
		copyString( '.js-referral-generated-url' );
		$( '.js-referral-url-copy' ).notify( wpj_vars.copied, { position: 'top center', className: 'success' } );
	});

	$( document ).on( 'click', '.js-generate-referral-url-btn', function( e ) {
		e.preventDefault();

		if ( $( '.js-referral-input-url' ).val() )
			var link = $( '.js-referral-input-url' ).val() + '?ref=' + $( this ).attr( 'aria-label' );

		else
			var link = wpj_vars.site_URL + '?ref=' + $( this ).attr( 'aria-label' );

		var html_content = '\
			<div class="ui compact menu">\
				<a class="item w100">\
					<span class="js-referral-generated-url">' + link + '</span>\
					<div class="floating ui primary label js-referral-url-copy">\
						<i class="ui copy icon mr0"></i>\
					</div>\
				</a>\
			</div>\
		';

		$( '.js-referral-generated-url-link' ).show().html( html_content );

	});

});

Hooks.add_action( 'wpj_after_page_load_without_refresh', wpj_aff_remove_ref_from_URL );
function wpj_aff_remove_ref_from_URL() {
	if ( getUrlParameter( 'ref' ) ) {
		var url = document.location.href;
		window.history.pushState( {}, "", url.split( "?" )[0] );
	}
}