/* WISE */

jQuery( document ).ready( function( $ ) {
	$( document ).on( 'click', '.js-connect-wise-user', function( e ) {
		e.preventDefault();

		$( this ).addClass( 'disabled' );

		$.ajax({
			type   : "POST",
			url    : wpj_vars.ajaxurl,
			data   : { action: 'generate_recipient_id_action' },
			success: function( response ) {
				$( '.js-connect-wise-user' ).removeClass( 'disabled' );

				if ( ! response ) refreshContent( '.connection-status-wrapper' );
				else $( '.js-wise-connection-status' ).html( response )
			}
		});

	});

	$( document ).on( 'click', '.js-connect-payoneer-user', function( e ) {
		e.preventDefault();

		$( this ).addClass( 'disabled' );

		$.ajax({
			type   : "POST",
			url    : wpj_vars.ajaxurl,
			data   : {
				action: 'connect_user_to_payoneer_action',
				action_type : $( this ).attr( 'name' )
			},
			success: function( response ) {
				$( '.js-connect-payoneer-user' ).removeClass( 'disabled' );

				if ( ! response ) refreshContent( '.connection-status-wrapper' );
				else $( '.js-payoneer-connection-status' ).html( response )
			}
		});

	});
});

Hooks.add_action( 'wpj_after_user_settings_saved', wpj_display_wise_connect_button );
function wpj_display_wise_connect_button() {
	refreshContent( '.connection-status-wrapper' );
}
