jQuery( document ).ready(function( $ ) {
	/* Transaction messages */
	$( document ).on( 'click', '.js-order-video-call-icon', function( e ) {
		e.preventDefault();

		var $this   = $( this );
		var $parent = $this.parent();

		addLoader( '.messages-form-container' );

		jQuery.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: {
				action: 'generate_video_call_link_action',
				order_id : $parent.attr( 'data-order-id' ),
				buyer_id : $parent.attr( 'data-buyer-id' ),
				seller_id: $parent.attr( 'data-seller-id' )
			},
			success: function( response ) {
				window.open( response );

				refreshContent( '#order-notification-messages-wrapper' );
			}
		});
	});

	/* Private messages */
	$( document ).on( 'click', '.js-pm-video-call-icon', function( e ) {
		e.preventDefault();

		$( '.js-pm-video-call-icon' ).attr('style', 'display:none !important');
		$( '.js-pm-video-call-loading-icon' ).css({ display: 'inline-flex' });

		jQuery.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: {
				action: 'generate_video_call_link_action',
				buyer_id : $( '#pm_interlocutor_id' ).val(),
				seller_id: wpj_vars.uid
			},
			success: function( response ) {
				window.open( response );

				// refresh message body div
				refreshContent( '.js-messages-list .kt-inside-inner-col:first' );

				// refresh conversations body div
				refreshContent( '.thread-list-wrapper' );

				// remove no message string
				$( '.error-no-messages' ).remove();

				$( '.js-pm-video-call-loading-icon' ).hide();
				$( '.js-pm-video-call-icon' ).css({ display: 'inline-flex' });
			}
		});
	});

	/* Chat */
	$( document ).on( 'click', '.js-chat-video-call-icon', function( e ) {
		e.preventDefault();

		var $this   = $( this );
		var $parent = $this.parent();
		var box_id  = $this.parents( '.message-box-container' ).attr( "rel" );

		// add loading icon
		$parent.addClass( 'ui button loading' );
		$this.removeClass( 'video' );

		jQuery.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: {
				action: 'generate_video_call_link_action',
				buyer_id : box_id,
				seller_id: wpj_vars.uid
			},
			success: function( response ) {
				// open zoom link
				window.open( response );

				// insert to box
				wpj_chat_insert_message_to_box( box_id, 'Zoom meeting link: ' + response );

				// remove loading icon
				$parent.removeClass( 'ui button loading' );
				$this.addClass( 'video' );

				// clear 'no message' pusher div
				$( this ).parents( '.message-box-wrapper' ).find( '.no-results' ).text( '' );
			}
		});
	});
});