jQuery( document ).ready( function( $ ) {
	// Brizy: stop login/register popup when editing
	if ( wpj_vars.is_user_logged_in && ( getUrlParameter( 'brizy-edit' ) || getUrlParameter( 'brizy-edit-iframe' ) ) ) {
		$( document ).off( 'click', '.login-link' );
		$( document ).off( 'click', '.register-link' );
	}

	// User login - modal
	$( document ).on( 'click', '.login-link', function( e ) {
		if ( $( 'body' ).hasClass( 'wpj-is-jobsterapp' ) ) {
			e.preventDefault();
		} else if ( ! $( '.page-id-' + wpj_vars.login_page_id )[0] && wpj_vars.is_login_page != true ) {
			e.preventDefault();

			var $this = $( this );

			$( '.ui.modal.js-user-login-modal' )
				.modal({
					onVisible: function() {
						// init reCaptcha
						try {
							var widget_id = grecaptcha.render( 'default_login', { 'sitekey' : wpj_vars.reCaptcha_api_key, 'callback' : 'var_default_login_callback', 'hl' : wpj_vars.language_code } );
							$( '#default_login' ).attr( 'data-widget-id', widget_id );

						} catch ( error ) {}

						// resize reCaptcha
						if ( typeof $.fn.wpjResizeReCaptchaInit == 'function' ) {
							$.fn.wpjResizeReCaptchaInit();
						}

						// add redirect_to param
						var redirect_to = window.location.href;

						if (
							$this.attr( 'href' ) !== undefined
							&& $this.attr( 'href' ).includes( 'redirect_to' )
							&& decodeURIComponent( getParameterFromGivenURL( $this.attr( 'href' ), 'redirect_to' ) ) != wpj_vars.auth_login_url
							&& decodeURIComponent( getParameterFromGivenURL( $this.attr( 'href' ), 'redirect_to' ) ) != wpj_vars.auth_register_url
							&& decodeURIComponent( getParameterFromGivenURL( $this.attr( 'href' ), 'redirect_to' ) ) != wpj_vars.auth_lostpassword_url
						) {
							redirect_to = decodeURIComponent( getParameterFromGivenURL( $this.attr( 'href' ), 'redirect_to' ) );

						} else if (
							$this.attr( 'href' ) !== undefined
							&& ! $this.attr( 'href' ).includes( 'redirect_to' )
							&& $this.attr( 'href' ) != wpj_vars.auth_login_url
							&& $this.attr( 'href' ) != wpj_vars.auth_register_url
							&& $this.attr( 'href' ) != wpj_vars.auth_lostpassword_url
						) {
							redirect_to = $this.attr( 'href' );

						}

						if ( redirect_to && wpj_vars.blog_url + '/' != redirect_to ) {
							if ( $( '.js-user-login-modal form' ).find( 'input[name="redirect_to"]' )[0] ) {
								$( 'input[name="redirect_to"]' ).val( redirect_to );

							} else {
								$( '<input type="hidden" name="redirect_to" value="' + redirect_to + '" />' ).appendTo( '.js-user-login-modal form' );

							}
						}
					}
				})
				.modal( 'setting', 'transition', 'fly down' )
				.modal( 'show' )
				.modal( 'refresh' );
		}
	});

	// User register - modal
	$( document ).on( 'click', '.register-link', function( e ) {
		if ( $( 'body' ).hasClass( 'wpj-is-jobsterapp' ) ) {
			e.preventDefault();
		} else if ( ! $( '.page-id-' + wpj_vars.register_page_id )[0] && wpj_vars.is_register_page != true ) {
			e.preventDefault();

			var $this = $( this );

			$( '.ui.modal.js-user-register-modal' )
				.modal({
					onVisible: function() {
						// init reCaptcha
						try {
							var widget_id = grecaptcha.render( 'default_register', { 'sitekey' : wpj_vars.reCaptcha_api_key, 'callback' : 'var_default_register_callback', 'hl' : wpj_vars.language_code } );
							$( '#default_register' ).attr( 'data-widget-id', widget_id );

						} catch ( error ) {}

						// resize reCaptcha
						if ( typeof $.fn.wpjResizeReCaptchaInit == 'function' ) {
							$.fn.wpjResizeReCaptchaInit();
						}

						// add redirect_to param
						var redirect_to = window.location.href;

						if (
							$this.attr( 'href' ) !== undefined
							&& $this.attr( 'href' ).includes( 'redirect_to' )
							&& decodeURIComponent( getParameterFromGivenURL( $this.attr( 'href' ), 'redirect_to' ) ) != wpj_vars.auth_login_url
							&& decodeURIComponent( getParameterFromGivenURL( $this.attr( 'href' ), 'redirect_to' ) ) != wpj_vars.auth_register_url
							&& decodeURIComponent( getParameterFromGivenURL( $this.attr( 'href' ), 'redirect_to' ) ) != wpj_vars.auth_lostpassword_url
						) {
							redirect_to = decodeURIComponent( getParameterFromGivenURL( $this.attr( 'href' ), 'redirect_to' ) );

						} else if (
							$this.attr( 'href' ) !== undefined
							&& ! $this.attr( 'href' ).includes( 'redirect_to' )
							&& $this.attr( 'href' ) != wpj_vars.auth_login_url
							&& $this.attr( 'href' ) != wpj_vars.auth_register_url
							&& $this.attr( 'href' ) != wpj_vars.auth_lostpassword_url
						) {
							redirect_to = $this.attr( 'href' );

						}

						if ( redirect_to && wpj_vars.blog_url + '/' != redirect_to ) {
							if ( $( '.js-user-register-modal form' ).find( 'input[name="redirect_to"]' )[0] ) {
								$( 'input[name="redirect_to"]' ).val( redirect_to );

							} else {
								$( '<input type="hidden" name="redirect_to" value="' + redirect_to + '" />' ).appendTo( '.js-user-register-modal form' );

							}
						}
					}
				})
				.modal( 'setting', 'transition', 'fly down' )
				.modal( 'show' )
				.modal( 'refresh' );
		}
	});

	// User lost password - modal
	$( document ).on( 'click', '.lostpassword-link', function( e ) {
		if ( $( 'body' ).hasClass( 'wpj-is-jobsterapp' ) ) {
			e.preventDefault();
		} else if ( ! $( '.page-id-' + wpj_vars.lost_password_page_id )[0] && wpj_vars.is_lost_password_page != true ) {
			e.preventDefault();

			$( '.ui.modal.js-user-lost-password-modal' )
				.modal( 'setting', 'transition', 'fly down' )
				.modal( 'show' )
				.modal( 'refresh' );
		}
	});

	$( document ).on( 'click', '.js-auth', function( e ) {
		if ( $( 'body' ).hasClass( 'wpj-is-jobsterapp' ) ) {
			e.preventDefault();
		}
	});

	// Clear localstorage on logout
	$( document ).on( 'click', '.log-out', function() {
		localStorage.clear();
	});

	// Show / hide password
	$( document ).on( 'click', '.js-toggle-password-visibility', function( e ) {
		if ( $( this ).hasClass( 'slash' ) ) {
			$( 'input[name="pwd"]' ).attr( 'type', 'password' );
			$( this ).removeClass( 'slash' );

		} else {
			$( 'input[name="pwd"]' ).attr( 'type', 'text' );
			$( this ).addClass( 'slash' );

		}
	});

	// Validate login & register form
	$( document ).on( 'click', '.js-authentication-button, #wp-submit', function( e ) {
		e.preventDefault();

		var $this     = $( this );
		var is_error  = 0;
		var this_form = $this.parents( 'form' );

		$( '.ui.error.message' ).remove();

		// Username
		if ( this_form.find( 'input[name="log"]' )[0] && ! this_form.find( 'input[name="log"]' ).val() ) {
			this_form.find( 'input[name="log"]' ).attr( 'placeholder', wpj_vars.empty_user_name ).addClass( 'error' );
			is_error = 1;
		} else this_form.find( 'input[name="log"]' ).removeClass( 'error' );

		if ( this_form.find( 'input[name="user_login"]' )[0] && ! this_form.find( 'input[name="user_login"]' ).val() ) {
			this_form.find( 'input[name="user_login"]' ).attr( 'placeholder', wpj_vars.empty_user_name ).addClass( 'input error' );
			is_error = 1;
		} else this_form.find( 'input[name="user_login"]' ).removeClass( 'error' );

		// Email
		if ( this_form.find( 'input[name="user_email"]' )[0] && ! this_form.find( 'input[name="user_email"]' ).val() ) {
			this_form.find( 'input[name="user_email"]' ).attr( 'placeholder', wpj_vars.empty_email ).addClass( 'input error' );
			is_error = 1;
		} else this_form.find( 'input[name="user_email"]' ).removeClass( 'error' );

		// Password
		if ( this_form.find( 'input[name="pwd"]' )[0] && ! this_form.find( 'input[name="pwd"]' ).val() ) {
			this_form.find( 'input[name="pwd"]' ).attr( 'placeholder', wpj_vars.empty_password ).addClass( 'error' );
			is_error = 1;
		} else this_form.find( 'input[name="pwd"]' ).removeClass( 'error' );

		if ( this_form.find( 'input[name="user_password"]' )[0] && ! this_form.find( 'input[name="user_password"]' ).val() ) {
			this_form.find( 'input[name="user_password"]' ).attr( 'placeholder', wpj_vars.empty_password ).addClass( 'input error' );
			is_error = 1;
		} else this_form.find( 'input[name="user_password"]' ).removeClass( 'error' );

		if ( this_form.find( 'input[name="user_confirm_password"]' )[0] && ! this_form.find( 'input[name="user_confirm_password"]' ).val() ) {
			this_form.find( 'input[name="user_confirm_password"]' ).attr( 'placeholder', wpj_vars.empty_password ).addClass( 'input error' );
			is_error = 1;
		} else this_form.find( 'input[name="user_confirm_password"]' ).removeClass( 'error' );

		if ( this_form.find( 'input[name="user_password"]' )[0] && this_form.find( 'input[name="user_confirm_password"]' )[0] ) {
			if ( this_form.find( 'input[name="user_password"]' ).val() && this_form.find( 'input[name="user_confirm_password"]' ).val() ) {
				if ( this_form.find( 'input[name="user_password"]' ).val() != this_form.find( 'input[name="user_confirm_password"]' ).val() ) {
					this_form.find( 'input[name="user_password"]' ).addClass( 'error' );
					this_form.find( 'input[name="user_confirm_password"]' ).addClass( 'error' );
					$( '<div class="ui visible error message js-passwords-not-match-error mt0">' + wpj_vars.pwd_not_match + '</div>' ).insertBefore( this_form.find( '.pass_extra_field:first' ) );
					is_error = 1;

				} else {
					this_form.find( 'input[name="user_password"]' ).removeClass( 'error' );
					this_form.find( 'input[name="user_confirm_password"]' ).removeClass( 'error' );

				}
			}
		}

		// Phone
		if ( wpj_vars.phone_number_mandatory ) {
			if ( this_form.find( 'input[name="cell_number"]' )[0] && ! this_form.find( 'input[name="cell_number"]' ).val() ) {
				this_form.find( 'input[name="cell_number"]' ).attr( 'placeholder', wpj_vars.empty_phone_number ).addClass( 'input error' );
				is_error = 1;
			} else this_form.find( 'input[name="cell_number"]' ).removeClass( 'error' );
		}

		// 2FA
		if ( this_form.find( 'input[name="2fa_code"]' )[0] && ! this_form.find( 'input[name="2fa_code"]' ).val() ) {
			this_form.find( 'input[name="2fa_code"]' ).attr( 'placeholder', wpj_vars.empty_two_fa ).addClass( 'input error' );
			is_error = 1;
		} else this_form.find( 'input[name="2fa_code"]' ).removeClass( 'error' );

		// reCaptcha
		if ( this_form.find( '.g-recaptcha-class' )[0] && grecaptcha && grecaptcha.getResponse( this_form.find( '.g-recaptcha-class' ).attr( 'data-widget-id' ) ).length === 0 ) {
			this_form.find( '.g-recaptcha-class > div' ).addClass( 'input error' );
			$( '<div class="ui visible error message js-recaptcha-error">' + wpj_vars.empty_recaptcha + '</div>' ).insertBefore( this_form.find( '.recaptcha_extra_field' ) );
			is_error = 1;
		} else this_form.find( '.g-recaptcha-class > div' ).removeClass( 'input error' );

		// TOS
		if ( this_form.find( 'input[name="wpj_agree_tos_privacy"]' )[0] && ! this_form.find( '.tos-checkbox' ).checkbox( 'is checked' ) ) {
			$( '<div class="ui visible error message js-tos-not-checked-error">' + wpj_vars.tos_not_checked + '</div>' ).insertBefore( this_form.find( '.tos_extra_field' ) );
			is_error = 1;
		}

		is_error = Hooks.apply_filters( 'wpj_validate_register_fields_filter', is_error, this_form );

		if ( is_error == 1 ) { // Is error
			e.preventDefault();
			$( 'html, body, .ui.dimmer' ).animate({ scrollTop : 0 }, 500 );
			$this.parents( '.ui.modal' ).modal( 'refresh' );

		} else { // Is OK
			var action = '';

			if ( $this.parents( 'form' ).attr( 'class' ) ) {

				if ( $this.parents( 'form' ).attr( 'class' ).includes( 'js-register-form' ) )
					action = 'validate_register_form';

				if ( $this.parents( 'form' ).attr( 'class' ).includes( 'js-lostpassword-form' ) )
					action = 'validate_lostpassword_form';

				if ( $this.parents( 'form' ).attr( 'class' ).includes( 'js-login-form' ) )
					action = 'validate_login_form';

			}

			$this.val( wpj_vars.please_wait );
			$this.addClass( 'disabled' );

			if ( action ) {
				setTimeout( function() {
					$.ajax({
						type   : 'POST',
						url    : wpj_vars.ajaxurl,
						data   : "action=" + action + "&" + $this.parents( 'form' ).serialize(),
						async  : false,
						success: function( response ) {
							if ( response['message'] ) {
								$( 'html, body, .ui.dimmer' ).animate({ scrollTop : 0 }, 500 );

								if ( this_form.find( '.g-recaptcha-class' )[0] && grecaptcha !== undefined )
									grecaptcha.reset( this_form.find( '.g-recaptcha-class' ).attr( 'data-widget-id' ) );

								if ( this_form.siblings( '.authentication-title' )[0] )
									$( '<div class="ui visible error message">' + response['message'] + '</div>' ).insertAfter( this_form.siblings( '.authentication-title' ) );

								else if ( this_form.find( '.authentication-title' )[0] )
									$( '<div class="ui visible error message">' + response['message'] + '</div>' ).insertAfter( this_form.find( '.authentication-title' ) );

								$( 'html, body, .ui.dimmer' ).animate({ scrollTop : 0 }, 500 );
								$this.parents( '.ui.modal' ).modal( 'refresh' );

								$this.val( wpj_vars.continue );
								$this.removeClass( 'disabled' );

							} else {
								$this.val( wpj_vars.loggingin );
								this_form.submit();

							}
						},
						error: function( response ) {
							$( 'html, body, .ui.dimmer' ).animate({ scrollTop : 0 }, 500 );
							$this.parents( '.ui.modal' ).modal( 'refresh' );

							$this.val( wpj_vars.continue );
							$this.removeClass( 'disabled' );
						}
					});
				});

			} else {
				this_form.submit();

			}
		}
	});

	$( document ).on( 'click', 'input[name="log"]', function( e ) {
		$( this ).removeClass( 'error' );
		$( this ).attr( 'placeholder', wpj_vars.user_email );
	});

	$( document ).on( 'click', 'input[name="user_login"]', function( e ) {
		$( this ).removeClass( 'error' );
		$( this ).attr( 'placeholder', wpj_vars.user_name );
	});

	$( document ).on( 'click', 'input[name="user_email"]', function( e ) {
		$( this ).removeClass( 'error' );
		$( this ).attr( 'placeholder', wpj_vars.email );
	});

	$( document ).on( 'click', 'input[name="pwd"]', function( e ) {
		$( this ).removeClass( 'error' );
		$( this ).attr( 'placeholder', wpj_vars.password );
	});

	$( document ).on( 'click', 'input[name="user_password"]', function( e ) {
		$( this ).removeClass( 'error' );
		$( this ).attr( 'placeholder', wpj_vars.password );
		$( this ).parents( 'form' ).find( '.ui.error.message.js-passwords-not-match-error' ).remove();
	});

	$( document ).on( 'click', 'input[name="user_confirm_password"]', function( e ) {
		$( this ).removeClass( 'error' );
		$( this ).attr( 'placeholder', wpj_vars.confirm_password );
		$( this ).parents( 'form' ).find( '.ui.error.message.js-passwords-not-match-error' ).remove();
	});

	$( document ).on( 'click', 'input[name="cell_number"]', function( e ) {
		$( this ).removeClass( 'error' );
		$( this ).attr( 'placeholder', wpj_vars.phone_number );
	});

	$( document ).on( 'click', 'input[name="2fa_code"]', function( e ) {
		$( this ).removeClass( 'error' );
		$( this ).attr( 'placeholder', wpj_vars.two_fa );
	});

	$( document ).on( 'change', 'input[name="wpj_agree_tos_privacy"]', function( e ) {
		$( this ).parents( 'form' ).find( '.ui.error.message.js-tos-not-checked-error' ).remove();
	});
});

// WP Form
function wpj_change_authentication_page_data() {
	// Add redirect_to param
	if ( getUrlParameter( 'redirect_to' ) && jQuery( 'input[name="redirect_to"]' )[0] && wpj_vars.blog_url + '/' != getUrlParameter( 'redirect_to' ) ) {
		jQuery( 'input[name="redirect_to"]' ).val( decodeURIComponent( getParameterFromGivenURL( wpj_vars.url_params, 'redirect_to' ) ) );
	}

	// RTL class
	if ( jQuery( 'body' ).hasClass( "rtl" ) && jQuery( ".cell_number" )[0] ) jQuery( ".cell_number" ).parent().addClass( "iti-rtl" );

	// Titles
	jQuery( 'form[name="loginform"], .aiosc-window form[name="loginform"]' ).prepend( '<h2 class="authentication-title">' + wpj_vars.login + '</h2>' );
	jQuery( 'form[name="registerform"]' ).prepend( '<h2 class="authentication-title">' + wpj_vars.register + '</h2>' );
	jQuery( 'form[name="lostpasswordform"]' ).prepend( '<h2 class="authentication-title">' + wpj_vars.forgot + '</h2>' );
	jQuery( 'form[name="resetpassform"]' ).prepend( '<h2 class="authentication-title">' + wpj_vars.reset + '</h2>' );

	// Fields
	jQuery( '#loginform' ).addClass( 'ui form js-login-form' );
	jQuery( '#registerform' ).addClass( 'ui form js-register-form' );
	jQuery( '#lostpasswordform' ).addClass( 'ui form js-lostpassword-form' );

	// Button
	jQuery( '#loginform input[type="submit"]' ).addClass( 'ui fluid primary-button' );
	jQuery( '#registerform input[type="submit"]' ).addClass( 'ui fluid primary-button' );
	jQuery( '#lostpasswordform input[type="submit"]' ).addClass( 'ui fluid primary-button' );

	jQuery( '#loginform input[type="submit"]' ).attr( 'value', wpj_vars.continue );
	jQuery( '#registerform input[type="submit"]' ).attr( 'value', wpj_vars.continue );
	jQuery( '#lostpasswordform input[type="submit"]' ).attr( 'value', wpj_vars.continue );

	// PlaceHolders
	jQuery( '#loginform input[name="log"]' ).attr( 'placeholder', wpj_vars.user_email );
	jQuery( '#loginform input[name="user_login"]' ).attr( 'placeholder', wpj_vars.user_email );
	jQuery( '#registerform input[name="user_login"]' ).attr( 'placeholder', wpj_vars.user_name );
	jQuery( '#lostpasswordform input[name="user_login"]' ).attr( 'placeholder', wpj_vars.user_email );

	jQuery( '#loginform input[name="user_email"]' ).attr( 'placeholder', wpj_vars.email );
	jQuery( '#registerform input[name="user_email"]' ).attr( 'placeholder', wpj_vars.email );

	jQuery( '#loginform input[name="pwd"]' ).attr( 'placeholder', wpj_vars.password );
	jQuery( '#loginform input[name="user_confirm_password"]' ).attr( 'placeholder', wpj_vars.confirm_password );
	jQuery( '#resetpassform input[name="pass1"]' ).attr( 'placeholder', wpj_vars.new_password );

	jQuery( '#loginform input[name="cell_number"]' ).attr( 'placeholder', wpj_vars.phone_number );

	jQuery( '#loginform input[name="user_company"]' ).attr( 'placeholder', wpj_vars.company );

	// Move content after submit button
	jQuery( '.login-outer-wrapper' ).detach().appendTo( '.js-login-form' );
	jQuery( '.register-outer-wrapper' ).detach().appendTo( '.js-register-form' );

	// Add ui checkbox to reset with week password
	jQuery( '.pw-weak > *' ).wrapAll( '<div class="ui checkbox"></div>' );

	// Remove space
	jQuery( '.clear' ).remove();
}

function wpj_add_password_visibility_icon_to_login_form() {
	if ( ! jQuery( '.login-password' ).find( '.js-toggle-password-visibility' )[0] ) {
		jQuery( '.login-password' ).addClass( 'pr' ).find( 'input[name="pwd"]' ).after( '<i class="eye icon password-visibility js-toggle-password-visibility"></i>' );
	}
}