jQuery( document ).ready( function( $ ) {
	// Job Carousel - Slider - Lazy Load
	$( document ).on( 'click', '.nav-next, .nav-prev, .slick-next, .slick-prev, .owl-next, .owl-prev', function( e ) {
		if ( typeof $.fn.wpjLazyLoadRender == 'function' ) $.fn.wpjLazyLoadRender();
	});

	// Go to job link when card is video and the play button is not pressed
	$( document ).on( 'click', '.owl-video-wrapper', function( e ) {
		if ( $( this ).parents( '.wpj-card-style-3' ).length > 0 || $( this ).parents( '.wpj-card-style-4' ).length > 0 ) {
			if ( e.target !== e.currentTarget ) return false;

			var card_link = $( this ).parents( '.image' ).siblings( '.job-area' ).find( '.list-header' ).attr( 'href' );
			if ( card_link ) window.location.href = card_link;
		}
	});
});

// General OWL Carousel
function wpj_initialize_wpj_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.wpj-carousel' )[0] ) {
		jQuery( '.wpj-carousel' ).owlCarousel({
			rtl            : is_rtl,
			loop           : false,
			margin         : 14,
			nav            : true,
			dots           : false,
			navText        : ['<i class="icon angle left">', '<i class="icon angle right">'],
			lazyLoad       : true,
			video          : true,
			URLhashListener: true,
			startPosition  : 'URLHash',
			responsive     : {
				0: {
					items: 1
				}
			},
			onTranslated : function( e ) {
				var current   = e.item.index;
				var this_item = jQuery( e.target ).find( '.owl-item' ).eq( current );

				this_item.find( '.owl-video-wrapper' ).find( 'iframe' ).siblings( '.owl-video-play-icon' ).remove();

				// add active class to preview image job carousel
				if ( jQuery( '.image-gallery-slider-pager' )[0] ) {
					jQuery( '.image-gallery-slider-pager' ).find( 'a' ).removeClass( 'active' );
					jQuery( '.image-gallery-slider-pager' ).find( 'a[href=#slide' + ( current + 1 ) + ']' ).addClass( 'active' );
				}
			},
			onInitialized : function( e ) {
				// add active class to preview image job carousel
				if ( jQuery( '.image-gallery-slider-pager' )[0] ) {
					var slides  = e.relatedTarget;
					var current = slides.current();

					jQuery( '.image-gallery-slider-pager' ).find( 'a' ).removeClass( 'active' );
					jQuery( '.image-gallery-slider-pager' ).find( 'a[href=#slide' + ( current + 1 ) + ']' ).addClass( 'active' );
				}

				if ( jQuery( '.wpj-card-style-3' ).find( '.card-image-clipper' ).siblings( '.wpj-carousel' )[0] ) {
					jQuery( '.wpj-card-style-3' ).find( '.card-image-clipper' ).remove();
				}

				if ( jQuery( '.wpj-card-style-4' ).find( '.card-image-clipper' ).siblings( '.wpj-carousel' )[0] ) {
					jQuery( '.wpj-card-style-4' ).find( '.card-image-clipper' ).remove();
				}
			}
		});
	}
}

// News Carousel
function wpj_initialize_news_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-news-carousel' )[0] ) {
		jQuery( '.js-news-carousel' ).owlCarousel({
			rtl       : is_rtl,
			loop      : false,
			margin    : 10,
			nav       : true,
			dots      : false,
			navText   : ['<i class="icon angle left">', '<i class="icon angle right">'],
			lazyLoad  : true,
			responsive: {
				0: {
					margin: 10,
					items : Hooks.apply_filters( 'wpj_news_items_mobile_filter', 1 )
				},
				600: {
					items: Hooks.apply_filters( 'wpj_news_items_tablet_filter', 2 )
				},
				1200: {
					margin: 40,
					items : Hooks.apply_filters( 'wpj_news_items_desktop_filter', 3 )
				}
			}
		});
	}
}

// Job Slider Carousel
function wpj_initialize_jobs_slider_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-jobs-carousel' )[0] ) {
		jQuery( '.js-jobs-carousel' ).owlCarousel({
			rtl       : is_rtl,
			loop      : false,
			margin    : 16,
			nav       : true,
			lazyLoad  : true,
			dots      : false,
			navText   : ['<i class="icon angle left">', '<i class="icon angle right">'],
			navClass  : ['nav-prev', 'nav-next'],
			responsive: {
				0: {
					items: Hooks.apply_filters( 'wpj_job_slider_items_mobile_filter', 1 )
				},
				480:{
					items: Hooks.apply_filters( 'wpj_job_slider_items_480_filter', 2 )
				},
				1200: {
					items: Hooks.apply_filters( 'wpj_job_slider_items_1024_filter', 4 )
				}
			}
		});
	}
}

// User Portfolio
function wpj_initialize_portfolio_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-image-attachments-carousel' )[0] ) {
		var owl = jQuery( '.js-image-attachments-carousel' );

		owl.owlCarousel({
			rtl       : is_rtl,
			loop      : false,
			margin    : 30,
			nav       : true,
			dots      : false,
			lazyLoad  : true,
			navText   : ['<i class="icon angle left">', '<i class="icon angle right">'],
			navClass  : ['nav-prev', 'nav-next'],
			video: true,
			responsive: {
				0: {
					items: 1
				},
				767: {
					items: 3
				},
				1200: {
					items: 3
				}
			},
			onInitialized : function( e ) {
				if ( jQuery( '.js-image-attachments-carousel' ).find ( 'video' )[0] ) {
					jQuery( '.js-image-attachments-carousel' ).find ( 'video' ).height( jQuery( '.js-image-attachments-carousel' ).find ( 'img' ).first().height() );
				}
			}
		});

		owl.on( 'resized.owl.carousel', function() {
			if ( jQuery( '.js-image-attachments-carousel' ).find ( 'video' )[0] ) {
				jQuery( '.js-image-attachments-carousel' ).find ( 'video' ).height( jQuery( '.js-image-attachments-carousel' ).find ( 'img' ).first().height() );
			}
		});
	}
}

// Home Hero Slider Public
function wpj_initialize_home_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-wpj-home-hero-slider' )[0] ) {
		jQuery( '.js-wpj-home-hero-slider' ).owlCarousel({
			rtl          : is_rtl,
			loop         : true,
			margin       : 0,
			nav          : true,
			navText      : ['<i class="icon angle left">', '<i class="icon angle right">'],
			dots         : false,
			video        : true,
			items        : 1,
			responsive: {
				0: {
					nav: false
				},
				767: {
					nav: true
				},
			},
			onTranslated : function( e ) {},
			onInitialized: function( e ) {}
		});
	}
}

// Photo Categories Carousel
function wpj_initialize_photo_categories_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-wpj-photo-categories-carousel' )[0] ) {
		jQuery( '.js-wpj-photo-categories-carousel' ).owlCarousel({
			rtl       : is_rtl,
			loop      : true,
			margin    : 25,
			nav       : true,
			dots      : false,
			lazyLoad  : true,
			navText   : ['<i class="icon angle left">', '<i class="icon angle right">'],
			navClass  : ['nav-prev', 'nav-next'],
			responsive: {
				0: {
					items: 1
				},
				767: {
					items: 3
				},
				1280: {
					items: 4
				},
				1400: {
					items: 5
				}
			}
		});
	}
}

// Jobs Images Carousel
function wpj_initialize_jobs_images_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-wpj-jobs-images-carousel' )[0] ) {
		jQuery( '.js-wpj-jobs-images-carousel' ).owlCarousel({
			rtl       : is_rtl,
			loop      : false,
			margin    : 10,
			nav       : true,
			dots      : false,
			lazyLoad  : true,
			navText   : ['<i class="icon angle left">', '<i class="icon angle right">'],
			navClass  : ['nav-prev', 'nav-next'],
			responsive: {
				0: {
					items: 1,
					margin: 10
				},
				767: {
					items: 3
				},
				1400: {
					items: 4,
					margin: 30
				}
			}
		});
	}
}

// Homepage Loggedin Categories Icons Carousel
function wpj_initialize_category_icons_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-carousel-content' )[0] ) {
		jQuery( '.js-carousel-content' ).owlCarousel({
			rtl       : is_rtl,
			loop      : true,
			margin    : 25,
			nav       : true,
			dots      : false,
			lazyLoad  : true,
			navText   : ['<i class="icon angle left">', '<i class="icon angle right">'],
			navClass  : ['nav-prev', 'nav-next'],
			responsive: {
				0: {
					items: 1
				},
				500: {
					items: 2
				},
				768: {
					items: 1
				},
				1024: {
					items: 2
				},
				1300: {
					items: 3
				}
			}
		});
	}
}

// News Hero Slide
function wpj_initialize_news_hero_slider( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-news-hero-slider' )[0] ) {
		jQuery( '.js-news-hero-slider' ).owlCarousel({
			rtl       : is_rtl,
			loop      : true,
			margin    : 0,
			nav       : true,
			dots      : false,
			navText   : ['<i class="icon angle left">', '<i class="icon angle right">'],
			lazyLoad  : true,
			items: 1
		});
	}
}

// User Reviews Carousel
function wpj_initialize_user_reviews_carousel( is_rtl ) {
	if ( typeof is_rtl === 'undefined' ) is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

	if ( jQuery( '.js-user-reviews-carousel' )[0] ) {
		jQuery( '.js-user-reviews-carousel' ).owlCarousel({
			rtl       : is_rtl,
			loop      : true,
			margin    : 0,
			nav       : true,
			dots      : false,
			navText   : ['<i class="icon angle left">', '<i class="icon angle right">'],
			lazyLoad  : true,
			autoHeight: true,
			items: 1
		});
	}
}