jQuery( document ).ready( function( $ ) {
	$( document ).on( 'click', '.category-direction-left', function() {
		let ul_element               = $('.subcategory-listing.subcategory-listing-slider ul' );
		let prev_subcategory         = ul_element.find( 'li:visible:first' ).prev();
		let last_visible_subcategory = ul_element.find( 'li:visible:last' );

		if ( prev_subcategory.length >= 1 ) {
			prev_subcategory.show();
			last_visible_subcategory.hide();

			$( '.category-direction-right' ).removeClass( 'div-disabled' );
		}

		if ( prev_subcategory.prev().length < 1 ) {
			$( this ).addClass( 'div-disabled' );
		}
	});

	$( document ).on( 'click', '.category-direction-right', function() {
		let ul_element             = $('.subcategory-listing.subcategory-listing-slider ul' );
		let next_category          = ul_element.find( 'li:visible:last' ).next();
		let first_visible_category = ul_element.find( 'li:visible:first' );

		if ( next_category.length >= 1 ) {
			first_visible_category.hide();
			next_category.show();

			$( '.category-direction-left' ).removeClass( 'div-disabled' );
		}

		if ( next_category.next().length < 1 ) {
			$( this ).addClass( 'div-disabled' );
		}
	});
});

function wpj_display_fully_visible_subcategoires() {
	if ( jQuery( '.subcategory-listing[data-slider="1"]' )[0] ) {
		let ul_element = jQuery( '.subcategory-listing ul' );
		let li_element = ul_element.children( 'li' );

		let ul_width = ul_element.width()
		let li_width = 0;

		li_element.each( function() {
			li_width += jQuery( this ).width();

			if ( li_width <= ul_width ) {
				jQuery( this ).css( 'display', 'block' );

			} else {
				jQuery( this ).css( 'display', 'none' );

			}
		});

		if ( ( li_width + 10 ) >= ul_width ) {
			jQuery( '.subcategory-listing[data-slider="1"]' ).addClass( 'subcategory-listing-slider' );
			jQuery( '.subcategory-listing[data-slider="1"]' ).find( '.arrows-wrapper' ).show();

		} else {
			jQuery( '.subcategory-listing[data-slider="1"]' ).removeClass( 'subcategory-listing-slider' );
			jQuery( '.subcategory-listing[data-slider="1"]' ).find( '.arrows-wrapper' ).hide();

		}
	}
}