jQuery( window ).ready( function( $ ) {
	// Add / Remove job multiples
	$( document ).on( 'click', '.amount_add, .amount_rmv', function( e ) {
		e.preventDefault();

		// Set checkbox as checked
		$( this ).parents( '.item' ).find( '.ui.checkbox' ).checkbox( 'set checked' );

		// Verify if current value is number
		var current_quantity = $( this ).siblings( '.current_amount' ).val();
		if ( ! current_quantity || isNaN( current_quantity ) ) { current_quantity = 1; }

		// Increase or decrease the value
		current_quantity = $( this ).hasClass( 'amount_add' ) ? parseInt( current_quantity ) + 1 : parseInt( current_quantity ) - 1;

		// Verify if value is greather or equal with 1
		if ( current_quantity < 1 ) { current_quantity = 1; }

		// Verify if value is lower than max accepted value
		var max_quantity = $( this ).siblings( '.current_amount' ).attr( 'data-max' );
		if ( current_quantity > max_quantity ) { current_quantity = max_quantity; }

		// Set new qunatity for extras front
		var item_name = $( this ).siblings( '.current_amount' ).attr( 'name' );
		$( 'input[name="' + item_name + '"]' ).val( current_quantity );

		// Set new qunatity for extras back
		$( this ).parents( '.item' ).find( "[type=checkbox]" ).val( current_quantity );

		var extra_nr = $( this ).parents( '.item' ).attr( 'data-extranr' );
		$( '.item[data-extranr=' + extra_nr + ']' ).attr( 'data-extraamount', current_quantity );

		// Set new quantity for free job
		if ( $( "#getforfree" ).length != 0 ) { $( "#getforfree" ).attr( 'href', $( "#getforfree" ).attr( 'href' ).replace( /amount=[^&]+/, 'amount=' + current_quantity ) ); }

		// Change EFD quantity by job quantity if EFD is checked
		if ( $( this ).parents( '.amount_section' ).find( '.current_amount' ).hasClass( 'main_value_inp' ) && $( '.chk_extrafast' ).parents( '.ui.checkbox' )[0] && $( '.chk_extrafast' ).parents( '.ui.checkbox' ).checkbox( 'is checked' ) ) {
			if ( current_quantity < parseInt( $( '.hid_extrafast' ).data( "max" ) ) ) {
				$( ".chk_extrafast" ).val( current_quantity );
				$( ".hid_extrafast" ).val( current_quantity );
			}
		}

		// Update the price
		wpj_update_purchase_price( 'job_purchase' );
	});

	// Prevents the customer from inserting a wrong value to qunatity
	$( document ).on( 'click keyup keypress blur change', '.current_amount', function( e ) {
		// Set checkbox as checked
		$( this ).parents( '.item' ).find( ".ui.checkbox" ).checkbox( "set checked" );

		var max_quantity = $( this ).attr( 'data-max' );

		var current_quantity = $( this ).val();

		// Set max allowed value
		if ( parseInt( $( this ).val() ) > max_quantity ) { current_quantity = max_quantity; }

		// Set new qunatity for extras front
		var item_name = $( this ).attr( 'name' );
		$( 'input[name="' + item_name + '"]' ).val( current_quantity );

		// Set new qunatity for extras back
		$( this ).parents( '.item' ).find( "[type=checkbox]" ).val( current_quantity );

		var extra_nr = $( this ).parents( '.item' ).attr( 'data-extranr' );
		$( '.item[data-extranr=' + extra_nr + ']' ).attr( 'data-extraamount', current_quantity );

		// Set new quantity for free job
		if ( $( this ).parents( '.amount_section' ).find( '.current_amount' ).hasClass( 'main_value_inp' ) ) {
			if ( $( "#getforfree" ).length != 0 ) { $( "#getforfree" ).attr( 'href', $( "#getforfree" ).attr( 'href' ).replace( /amount=[^&]+/, 'amount=' + current_quantity ) ); }
		}

		// Update the price
		wpj_update_purchase_price( 'job_purchase' );
	});

	// Update extra fast delivery by quantity
	$( document ).on( 'change', '.chk_extrafast', function( e ) {
		var current_quantity = parseInt( $( ".js-job-quantity-wrapper .main_value_inp" ).val() );

		if ( ! current_quantity || isNaN( current_quantity ) ) { current_quantity = 1; }

		if ( $( '.chk_extrafast' ).parents( '.ui.checkbox' )[0] && $( '.chk_extrafast' ).parents( '.ui.checkbox' ).checkbox( 'is checked' ) ) {
			if ( current_quantity < parseInt( $( '.hid_extrafast' ).data( "max" ) ) ) {
				$( ".chk_extrafast" ).val( current_quantity );
				$( ".hid_extrafast" ).val( current_quantity );
			} else {
				$( ".chk_extrafast" ).val( parseInt( $( '.hid_extrafast' ).data( "max" ) ) );
				$( ".hid_extrafast" ).val( parseInt( $( '.hid_extrafast' ).data( "max" ) ) );
			}
		}
	});

	// Change both (sidebar/normal) checkbox when one is changed
	$( document ).on( 'change', '.uzextracheck[type=checkbox]', function( e ) {
		var ob = $( "[name=" + $( this ).attr( "name" ) + "]" );

		if ( $( this ).parents( '.ui.checkbox' )[0] && $( this ).parents( '.ui.checkbox' ).checkbox( 'is checked' ) ) {
			ob.parents( '.ui.checkbox' ).checkbox( 'set checked' );
		} else {
			ob.parents( '.ui.checkbox' ).checkbox( 'set unchecked' );
		}

		// Update the price
		wpj_update_purchase_price( 'job_purchase' );
	});

	// Featured / Badge / Topup / Subscription - check/uncheck
	$( document ).on( 'change', '.featured_chk[type="checkbox"], .badge_chk[type="radio"], .topup_chk[type="radio"], input[name="sub_id"]', function( e ) {
		if ( ! $( '.ui.message' ).hasClass( 'hidden' ) ) $( '.ui.message' ).addClass( 'hidden' );

		if ( $( this ).attr( 'name' ) == 'sub_id' ) var payment_type = 'subscription';
		else if ( $( this ).attr( 'name' ) == 'feature_pages[]' ) var payment_type = 'featured';
		else if ( $( this ).attr( 'name' ) == 'badges' ) var payment_type = 'badge';
		else if ( $( this ).attr( 'name' ) == 'topup' ) var payment_type = 'topup';

		if ( payment_type !== 'undefined' ) {
			// Update the price
			wpj_update_purchase_price( payment_type );

			if ( payment_type == 'subscription' ) {
				var sd_arr  = $( this ).val().split( '-' );

				var sub_typ = sd_arr[0];
				var sub_lvl = sd_arr[1];

				// Get price
				var sub_amt = $( this ).siblings( '.checkbox-wrapper' ).children( '.level-amount' ).html();
				if ( sub_amt ) sub_amt = $.trim( sub_amt );

				// Remove class active from all levels
				$( '.level0, .level1, .level2, .level3' ).removeClass( 'active' );

				// Add active class to selected level
				$( '.' + sub_lvl ).addClass( 'active' ).html( sub_amt );
			}
		}

		return false;
	});

});

function wpj_update_purchase_price( purchase_type ) {
	if ( typeof purchase_type === 'undefined' ) {
		if ( jQuery( '.page-id-' + wpj_vars.my_payments_page_id )[0] ) {
			purchase_type = 'topup';

		} else if ( jQuery( '.page-id-' + wpj_vars.badge_page_id )[0] ) {
			purchase_type = 'badge';

		} else if ( jQuery( '.page-id-' + wpj_vars.subscription_page_id )[0] ) {
			purchase_type = 'subscription';

		} else if ( jQuery( '.page-id-' + wpj_vars.featured_page_id )[0] ) {
			purchase_type = 'featured';

		} else if ( jQuery( '.page-id-' + wpj_vars.checkout_page_id )[0] ) {
			if ( jQuery( 'input[name="custom_extra"]' )[0] ) purchase_type = 'custom_extra';
			else if ( jQuery( 'input[name="tips"]' )[0] ) purchase_type = 'tips';
			else purchase_type = 'job_purchase';

		} else {
			purchase_type = 'job_purchase';

		}
	}

	if ( jQuery( ".total" )[0] ) {
		jQuery( ".total" ).each( function() {
			var total = 0;
			var $total = jQuery( this );

			if ( purchase_type == 'job_purchase' || purchase_type == 'custom_extra' || purchase_type == 'tips' ) {
				var total = Number( $total.data( "price" ) );

			} else if ( purchase_type == 'featured' ) {
				var s_total      = 0;
				var master_total = 0;

				jQuery( '.featured_chk[type="checkbox"]' ).each( function() {
					var ob = jQuery( "#" + this.id );

					if ( jQuery( this ).parents( '.ui.checkbox' )[0] && jQuery( this ).parents( '.ui.checkbox' ).checkbox( 'is checked' ) ) {
						s_total      = Number( ob.data( "price" ) );
						master_total = master_total + s_total;

						ob.parents( '.ui.checkbox' ).checkbox( 'set checked' );

					} else {
						ob.parents( '.ui.checkbox' ).checkbox( 'set unchecked' );

					}
				});

				var total = master_total;

			} else if ( purchase_type == 'badge' ) {
				var s_total      = 0;
				var master_total = 0;

				jQuery( '.badge_chk[type="radio"]' ).each( function() {
					var ob = jQuery( "#" + this.id );

					if ( jQuery( this ).parents( '.ui.checkbox' )[0] && jQuery( this ).parents( '.ui.checkbox' ).checkbox( 'is checked' ) ) {
						s_total      = Number( ob.data( 'price' ) );
						master_total = master_total + s_total;

						ob.parents( '.ui.checkbox' ).checkbox( 'set checked' );
					} else {
						ob.parents( '.ui.checkbox' ).checkbox( 'set unchecked' );

					}
				});

				var total = master_total;

			} else if ( purchase_type == 'subscription' ) {
				var s_total      = 0;
				var master_total = 0;

				jQuery( 'input[name="sub_id"]' ).each( function() {
					if ( jQuery( this ).parents( '.ui.checkbox' )[0] && jQuery( this ).parents( '.ui.checkbox' ).checkbox( 'is checked' ) ) {
						s_total      = jQuery( this ).siblings( 'input[name="sub_amt"]' ).val();
						master_total = master_total + parseFloat( s_total );
					}
				});

				var total = master_total;

			} else if ( purchase_type == 'topup' ) {
				var s_total      = 0;
				var master_total = 0;

				jQuery( '.topup_chk[type="radio"]' ).each( function() {
					var ob = jQuery( "#" + this.id );

					if ( jQuery( this ).parents( '.ui.checkbox' )[0] && jQuery( this ).parents( '.ui.checkbox' ).checkbox( 'is checked' ) ) {
						s_total      = Number( ob.data( "price" ) );
						master_total = master_total + s_total;

						ob.parents( '.ui.checkbox' ).checkbox( 'set checked' );

					} else {
						ob.parents( '.ui.checkbox' ).checkbox( 'set unchecked' );

					}

				});

				var total = master_total;
			}

			var shipping              = $total.data( "shipping" ) || 0;
			var cur                   = $total.data( "cur" );
			var symbol                = $total.data( "symbol" ) || cur;
			var position              = $total.data( "position" ) || '';
			var space                 = $total.data( "space" ) || 'yes';
			var decimal               = $total.data( "decimal" ) || '.';
			var thousands             = $total.data( "thousands" ) || ',';
			var decimaldisplay        = $total.data( "decimaldisplay" ) || 'default';
			var processingfeesenable  = $total.data( "processingfeesenable" ) || 'disabled';
			var processingfeesfixed   = Number( $total.data( "processingfeesfixed" ) ) || 0;
			var processingfeespercent = $total.data( "processingfeespercent" ) || 0;
			var taxover               = $total.data( "taxover" ) || '';
			var tax                   = $total.data( "tax" ) || 0;
			var zerowithfree          = $total.data( "zerowithfree" ) || '';
			var freestr               = $total.data( "freestr" ) || 'Free';
			var amount;

			var space_str = "";
			if ( space == "yes" ) space_str = " ";

			// Job Price & Extras
			if ( purchase_type == 'job_purchase' ) {
				// Job Quantity
				if ( Number( jQuery( "[name=myFormPurchase] .main_value_inp" ).val() ) ) {
					total = total * Number( jQuery( "[name=myFormPurchase] .main_value_inp" ).val() );
				}

				// Extras
				jQuery( '[name=myFormPurchase]:first' ).find( ".extra-item" ).each( function() {
					if ( jQuery( this ).find( '.ui.checkbox' )[0] && jQuery( this ).find( '.ui.checkbox' ).checkbox( 'is checked' ) ) {
						// Amount
						var extra_amount = Number( jQuery( this ).find( '.ui.checkbox' ).children( '.uzextracheck' ).attr( 'data-price' ) );

						// Multiple
						var extra_multiple = extra_amount * Number( jQuery( this ).attr( 'data-extraamount' ) );

						total = total + extra_multiple;
					}
				});
			}

			// Set data job price including extras
			$total.attr( 'data-price-with-extras', total );

			total = Hooks.apply_filters( 'wpj_checkout_total_price_filter', total, $total );

			if ( total < 0 ) total = 0;

			var chargeable_total = total;

			// Shipping
			shipping = purchase_type == 'job_purchase' ? Number( shipping ) : 0;
			chargeable_total = total + shipping;

			if ( purchase_type == 'job_purchase' || purchase_type == 'custom_extra' || purchase_type == 'tips' || purchase_type == 'featured' ) {
				// Processing Fee
				var processingfee_total = 0;

				if ( processingfeesenable != 'disabled' ) {
					if ( processingfeesenable == 'percent' ) {
						if ( processingfeespercent > 0 ) {
							processingfee_total = ( total + shipping ) * processingfeespercent / 100;

						} else {
							processingfee_total = 0;

						}
					}

					if ( processingfeesenable == 'fixed' ) {
						processingfee_total = processingfeesfixed;
					}

					// display processing fees
					var formatted_processingfee = String( processingfee_total.formatMoney( 2, decimal, thousands ) );

					if ( decimaldisplay == "ifneeded" ) {
						if ( isInt( processingfee_total ) ) {
							formatted_processingfee = String( processingfee_total.formatMoney( 0, decimal, thousands ) );

						} else {
							formatted_processingfee = String( processingfee_total.formatMoney( 2, decimal, thousands ) );

						}
					} else if ( decimaldisplay == "never" ) {
						formatted_processingfee = String( processingfee_total.formatMoney( 0, decimal, thousands ) );

					}

					if ( position == "front" ) {
						jQuery( ".processingfee-amount" ).html( symbol + space_str + formatted_processingfee );

					} else {
						jQuery( ".processingfee-amount" ).html( formatted_processingfee + space_str + symbol );

					}
				}

				// processing fees only apply when price > 0
				if ( chargeable_total > 0 ) {
					chargeable_total = chargeable_total + Number( processingfee_total );
				}

				// Tax
				var tax_amount = 0;

				if ( tax != '0' ) {
					var tax_chargeable_total = 0;

					if ( taxover == 'processing_fee' ) {
						tax_chargeable_total = processingfee_total;

					} else if ( taxover == 'job_and_pf' ) {
						tax_chargeable_total = total + processingfee_total + shipping;

					} else {
						tax_chargeable_total = total + shipping;

					}

					tax_amount = tax_chargeable_total * tax / 100;

					// display tax
					var formatted_tax = String( tax_amount.formatMoney( 2, decimal, thousands ) );

					if ( decimaldisplay == "ifneeded" ) {
						if ( isInt( tax_amount ) ) {
							formatted_tax = String( tax_amount.formatMoney( 0, decimal, thousands ) );

						} else {
							formatted_tax = String( tax_amount.formatMoney( 2, decimal, thousands ) );

						}

					} else if ( decimaldisplay == "never" ) {
						formatted_tax = String( tax_amount.formatMoney( 0, decimal, thousands ) );

					} else {
						formatted_tax = String( tax_amount.formatMoney( 2, decimal, thousands ) );

					}

					if ( position == "front" ) {
						jQuery( ".tax-amount" ).html( symbol + space_str + formatted_tax );

					} else {
						jQuery( ".tax-amount" ).html( formatted_tax + space_str + symbol );

					}
				}

				// tax only applies when price > 0
				if ( chargeable_total > 0 ) {
					chargeable_total = chargeable_total + tax_amount;
				}
			}

			// set data total price
			$total.attr( 'data-total', chargeable_total );

			var formatted_money = '';

			if ( decimaldisplay == "ifneeded" ) {
				if ( isInt( chargeable_total ) ) {
					formatted_money = String( chargeable_total.formatMoney( 0, decimal, thousands ) );

				} else {
					formatted_money = String( chargeable_total.formatMoney( 2, decimal, thousands ) );

				}

			} else if ( decimaldisplay == "never" ) {
				formatted_money = String( chargeable_total.formatMoney( 0, decimal, thousands ) );

			} else {
				formatted_money = String( chargeable_total.formatMoney( 2, decimal, thousands ) );

			}

			if ( position == "front" ) {
				if ( total > 0 ) {
					$total.html( symbol + space_str + formatted_money );

				} else {
					if ( zerowithfree === 'yes' ) {
						$total.html( freestr );

					} else {
						$total.html( symbol + space_str + formatted_money );

					}
				}

			} else {
				if ( chargeable_total > 0 ) {
					$total.html( formatted_money + space_str + symbol );

				} else {
					if ( zerowithfree === 'yes' ) {
						$total.html( freestr );

					} else {
						$total.html( formatted_money + space_str + symbol );

					}
				}
			}

			// Hide payment methods if job is free
			if ( chargeable_total <= 0 || isNaN( chargeable_total ) ) {
				jQuery( '.js-credits' ).text( wpj_vars.get_for_free );
				jQuery( '.payment-buttons' ).hide();

				if (
					purchase_type == 'job_purchase'
					|| purchase_type == 'custom_extra'
					|| ( purchase_type == 'badge' && jQuery( 'input:checked[name="badges"]' )[0] )
				) {
					jQuery( '.payment-buttons' ).css({ display: "flex" });
					jQuery( '.js-credits' ).siblings().hide();
				}

			} else {
				jQuery( '.js-credits' ).text( wpj_vars.account_balance );
				jQuery( '.payment-buttons' ).css({ display: "flex" });

				if (
					purchase_type == 'job_purchase'
					|| purchase_type == 'custom_extra'
					|| ( purchase_type == 'badge' && jQuery( 'input:checked[name="badges"]' )[0] )
				) {
					jQuery( '.js-credits' ).siblings().show();
				}
			}
		});

		// Disable button if not enough credits
		if ( parseFloat( jQuery( '#showtotal' ).attr( 'data-total' ) ) > parseFloat( wpj_vars.user_credits ) ) {
			jQuery( '.js-credits' ).attr( 'onclick', '' );
			jQuery( '.js-credits' ).attr( 'data-tooltip', wpj_vars.not_enough_credits );
			jQuery( '.js-credits' ).attr( 'data-position', 'right center' );
			jQuery( '.js-credits' ).attr( 'data-inverted', '' );

		} else {
			jQuery( '.js-credits' ).attr( 'onclick', 'take_to_gateway( "credits", "' + purchase_type + '" );' );
			jQuery( '.js-credits' ).removeAttr( 'data-tooltip' );
			jQuery( '.js-credits' ).removeAttr( 'data-position' );
			jQuery( '.js-credits' ).removeAttr( 'data-inverted' );

		}
	}
}