// Charscounter
( function( $ ) {
	$.fn.counted = function( options ) {
		var settings = { count: 300 };
		options      = $.extend( settings, options || {} );

		return this.each( function() {
			var $this   = $( this );
			var counter = $( '<span class="charscounter" />' ).html( options.count ).insertAfter( $this );

			function wpj_count_and_insert( $this ) {
				var count = options.count - $this.val().length;

				if ( count >= 0 ) {
					counter.html( count );

				} else {
					$this.val( $this.val().substr( 0, options.count ) );

					counter.html( 0 );

				}
			}

			$this.on( 'ready change paste keyup blur', function( e ) {
				wpj_count_and_insert( $this );
			});

			$this.ready( function() {
				wpj_count_and_insert( $this );
			});

		});
	};
})( jQuery );

// Input char counter functions
function get_input_length( element, type ) {
	type = typeof type !== 'undefined' ? type : 'input';

	if ( type == 'html' ) {
		var contentdiv      = jQuery( "<div/>" ).html( ( element ).html() );
		var breakrows       = jQuery( contentdiv ).html().match( /(<((br)|(\/br)|(\/ br))>)/gi );
		var breakrows_count = breakrows ? breakrows.length : 0;

		var $elem_class = jQuery( element ).attr( 'class' );

		if ( $elem_class.indexOf( 'wysiwyg-description-textarea' ) >= 0 ) {
			var $placeholder = jQuery( '.wysiwyg-description-textarea' ).attr( 'placeholder' );

			if ( jQuery( contentdiv ).text() == $placeholder ) {
				return jQuery( contentdiv ).val().length + breakrows_count;

			} else {
				return jQuery( contentdiv ).text().length + breakrows_count;

			}
		}

		return jQuery( contentdiv ).text().length + breakrows_count;

	} else {
		return jQuery( "<div/>" ).html( ( element ).val() ).text().length;

	}
}

function get_input_length_emoji( str ) {
	var point;
	var index;
	var width = 0;
	var len   = 0;

	for ( index = 0; index < str.length; ) {
		point = str.codePointAt( index );
		width = 0;

		while ( point ) {
			width += 1;
			point = point >> 8;
		}

		index += Math.round( width / 2 );
		len   += 1;
	}

	var breakrows = str.match( /(<((br)|(\/br)|(\/ br))>)/gi );
	var breakrows_count = breakrows ? breakrows.length : 0;

	return len + breakrows_count;
}

function the_input_length( element, target, max_length, type ) {
	type = typeof type !== 'undefined' ? type : 'input';

	var target_cnt = target.find( 'em' ).eq( 0 );

	if ( target_cnt.length == 0 ) {
		var target_cnt = jQuery( '<em/>' ).prependTo( target );
	}

	var input_length = get_input_length( element, type );

	target_cnt.html( input_length );

	if ( input_length > max_length ) target.addClass( 'char-limit-exceeded' );
	else target.removeClass( 'char-limit-exceeded' );
}

function add_input_length_listener( element, target, max_length, type ) {
	type = typeof type !== 'undefined' ? type : 'input';

	if ( type == 'html' ) {
		var editor = element;
		var element = jQuery( editor.composer.element );

		the_input_length( element, target, max_length, type );

		editor.composer.element.addEventListener( "keyup", function() {
			the_input_length( element, target, max_length, type );
		});

	} else {
		the_input_length( element, target, max_length, type );

		element.keyup( function( e ) {
			the_input_length( element, target, max_length, type );
		});

	}
}