jQuery( document ).ready( function( $ ) {
	// open custom offer modal
	$( document ).on( "click", ".open-custom-offer-modal", function( e ) {
		e.preventDefault();

		var unique_id     = $( this ).attr( 'data-unique-id' );
		var this_modal_el = $( '.ui.modal.custom-offer-container.' + unique_id );

		this_modal_el
			.modal({
				onApprove: function() { return false; },
				onDeny: function() { return false; },
				onShow: function() { jQuery.fn.wpjUploadifiveUploaderInit(); }
			})
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' )
			.modal( 'refresh' );
	});

	// save request
	$( document ).on( 'submit', '.request_form', function( e ) {
		e.preventDefault();

		// disable submit button
		$( '.request_form .actions .button' ).addClass( 'loading disabled' );

		var unique_id = $( this ).parents( '.custom-offer-wrapper' ).attr( 'data-unique-id' );

		$.ajax({
			data    : "action=request_custom_offer_action&" + $( this ).serialize(),
			dataType: "json",
			type    : "POST",
			url     : wpj_vars.ajaxurl,
			success : function( data ) {
				// enable submit button
				$( '.request_form .actions .button' ).removeClass( 'loading disabled' );

				// display success/error message
				$( '.custom-offer-btn' ).notify( data.message['description'], { position: 'top center', className: data.message['code'] } );

				if ( data.message['code'] == 'success' ) {
					// this modal wrapper element
					var this_modal_el = $( '.ui.modal.custom-offer-container.' + unique_id );

					// hide the modal
					this_modal_el.modal( 'hide' );

					// clear the textarea
					this_modal_el.find( '.request_message' ).val( '' );

					// clear the attachments queue
					this_modal_el.find( '.uploadifive-queue' ).empty();
					this_modal_el.find( '.uploadifive-queue + input' ).val( '' );

					// action
					Hooks.do_action( 'wpj_after_custom_offer_saved', data, { action : 'request' } );
				}
			}
		});
	});

	// save offer and extra
	$( document ).on( 'submit', '.offer_form', function( e ){
		e.preventDefault();

		// disable submit button
		$( '.offer_form .actions .button' ).addClass( 'loading disabled' );

		var unique_id = $( this ).parents( '.custom-offer-wrapper' ).attr( 'data-unique-id' );

		$.ajax({
			data     : "action=send_custom_offer_action&" + $( this ).serialize(),
			dataType : 'json',
			type     : "POST",
			url      : wpj_vars.ajaxurl,
			success: function( data ) {
				// enable submit button
				$( '.offer_form .actions .button' ).removeClass( 'loading disabled' );

				// display success/error message
				$( '.custom-offer-btn' ).notify( data.message['description'], { position: 'top center', className: data.message['code'] } );

				if ( data.message['code'] == 'success' ) {
					// this modal wrapper element
					var this_modal_el = $( '.ui.modal.custom-offer-container.' + unique_id );

					// hide the modal
					this_modal_el.modal( 'hide' );

					// clear the form
					this_modal_el.find( '.offer_description' ).val( '' );
					this_modal_el.find( 'input[name="price"]' ).val( '' );
					this_modal_el.find( 'input[name="delivery"]' ).val( '' );

					// action
					Hooks.do_action( 'wpj_after_custom_offer_saved', data, { action : 'send' } );

					// refresh message div
					if ( jQuery( '.is-page-pm' )[0] ) {
						refreshContent( '.thread-list-wrapper' ); // pm page
					}

					if ( jQuery( '.is-page-pm.is-page-pm-single' )[0] ) {
						refreshContent( '.js-messages-list .kt-inside-inner-col:first' ); // pm user page
					}

					// refresh order div
					if ( $( '#order-notification-messages-wrapper' )[0] ) {
						refreshContent( '#order-notification-messages-wrapper' ); // order page
					}
				}
			}
		});
	});
});
