/* PM */
function wpj_pm_emoji_init( class_name ) {
	class_name = typeof class_name !== 'undefined' ? class_name : '#message-pm-user';

	if ( wpj_vars.pm_emoji_enabled == 1 && typeof jQuery( class_name ).data( "emojioneArea" ) === 'undefined' ) {
		if ( jQuery( class_name )[0] ) {
			jQuery( class_name ).emojioneArea({
				pickerPosition : "top",
				filtersPosition: "top",
				searchPosition : "top",
				tonesStyle     : "bullet",
				events         : {
					keyup : function ( editor, event ) {
						// icons position on scroll
						if ( editor.hasScrollbar() ) jQuery( '.thread-input' ).addClass( 'has-scroll' );
						else jQuery( '.thread-input' ).removeClass( 'has-scroll' );

						if ( wpj_vars.is_rtl ) {
							if ( editor.hasScrollbar() ) jQuery( '.emojionearea-button' ).animate( { 'margin-left' : '10px' }, 100 );
							else jQuery( '.emojionearea-button' ).animate( { 'margin-left' : '0' }, 100 );
						}
					}
				}
			});
		}
	}

	return false;
}

/* Chat */
function wpj_chat_emoji_init( class_name ) {
	class_name = typeof class_name !== 'undefined' ? class_name : '.message-box-input-content';

	if ( wpj_vars.chat_emoji_enabled == 1 && typeof jQuery( class_name ).data( "emojioneArea" ) === 'undefined' ) {
		if ( jQuery( class_name )[0] ) {
			jQuery( class_name ).emojioneArea({
				pickerPosition : "top",
				filtersPosition: "top",
				searchPosition : "top",
				tonesStyle     : "bullet",
				placeholder    : wpj_vars.write_message,
				events         : {
					ready : function () {
						jQuery( '.message-box-container' ).addClass( 'emoji-enabled' );
						jQuery( '.message-box-placeholder-container' ).hide();
					}
				}
			});
		}
	}

	return false;
}

/* Transaction */
function wpj_transaction_emoji_init( class_name ) {
	class_name = typeof class_name !== 'undefined' ? class_name : '.order-message-form-textarea';

	if ( wpj_vars.transaction_emoji_enabled == 1 && typeof jQuery( class_name ).data( "emojioneArea" ) === 'undefined' ) {
		if ( jQuery( class_name )[0] ) {
			jQuery( class_name ).emojioneArea({
				pickerPosition : "top",
				filtersPosition: "top",
				searchPosition : "top",
				tonesStyle     : "bullet",
				events         : {
					keyup : function ( editor, event ) {
						// counter
						var input_length = get_input_length_emoji( jQuery( '.cmi-listen.message-field' ).data( 'emojioneArea' ).getText() );
						var characters_left = wpj_vars.characters_pm_max - input_length;

						if ( characters_left <= 0 ) characters_left = 0;

						jQuery( '.charscounter' ).first().html( characters_left );

						// icons position on scroll
						if ( editor.hasScrollbar() ) {
							if ( wpj_vars.is_rtl ) {
								jQuery( '.quick-response-wrapper' ).animate( {'left': '54px'}, 100 );

							} else {
								jQuery( '.quick-response-wrapper' ).animate( {'right': '54px'}, 100 );

							}

						} else {
							if ( wpj_vars.is_rtl ) {
								jQuery( '.quick-response-wrapper' ).animate( {'left': '44px'}, 100 );

							} else {
								jQuery( '.quick-response-wrapper' ).animate( {'right': '44px'}, 100 );

							}
						}
					}
				}
			});
		}
	}

	return false;
}