jQuery( document ).ready( function( $ ) {

	$( document ).on( 'click', '.graph-button', function( e ) {

		$( "#disp_type" ).val( $( "input[name=disp_type]:checked" ).val() );

		if ( $( "#disp_type" ).val() == 'lastweek' || $( "#disp_type" ).val() == 'all' ) {
			$( "#form_graph" ).removeClass( "hidden" );
			$( "#form_graph" ).addClass( "hidden" );
			$( "#select_month" ).removeClass( "hidden" );
			$( "#select_month" ).addClass( "hidden" );
			wpj_get_user_account_graph();

		} else if ( $( "#disp_type" ).val() == 'month' ){
			$( "#form_graph" ).removeClass( "hidden" );
			$( "#select_month" ).removeClass( "hidden" );

		} else if ( $( "#disp_type" ).val() == 'year' ) {
			$( "#form_graph" ).removeClass( "hidden" );
			$( "#select_month" ).removeClass( "hidden" );
			$( "#select_month" ).addClass( "hidden" );

		}

	});

	$( document ).on( 'click', '.graph-link', function( e ) {
		if ( $( this ).hasClass( 'open' ) ) { $( this ).removeClass( 'open' );
			$( '#chart-div-container' ).slideUp( 400 );
			$( '#chart_div' ).slideUp( 400 );

		} else { $( this ).addClass( 'open' );
			$( '#chart-div-container' ).slideDown( 400 );
			$( '#chart_div' ).slideDown( 400 );

			wpj_get_user_account_graph();

		}
	});

});

function wpj_get_user_account_graph() {

	var graph_type = jQuery( '.page-id-' + wpj_vars.my_account_page_id )[0] || jQuery( '.page-id-' + wpj_vars.my_sales_page_id )[0] ? 'sales' : 'shopping';

	if ( jQuery( '.js-user-chart-wrapper' )[0] ) {

		var ret = '';

		disp_type    = jQuery( '#disp_type' ).val();
		select_year  = jQuery( '#select_year select[name="select_year"]' ).val();
		select_month = jQuery( '#select_month select[name="select_month"]' ).val();

		jQuery.ajax({
			url  : wpj_vars.ajaxurl,
			data : {
				'uid'         : wpj_vars.uid,
				'action'      : 'user_account_graph_action',
				'disp_type'   : disp_type,
				'select_year' : select_year,
				'select_month': select_month,
				'graph_type'  : graph_type
			},
			success: function( json_data ) {
				chart_data = JSON.parse( json_data );
				data       = google.visualization.arrayToDataTable( eval( chart_data['data_table'] ) );

				wpj_draw_user_account_chart( data );
			},
			error: function( errorThrown ) {}
		});

	}
}

function wpj_draw_user_account_chart( data ) {

	var graph_type = jQuery( '.page-id-' + wpj_vars.my_account_page_id )[0] || jQuery( '.page-id-' + wpj_vars.my_sales_page_id )[0] ? 'sales' : 'shopping';

	if ( jQuery( ".js-user-chart-wrapper" )[0] ) {

		var vAxis_val = wpj_vars.is_rtl ? { minValue: 0, reverseAxis: true, legend: { position: "top" } } : { minValue: 0 };

		if ( graph_type == 'sales' ) {
			var options = {
				hAxis: {
					titleTextStyle: {color: '#333'}
				},
				vAxis: vAxis_val,
				colors: ['#BEEC78', '#119EE2', '#FFBE00', '#65BEE9', '#20c497']
			};

		} else if ( graph_type == 'shopping' ) {
			var options = {
				hAxis: {
					titleTextStyle: {color: '#333'}
				},
				vAxis: vAxis_val,
				colors: ['#BEEC78', '#FFBE00', '#119EE2', '#20c497', '#20c497']
			};

		} else {
			var options = {
				hAxis: {
					titleTextStyle: {color: '#333'}
				},
				vAxis: vAxis_val,
				colors: ['#20c497', '#83C0D8', '#03C0D8', '#f3CaD8', '#8fCbD8']
			};

		}

		var chart = new google.visualization.AreaChart( document.getElementById( 'chart_div' ) );
		chart.draw( data, options );

	}
}

function wpj_change_user_account_table_responsive() {
	if ( jQuery( this ).width() > 767 ) jQuery( '.ui.list.user-graph-table-wrapper' ).removeClass( 'relaxed' ).addClass( 'horizontal' );
	else jQuery( '.ui.list.user-graph-table-wrapper' ).addClass( 'relaxed' ).removeClass( 'horizontal' );
}
