//------------------------------------
// Job Activate / Deactivate / Delete
//------------------------------------
jQuery( document ).ready( function( $ ) {

	// Activate - modal
	$( document ).on( 'click', '.js-activate-job-link', function() {
		$( '.js-activate-job-action' ).attr( 'data-id', $( this ).attr( 'data-id' ) );

		$( '.job-title-modal' ).html( validateInputContent( $( this ).attr( 'data-title' ) ) );

		$( '.ui.modal.js-activate-job-modal' )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' );
	});

	// Activate - action
	$( document ).on( 'click', '.js-activate-job-action', function( e ) {
		$.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'activate_job_action',
				post_id: $( this ).attr( 'data-id' )
			},
			beforeSend: function() {
				$( '.js-activate-job-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( response == '1' ) {
					if ( $( '.order-additional-wrapper' )[0] ) {
						changeURL( wpj_vars.page_url );

					} else {
						if ( $( '.js-user-account-wrapper' )[0] ) refreshContent( '.js-user-account-wrapper' ); // for code
						else wpj_refresh_kadence_tab_content(); // for page builder

					}

					$( '.ui.modal.js-activate-job-modal' ).modal( 'hide' ); // close modal
				}
				else if ( response == 'active_jobs_exceeded' ) $( '.content.activate-job' ).text( wpj_vars.active_jobs_exceeded );
				else if ( response == 'not_your_post' )        $( '.content.activate-job' ).text( wpj_vars.not_your_post );
				else if ( response == 'no_credits' )           $( '.content.activate-job' ).text( wpj_vars.no_credits );
				else if ( response == 'not_logged_in' )        $( '.content.activate-job' ).text( wpj_vars.not_logged_in );
			},
			complete: function() {
				$( '.js-activate-job-action' ).removeClass( 'loading' );
				$( '.ui.active.inverted.dimmer' ).remove();
			}
		});
	});

	// Activate all - modal
	$( document ).on( 'click', '#js-activate-all-jobs-link', function( e ) {
		$( '.ui.modal.js-activate-all-jobs-modal' ).modal( 'setting', 'transition', 'fly down' ).modal( 'show' );
	});

	// Activate all - action
	$( document ).on( 'click', '.js-activate-all-jobs-action', function( e ) {
		$.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: { action : 'activate_all_jobs_action', reason: 'by_user' },
			beforeSend: function() {
				$( '.js-activate-all-jobs-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( $( '.js-user-account-wrapper' )[0] ) refreshContent( '.js-user-account-wrapper' ); // for code
				else wpj_refresh_kadence_tab_content(); // for page builder
			},
			complete: function() {
				$( '.js-activate-all-jobs-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-activate-all-jobs-modal' ).modal( 'hide' );
			}
		});
	});

	// Deactivate - modal
	$( document ).on( 'click', '.js-deactivate-job-link', function() {
		$( '.js-deactivate-job-action' ).attr( 'data-id', $( this ).attr( 'data-id' ) );

		$( '.job-title-modal' ).html( validateInputContent( $( this ).attr( 'data-title' ) ) );

		$( '.ui.modal.js-deactivate-job-modal' )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' );
	});

	// Deactivate - action
	$( document ).on( 'click', '.js-deactivate-job-action', function( e ) {
		$.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: {
				action : 'deactivate_job_action',
				post_id: $( this ).attr( 'data-id' )
			},
			beforeSend: function() {
				$( '.js-deactivate-job-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( response == '1' ) {
					if ( $( '.order-additional-wrapper' )[0] ) {
						changeURL( wpj_vars.page_url );

					} else {
						if ( $( '.js-user-account-wrapper' )[0] ) refreshContent( '.js-user-account-wrapper' ); // for code
						else wpj_refresh_kadence_tab_content(); // for page builder

					}

					$( '.ui.modal.js-deactivate-job-modal' ).modal( 'hide' ); // close modal
				}
				else if ( response == 'not_your_post' ) $( '.content.deactivate-job' ).text( wpj_vars.not_your_post );
				else if ( response == 'not_logged_in' ) $( '.content.deactivate-job' ).text( wpj_vars.not_logged_in );
			},
			complete: function() {
				$( '.js-deactivate-job-action' ).removeClass( 'loading' );
				$( '.ui.active.inverted.dimmer' ).remove();
			}
		});
	});

	// Deactivate all - modal
	$( document ).on( 'click', '#js-deactivate-all-jobs-link', function( e ) {
		$( '.ui.modal.js-deactivate-all-jobs-modal' ).modal( 'setting', 'transition', 'fly down' ).modal( 'show' );
	});

	// Deactivate all - action
	$( document ).on( 'click', '.js-deactivate-all-jobs-action', function( e ) {
		$.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: { action : 'deactivate_all_jobs_action', reason: 'by_user' },
			beforeSend: function() {
				$( '.js-deactivate-all-jobs-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( $( '.js-user-account-wrapper' )[0] ) refreshContent( '.js-user-account-wrapper' ); // for code
				else wpj_refresh_kadence_tab_content(); // for page builder
			},
			complete: function() {
				$( '.js-deactivate-all-jobs-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-deactivate-all-jobs-modal' ).modal( 'hide' );
			}
		});
	});

	// Delete - modal
	$( document ).on( 'click', '.js-delete-job-link', function() {
		$( '.js-delete-job-action' ).attr( 'data-id', $( this ).attr( 'data-id' ) );

		$( '.job-title-modal' ).html( validateInputContent( $( this ).attr( 'data-title-delete' ) ) );

		$( '.ui.modal.js-delete-job-modal' )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' );
	});

	// Delete - action
	$( document ).on( 'click', '.js-delete-job-action', function( e ) {
		$.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'delete_job_action',
				post_id: $( this ).attr( 'data-id' )
			},
			beforeSend: function() {
				$( '.js-delete-job-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( response == '1' ) {
					if ( $( '.order-additional-wrapper' )[0] ) {
						changeURL( wpj_vars.my_account_url );

					} else {
						if ( $( '.js-user-account-wrapper' )[0] ) refreshContent( '.js-user-account-wrapper' ); // for code
						else wpj_refresh_kadence_tab_content(); // for page builder

					}

					$( '.ui.modal.js-delete-job-modal' ).modal( 'hide' ); // close modal
				}
				else if ( response == 'not_your_post' ) $( '.content.delete-job' ).text( wpj_vars.not_your_post );
				else if ( response == 'not_logged_in' ) $( '.content.delete-job' ).text( wpj_vars.not_logged_in );
			},
			complete: function() {
				$( '.js-delete-job-action' ).removeClass( 'loading' );
			}
		});
	});

	// Delete all - modal
	$( document ).on( 'click', '#js-delete-all-jobs-link', function( e ) {
		$( '.ui.modal.js-delete-all-jobs-modal' ).modal( 'setting', 'transition', 'fly down' ).modal( 'show' );
	});

	// Delete all - action
	$( document ).on( 'click', '.js-delete-all-jobs-action', function( e ) {
		$.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: { action : 'delete_all_jobs_action' },
			beforeSend: function() {
				$( '.js-delete-all-jobs-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( $( '.js-user-account-wrapper' )[0] ) refreshContent( '.js-user-account-wrapper' ); // for code
				else wpj_refresh_kadence_tab_content(); // for page builder
			},
			complete: function() {
				$( '.js-delete-all-jobs-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-delete-all-jobs-modal' ).modal( 'hide' );
			}
		});
	});

});