function wpj_validate_new_job_form() {

	//-> FUNCTION for validations
	jQuery.fn.form.settings.rules.maxLengthDesc = function ( inputValue, validationValue ) {
		if ( jQuery( ".char-count" ).length ) inputValue = jQuery( "#job_description_field .char-count" ).children( "em" ).html();
		else if ( jQuery( "#chars_counter" ).length ) inputValue = jQuery( "#job_description_field #chars_counter" ).html();
		else inputValue = jQuery( "#job_description_field .charscounter" ).html();

		return parseFloat( inputValue ) <= parseFloat( validationValue );
	}

	jQuery.fn.form.settings.rules.greaterThan = function ( inputValue, validationValue ) {
		return parseFloat( inputValue ) >= parseFloat( validationValue );
	}

	jQuery.fn.form.settings.rules.lessThan = function ( inputValue, validationValue ) {
		return parseFloat( inputValue ) <= parseFloat( validationValue );
	}

	jQuery.fn.form.settings.rules.noValidation = function () {
		return true;
	}

	jQuery.fn.form.settings.rules.instant_file_upload = function () {
		var validation_complete = true;

		if ( jQuery( "#uploadifive-file_upload_instant_job_attachments" ).siblings( ".attachments-wrapper" )[0] ) {
			if ( jQuery.trim( jQuery( "#uploadifive-file_upload_instant_job_attachments" ).siblings( ".attachments-wrapper" ).text() ).length <= 0 ) {
				if ( jQuery( "#uploadifive-file_upload_instant_job_attachments-queue" ).html().length <= 0 ) validation_complete = false;
				else validation_complete = true;

			} else validation_complete = true;

		} else if ( jQuery( "#uploadifive-file_upload_instant_job_attachments-queue" )[0] ) {
			if ( jQuery( "#uploadifive-file_upload_instant_job_attachments-queue" ).html().length <= 0 ) validation_complete = false;
			else validation_complete = true;

		}

		if ( validation_complete ) return true;
		return false;
	}

	jQuery.fn.form.settings.rules.audio_file_upload = function () {
		if ( jQuery( ".audio-file-wrapper" ).length ) return true;
		return false;
	}

	jQuery.fn.form.settings.rules.image_file_upload = function () {
		if (
			( jQuery( "#job_images" )[0] && jQuery( "#job_images" ).find( '.dz-complete' ).length )
			|| ( ! jQuery( "#job_images" )[0] && jQuery.trim( jQuery( '.images-wrapper' ).html() ).length )
		) return true;
		return false;
	}

	jQuery.fn.form.settings.rules.image_file_upload_error = function () {
		if ( jQuery( "#job_images" ).find( '.dz-error' ).length ) return false;
		return true;
	}

	jQuery.fn.form.settings.rules.video_validation = function () {
		var is_ok = true;
		jQuery( ".video-link" ).each( function() { if ( jQuery( this ).val() != '' && wpj_validate_video_url( jQuery( this ).val() ) === false ) is_ok = false; });
		return is_ok;
	}

	jQuery.fn.form.settings.rules.faq_validation = function () {
		var is_ok = true;
		jQuery( ".faq-question" ).each( function() { if ( ! jQuery( this ).val() ) is_ok = false; });
		jQuery( ".faq-answer" ).each( function() { if ( ! jQuery( this ).val() ) is_ok = false; });
		return is_ok;
	}

	if ( localStorage.getItem( 'validate_subcat' ) == 'no' ) var sub_cat_rule = { type: 'noValidation' };
	else var sub_cat_rule = wpj_aoe_empty( 'job_subcategory_blank' );

	var fields_arr = {};

	fields_arr.title = {
		identifier: 'job_title',
		rules: [ wpj_aoe_empty( 'job_title_blank' ), wpj_aoe_min_length( 'job_title_min', wpj_vars.characters_job_title_min ), wpj_aoe_max_length( 'job_title_max', wpj_vars.characters_job_title_max ) ],
	}

	fields_arr.category = {
		identifier: 'job_cat',
		rules: [ wpj_aoe_empty( 'job_category_blank' ) ]
	}

	fields_arr.subcategory = {
		identifier: 'subcat',
		rules: [ sub_cat_rule ]
	}

	fields_arr.description = {
		identifier: 'job_description',
		rules: [ wpj_aoe_empty( 'job_description_blank' ), wpj_aoe_min_length( 'job_description_min', wpj_vars.characters_job_desc_min ), wpj_aoe_max_length( 'job_description_max', wpj_vars.characters_job_desc_max, null, 'job_description' ) ],
	}

	if ( jQuery( 'textarea[name="instruction_box"]' ).attr( 'data-required' ) == true ) {
		fields_arr.buyer_instruction = {
			identifier: 'instruction_box',
			rules: [ wpj_aoe_empty( 'job_instructions_blank' ), wpj_aoe_min_length( 'job_instructions_min', wpj_vars.characters_job_instr_min ), wpj_aoe_max_length( 'job_instructions_max', wpj_vars.characters_job_instr_max ) ],
		}
	}

	if ( jQuery( '.faq-question' ).attr( 'data-required' ) == true ) {
		fields_arr.faq = {
			identifier: 'faq_question[]',
			rules: [ wpj_aoe_faq() ],
		}
	}

	if ( wpj_vars.op_enable_shipping == 1 ) {
		fields_arr.shipping = {
			identifier: 'job_shipping',
			rules: [ wpj_aoe_number( 'job_shipping_numeric' ), ]
		}
	}

	wpj_aoe_packages_validation( jQuery( 'select[name="price_type"]' ), fields_arr );
	jQuery( document ).on( "change", 'select[name="price_type"]', function() {
		wpj_aoe_packages_validation( jQuery( this ), fields_arr );
	});

	if ( wpj_vars.op_mandatory_job_image == 1 ) {
		fields_arr.image = {
			identifier: 'images_order',
			rules: [ wpj_aoe_image_file_upload(), wpj_aoe_image_file_upload_error() ]
		}
	}

	fields_arr.video = {
		identifier: 'video_link[]',
		rules: [ wpj_aoe_video() ]
	}

	if ( wpj_vars.op_mandatory_job_audio == 1 && wpj_vars.op_enable_audio == 1 ) {
		fields_arr.audio = {
			identifier: 'file_upload_audio',
			rules: [ wpj_aoe_audio_file_upload() ]
		}
	}

	wpj_aoe_efd_validation( jQuery( '#enable_extra_fast' ), fields_arr );

	jQuery( document ).on( 'change', '#enable_extra_fast, #max_days_fast, #max_days', function( e ) {
		wpj_aoe_efd_validation( jQuery( '#enable_extra_fast' ), fields_arr );
	});

	wpj_aoe_ar_validation( jQuery( '#enable_extra_revision' ), fields_arr );

	jQuery( document ).on( 'change', '#enable_extra_revision', function( e ) {
		wpj_aoe_ar_validation( jQuery( this ), fields_arr );
	});

	jQuery( document ).on( "change", ".extra_enable", function() {
		$id_arr = jQuery( this ).find( 'input:checkbox' ).attr( 'id' ).split( '_' );

		wpj_aoe_extra_validation( jQuery( this ), fields_arr, parseInt( $id_arr[2] ), jQuery( this ).find( 'input:checkbox' ).prop( 'checked' ) );
	});

	for ( var i = 1; i <= 10; i++ ) {
		wpj_aoe_extra_validation( jQuery( '#enable_extra_' + i ), fields_arr, i, jQuery( '#enable_extra_' + i ).prop( 'checked' ) );
	}

	if ( wpj_vars.op_enable_tos != 'disabled' ) {
		fields_arr.terms = {
			identifier: 'i_agree',
			rules: [ wpj_aoe_i_agree() ]
		}
	}

	Hooks.do_action( 'wpj_before_execute_job_form_validation', fields_arr );

	fields_arr = Hooks.apply_filters( 'wpj_fields_validation_filter', fields_arr, 'job' );

	jQuery( '#add-edit-job-form' ).form({
		on: 'blur',
		keyboardShortcuts: false,
		fields: fields_arr,
		onFailure : function( e ) {
			if ( jQuery( window ).scrollTop() > 100 ) jQuery( 'html, body' ).animate({ scrollTop : 0 }, 800 );
			return false;
		}
	});

	jQuery( '#add-edit-job-form' ).form( 'validate form' );
}

//-> FUNCTIONS for validation type
function wpj_aoe_empty( name ) {
	var i = arguments.length > 1 && arguments[1] ? arguments[1] : '';

	var empty_ret = {
		type   : 'empty',
		prompt : wpj_vars[name + i],
	}

	return empty_ret;
}

function wpj_aoe_min_length( name ) {
	var min_no = arguments.length > 1 && arguments[1] ? arguments[1] : 0;
	var i      = arguments.length > 2 && arguments[2] ? arguments[2] : '';

	var min_length_ret = {
		type   : 'minLength[' + min_no + ']',
		prompt : wpj_vars[name + i],
	}

	return min_length_ret;
}

function wpj_aoe_max_length( name ) {
	var max_no = arguments.length > 1 && arguments[1] ? arguments[1] : 0;
	var i      = arguments.length > 2 && arguments[2] ? arguments[2] : '';
	var field  = arguments.length > 3 && arguments[3] ? arguments[3] : null;

	var fnc_type = field == 'job_description' ? 'maxLengthDesc[' + max_no + ']' : 'maxLength[' + max_no + ']';

	var max_length_ret = {
		type   : fnc_type,
		prompt : wpj_vars[name + i],
	}

	return max_length_ret;
}

function wpj_aoe_number( name ) {
	var i = arguments.length > 1 && arguments[1] ? arguments[1] : '';

	var number_ret = {
		type   : 'number',
		prompt : wpj_vars[name + i],
	}

	return number_ret;
}

function wpj_aoe_greater_than_or_equal( name ) {
	var min_no = arguments.length > 1 && arguments[1] ? arguments[1] : 0;
	var i      = arguments.length > 2 && arguments[2] ? arguments[2] : '';

	var greater_than_ret = {
		type   : 'greaterThan[' + min_no + ']',
		prompt : wpj_vars[name + i]
	}

	return greater_than_ret;
}

function wpj_aoe_less_than_or_equal( name ) {
	var max_no = arguments.length > 1 && arguments[1] ? arguments[1] : 0;
	var i      = arguments.length > 2 && arguments[2] ? arguments[2] : '';

	var less_than_ret = {
		type   : 'lessThan[' + max_no + ']',
		prompt : wpj_vars[name + i],
	}

	return less_than_ret;
}

function wpj_aoe_instant_file_upload() {
	var instant_file_upload_ret = {
		type   : 'instant_file_upload',
		prompt : wpj_vars.job_instant_file_blank,
	}

	return instant_file_upload_ret;
}

function wpj_aoe_audio_file_upload() {
	var audio_file_upload_ret = {
		type   : 'audio_file_upload',
		prompt : wpj_vars.job_audio_blank,
	}

	return audio_file_upload_ret;
}

function wpj_aoe_image_file_upload() {
	var image_file_upload_ret = {
		type   : 'image_file_upload',
		prompt : wpj_vars.job_image_blank,
	}

	return image_file_upload_ret;
}

function wpj_aoe_image_file_upload_error() {
	var image_file_upload_error_ret = {
		type   : 'image_file_upload_error',
		prompt : wpj_vars.job_image_error,
	}

	return image_file_upload_error_ret;
}

function wpj_aoe_faq() {
	var faq_ret = {
		type   : 'faq_validation',
		prompt : wpj_vars.job_faq_blank,
	}

	return faq_ret;
}

function wpj_aoe_video() {
	var video_ret = {
		type   : 'video_validation',
		prompt : wpj_vars.job_video_invalid,
	}

	return video_ret;
}

function wpj_aoe_i_agree() {
	var i_agree_ret = {
		type   : 'checked',
		prompt : wpj_vars.job_tos_uncheck,
	}

	return i_agree_ret;
}

//-> FUNCTION for max days validation
function wpj_aoe_max_days_validation( $this, fields_arr ) {
	if ( $this.val() == "instant" && jQuery( 'select[name="price_type"]' ).val() != 'package' ) {
		fields_arr.instant_delivery = {
			identifier : 'hidden_files_instant_job_attachments',
			rules: [ wpj_aoe_instant_file_upload() ]
		}
	} else {
		delete fields_arr.instant_delivery;
	}
}

//-> FUNCTION for extra fast delivery validation
function wpj_aoe_efd_validation( $this, fields_arr ) {
	if ( $this.prop( 'checked' ) && wpj_vars.max_days_enabled ) {
		var amount_jobefdprice_min = wpj_vars.amount_jobextra_price_min;
		var amount_jobefdprice_max = wpj_vars.amount_jobextra_price_max;

		if ( amount_jobefdprice_max ) {
			var max_amount_efdprice_rule = wpj_aoe_less_than_or_equal( 'job_efd_price_max', amount_jobefdprice_max );
		} else {
			var max_amount_efdprice_rule = { type: 'noValidation' };
		}

		if ( jQuery( 'select[name="price_type"]' ).val() == 'package' ) {
			var pck_max_days_values = jQuery( "select[name='package_max_days[]']" ).map( function() { return jQuery( this ).val(); } ).get();
			var amount_jobefdmaxdays_min = Math.max.apply( Math, pck_max_days_values );
		} else {
			var amount_jobefdmaxdays_min = jQuery( '#max_days' ).val();
		}

		amount_jobefdmaxdays_min = Hooks.apply_filters( 'wpj_efd_max_days_validation_filter', amount_jobefdmaxdays_min );

		var max_days_fast_validation = jQuery( '#max_days_fast' ).val() != 'instant' ? wpj_aoe_less_than_or_equal( 'job_efd_max_days_max', amount_jobefdmaxdays_min ) : { type: 'noValidation' };

		fields_arr.efd_price = {
			identifier : 'extra_fast_price',
			rules: [
				wpj_aoe_empty( 'job_efd_price_blank' ),
				wpj_aoe_number( 'job_efd_price_numeric' ),
				wpj_aoe_greater_than_or_equal( 'job_efd_price_min', amount_jobefdprice_min ),
				max_amount_efdprice_rule
			]
		}

		fields_arr.efd_max_days = {
			identifier : 'max_days_fast',
			rules: [ wpj_aoe_empty( 'job_efd_max_days_blank' ), max_days_fast_validation ]
		}

	} else {
		delete fields_arr.efd_price;
		delete fields_arr.efd_max_days;

		$this.parents( '.field' ).siblings( '.two.fields' ).children( '.field' ).removeClass( 'error' );

	}
}

//-> FUNCTION for additional revision validation
function wpj_aoe_ar_validation( $this, fields_arr ) {
	if ( $this.prop( 'checked' ) ) {
		var amount_jobarprice_min = wpj_vars.amount_jobextra_price_min;
		var amount_jobarprice_max = wpj_vars.amount_jobextra_price_max;
		if ( amount_jobarprice_max ) {
			var max_amount_arprice_rule = wpj_aoe_less_than_or_equal( 'job_ar_price_max', amount_jobarprice_max );
		} else {
			var max_amount_arprice_rule = { type: 'noValidation' };
		}

		fields_arr.ar_price = {
			identifier : 'extra_revision_price',
			rules: [
				wpj_aoe_empty( 'job_ar_price_blank' ),
				wpj_aoe_number( 'job_ar_price_numeric' ),
				wpj_aoe_greater_than_or_equal( 'job_ar_price_min', amount_jobarprice_min ),
				max_amount_arprice_rule
			]
		}

		fields_arr.ar_max_days = {
			identifier : 'max_days_revision',
			rules: [ wpj_aoe_empty( 'job_ar_max_days_blank' ) ]
		}
	} else {
		delete fields_arr.ar_price;
		delete fields_arr.ar_max_days;

		$this.parents( '.field' ).siblings( '.three.fields' ).children( '.field' ).removeClass( 'error' );
	}
}

//-> FUNCTION for extra validation
function wpj_aoe_extra_validation( $this, fields_arr, i, cond ) {
	var amount_jobextraprice_min = wpj_vars.amount_jobextra_price_min;
	var amount_jobextraprice_max = wpj_vars.amount_jobextra_price_max;
	if ( amount_jobextraprice_max ) {
		var max_amount_extraprice_rule = wpj_aoe_less_than_or_equal( 'job_extra_price_max' + i, amount_jobextraprice_max );
	} else {
		var max_amount_extraprice_rule = { type: 'noValidation' };
	}

	var characters_jobextra_description_min = wpj_vars.characters_extradesc_min;
	var characters_jobextra_description_max = wpj_vars.characters_extradesc_max;

	if ( cond ) {
		fields_arr['job_extra_description' + i] = {
			identifier : 'extra' + i + '_content',
			rules: [
				wpj_aoe_empty( 'job_extra_desc_blank' + i, i ),
				wpj_aoe_min_length( 'job_extra_desc_min' + i, characters_jobextra_description_min ),
				wpj_aoe_max_length( 'job_extra_desc_max' + i, characters_jobextra_description_max )
			],
		}

		fields_arr['job_extra_price' + i] = {
			identifier : 'extra' + i + '_price',
			rules: [
				wpj_aoe_empty( 'job_extra_price_blank' + i, i ),
				wpj_aoe_number( 'job_extra_price_numeric' + i ),
				wpj_aoe_greater_than_or_equal( 'job_extra_price_min' + i, amount_jobextraprice_min ),
				max_amount_extraprice_rule
			]
		}

		fields_arr['job_extra_max_days' + i] = {
			identifier : 'max_days_' + i,
			rules: [ wpj_aoe_empty( 'job_extra_max_days_blank' + i, i ) ]
		}
	} else {
		delete fields_arr['job_extra_description' + i];
		delete fields_arr['job_extra_price' + i];
		delete fields_arr['job_extra_max_days' + i];

		$this.siblings( '.three.fields' ).children( '.field' ).removeClass( 'error' );
		$this.siblings( '.extra_description' ).removeClass( 'error' );
	}
}

//-> FUNCTION for packages validation
function wpj_aoe_packages_validation( $this ,fields_arr ) {
	if ( $this.val() == 'package' ) {

		delete fields_arr.price;
		delete fields_arr.max_days;

		for ( var i = 0; i < 3; i++ ) {
			var min_pck_title = wpj_vars.characters_job_package_title_min;
			var max_pck_title = wpj_vars.characters_job_package_title_max;
			fields_arr['package_name' + i] = {
				identifier : 'package_name' + i,
				rules: [
					wpj_aoe_empty( 'job_pck_name_blank', i + 1 ),
					wpj_aoe_min_length( 'job_pck_name_min', min_pck_title, i + 1 ),
					wpj_aoe_max_length( 'job_pck_name_max', max_pck_title, i + 1 )
				]
			}

			var min_pck_description = wpj_vars.characters_job_package_description_min;
			var max_pck_description = wpj_vars.characters_job_package_description_max;
			fields_arr['package_description' + i] = {
				identifier : 'package_description' + i,
				rules: [
					wpj_aoe_empty( 'job_pck_description_blank', i + 1 ),
					wpj_aoe_min_length( 'job_pck_description_min', min_pck_description, i + 1 ),
					wpj_aoe_max_length( 'job_pck_description_max', max_pck_description, i + 1 )
				]
			}

			var min_pck_price = wpj_vars.amount_job_package_price_min;
			var max_pck_price = wpj_vars.amount_job_package_price_max;
			if ( max_pck_price ) {
				max_pck_price_rule = wpj_aoe_less_than_or_equal( 'job_pck_price_max', max_pck_price, i + 1 );
			} else {
				max_pck_price_rule = { type: 'noValidation' };
			}

			fields_arr['package_price' + i] = {
				identifier : 'package_price' + i,
				rules: [
					wpj_aoe_empty( 'job_pck_price_blank', i + 1 ),
					wpj_aoe_number( 'job_pck_price_numeric', i + 1 ),
					wpj_aoe_greater_than_or_equal( 'job_pck_price_min', min_pck_price, i + 1 ),
					max_pck_price_rule
				]
			}
		}

		wpj_aoe_max_days_validation( jQuery( 'select[name="price_type"]' ), fields_arr );

	} else {

		for ( var i = 0; i < 3; i++ ) {
			delete fields_arr['package_name' + i];
			delete fields_arr['package_description' + i];
			delete fields_arr['package_price' + i];
		}

		var amount_jobprice_min = wpj_vars.amount_jobprice_min;
		var amount_jobprice_max = wpj_vars.amount_jobprice_max;
		if ( amount_jobprice_max ) {
			var max_amount_jobprice_rule = wpj_aoe_less_than_or_equal( 'job_price_max', amount_jobprice_max );
		} else {
			var max_amount_jobprice_rule = { type: 'noValidation' };
		}
		fields_arr.price = {
			identifier : 'job_cost',
			rules: [
				wpj_aoe_empty( 'job_price_blank' ),
				wpj_aoe_number( 'job_price_numeric' ),
				wpj_aoe_greater_than_or_equal( 'job_price_min', amount_jobprice_min ),
				max_amount_jobprice_rule
			]
		}

		fields_arr.max_days = {
			identifier : 'max_days',
			rules: [ wpj_aoe_empty( 'job_max_days_blank' ) ]
		}

		wpj_aoe_max_days_validation( jQuery( '#max_days' ), fields_arr );
		jQuery( document ).on( 'change', '#max_days', function( e ) {
			wpj_aoe_max_days_validation( jQuery( this ), fields_arr );
		});
	}
}