jQuery( document ).ready( function( $ ) {

	//---------------------------------------
	// Job - Read More Description
	//---------------------------------------
	$( document ).on( 'click', '.read-more-desc', function( e ) {
		e.preventDefault();

		if ( $( this ).parents( '.post-job-description' ).find( '.job-excerpt' ).is( ':visible' ) ) {
			$( this ).text( wpj_vars.read_less );

			$( this ).parents( '.post-job-description' ).find( '.job-excerpt' ).hide();
			$( this ).parents( '.post-job-description' ).find( '.job-post' ).show();
		} else {
			$( this ).text( wpj_vars.read_more );

			$( this ).parents( '.post-job-description' ).find( '.job-post' ).hide();
			$( this ).parents( '.post-job-description' ).find( '.job-excerpt' ).show();
		}
	});

	//---------------------------------------
	// Job - Purchase post
	//-----------------------------------
	$( document ).on( 'click', '[data-submit]', function( e ) {
		var form_element = $( this ).parents( "form" );

		if ( $( this ).data( "submit" ) ) form_element = $( $( this ).data( "submit" ) );

		form_element.submit();

		return false;
	});

	//---------------------------------------
	// Cards Layout
	//---------------------------------------
	$( document ).on( 'click', '.layout_jobs', function( e ) {
		// Simulate resize to set the correct width for sliders
		var event = document.createEvent( 'HTMLEvents' );
		event.initEvent( 'resize', true, false );
		document.dispatchEvent( event );

		var job_style = $( this ).data( "value" );
		if ( job_style == 'grid' ) {
			$( '.wpj-load-more-target' ).removeClass( 'list-grid' );
			$( this ).parent().removeClass( 'list-grid' );
		}
		if ( job_style == 'list' ) {
			$( '.wpj-load-more-target' ).addClass( 'list-grid' );
			$( this ).parent().addClass( 'list-grid' );
		}

		// Change video card height
		$( '.owl-video-wrapper' ).each( function() {
			var wrapper_height = $( this ).height();
			$( this ).find( 'iframe' ).attr( 'height', wrapper_height );
		});

		if ( $.cookie( 'cards-layout' ) != 'list' ) {
			$.cookie( 'cards-layout', 'list', { expires: 7, path: '/' } );
		} else {
			$.cookie( 'cards-layout', 'grid', { expires: 7, path: '/' } );
		}
	});

	//---------------------------------------
	// Job Search
	//---------------------------------------
	$( document ).on( 'submit', '.js-job-filter-form', function ( e ) {
		e.preventDefault();

		$( this ).find( 'input[type="submit"]' ).addClass( 'disabled' );

		addLoader( '.wpj-load-more-target' );

		$.ajax({
			url     : $( this ).attr( 'action' ),
			type    : $( this ).attr( 'method' ),
			data    : $( this ).serialize(),
			success : function( response ) {
				changeURL( this.url );
			}
		});

		return false;
	});

});

//---------------------------------------
// Job - Video poster
//---------------------------------------
function wpj_display_video_poster() {
	if ( jQuery( '.owl-video-tn' ).length >= 1 ) {
		jQuery( '.owl-video-tn' ).each( function() {
			var img_url = jQuery( this ).attr( 'srctype' );

			var el = jQuery( this ).parents( '.owl-video-wrapper' );
			el.css( 'opacity', 1 );
			el.css( 'background-image', 'url(' + img_url + ')' );
			el.css( 'background-repeat', 'no-repeat' );
			el.css( 'background-position', 'center' );
			el.css( 'background-size', 'cover' );
		});
	}
}

//---------------------------------------
// Job - Homepage categories
//---------------------------------------
function wpj_add_responsive_classes_to_homepage_elements() {
	if ( jQuery( this ).width() <= 479 )
		jQuery( '.icon-categories-wrapper' ).removeClass( 'four three two one column' ).addClass( 'one column' );

	else if ( jQuery( this ).width() > 479 && jQuery( this ).width() <= 767 )
		jQuery( '.icon-categories-wrapper' ).removeClass( 'four three two one column' ).addClass( 'two column' );

	else if ( jQuery( this ).width() > 767 && jQuery( this ).width() <= 991 )
		jQuery( '.icon-categories-wrapper' ).removeClass( 'four three two one column' ).addClass( 'three column' );

	else
		jQuery( '.icon-categories-wrapper' ).removeClass( 'four three two one column' ).addClass( 'four column' );

}

//---------------------------------------
// Job - Social Share Panel
//---------------------------------------
function wpj_init_social_share_vertical_panel() {
	if ( jQuery( '.job-social-icons-wrapper' )[0] ) {
		if ( jQuery( this ).width() > 767 ) {
			var el           = jQuery( '.job-social-icons-wrapper' );
			var stickyTop    = el.offset().top;
			var stickyHeight = el.height();
			var topValue     = parseFloat( el.css( 'top' ) );

			jQuery( window ).scroll( function() {
				var limit = jQuery( '.footer-wrapper' ).offset().top - stickyHeight - 54;

				var windowTop = jQuery( window ).scrollTop();

				if ( ( stickyTop + stickyHeight ) < windowTop ) {
					el.css({ top: topValue });
				}

				if ( ( limit - stickyHeight ) < windowTop ) {
					var diff = limit - windowTop;

					el.css({ top: diff });
				}
			});
		}
	}
}

//---------------------------------------
// Job - Social Share Prompt
//---------------------------------------
Hooks.add_action( 'wpj_after_page_load_without_refresh', wpj_init_social_share_modal );
function wpj_init_social_share_modal() {
	if ( getUrlParameter( 'published-job' ) ) {
		jQuery( '.ui.modal.share-job-modal-wrapper' )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' );
	}
}