jQuery( document ).ready( function( $ ) {

	// Load more general function
	$( document ).on( 'click', '.wpj-load-more', function( e ) {
		var button = this;

		if ( $( button ).hasClass( 'js-load-more-button' ) )
			$( button ).addClass( 'ui primary button loading' );

		var pid = Number( $( button ).attr( 'data-pid' ) );
		var uid = Number( $( button ).attr( 'data-uid' ) );

		var query_type      = $( button ).attr( 'data-querytype' );
		var query_status    = $( button ).attr( 'data-querystatus' );
		var query_params    = $( button ).attr( 'data-queryparams' );
		if ( query_params ) query_params = JSON.parse( query_params );

		var function_name   = $( button ).attr( 'data-functionname' );
		var function_params = $( button ).attr( 'data-functionparams' );
		if ( function_params ) function_params = JSON.parse( function_params );

		var posts_per_page  = $( button ).attr( 'data-postsperpage' );
		if ( ! posts_per_page ) posts_per_page = wpj_vars.posts_per_page;

		var row_extra_classes = $( button ).attr( 'data-rowextraclasses' );
		var load_type         = $( button ).attr( 'data-loadtype' );

		var page_nr = isNaN( Number( $( button ).attr( 'data-page-nr' ) ) ) ? 2 : Number( $( button ).attr( 'data-page-nr' ) );
		$( button ).attr( 'data-page-nr', page_nr + 1 );

		var args_encoded    = $( button ).attr( 'data-class-args' );
		if ( args_encoded ) args_encoded = JSON.parse( args_encoded );

		var data = {
			action           : $( button ).attr( 'data-action' ),
			page_nr          : page_nr,
			pid              : pid,
			uid              : uid,
			query_type       : query_type,
			query_status     : query_status,
			query_params     : query_params,
			function_name    : function_name,
			function_params  : function_params,
			posts_per_page   : posts_per_page,
			row_extra_classes: row_extra_classes,
			load_type        : load_type,
			args_encoded     : args_encoded
		};

		var click_nr = Number( $( button ).attr( 'data-click-nr' ) );

		$( button ).attr( 'data-click-nr', click_nr + 1 );

		$.post( wpj_vars.ajaxurl + ( wpj_vars.url_params ? '?' + wpj_vars.url_params : '' ), data, function( response ) {
			if ( $( button ).hasClass( 'js-load-more-button' ) )
				$( button ).removeClass( 'ui primary button loading' );

			if ( $( button ).hasClass( 'js-load-more-icon' ) ) {
				$( button ).siblings( '.wpj-load-more-target' ).prepend( response ).slideDown( 400 );
				$( '.js-load-more-icon' ).hide();

			} else if ( $( button ).hasClass( 'js-load-more-icon-down' ) ) {
				$( button ).parent().siblings( '.wpj-load-more-target' ).append( response ).slideDown( 400 );
				$( '.js-load-more-icon-down' ).hide();

			} else {
				$( response ).hide().appendTo( $( button ).parent().siblings( '.wpj-load-more-target' ) ).slideDown( 400 );

			}

			var is_rtl = typeof wpj_vars !== 'undefined' && wpj_vars.is_rtl ? true : false;

			wpj_initialize_wpj_carousel( is_rtl );
			wpj_display_video_poster();

			if (
				response === ''
				|| (
					( $( button ).attr( 'id' ) == 'wpjobster-query-load-more-icon' || $( button ).attr( 'id' ) == 'wpjobster-query-load-more-icon-down' || $( button ).attr( 'id' ) == 'wpjobster-query-load-more-button' )
						&& click_nr == Number( $( button ).attr( 'data-clicks' ) )
				)
				|| (
					$( button ).attr( 'id' ) == 'wpjobster-post-load-more-button'
						&& page_nr >= Number( $( button ).attr( 'data-max' ) )
				)
			) {
				$( button ).slideUp( 400 );
				$( button ).parents( '.mb75' ).removeClass( 'mb75' );
			}

			if ( typeof $.fn.wpjLazyLoadRender == 'function' ) $.fn.wpjLazyLoadRender();
		});
	});

	// Pagination
	$( document ).on( 'click', '.page-numbers', function( e ) {
		if (
			$( this ).parents( '.js-pagination-wrapper' )[0]
			&& wpj_vars.load_more_type == 'pagination'
			&& wpj_vars.page_transition == 'animation'
			&& typeof Modernizr !== 'undefined'
			&& Modernizr.history
		) {
			e.preventDefault();

			var button = this;

			var hash = $( this ).attr( 'href' );

			if ( history.pushState ) history.pushState( null, null, hash );
			else location.hash = hash;

			$( this ).addClass( 'ui loading button' );
			$( this ).siblings( '.page-numbers' ).addClass( 'div-disabled' );

			if ( $( window ).scrollTop() > 100 ) $( 'html, body' ).animate({ scrollTop : 0 }, 800 ); // scroll to top before change the page

			refreshContent( '.' + $.trim( $( this ).parents( '.js-pagination-wrapper' ).siblings( '.wpj-load-more-target' ).attr( 'class' ) ).split( /\s+/ ).join( '.' ) );
			refreshContent( '.' + $.trim( $( this ).parents( '.js-pagination-wrapper' ).attr( 'class' ) ).split( /\s+/ ).join( '.' ) );
		}
	});

	// Load more search fields taxonomy and search pages
	$( document ).on( 'click', 'form .filter-box', function( e ) {
		$( '.filter-container .js-group-filters' ).toggleClass( 'collapse-filters' );
	});
});

function wpj_display_load_more_button() {
	if ( ( '.js-load-more-button' )[0] ) {
		if ( ! jQuery( '.js-load-more-button' ).parent().parent().is( '#main-wrapper' ) ) {
			if ( jQuery( '.js-load-more-button' ).parent().siblings().hasClass( 'grid-switch-absolute' ) )
				jQuery( '.js-load-more-button' ).parent().parent().addClass( 'mb75' );
		}

		jQuery( '.js-load-more-button.wpj-load-more' ).parent().addClass( 'pr' );
		jQuery( '.js-load-more-button.wpj-load-more' ).show();
	}
}

function wpj_init_load_more_automatically() {
	// Auto load script
	jQuery.fn.isOnScreen = function() {
		var win = jQuery( window );

		var viewport = {
			top : win.scrollTop(),
			left: win.scrollLeft()
		};

		viewport.right  = viewport.left + win.width();
		viewport.bottom = viewport.top + win.height();

		var bounds = this.offset();

		bounds.right  = bounds.left + this.outerWidth();
		bounds.bottom = bounds.top + this.outerHeight();

		return ( ! ( viewport.right < bounds.left || viewport.left > bounds.right || viewport.bottom < bounds.top || viewport.top > bounds.bottom ) );
	};

	// Load more automatically
	if ( jQuery( '.auto-load' )[0] ) {
		jQuery( window ).on( 'scroll', function() {
			if ( jQuery( '.auto-load' ).isOnScreen() === true ) {
				if ( ( jQuery( '.auto-load' ).css( 'display' ) != 'none' ) && ( ! jQuery( '.auto-load' ).hasClass( 'loading' ) ) ) {
					jQuery( '.auto-load' ).trigger( 'click' );
				}
			}
		});
	}
}

function wpj_init_load_more_messages() {
	if ( jQuery( '.js-messages-list' )[0] ) {
		jQuery( '.pusher' ).on( 'mousewheel DOMMouseScroll scroll', '.js-messages-list', function() {
			if ( jQuery( this ).scrollTop() - 1 <= jQuery( this ).innerHeight() - jQuery( this )[0].scrollHeight )
				jQuery( this ).find( '.js-load-more-icon' ).show().trigger( 'click' );

			if ( jQuery( this ).scrollTop() >= 0 )
				jQuery( this ).find( '.js-load-more-icon-down' ).show().trigger( 'click' );
		});
	}

	if ( jQuery( '#user_messages' )[0] ) {
		jQuery( '.pusher' ).on( 'mousewheel DOMMouseScroll scroll', '.pm-conversations-row-wrapper', function() {
			if ( jQuery( this ).scrollTop() + jQuery( this ).innerHeight() + 200 >= jQuery( this )[0].scrollHeight ) {
				if ( ! jQuery( this ).find( '.js-search-conversation-results' )[0] )
					jQuery( this ).find( '.js-load-more-icon-down' ).show().trigger( 'click' );
			}
		});
	}
}