jQuery( document ).ready( function( $ ) {

	// slider main menu
	$( document ).on( 'click', '.menu-direction-right', function( e ) {
		e.preventDefault();
		$( '.main-menu-container.slider' ).find( '.categories-menu-list' ).animate( {scrollLeft: '+=200'}, 500 );
	});

	$( document ).on( 'click', '.menu-direction-left', function( e ) {
		e.preventDefault();
		$( '.main-menu-container.slider' ).find( '.categories-menu-list' ).animate( {scrollLeft: '-=200'}, 500 );
	});

	// dropdown menu
	$( document ).on( 'click', '.nh-accordion-handler', function( e ) {
		e.preventDefault();

		if ( $( this ).parent().children( " .nh-accordion" ).css( "display" ) == "block" ) {
			$( this ).parent().children( ".nh-accordion" ).slideUp( 150 );
			$( this ).removeClass( "nh-accordion-selected" );

			e.stopPropagation();
		} else {
			$( this ).parent().children( ".nh-accordion" ).slideDown( 150 );
			$( this ).addClass( "nh-accordion-selected" );

			e.stopPropagation();
		}
	});

	$( document ).on( 'click', '.js-dropdown-menu-trigger', function( e ) {
		$( this ).parent().toggleClass( 'dropdown-menu-open' );
	});

	$( document ).click( function( e ) {
		$( '.js-dropdown-menu' ).each( function() {
			if ( $( this ).has( e.target ).length === 0 ) {
				$( this ).removeClass( 'dropdown-menu-open' );
			}
		});
	});

	// responsive menus
	$( document ).on( 'click', '.js-mobile-menu-toggle', function( e ) {
		if ( $( this ).attr( 'class' ).indexOf( 'menu-left' ) != -1 ) {
			if ( ! $( '.left.menu' ).hasClass( 'visible' ) ) {
				$( '.ui.sidebar.left' ).sidebar({
					onChange: function() { $( 'html[dir=rtl]' ).css( 'overflow-x', 'hidden' ); },
					onHidden: function() { $( 'html[dir=rtl]' ).css( 'overflow-x', '' ); },
				})
				.sidebar( 'toggle' );

			}
		}

		if ( $( this ).attr( 'class' ).indexOf( 'menu-right' ) != -1 ) {
			if ( ! $( '.right.menu' ).hasClass( 'visible' ) ) {
				$( '.ui.sidebar.right' ).sidebar({
					onChange: function() { $( 'html[dir=rtl]' ).css( 'overflow-x', 'hidden' ); },
					onHidden: function() { $( 'html[dir=rtl]' ).css( 'overflow-x', '' ); },
				})
				.sidebar( 'toggle' );
			}
		}
	});
});

// fixed menu
function wpj_add_fixed_menu_on_scroll() {
	// fixed header menu
	if ( wpj_vars.header_style == 'fixed' ) {
		if ( jQuery( window ).scrollTop() > 0 ) {
			jQuery( '.header-wrapper' ).addClass( 'fixed sticky' );
			jQuery( 'html' ).addClass( 'fixed-header' );

			// front page
			jQuery( '.home.without-header:not(.logged-in)' ).find( '.header-wrapper' ).find( '.header-wrapper-top' ).addClass( 'fixed sticky' );

		} else {
			jQuery( '.header-wrapper' ).removeClass( 'fixed sticky' );
			jQuery( 'html' ).removeClass( 'fixed-header' );

			// front page
			jQuery( '.home.without-header:not(.logged-in)' ).find( '.header-wrapper' ).find( '.header-wrapper-top' ).removeClass( 'fixed sticky' );

		}
	}

	// fixed header top menu
	if ( wpj_vars.header_style == 'fixed_top' ) {
		if ( jQuery( window ).scrollTop() > 0 ) {
			jQuery( '.header-wrapper-top' ).addClass( 'fixed' );
			jQuery( 'html' ).addClass( 'fixed-top-header' );

			// front page
			jQuery( '.home.without-header:not(.logged-in)' ).find( '.header-wrapper' ).find( '.header-wrapper-top' ).addClass( 'fixed' );

		} else {
			jQuery( '.header-wrapper-top' ).removeClass( 'fixed' );
			jQuery( 'html' ).removeClass( 'fixed-top-header' );

			// front page
			jQuery( '.home.without-header:not(.logged-in)' ).find( '.header-wrapper' ).find( '.header-wrapper-top' ).removeClass( 'fixed' );

		}
	}

	// fixed header bottom menu
	if ( wpj_vars.header_style == 'fixed_bottom' ) {
		if ( jQuery( window ).scrollTop() > jQuery( '.header-wrapper-top' ).height() ) {
			jQuery( '.header-wrapper-menu' ).addClass( 'fixed' );
			jQuery( 'html' ).addClass( "fixed-bottom-header" );

		} else {
			jQuery( '.header-wrapper-menu' ).removeClass( 'fixed' );
			jQuery( 'html' ).removeClass( 'fixed-bottom-header' );

		}

		// front page
		jQuery( '.home.without-header:not(.logged-in)' ).find( '.header-wrapper' ).css( 'position', 'absolute' );
	}

	// regular
	if ( ! wpj_vars.header_style || wpj_vars.header_style == 'regular' )
		// front page
		jQuery( '.home.without-header:not(.logged-in)' ).find( '.header-wrapper' ).css( 'position', 'absolute' );
}

// submenu left for first element of a new row
function wpj_change_first_menu_item_alignment() {
	var last_element = false;
	jQuery( 'ul.menu-list-with-children' ).children( 'li' ).each( function() {
		if ( last_element && last_element.offset().top != jQuery( this ).offset().top ) {
			if ( jQuery( this ).find( 'ul' ).hasClass( 'right0' ) ) {
				jQuery( this ).find( 'ul' ).removeClass( 'right0' ).removeClass( 'mr10' ).addClass( 'left0' );
			}
		}
		last_element = jQuery( this );
	});
}

// remove justify-content: space-between
function wpj_change_main_menu_alignment_by_height() {
	if ( jQuery( '.categories-menu-list.menu' )[0] && jQuery( '.categories-menu-list.menu li' ).length >= 1 ) {
		if ( jQuery( '.categories-menu-list.menu' ).children( 'li' ).first().offset().top != jQuery( '.categories-menu-list.menu' ).children( 'li' ).last().offset().top ) {
			jQuery( '.categories-menu-list.menu' ).css( 'justify-content', 'unset' );
		}
	}
}

// main menu
function wpj_change_long_main_menu_alignment() {
	if ( wpj_vars.long_menu_arrows == '1' ) {
		if ( jQuery( '.categories-menu-list' ).prop( 'scrollWidth' ) > jQuery( 'ul.categories-menu-list' ).prop( 'clientWidth' ) ) {
			jQuery( '.main-menu-wrapper' ).find( '.arrows-wrapper' ).addClass( 'visible' );
			jQuery( '.categories-menu-list' ).css( 'overflow', 'hidden' );
			jQuery( '.main-menu-container.slider' ).find( 'ul' ).css( 'white-space', 'nowrap' );

		} else {
			jQuery( '.main-menu-wrapper' ).find( '.arrows-wrapper' ).removeClass( 'visible' );
			jQuery( '.main-menu-container.slider' ).find( 'ul' ).css( 'overflow', 'visible' );
			jQuery( '.main-menu-container.slider' ).find( 'ul' ).css( 'white-space', 'initial' );

		}
	}
}