jQuery( document ).ready( function( $ ) {

	// iOS devices
	var ver = getIOSversion();
	if ( ver[0] >= 11 ) $( "body" ).addClass( "ios11" );

	// mobile iframe
	if ( inIframe() ) {
		$( 'body' ).addClass( 'wpj-is-iframe' );
		$( 'body' ).removeClass( 'wpj-maybe-iframe' );
		$.cookie( 'wpj_is_iframe', 'true', { expires: 7, path: '/' });

	} else {
		$( 'body' ).removeClass( 'wpj-is-iframe' );
		$( 'body' ).removeClass( 'wpj-maybe-iframe' );
		$.cookie( 'wpj_is_iframe', 'false', { expires: 7, path: '/' });

	}

});

function wpj_get_mobile_os() {
	var userAgent = navigator.userAgent || navigator.vendor || window.opera;

	  // Windows Phone must come first because its UA also contains "Android"
	if ( /windows phone/i.test( userAgent ) ) {
		return 'winphone';
	}

	if ( /android/i.test( userAgent ) ) {
		return 'android';
	}

	// iOS detection from: http://stackoverflow.com/a/9039885/177710
	if ( /iPad|iPhone|iPod/.test( userAgent ) && ! window.MSStream ) {
		return 'ios';
	}

	return '';
}