jQuery( document ).ready( function( $ ) {

	// Mark all notifications as read
	$( document ).on( 'click', '.js-mark-all-notifications-as-read', function( e ) {
		e.preventDefault();

		// Add loading class
		addLoader( '.all-notifications-list-wrapper' );

		$.ajax({
			type: "POST",
			url : wpj_vars.ajaxurl,
			data: {
				action                : 'mark_all_notifications_as_read_action',
				all_notifications_read: true
			},
			success: function( data ) {
				refreshContent( '.all-notifications-list-wrapper' );
			}
		});
	});

	// Mark notifications as read
	$( document ).on( 'click', '.js-mark-notification-as-read', function() {
		$( this ).removeClass( 'x' ).removeClass( 'icon' ).addClass( 'ui active inline loader' );

		$.ajax({
			type: "POST",
			url : wpj_vars.ajaxurl,
			data: {
				action         : 'mark_notification_as_read_action',
				notification_id: $( this ).attr( 'data-value' )
			},
			success: function( data ) {
				refreshContent( '.all-notifications-list-wrapper' );
			}
		});
	});

	// Save user checked notifications
	$( document ).on( 'click', '.js-save-user-checked-notifications', function( e ) {
		e.preventDefault();

		var $this = $( this );

		var email_notifications = [];
		$( 'input:checked[name="email_notifications[]"]' ).each( function() {
			email_notifications.push( $( this ).val() );
		});

		var sms_notifications = [];
		$( 'input:checked[name="sms_notifications[]"]' ).each( function() {
			sms_notifications.push( $( this ).val() );
		});

		$.ajax({
			type: "POST",
			url : wpj_vars.ajaxurl,
			data: {
				action: 'save_user_selected_notifications_action',
				email_notifications: email_notifications,
				sms_notifications: sms_notifications
			},
			beforeSend: function() {
				$this.addClass( 'ui button loading disabled' );
			},
			success: function( data ) {
				$( '.js-save-user-checked-notifications' ).notify( wpj_vars.success_saved, { position: 'right', className: 'success' } );
			},
			complete: function() {
				$this.removeClass( 'ui button loading disabled' );
			}
		});
	});

	$( document ).on( 'change', '#all-email-notify', function( e ) {
		var checkboxes = $( this ).closest( '.mail_notification' ).find( ':checkbox' );
		if ( $( this ).is( ':checked' ) ) {
			checkboxes.prop( 'checked', true );
			$( '#all-mail' ).find( 'label' ).text( wpj_vars.uncheck_all_email );

		} else {
			checkboxes.prop( 'checked', false );
			$( '#all-mail' ).find( 'label' ).text( wpj_vars.check_all_email );

		}
	});

	$( document ).on( 'change', '.mail_notification', function( e ) {
		wpj_check_notifications( 'all-email-notify', 'email_notifications' );
	});

	$( document ).on( 'change', '#all-sms-notify', function( e ) {
		var checkboxes = $( this ).closest( '.sms_notification' ).find( ':checkbox' );
		if ( $( this ).is( ':checked' ) ) {
			checkboxes.prop( 'checked', true );
			$( '#all-sms' ).find( 'label' ).text( wpj_vars.uncheck_all_sms );

		} else {
			checkboxes.prop( 'checked', false );
			$( '#all-sms' ).find( 'label' ).text( wpj_vars.check_all_sms );

		}
	});

	$( document ).on( 'change', '.sms_notification', function( e ) {
		wpj_check_notifications( 'all-sms-notify', 'sms_notifications' );
	});

	$( document ).on( 'click', '.js-resend-sms-code', function( e ) {
		if ( $( '.sms-countdown-wrapper' ).is( ':hidden' ) || e.originalEvent === undefined ) {
			if ( ! localStorage.endTime || localStorage.endTime < Date.now() ) {
				$.ajax({
					type: "POST",
					url : wpj_vars.ajaxurl,
					data: {
						action: 'resend_sms_verification_code_action',
						resend: true
					},
					success: function( data ) {}
				});
			}

			wpj_sms_countdown( true );
			$( '.sms-countdown-wrapper' ).show();
			jQuery( '.js-resend-sms-code' ).removeClass( 'primary' ).removeClass( 'cursor-pointer' );
		}
	});

});

// Check notification status
function wpj_check_notifications( id, cname ) {
	if ( jQuery( '.' + cname + ':checked' ).length == jQuery( '.' + cname ).length ) {
		jQuery( '#' + id ).prop( 'checked', true );

	} else {
		jQuery( '#' + id ).prop( 'checked', false );

	}
}

// SMS countdown
function wpj_sms_countdown( force_reset ) {
	if ( jQuery( '.js-sms-countdown' )[0] ) {
		var interval = parseInt( wpj_vars.resend_sms_time );
		if ( ! interval ) interval = 0;
		interval = interval * 1000;

		function reset() {
			localStorage.endTime = + new Date + interval;
		}

		if ( ! localStorage.endTime && force_reset )
			reset();

		var countdown = setInterval( function() {
			var remaining = localStorage.endTime - new Date;

			if ( remaining >= 0 ) {
				jQuery( '.js-sms-countdown' ).text( '(' + Math.floor( remaining / 1000 ) + ')' );

			} else {
				clearInterval( countdown );
				localStorage.endTime = '';
				jQuery( '.sms-countdown-wrapper' ).hide();
				jQuery( '.js-resend-sms-code' ).addClass( 'primary' ).addClass( 'cursor-pointer' );

			}

		}, 100 );
	}
}