jQuery( document ).ready( function( $ ) {

	// Delete a Row
	$( document ).on( 'click', '.pck-icon-rem', function( e ) {
		if ( $( '.pck-icon-rem' ).length > 1 ) {
			$( this ).parents( '.pck-repeater' ).remove();

		} else {
			$( '.pck-repeater .ui.checkbox' ).each( function(){
				$( this ).checkbox( 'uncheck' );
			});

			$( '.pck-inp-custom-name' ).val( '' );

		}
	});

	// Add a Row
	$( document ).on( 'click', '#add_custom_field_to_package', function( e ) {
		var clone = $( '.pck-repeater:first' ).clone();
		clone.find( 'input:text' ).val( '' );
		clone.find( 'input:checkbox' ).removeAttr( 'checked' );
		clone.find( '.pck-icon-rem' ).show();
		clone.appendTo( '.packages tbody' );

		$( '.ui.checkbox' ).checkbox();
	});

	// Add New Custom Field
	var indx   = 1;
	var indx_b = 1;
	var indx_s = 1;
	var indx_p = 1;
	$( document ).on( 'click', '#add_pck_custom_field', function( e ) {
		var new_field = $( '.pck-repeater:first' ).clone();

		if ( indx > ( JSON.parse( wpj_vars.pck_cf_name ).length - 1 ) ) indx = 1;
		if ( indx_b > ( JSON.parse( wpj_vars.pck_cf_name ).length - 1 ) ) indx_b = 1;
		if ( indx_s > ( JSON.parse( wpj_vars.pck_cf_name ).length - 1 ) ) indx_s = 1;
		if ( indx_p > ( JSON.parse( wpj_vars.pck_cf_name ).length - 1 ) ) indx_p = 1;

		new_field.find( ':input' ).each( function() {

			if ( ! $( this ).is( ":checked" ) ) $( this ).val( 'off' );

			if ( e.originalEvent !== undefined ) { // IF button is clicked
				new_field.find( 'input:text' ).val( '' );
				new_field.find( 'input:checkbox' ).removeAttr( 'checked' );
				new_field.find( '.pck-icon-rem' ).show();

				var new_handler_id = $( this ).parent().data( 'handler-id' ) + Math.floor( Math.random() * 1000001 );
				$( this ).parent().attr( 'data-handler-id', new_handler_id );
				$( this ).parent().siblings( '.ui.popup' ).attr( 'data-tooltip-id', new_handler_id );

			} else { // IF button is triggered( for edit job )
				var obj_cf_name = JSON.parse( wpj_vars.pck_cf_name );
				if ( this.name == 'pck-inp-custom-name[]' ) {
					$( this ).val( obj_cf_name[indx] ); indx++;
				}

				var obj_cf_basic = JSON.parse( wpj_vars.pck_cf_basic );
				if ( this.name == 'pck-chk-value[basic][]' ) {
					if ( obj_cf_basic[indx_b] == 'on' ) {
						$( this ).parent().checkbox( 'check' );
						$( this ).val( 'on' );

					} else {
						$( this ).parent().checkbox( 'uncheck' );
						$( this ).val( 'off' );

					} indx_b++;
				}

				var obj_cf_standard = JSON.parse( wpj_vars.pck_cf_standard );
				if ( this.name == 'pck-chk-value[standard][]' ) {
					if ( obj_cf_standard[indx_s] == 'on' ) {
						$( this ).parent().checkbox( 'check' );
						$( this ).val( 'on' );

					} else {
						$( this ).parent().checkbox( 'uncheck' );
						$( this ).val( 'off' );

					} indx_s++;
				}

				var obj_cf_premium = JSON.parse( wpj_vars.pck_cf_premium );
				if ( this.name == 'pck-chk-value[premium][]' ) {
					if ( obj_cf_premium[indx_p] == 'on' ) {
						$( this ).parent().checkbox( 'check' );
						$( this ).val( 'on' );

					} else {
						$( this ).parent().checkbox( 'uncheck' );
						$( this ).val( 'off' );

					} indx_p++;
				}
			}

		});

		new_field.appendTo( '.packages tbody' );

		$( '.ui.checkbox' ).checkbox();

		jQuery.fn.wpjTooltipInit();
	});

	// PCK CF Checkbox Change
	$( document ).on( "change", "input.pck_cf_chk", function() {
		var value = $( this ).is( ":checked" ) ? 'on' : 'off';
		$( this ).siblings( "input[type='hidden']" ).val( value );
	});

	// PCK Max Days Change
	$( document ).on( 'change', 'select[name="package_max_days[]"]', function() {
		wpj_pck_disable_efd_delivery_days();
	});

	// Select package
	$( document ).on( 'click', '.pck-sidebar-select-package, .pck-pc-select-package, .pck-mobile-select-package, .pck-sidebar-dropdown-select-package', function( e ) {
		var $this = $( this );
		var regex = /[+-]?\d+(\.\d+)?/g;
		var indx  = parseFloat( $( this ).attr( 'class' ).match( regex ) );

		// Change table column color
		wpj_change_pc_package_table_column_color( $this );

		// Sync all packages
		if ( $this.hasClass( 'pck-pc-select-package' ) ) {
			$( '.ui.menu.top' ).find( '.item'+ '.' + indx ).tab( 'change tab', $( '.pck-sidebar-select-package' + '.' + indx ).attr( 'data-tab' ) );
			$( '.ui.packages-tabs.menu' ).find( '.item'+ '.' + indx ).tab( 'change tab', $( '.pck-mobile-select-package' + '.' + indx ).attr( 'data-tab' ) );
			$( '.ui.accordion.packages-sidebar' ).accordion( 'open', indx );
			$( '.sidebar-top-info' ).find( '.type' ).html( $( this ).parents( '.packages-table' ).find( 'thead' ).find( '.active' ).text() );

		} else if ( $this.hasClass( 'pck-sidebar-select-package' ) ) {
			$( '.pck-pc-select-package' + '.' + indx ).find( 'button' ).trigger( 'click' );
			$( '.ui.packages-tabs.menu' ).find( '.item'+ '.' + indx ).tab( 'change tab', $( '.pck-mobile-select-package' + '.' + indx ).attr( 'data-tab' ) );
			$( '.ui.accordion.packages-sidebar' ).accordion( 'open', indx );
			$( '.sidebar-top-info' ).find( '.type' ).html( $( this ).text() );

		} else if ( $this.hasClass( 'pck-mobile-select-package' ) ) {
			$( '.pck-pc-select-package' + '.' + indx ).find( 'button' ).trigger( 'click' );
			$( '.ui.menu.top' ).find( '.item'+ '.' + indx ).tab( 'change tab', $( '.pck-sidebar-select-package' + '.' + indx ).attr( 'data-tab' ) );
			$( '.ui.accordion.packages-sidebar' ).accordion( 'open', indx );
			$( '.sidebar-top-info' ).find( '.type' ).html( $( this ).text() );

		} else if ( $this.hasClass( 'pck-sidebar-dropdown-select-package' ) ) {
			$( '.ui.menu.top' ).find( '.item'+ '.' + indx ).tab( 'change tab', $( '.pck-sidebar-select-package' + '.' + indx ).attr( 'data-tab' ) );
			$( '.pck-pc-select-package' + '.' + indx ).find( 'button' ).trigger( 'click' );
			$( '.ui.packages-tabs.menu' ).find( '.item'+ '.' + indx ).tab( 'change tab', $( '.pck-mobile-select-package' + '.' + indx ).attr( 'data-tab' ) );

			// Open sidebar accordion
			$( '.packages-sidebar .pck-sidebar-dropdown-select-package' ).removeClass( 'right' ).removeClass( 'labeled' ).find( 'i' ).hide();
			$this.addClass( 'right' ).addClass( 'labeled' ).find( 'i' ).show();

		}

		// Update package id
		$( '.package_no' ).val( indx );

		// Update the price
		$( '.package_price' ).val( $this.attr( 'data-price' ) );
		$( '.total' ).data( 'price', $this.attr( 'data-price' ) ).attr( 'data-price', $this.attr( 'data-price' ) );
		$( '.js-job-quantity-wrapper .extra-price-inside' ).html( $this.attr( 'data-price-formatted' ) );
		$( '.sidebar-top-info' ).find( '.price' ).html( $this.attr( 'data-price-formatted' ) );

		// Update delivery time
		$( '.package_delivery_days' ).val( $this.attr( 'data-delivery' ) );

		// Update the total price
		wpj_update_purchase_price( 'job_purchase' );
	});

});

// Set active classes
function wpj_change_pc_package_table_column_color( $this ) {
	jQuery( '.pc-packages .active' ).removeClass( 'active' );

	var col = $this.parents( 'tbody' ).siblings( 'thead' ).children( 'tr' ).children( 'th:nth(' + $this.index() + ')' ).index();

	// Check the column
	$this.find( '.ui.checkbox' ).checkbox( 'set checked' );

	// Add active class to table header
	$this.parents( 'tbody' ).siblings( 'thead' ).children( 'tr' ).children( 'th:nth(' + $this.index() + ')' ).addClass( 'active' );

	// Add active class to table body
	jQuery( 'td' ).filter( ':nth-child(' + ( col + 1 ) + ')' ).addClass( 'active' );
}

// Trigger add new custom field
function wpj_load_package_custom_fields() {
	if ( jQuery( '.page-id-' + wpj_vars.new_job_page_id )[0] && wpj_vars.pck_cf_name ) {
		jQuery.each( JSON.parse( wpj_vars.pck_cf_name ), function( key, value ) {
			if ( key != 0 && value != '' )
				jQuery( '#add_pck_custom_field' ).trigger( 'click' );
		});
	}
}

// Disable extra fast delivery field
function wpj_pck_disable_efd_delivery_days() {
	var price_type = jQuery( 'select[name="price_type"]' ).val();

	if ( price_type == 'package' ) {
		var total_days = 0;
		jQuery( 'select[name="package_max_days[]"]' ).each( function() {
			if ( jQuery( this ).val() > total_days ) total_days = parseInt( jQuery( this ).val() );
		});

		jQuery( '.max_days_fast.ui.dropdown .menu .item' ).each( function( ind, el ) {
			if ( parseInt( total_days ) && parseInt( jQuery( el ).data( 'value' ) ) >= parseInt( total_days ) )
				jQuery( el ).addClass( 'disabled' );

			else
				jQuery( el ).removeClass( 'disabled' );

		});
	}
}
