jQuery( document ).ready( function( $ ) {

	/* FILTER BUTTONS */
	$( document ).on( 'click', '.kt-tab-title-active, .kt-tab-title-inactive', function( e ) {
		if ( ! $( this ).parents( '.wp-block-kadence-tabs' ).hasClass( 'without-responsive-dropdown' ) ) {
			var active_tab = window.location.pathname.split( '/' ).filter( Boolean ).pop(); // get active tab

			if ( active_tab != $( this ).attr( 'id' ) ) {
				if ( jQuery( '.page-id-' + wpj_vars.page_on_front_page_id )[0] ) {
					history.pushState( null, null, wpj_vars.home_loggedin_url + '/' + $( this ).attr( 'id' ) ); // for pc
				} else {
					history.pushState( null, null, wpj_vars.parent_url + $( this ).attr( 'id' ) ); // for pc
				}

				$( this ).parents( '.kt-tabs-wrap' ).find( '.ui.dropdown' ).dropdown( 'set selected', $( '.kt-tab-title-active' ).attr( 'id' ) ); // for mobile
			}
		}
	});

	/* BROWSER NAVIGATION */
	$( window ).on( 'popstate', function( e ) {
		var active_tab = window.location.pathname.match( /([^\/]*)\/*$/ )[1]; // get active tab
		$( '.kt-tabs-wrap' ).find( '.ui.dropdown' ).dropdown( 'set selected', active_tab ); // for mobile
	});

	/* SHOW/HIDE FIELDS ON LET'S MEET */
	$( document ).on( 'change', '.js-lets-meet-trigger', function( e ) {
		if ( $( '.wp-block-kadence-rowlayout' )[0] ) {

			if ( this.checked ) {
				$( '.js-lets-meet-item' ).each( function() {
					$( this ).parents( '.kt-inside-inner-col:first' ).show();
					$( this ).parents( '.wp-block-kadence-rowlayout' ).eq( 1 ).show();
				});

			} else {
				$( '.js-lets-meet-item' ).each( function() {
					$( this ).parents( '.kt-inside-inner-col:first' ).hide();

					if ( $( this ).parents( '.wp-block-kadence-rowlayout:first' ).find( '.wp-block-kadence-column' ).find( '.kt-inside-inner-col:visible' ).length == 0 ) {
						$( this ).parents( '.wp-block-kadence-rowlayout' ).eq( 1 ).hide();
					}
				});

			}

		}
	});

	/* JOB BULK ACTION BUTTON */
	$( document ).on( 'click', '.js-job-bulk-action-btn', function( e ) {
		e.preventDefault();
		$( '.js-job-bulk-action-button' ).trigger( 'click' );
	});

	/* REQUEST BULK ACTION BUTTON */
	$( document ).on( 'click', '.js-request-bulk-action-btn', function( e ) {
		e.preventDefault();
		$( '.js-request-bulk-action-button' ).trigger( 'click' );
	});

	/* MESSAGE SETTINGS BUTTON */
	$( document ).on( 'click', '.js-message-settings-action-btn', function( e ) {
		e.preventDefault();
		$( '.js-message-settings-action-button' ).trigger( 'click' );
	});

});

/* TABS TO DROPDOWN RESPONSIVE */
( function ( $ ) {
	$.fn.wpjPBTabsToDropdownInit = function() {
		if ( $( '.wp-block-kadence-tabs' )[0] ) {
			$( '.wp-block-kadence-tabs' ).not( '.without-responsive-dropdown' ).each( function() {
				var $cnt = $( this ).find( '.kt-tabs-wrap' );

				$( '<select />' ).insertAfter( $cnt.find( '.kt-tabs-title-list' ).first() );

				$cnt.find( '.kt-tabs-title-list' ).first().find( '.kt-title-item' ).each( function() {
					var $el = $( this );

					$( '<option />', {
						'value'   : $el.attr( 'id' ),
						'text'    : $el.text(),
					}).appendTo( $cnt.find( 'select' ).first() );
				});

				$cnt.find( 'select' ).change( function() {
					if ( jQuery( '.page-id-' + wpj_vars.page_on_front_page_id )[0] ) {
						history.pushState( null, null, wpj_vars.home_loggedin_url + '/' + $( this ).val() ); // for pc
					} else {
						history.pushState( null, null, wpj_vars.parent_url + $( this ).val() );
					}

					wpj_change_kadence_active_tab( $( this ).val() );
				});

				$cnt.find( 'select' ).addClass( 'fluid' );
				$cnt.find( 'select' ).dropdown( { message: { noResults: wpj_vars.nothing_found } } );
			});
		}
	}
} ( jQuery ) );

/* ADD FORM ELEMENT TO PAGE */
function wpj_add_form_element() {
	// user registration
	if (
		wpj_vars.is_user_logged_in != true
		&& ( jQuery( '.page-id-' + wpj_vars.register_page_id )[0] || jQuery( '.js-user-register-modal' )[0] )
		&& jQuery( '.kt-inside-inner-col' )[0]
	) {
		jQuery( '.register-wrapper-row .wp-block-kadence-column.ui.form' ).find( '.kt-inside-inner-col:first > *' ).wrapAll( '<form action="' + wpj_vars.site_URL + '/wp-login.php?action=register" class="ui form js-register-form" method="post"></form>' );
		jQuery( '.register-wrapper-row .wp-block-kadence-column.ui.form' ).removeClass( 'ui form' );
	}

	// user lost password
	if (
		wpj_vars.is_user_logged_in != true
		&& ( jQuery( '.page-id-' + wpj_vars.lost_password_page_id )[0] || jQuery( '.js-user-lost-password-modal' )[0] )
		&& jQuery( '.kt-inside-inner-col' )[0]
	) {
		jQuery( '.lost-password-wrapper-row .wp-block-kadence-column.ui.form' ).find( '.kt-inside-inner-col:first > *' ).wrapAll( '<form action="' + wpj_vars.site_URL + '/wp-login.php?action=lostpassword" class="ui form js-user-lost-password-modal" method="post"></form>' );
		jQuery( '.lost-password-wrapper-row .wp-block-kadence-column.ui.form' ).removeClass( 'ui form' );
	}

	// user settings
	if ( jQuery( '.page-id-' + wpj_vars.user_settings_page_id )[0] && jQuery( '.kt-tab-inner-content' )[0] ) {
		jQuery( '.kt-tab-inner-content' ).each( function() {
			jQuery( this ).find( '.kt-tab-inner-content-inner:first > *' ).wrapAll( '<form class="ui form" method="post" enctype="multipart/form-data"></form>' );
		});
	}

	// post new request
	if ( jQuery( '.page-id-' + wpj_vars.new_request_page_id )[0] && jQuery( '.kt-inside-inner-col' )[0] ) {
		jQuery( '.post-new-wrapper' ).wrapAll( '<form id="add-edit-request-form" class="ui form" method="post" enctype="multipart/form-data"></form>' );
		jQuery( '.post-new-wrapper' ).find( '.wp-block-kadence-column.ui.form' ).removeClass( 'ui form' );

		// init popup and calendar fields
		jQuery.fn.wpjTooltipInit();
		jQuery.fn.wpjCalendarInit();
	}

	// post new job
	if ( jQuery( '.page-id-' + wpj_vars.new_job_page_id )[0] && jQuery( '.wp-block-kadence-tabs' )[0] ) {
		jQuery( '.post-new-wrapper' ).wrapAll( '<form id="add-edit-job-form" class="ui form" method="post" enctype="multipart/form-data"></form>' );
		jQuery( '.post-new-wrapper' ).find( '.wp-block-kadence-column.ui.form' ).removeClass( 'ui form' );

		// init popup fields
		jQuery.fn.wpjTooltipInit();
	}

	Hooks.do_action( 'wpj_after_form_added_to_page_builder' );
}

/* REINIT PB TABS TO FIX THE URL HASH */
function wpj_reinit_kadence_tabs() {
	if ( jQuery( '.wp-footer-scripts script[src*="kadence-blocks/includes/assets/js/kt-tabs.min.js"]' )[0] ) {
		var tabs_script = jQuery( '.wp-footer-scripts script[src*="kadence-blocks/includes/assets/js/kt-tabs.min.js"]' )[0].outerHTML;

		jQuery( '.wp-footer-scripts script[src*="kadence-blocks/includes/assets/js/kt-tabs.min.js"]' ).remove();
		jQuery( tabs_script ).appendTo( '.wp-footer-scripts' );
	}
}

/* CHANGE TAB */
function wpj_change_kadence_active_tab( active_tab ) {
	if ( jQuery( '.kt-tabs-title-list' )[0] && ! jQuery( '.page-id-' + wpj_vars.new_job_page_id )[0] && ! jQuery( '.page-id-' + wpj_vars.new_request_page_id )[0] ) {
		// Active Tab
		if ( typeof active_tab === 'undefined' ) {
			var split1 = window.location.pathname.split( wpj_vars.page_name );

			if ( typeof split1[1] !== 'undefined' ) {
				var split2 = split1[1].split( '/' );
				var active_tab = split2[1];
			}
		}

		if ( ! jQuery( '#' + active_tab )[0] )
			active_tab = jQuery( '.kt-tabs-title-list' ).find( 'li:first' ).attr( 'id' );

		if ( jQuery( '#' + active_tab )[0] ) {
			// Kadence Tab
			var current_tab = window.document.querySelector( '#' + active_tab );
			var tab_number  = current_tab.querySelector( 'a' ).getAttribute( 'data-tab' );
			var tab_wrapper = current_tab.closest( '.kt-tabs-wrap' );

			const prev_active_anchor = tab_wrapper.querySelector( ':scope > .kt-tabs-title-list > li.kt-tab-title-active a' );
			prev_active_anchor.parentElement.classList.replace( 'kt-tab-title-active', 'kt-tab-title-inactive' );
			prev_active_anchor.setAttribute( 'tabindex', '-1' );
			prev_active_anchor.setAttribute( 'aria-selected', 'false' );

			tab_wrapper.className = tab_wrapper.className.replace( /\bkt-active-tab-\S+/g, 'kt-active-tab-' + tab_number );

			const new_active_anchor = tab_wrapper.querySelector( ':scope > .kt-tabs-title-list > li.kt-title-item-' + tab_number + ' a' );
			new_active_anchor.parentElement.classList.replace( 'kt-tab-title-inactive', 'kt-tab-title-active' );
			new_active_anchor.setAttribute( 'tabindex', '0' );
			new_active_anchor.setAttribute( 'aria-selected', 'true' );

			tab_wrapper.querySelectorAll( ':scope > .kt-tabs-content-wrap > .kt-tab-inner-content' ).forEach( ( tab ) => { tab.style.display = 'none'; });
			tab_wrapper.querySelector( ':scope > .kt-tabs-content-wrap > .kt-inner-tab-' + tab_number ).style.display = 'block';

			// Mobile Dropdown
			jQuery( '.kt-tabs-title-list' ).siblings( '.ui.dropdown' ).dropdown( 'set selected', active_tab );
		}

		// Load images
		if ( typeof jQuery.fn.wpjLazyLoadRender == 'function' ) jQuery.fn.wpjLazyLoadRender();
	}
}

/* REFRESH TAB CONTENT */
function wpj_refresh_kadence_tab_content() {
	// tab button
	if ( jQuery( '.kt-tabs-title-list' )[0] ) {
		jQuery( '.kt-tabs-title-list li' ).each( function() {
			refreshContent( '.' + jQuery.trim( jQuery( this ).find( 'a' ).attr( 'class' ) ).split( /\s+/ ).join( '.' ) );
		});
	}

	// tab content
	if ( jQuery( '.kt-tabs-content-wrap' )[0] ) refreshContent( '.kt-tabs-content-wrap' );
}

/* HIDE POST NEW DISABLED FIELDS */
function wpj_hide_disabled_page_builder_post_new_fields() {
	if ( jQuery( '.post-new-optional-fields-row-wrapper' )[0] )
		jQuery( '.post-new-optional-fields-row-wrapper' ).show();

	if (
		jQuery( '.subcategory-field-wrapper' )[0]
		&& ( jQuery.trim( jQuery( '.subcategory-field-wrapper' ).find( '#request_subcategories' ).text() ) != ''
			|| jQuery.trim( jQuery( '.subcategory-field-wrapper' ).find( '#job_subcategories' ).text() ) != '' )
	) {
		jQuery( '.subcategory-field-wrapper' ).find( '.kt-inside-inner-col' ).show();
	}

	if ( jQuery( '.js-disabled-field' )[0] ) {
		jQuery( '.js-disabled-field' ).each( function() {
			jQuery( this ).parents( '.kt-inside-inner-col' ).eq( 0 ).hide();

			if ( jQuery( this ).parents( '.wp-block-kadence-column:first' ).siblings( '.wp-block-kadence-column' ).find( '.kt-inside-inner-col' ).text().length <= 0 )
				jQuery( this ).parents( '.wp-block-kadence-rowlayout' ).eq( 1 ).hide(); // half solo

			if ( jQuery( this ).parents( '.wp-block-kadence-column:first' ).siblings( '.wp-block-kadence-column' ).find( '.js-disabled-field' ).length > 0 )
				jQuery( this ).parents( '.wp-block-kadence-rowlayout' ).eq( 1 ).hide(); // empty row

			if ( jQuery( this ).parents( '.wp-block-kadence-column:first' ).siblings( '.wp-block-kadence-column' ).find( '.kt-inside-inner-col' ).find( '.js-tooltip-handler' ).length <= 0 )
				jQuery( this ).parents( '.wp-block-kadence-rowlayout' ).eq( 0 ).hide();

			if (
				jQuery( this ).parents( '.wp-block-kadence-rowlayout:first' ).siblings( '.wp-block-kadence-rowlayout:visible' ).length == 0
				&& jQuery( this ).parents( '.wp-block-kadence-rowlayout:first' ).siblings( '.wp-block-kadence-spacer' )[0]
			)
				jQuery( this ).parents( '.wp-block-kadence-rowlayout' ).eq( 1 ).hide(); // extra

		});
	}

}

/* ADD USER COVER CLASS */
function wpj_add_user_cover_class() {
	if ( jQuery( '.user-profile-cover-row-wrapper' )[0] ) {
		if ( jQuery( '.ub-cover-photo' )[0] )
			jQuery( '.user-profile-cover-row-wrapper' ).addClass( 'user-has-cover js-user-has-cover' );
		else
			jQuery( '.user-profile-cover-row-wrapper' ).removeClass( 'user-has-cover js-user-has-cover' );
	}
}

/* SHOW SELLERS PROJECTS CAROUSEL */
function wpj_show_sellers_projects_carousel() {
	if ( jQuery( '.seller-projects-carousel-wrapper' )[0] ) {
		setTimeout( function() {
			if ( jQuery( '.seller-projects-carousel-wrapper' ).find( '.kt-post-slider-item' )[0] ) {
				jQuery( '.seller-projects-carousel-wrapper' ).show();
				jQuery( '.jobs-images-carousel' ).hide();
			}
		}, 100 );
	}
}

/* INIT PM CUSTOM OFFER MODAL */
function wpj_init_send_custom_offer_page_builder_modal() {
	jQuery( '.js-message-custom-offer-action-btn' ).attr( 'data-unique-id', jQuery( '.pm-list' ).attr( 'data-uid' ) );
}

/* SHOW CONTACT/FEATURE BUTTON */
function wpj_show_contact_or_feature_button() {
	if ( jQuery( 'body' ).is( '.single.single-job.logged-in' ) ) {
		if ( wpj_vars.featured_enable == 1 && wpj_vars.uid == jQuery( '.js-buy-job-button' ).attr( 'data-author' ) )
			jQuery( '.wp-block-kadence-advancedbtn .kt-button.button.feature-button-link' ).css( 'display', 'flex' );

		else if ( wpj_vars.uid != jQuery( '.js-buy-job-button' ).attr( 'data-author' ) )
			jQuery( '.wp-block-kadence-advancedbtn .kt-button.button.contact-button-link' ).css( 'display', 'flex' );

	} else
		jQuery( '.wp-block-kadence-advancedbtn .kt-button.button.contact-button-link' ).addClass( 'login-link' ).css( 'display', 'flex' );
}