jQuery( window ).ready( function( $ ) {

	// Expand user notifications
	$( document ).on( 'click', '.notifications-icon .user-notification-icon-link', function( e ) {
		e.preventDefault();

		if ( $( '.notifications-icon-dropdown' ).css( 'display' ) == 'block' && ! isMobile() ) {

			$( '.messages-icon' ).attr( 'data-position', 'bottom center' );
			$( '.notifications-icon' ).attr( 'data-position', 'bottom center' );

			$( '.notifications-icon-dropdown' ).css( 'display', 'none' );

			e.stopPropagation();

		} else {

			if ( isMobile() )
				$( '.messages-icon' ).attr( 'data-position', 'right center' );
			else
				$( '.messages-icon' ).attr( 'data-position', 'left center' );

			$( '.notifications-icon' ).attr( 'data-position', 'right center' );

			$( '.notifications-icon-dropdown' ).css( 'display', 'block' );

			e.stopPropagation();

		}

		$.ajax({
			url: wpj_vars.ajaxurl,
			data : {
				action: 'load_preview_notification_list_action'
			},

			beforeSend: function() {
				$( '.notifications-icon-dropdown' ).each( function() {
					$( this ).html( '<center><img src="' + wpj_vars.theme_path + '/assets/images/loader/loader-green.svg"></center>' );
				});
			},

			success: function( data ) {
				$( '.notifications-icon-dropdown' ).each( function() {
					$( this ).html( data );

					$( '.antiscroll-inner' ).mCustomScrollbar({
						theme: 'minimal-dark'
					});
				});
			}
		});
	});

	// Collpase user notifications
	$( document ).mouseup( function ( e ) {
		var notifications_container = $( '.notifications-icon-dropdown' );
		var notifications_handler   = $( '.notifications-icon' );

		if ( ! notifications_container.is( e.target ) // if the target of the click isn't the container...
			&& notifications_container.has( e.target ).length === 0 // ... nor a descendant of the container
			&& ! notifications_handler.is( e.target )
			&& notifications_handler.has( e.target ).length === 0 )
		{
			if ( ! isMobile() ) {
				$( '.messages-icon' ).attr( 'data-position', 'bottom center' );
				$( '.notifications-icon' ).attr( 'data-position', 'bottom center' );
			}

			// Close preview panel
			notifications_container.css( 'display', 'none' );
		}
	});

	// Expand user messages
	$( document ).on( 'click', '.messages-icon .user-notification-icon-link', function( e ) {
		e.preventDefault();

		if ( $( '.messages-icon-dropdown' ).css( 'display' ) == 'block' && ! isMobile() ) {

			$( '.messages-icon' ).attr( 'data-position', 'bottom center' );
			$( '.notifications-icon' ).attr( 'data-position', 'bottom center' );

			$( '.messages-icon-dropdown' ).css( 'display', 'none' );

			e.stopPropagation();

		} else {

			if ( isMobile() )
				$( '.messages-icon' ).attr( 'data-position', 'right center' );
			else
				$( '.messages-icon' ).attr( 'data-position', 'left center' );

			$( '.notifications-icon' ).attr( 'data-position', 'right center' );

			$( '.messages-icon-dropdown' ).css( 'display', 'block' );

			e.stopPropagation();

		}

		$.ajax({
			url: wpj_vars.ajaxurl,
			data : {
				action: 'load_preview_pm_list_action'
			},

			beforeSend: function() {
				$( '.messages-icon-dropdown' ).each( function() {
					$( this ).html( '<center><img src="' + wpj_vars.theme_path + '/assets/images/loader/loader-green.svg"></center>' );
				});
			},

			success: function( data ) {
				$( '.messages-icon-dropdown' ).each( function() {
					$( this ).html( data );

					$( '.antiscroll-inner' ).mCustomScrollbar({
						theme: 'minimal-dark'
					});
				});
			}
		});
	});

	// Collpase user messages
	$( document ).mouseup( function ( e ) {
		var messages_container = $( '.messages-icon-dropdown' );
		var messages_handler   = $( '.messages-icon-dropdown' );

		if ( ! messages_container.is( e.target ) // if the target of the click isn't the container...
			&& messages_container.has( e.target ).length === 0 // ... nor a descendant of the container
			&& ! messages_handler.is( e.target )
			&& messages_handler.has( e.target ).length === 0 )
		{
			if ( ! isMobile() ) {
				$( '.messages-icon' ).attr( 'data-position', 'bottom center' );
				$( '.notifications-icon' ).attr( 'data-position', 'bottom center' );
			}

			// Close preview panel
			messages_container.css( 'display', 'none' );
		}
	});

});
