jQuery( document ).ready( function( $ ) {

	// New quick response
	$( document ).on( 'click', '#new-quick-response', function( e ) {

		var uid = $( this ).attr( 'data-uid' );

		$( '#new-quick-response-modal-' + uid ).find( '.header' ).first().html( wpj_vars.add_quick_response );

		$( '#new-quick-response-modal-' + uid )
			.modal({
				onVisible: function() {
					// clear the inputs
					$( '#new-quick-response-modal-' + uid ).find( '.quick-response-name-input' ).val( '' );
					$( '#new-quick-response-modal-' + uid ).find( '.quick-response-content-textarea' ).val( '' );
					$( '#new-quick-response-modal-' + uid ).find( '.edit-action' ).val( '' );
				}
			})
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' )
			.modal( 'refresh' );

	});

	// Edit quick response
	$( document ).on( 'click', '#edit-quick-response', function( e ) {

		e.preventDefault();

		// Remove autocomplete text
		var this_editor = wpj_get_editor_element( $( this ) );

		this_editor.html( '' );

		var id  = $( this ).attr( 'data-id' );
		var uid = $( this ).attr( 'data-uid' );

		$( '#new-quick-response-modal-' + uid ).find( '.header' ).first().html( wpj_vars.edit_quick_response );

		var last_quick_response = JSON.parse( localStorage.getItem( 'last_quick_response' ) );

		if ( wpj_vars.quick_responses.hasOwnProperty( id ) ) {
			var name    = wpj_vars.quick_responses[id].name;
			var content = wpj_vars.quick_responses[id].content;

		} else {
			var name    = last_quick_response[1];
			var content = last_quick_response[2];

		}

		$( '#new-quick-response-modal-' + uid )
			.modal({
				onVisible: function() {
					$( this ).find( '.quick-response-name-input' ).val( name );
					$( this ).find( '.quick-response-content-textarea' ).val( content );
					$( this ).find( '.edit-action' ).val( id );
				}
			})
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' )
			.modal( 'refresh' );

	});

	// Save quick response
	$( document ).on( 'click', '#save-quick-response', function( e ) {

		var uid               = $( this ).attr( 'data-uid' );
		var this_modal_elem   = $( this ).parents( '#new-quick-response-modal-' + uid );
		var this_select_elemt = $( '.quick-response-dropdown' );

		// get name and content
		var name    = this_modal_elem.find( '.quick-response-name-input' ).val();
		var content = this_modal_elem.find( '.quick-response-content-textarea' ).val();

		if ( name && content ) {

			// hide errors
			$( '#quick-response-error' ).html( '' ).addClass( 'hidden' ).removeClass( 'visible' );

			// hide modal
			this_modal_elem.modal( 'hide' );

			// generate array of existing numbers for data_id
			var restricted = [0];
			if ( this_select_elemt.find( '.menu' ).find( '.item' )[0] ) {
				this_select_elemt.find( '.menu' ).find( '.item' ).each( function() {
					restricted.push( $( this ).attr( 'data-id' ) );
				});
			}

			// get last quick response id
			if ( this_modal_elem.find( '.edit-action' ).val() ) {
				var data_id = this_modal_elem.find( '.edit-action' ).val();
			} else {
				var data_id = generateNumber( restricted );
			}

			// save content to localstorage
			localStorage.setItem( 'last_quick_response', JSON.stringify( [data_id, name, content] ) );

			// insert/edit quick response to dropdown
			if ( this_modal_elem.find( '.edit-action' ).val() ) {

				this_select_elemt.find( '.menu' ).find( '.item[data-id="' + this_modal_elem.find( '.edit-action' ).val() + '"]' ).find( 'span' ).text( name );

			} else {

				// display delete all link
				$( '.quick-response-dropdown' ).find( '#delete-all-quick-responses-wrapper' ).show();

				// remove no quik responses item
				$( '.quick-response-dropdown' ).find( '#no-quick-responses' ).remove();

				var new_item = '\
					<div class="item" data-id="' + data_id + '">\
						\
						<span>' + name.substring( 0, 25 ) + '</span>\
						\
						<div class="action-buttons float-right">\
								<i data-uid="' + uid + '" data-id="' + data_id + '" id="edit-quick-response" class="edit icon"></i>\
								<i data-uid="' + uid + '" data-id="' + data_id + '" id="remove-quick-response" class="close red icon"></i>\
						</div>\
						\
					</div>\
				';
				$( new_item ).insertAfter( this_select_elemt.find( '.menu' ).find( '.header:nth-child(3)' ) );

			}

			// clear the inputs
			$( '.quick-response-name-input' ).val( '' );
			$( '.quick-response-content-textarea' ).val( '' );

			// save quick response
			$.ajax({
				type : 'post',
				url  : wpj_vars.ajaxurl,
				data : {
					action : 'save_quick_response_action',
					id     : data_id,
					name   : name,
					content: content
				},
				success : function( data ) {

				}
			});

		} else {
			$( '#quick-response-error' ).html( wpj_vars.empty_quick_response ).removeClass( 'hidden' ).addClass( 'visible' );

		}

	});

	// Remove quick response
	$( document ).on( 'click', '#remove-quick-response', function( e ) {

		e.preventDefault();

		var id  = $( this ).attr( 'data-id' );
		var uid = $( this ).attr( 'data-uid' );

		// Remove autocomplete text
		var this_editor = wpj_get_editor_element( $( this ) );

		this_editor.html( '' );

		var this_select_elemt = $( '.quick-response-dropdown' );

		$( '.item[data-id="' + id + '"]' ).remove();

		// if no quick responses
		if ( ! this_select_elemt.find( '.menu' ).find( '.item' )[0] ) {

			// add no quik responses item
			var no_responses_item = '<div class="item" id="no-quick-responses">' + wpj_vars.no_quick_responses + '</div>';
			$( no_responses_item ).insertAfter( this_select_elemt.find( '.menu' ).find( '.header:nth-child(3)' ) );

			// hide delete all link
			$( '.quick-response-dropdown' ).find( '#delete-all-quick-responses-wrapper' ).hide();

		}

		// delete quick response
		$.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'delete_quick_response_action',
				id     : id
			},
			success : function( data ) {

			}
		});

	});

	// INIT 'Remove all quick responses' MODAL
	$( document ).on( 'click', '#delete-all-quick-responses', function( e ) {

		var uid = $( this ).attr( 'data-uid' );

		$( '#delete-all-quick-responses-modal-' + uid )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' )
			.modal( 'refresh' );

	});

	// Remove all quick responses action
	$( document ).on( 'click', '#delete-all-quick-responses-action', function( e ) {

		var uid               = $( this ).attr( 'data-uid' );
		var this_select_elemt = $( '.quick-response-dropdown' );

		// Remove autocomplete text
		var this_editor = wpj_get_editor_element( $( this ) );

		this_editor.html( '' );

		// hide delete all link
		$( '.quick-response-dropdown' ).find( '#delete-all-quick-responses-wrapper' ).hide();

		// hide modal
		var this_modal_elem = $( this ).parents( '#delete-all-quick-responses-modal-' + uid );
		this_modal_elem.modal( 'hide' );

		// delete items
		this_select_elemt.find( '.menu' ).find( '.item' ).each( function() {
			$( this ).remove();
		});

		// add no quik responses item
		var no_responses_item = '<div class="item" id="no-quick-responses">' + wpj_vars.no_quick_responses + '</div>';
		$( no_responses_item ).insertAfter( this_select_elemt.find( '.menu' ).find( '.header:nth-child(3)' ) );

		// delete all quick responses
		$.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'delete_quick_responses_action'
			},
			success : function( data ) {}
		});

	});

});

// Select quick response
function wpj_init_quick_responses() {
	if ( jQuery( '.quick-response-dropdown' ).length ) {
		jQuery( '.ui.dropdown.quick-response-dropdown' ).dropdown({
			fullTextSearch: true,
			message: { noResults: wpj_vars.nothing_found },
			onChange: function ( value, text, selected_item ) {
				wpj_insert_quick_response_to_textarea( selected_item, jQuery( this ) );
			}
		});
	}
}

function wpj_insert_quick_response_to_textarea( selected_item, wrapper ) {

	if ( selected_item ) {

		var sel_item            = jQuery( selected_item ).data( 'id' );
		var last_quick_response = JSON.parse( localStorage.getItem( 'last_quick_response' ) );

		if ( sel_item ) {

			if ( wpj_vars.quick_responses.hasOwnProperty( sel_item ) ) {

				if ( last_quick_response && last_quick_response[0] == sel_item ) {

					if ( wpj_vars.quick_responses[sel_item].content == last_quick_response[2] ) {
						var message = wpj_vars.quick_responses[sel_item].content;

					} else {
						var message = last_quick_response[2];

					}

				} else {
					var message = wpj_vars.quick_responses[sel_item].content;

				}

			} else {
				var message = last_quick_response[2];

			}

			message = message.replace( '{username}', wrapper.attr( 'data-username' ) ).replace( /\n/g, "<br />" );

			var this_editor = wpj_get_editor_element( wrapper );

			this_editor.html( message );

			this_editor.focus();

			// move curosor to the end of the text
			document.execCommand( 'selectAll', false, null );
			document.getSelection().collapseToEnd();

		}

	}

}

function wpj_get_editor_element( wrapper ) {
	if ( wrapper.parents( '.emoji-enabled' )[0] ) {
		return wrapper.parents( '.emoji-enabled' ).find( '.emojionearea-editor' );

	} else {
		if ( wrapper.parents( '.message-box-wrapper' )[0] ) {
			return wrapper.parents( '.message-box-wrapper' ).find( '.message-field' );

		} else if ( wrapper.parents( '.thread-input' )[0] ) {
			return wrapper.parents( '.thread-input' ).find( '.message-field' );

		} else {
			return wrapper.parents( '.quick-response-wrapper' ).siblings( '.message-field' );

		}

	}
}