jQuery( function( $ ) {

	// Open modal
	$( document ).on( 'click', '.report-link', function( e ) { e.preventDefault();
		var id = $( this ).attr( 'data-id' );
		$( '.ui.modal.report-modal.' + id ).modal( 'setting', 'transition', 'fly down' ).modal( 'show' ).modal( 'refresh' );
		$( '.report-error-wrapper' ).html( '' );
	});

	// Send report
	$( document ).on( 'click', '.report-submit', function( e ) { e.preventDefault();
		var $this = $( this );

		$this.addClass( 'loading' );

		$.ajax({
			data    : $( this ).parents( 'form' ).serialize(),
			type    : 'POST',
			dataType: 'json',
			url     : wpj_vars.ajaxurl,
			success : function( msg ) {
				$this.removeClass( 'loading' );

				if ( msg.err == '1' ) {
					$( '.report-error-wrapper' ).html( '<div class="ui negative visible message">' + msg.msg + '</div><div class="ui hidden divider"></div>' );

				} else {
					$( '.report-error-wrapper' ).html( '<div class="ui positive visible message">' + msg.msg + '</div><div class="ui hidden divider"></div>' );
					setTimeout( function() {
						$this.parents( '.ui.modal' ).modal( 'hide' );
						$this.parents( 'form' ).form( 'clear' );
					}, 1000 );

				}

			}
		});
	});

});