//---------------------------------------
// Request Activate / Deactivate / Delete
//---------------------------------------
jQuery( document ).ready( function( $ ) {

	// Activate - modal
	$( document ).on( 'click', '.js-activate-request-link', function() {
		$( '.js-activate-request-action' ).attr( 'data-id', $( this ).attr( 'data-id' ) );

		$( '.request-title-modal' ).html( validateInputContent( $( this ).attr( 'data-title' ) ) );

		$( '.ui.modal.js-activate-request-modal' )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' );
	});

	// Activate - action
	$( document ).on( 'click', '.js-activate-request-action', function( e ) {
		$.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'activate_request_action',
				post_id: $( this ).attr( 'data-id' )
			},
			beforeSend: function() {
				$( '.js-activate-request-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( response == '1' ) {
					if ( $( '.single-request' )[0] ) {
						changeURL( wpj_vars.page_url );

					} else {
						if ( $( '.js-user-requests-wrapper' )[0] ) refreshContent( '.js-user-requests-wrapper' ); // for code
						else wpj_refresh_kadence_tab_content(); // for page builder

					}
				}
				else if ( response == 'not_your_post' ) $( '.content.activate-request' ).text( wpj_vars.not_your_post );
				else if ( response == 'no_credits' )    $( '.content.activate-request' ).text( wpj_vars.no_credits );
				else if ( response == 'not_logged_in' ) $( '.content.activate-request' ).text( wpj_vars.not_logged_in );
			},
			complete: function() {
				$( '.js-activate-request-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-activate-request-modal' ).modal( 'hide' );
			}
		});
	});

	// Activate all - modal
	$( document ).on( 'click', '#js-activate-all-requests-link', function( e ) {
		$( '.ui.modal.js-activate-all-requests-modal' ).modal( 'setting', 'transition', 'fly down' ).modal( 'show' );
	});

	// Activate all - action
	$( document ).on( 'click', '.js-activate-all-requests-action', function( e ) {
		$.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: { action : 'activate_all_requests_action', reason: 'by_user' },
			beforeSend: function() {
				$( '.js-activate-all-requests-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( $( '.js-user-requests-wrapper' )[0] ) refreshContent( '.js-user-requests-wrapper' ); // for code
				else wpj_refresh_kadence_tab_content(); // for page builder
			},
			complete: function() {
				$( '.js-activate-all-requests-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-activate-all-requests-modal' ).modal( 'hide' );
			}
		});
	});

	// Deactivate - modal
	$( document ).on( 'click', '.js-deactivate-request-link', function() {
		$( '.js-deactivate-request-action' ).attr( 'data-id', $( this ).attr( 'data-id' ) );

		$( '.request-title-modal' ).html( validateInputContent( $( this ).attr( 'data-title' ) ) );

		$( '.ui.modal.js-deactivate-request-modal' )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' );
	});

	// Deactivate - action
	$( document ).on( 'click', '.js-deactivate-request-action', function( e ) {
		$.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: {
				action : 'deactivate_request_action',
				post_id: $( this ).attr( 'data-id' )
			},
			beforeSend: function() {
				$( '.js-deactivate-request-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( response == '1' ) {
					if ( $( '.single-request' )[0] ) {
						changeURL( wpj_vars.page_url );

					} else {
						if ( $( '.js-user-requests-wrapper' )[0] ) refreshContent( '.js-user-requests-wrapper' ); // for code
						else wpj_refresh_kadence_tab_content(); // for page builder

					}
				}
				else if ( response == 'not_your_post' ) $( '.content.deactivate-request' ).text( wpj_vars.not_your_post );
				else if ( response == 'not_logged_in' ) $( '.content.deactivate-request' ).text( wpj_vars.not_logged_in );
			},
			complete: function() {
				$( '.js-deactivate-request-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-deactivate-request-modal' ).modal( 'hide' );
			}
		});
	});

	// Deactivate all - modal
	$( document ).on( 'click', '#js-deactivate-all-requests-link', function( e ) {
		$( '.ui.modal.js-deactivate-all-requests-modal' ).modal( 'setting', 'transition', 'fly down' ).modal( 'show' );
	});

	// Deactivate all - action
	$( document ).on( 'click', '.js-deactivate-all-requests-action', function( e ) {
		$.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: { action : 'deactivate_all_requests_action', reason: 'by_user' },
			beforeSend: function() {
				$( '.js-deactivate-all-requests-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( $( '.js-user-requests-wrapper' )[0] ) refreshContent( '.js-user-requests-wrapper' ); // for code
				else wpj_refresh_kadence_tab_content(); // for page builder
			},
			complete: function() {
				$( '.js-deactivate-all-requests-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-deactivate-all-requests-modal' ).modal( 'hide' );
			}
		});
	});

	// Delete - modal
	$( document ).on( 'click', '.js-delete-request-link', function() {
		$( '.js-delete-request-action' ).attr( 'data-id', $( this ).attr( 'data-id' ) );

		$( '.request-title-modal' ).html( $( this ).attr( 'data-title-request' ) );

		$( '.ui.modal.js-delete-request-modal' )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' );
	});

	// Delete - action
	$( document ).on( 'click', '.js-delete-request-action', function( e ) {
		$.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'delete_request_action',
				post_id: $( this ).attr( 'data-id' )
			},
			beforeSend: function() {
				$( '.js-delete-request-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( response == '1' ) {
					if ( $( '.single-request' )[0] ) {
						changeURL( wpj_vars.my_requests_url );

					} else {
						if ( $( '.js-user-requests-wrapper' )[0] ) refreshContent( '.js-user-requests-wrapper' ); // for code
						else wpj_refresh_kadence_tab_content(); // for page builder

					}
				}
				else if ( response == 'not_your_post' ) $( '.content.delete-request' ).text( wpj_vars.not_your_post );
				else if ( response == 'not_logged_in' ) $( '.content.delete-request' ).text( wpj_vars.not_logged_in );
			},
			complete: function() {
				$( '.js-delete-request-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-delete-request-modal' ).modal( 'hide' );
			}
		});
	});

	// Delete - from single request
	$( document ).on( 'click', '.js-delete-request-button', function( e ) {
		if ( $( this ).siblings( '.js-delete-request-warning' ).css( "display" ) == "inline-block" ) {
			$( this ).siblings( '.js-delete-request-warning' ).slideUp( 400 );
			e.stopPropagation();
		} else {
			$( this ).siblings( '.js-delete-request-warning' ).slideDown( 400 );
			e.stopPropagation();
		}
	});

	// Delete all - modal
	$( document ).on( 'click', '#js-delete-all-requests-link', function( e ) {
		$( '.ui.modal.js-delete-all-requests-modal' ).modal( 'setting', 'transition', 'fly down' ).modal( 'show' );
	});

	// Delete all - action
	$( document ).on( 'click', '.js-delete-all-requests-action', function( e ) {
		$.ajax({
			type: 'post',
			url : wpj_vars.ajaxurl,
			data: { action : 'delete_all_requests_action' },
			beforeSend: function() {
				$( '.js-delete-all-requests-action' ).addClass( 'loading' );
				addLoader( '.wpj-grid-table' );
			},
			success: function( response ) {
				if ( $( '.js-user-requests-wrapper' )[0] ) refreshContent( '.js-user-requests-wrapper' ); // for code
				else wpj_refresh_kadence_tab_content(); // for page builder
			},
			complete: function() {
				$( '.js-delete-all-requests-action' ).removeClass( 'loading' );
				$( '.ui.modal.js-delete-all-requests-modal' ).modal( 'hide' );
			}
		});
	});

});