jQuery( document ).ready( function( $ ) {

	// Save autodraft post values
	// when are changes inside the form
	$( document ).on( 'click', '#add-edit-request-form', function( e ) {
		var action_type = getUrlParameter( 'action' ) ? getUrlParameter( 'action' ) : 'new-request';
		var requestid   = getUrlParameter( 'requestid' );

		if ( $( e.target ).parent().hasClass( 'post-new-request-btn' ) === false ) {
			$.ajax({
				type: 'post',
				url : wpj_vars.ajaxurl,
				data: $( this ).serialize() + "&status=autodraft&action=save_request_post_action&aoer_form_submitted=1&action_type=" + action_type + "&requestid=" + requestid,
				success: function( data ) {}
			});
		}
	});

	// Save autodraft post values
	// when publosh button is clicked
	$( document ).on( 'click', '.post-new-request-btn', function( e ) {
		wpj_validate_new_request_form();

		if ( $( '#add-edit-request-form' ).form( 'is valid' ) ) {
			e.preventDefault();

			if ( ! wpj_vars.is_user_logged_in ) {
				jQuery( '.register-link' ).trigger( 'click' );

			} else {
				var action_type = getUrlParameter( 'action' ) ? getUrlParameter( 'action' ) : 'new-request';
				var requestid   = getUrlParameter( 'requestid' );

				$( this ).addClass( 'ui loading disabled button' );

				$.ajax({
					type: 'post',
					url : wpj_vars.ajaxurl,
					data: $( '#add-edit-request-form' ).serialize() + "&status=publish&action=save_request_post_action&aoer_form_submitted=1&action_type=" + action_type + "&requestid=" + requestid,
					success: function( data ) {
						$( 'post-new-request-btn' ).removeClass( 'ui loading disabled button' );

						if ( data.includes( 'http://' ) || data.includes( 'https://' ) ) changeURL( data );
						else {
							$( '.ui.error.message' ).html( data ).removeClass( 'hidden' ).show();
							return false;
						}
					}
				});

			}

		}
	});

	// Fill request subcategory by selected categories
	$( document ).on( 'change', '#request_category', function( e ) {
		if ( $( this ).val().length !== 0 ) {
			var vals = $( this ).val() instanceof Array ? $( this ).val().join( ',' ) : $( this ).val();

			$.ajax({
				type: 'post',
				url : wpj_vars.ajaxurl,
				data: {
					'action'               : 'load_subcategories_by_categories_action',
					'taxonomy_name'        : 'job_cat',
					'term_type'            : 'slug',
					'include_empty_option' : wpj_vars.select_subcategory,
					'select_name'          : 'subcat',
					'select_id'            : 'subcat',
					'select_category_value': vals,
					'select_multiple'      : wpj_vars.request_multiple
				},
				beforeSend: function() {
					if ( e.type == 'change' ) $( '#request_subcategories' ).html( '<center><img src="' + wpj_vars.theme_path + '/assets/images/loader/loader-green.svg"></center>' );
				},
				success: function( data ) {
					if ( data && data.match( /option/g ).length > 2 ) {
						if ( e.type == 'change' ) $( '#request_subcategories' ).html( data );
						$( '.ui.dropdown' ).dropdown( { message: { noResults: wpj_vars.nothing_found } } );

					} else {
						if ( e.type == 'change' ) $( '#request_subcategories' ).html( '' );

					}
				}
			});

		} else {
			if ( e.type == 'change' ) $( '#request_subcategories' ).html( '' );

		}
	});

});