function wpj_validate_new_request_form() {

	jQuery.fn.form.settings.rules.request_budget = function ( inputValue ) {
		if ( jQuery( '#request_budget_to' ).val() ) {
			return parseFloat( inputValue ) < parseFloat( jQuery( '#request_budget_to' ).val() );
		} else {
			return true;
		}
	}

	jQuery.fn.form.settings.rules.request_date = function ( inputValue ) {
		if ( jQuery( '#request_end_date' ).val() ) {
			return parseInt( jQuery( 'input[name="request_start_date"]' ).val() ) <= parseInt( jQuery( 'input[name="request_end_date"]' ).val() );
		} else {
			return true;
		}
	}

	jQuery.fn.form.settings.rules.request_deadline = function ( inputValue ) {
		if ( jQuery( '#request_deadline' ).val() ) {
			return parseInt( jQuery( 'input[name="request_deadline"]' ).val() ) >= Math.floor( Date.now() / 1000 );
		} else {
			return true;
		}
	}

	var fields_arr = {
		title: {
			identifier : 'request_title',
			rules: [
				{
					type   : 'empty',
					prompt : wpj_vars.lbl_request_title_empty
				},
				{
					type   : 'minLength[' + wpj_vars.characters_request_title_min + ']',
					prompt : wpj_vars.lbl_request_title_min,
				},
				{
					type   : 'maxLength[' + wpj_vars.characters_request_title_max + ']',
					prompt : wpj_vars.lbl_request_title_max,
				}
			]
		},
		description: {
			identifier : 'request_description',
			rules: [
				{
					type   : 'empty',
					prompt : wpj_vars.lbl_request_description_empty
				},
				{
					type   : 'minLength[' + wpj_vars.characters_request_desc_min + ']',
					prompt : wpj_vars.lbl_request_description_min,
				},
				{
					type   : 'maxLength[' + wpj_vars.characters_request_desc_max + ']',
					prompt : wpj_vars.lbl_request_description_max,
				}
			]
		},
		category: {
			identifier : 'request_category',
			rules: [{
				type   : 'empty',
				prompt : wpj_vars.lbl_request_category
			}]
		},
		budget: {
			identifier : 'request_budget_from',
			rules: [{
				type   : 'request_budget',
				prompt : wpj_vars.lbl_request_budget
			}]
		},
		date: {
			identifier : 'request_start_date-old',
			rules: [{
				type   : 'request_date',
				prompt : wpj_vars.lbl_request_date
			}]
		},
		deadline: {
			identifier : 'request_deadline-old',
			rules: [{
				type   : 'request_deadline',
				prompt : wpj_vars.lbl_request_deadline
			}]
		}
	};

	fields_arr = Hooks.apply_filters( 'wpj_fields_validation_filter', fields_arr, 'request' );

	jQuery( '#add-edit-request-form' ).form({
		on: 'blur',
		keyboardShortcuts: false,
		fields: fields_arr,
		onSuccess : function( e ) {

		},
		onFailure : function( e ) {
			if ( jQuery( window ).scrollTop() > 100 ) jQuery( 'html, body' ).animate({ scrollTop : 0 }, 800 );
			return false;
		}
	});

	jQuery( '#add-edit-request-form' ).form( 'validate form' );
}