jQuery( document ).ready( function( $ ) {

	$( window ).on( 'load resize', function() {

		wpj_init_on_resize();

	});

});

function wpj_init_on_resize() {
	// main menu
	wpj_change_long_main_menu_alignment();

	// pusher full width if width < 1258
	wpj_chat_hide_sidebar_responsive();

	// add stackable class on responsive columns
	wpj_add_responsive_classes_to_footer_elements();

	// switch between mobile and pc view
	wpj_change_user_account_table_responsive();

	// reCaptcha
	if ( typeof jQuery.fn.wpjResizeReCaptchaInit == 'function' ) jQuery.fn.wpjResizeReCaptchaInit();

	// footer arrows
	wpj_collapse_footer_menus();

	// homepage categories
	wpj_add_responsive_classes_to_homepage_elements();

	// render lazy load
	if ( typeof jQuery.fn.wpjLazyLoadRender == 'function' ) jQuery.fn.wpjLazyLoadRender();

	// subcategories slider
	wpj_display_fully_visible_subcategoires();
}

function wpj_set_site_viewport() {
	// get the real viewport height on mobile when the address bar or other bars are on
	// https://css-tricks.com/the-trick-to-viewport-units-on-mobile/
	let vh = window.innerHeight * 0.01;
	document.documentElement.style.setProperty( '--vh', `${vh}px` );

	jQuery( window ).on( 'load resize', _.debounce( function() {

		let vh = window.innerHeight * 0.01;
		document.documentElement.style.setProperty( '--vh', `${vh}px` );

	}, 200 ) );
}