jQuery( document ).ready( function( $ ) {

	// init elements
	wpj_init_search_autocomplete_elements();

	// highlight jquery
	jQuery.extend({
		highlight: function ( node, re, nodeName, className ) {
			if ( node.nodeType === 3 ) {
				var match = node.data.match( re );
				if ( match ) {
					var highlight = document.createElement( nodeName || 'span' );
					highlight.className = className || 'highlight';

					var wordNode = node.splitText( match.index );
					wordNode.splitText( match[0].length );

					var wordClone = wordNode.cloneNode( true );
					highlight.appendChild( wordClone );

					wordNode.parentNode.replaceChild( highlight, wordNode );
					return 1; //skip added node in parent
				}

			} else if ( ( node.nodeType === 1 && node.childNodes ) && // only element nodes that have children
				!/(script|style)/i.test( node.tagName ) && // ignore script and style nodes
				!( node.tagName === nodeName.toUpperCase() && node.className === className ) ) { // skip if already highlighted

					for ( var i = 0; i < node.childNodes.length; i++ ) {
						i += jQuery.highlight( node.childNodes[i], re, nodeName, className );
					}

			}

			return 0;
		}
	});

	jQuery.fn.unhighlight = function ( options ) {
		var settings = { className: 'highlight', element: 'span' };

		jQuery.extend( settings, options );

		return this.find( settings.element + "." + settings.className ).each( function () {
			var parent = this.parentNode;
			parent.replaceChild( this.firstChild, this );
			parent.normalize();
		}).end();
	};

	jQuery.fn.highlight = function ( words, options ) {
		var settings = { className: 'highlight', element: 'span', caseSensitive: false, wordsOnly: false };

		jQuery.extend( settings, options );

		if ( words.constructor === String ) words = [words];

		words = jQuery.grep( words, function( word, i ) {
			return word != '';
		});

		words = jQuery.map( words, function( word, i ) {
			return word.replace( /[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&" );
		});

		if ( words.length == 0 ) { return this; }

		var flag = settings.caseSensitive ? "" : "i";
		var pattern = "(" + words.join( "|" ) + ")";
		if ( settings.wordsOnly ) {
			pattern = "\\b" + pattern + "\\b";
		}
		var re = new RegExp( pattern, flag );

		return this.each( function () {
			jQuery.highlight( this, re, settings.element, settings.className );
		});
	};

	$( document ).on( 'click', '.js-search-icon-wrapper', function( e ) {
		e.preventDefault();
		jQuery( this ).parents( 'form' ).trigger( 'submit' );
	});

});

// search init
function wpj_init_search_autocomplete_elements() {
	jQuery( '.js-autocomplete-search' ).each( function() {

		var $container = jQuery( this );

		var search_timeout;

		var $input = $container.find( 'input[type="text"]' );
		$input.on( 'keyup keydown keypress', function() {
			$container.addClass( 'loading' );
			clearTimeout( search_timeout );
			search_timeout = setTimeout( function() {
				wpj_search_when_done_typing( $container, $input );
			}, 250 );
		});

		$container.append( '<div class="autocomplete-list-container"></div>' );

		var $list = $container.find( '.autocomplete-list-container' );

		jQuery( document ).on( 'click', 'html', function( e ) {
			$list.slideUp( 150 );
		});

		$container.click( function( e ) {
			$list.slideDown( 150 );
			e.stopPropagation();
		});

	});
}

// search ajax
function wpj_search_when_done_typing( $container, $input ) {

	function autocomplete_item_html( item_html, item_input, item_class ) {

		if ( item_class == '' ) item_class = 'autocomplete';

		var cnt_open  = '';
		var cnt_close = '';

		if ( item_input != '' ) {
			cnt_open  = '<div class="autocomplete-text">';
			cnt_close = '</div>';
		}

		var a_href_open  = '';
		var a_href_close = '';
		var item_icon    = '';

		if ( item_class == 'autocomplete-search-jobs' ) {
			a_href_open  = '<a href="' + wpj_vars.search_jobs_url + '?term=' + item_input + '" class="js-internal">';
			a_href_close = '</a>';
			item_icon    = '<i class="search icon"></i>';
		}

		if ( item_class == 'autocomplete-search-requests' ) {
			a_href_open  = '<a href="' + wpj_vars.search_requests_url + '?term=' + item_input + '" class="js-internal">';
			a_href_close = '</a>';
			item_icon    = '<i class="search icon"></i>';
		}

		if ( item_class == 'autocomplete-search-users' ) {
			a_href_open  = '<a href="' + wpj_vars.search_users_url + '?user=' + item_input + '" class="js-internal">';
			a_href_close = '</a>';
			item_icon    = '<i class="search icon"></i>';
		}

		if ( item_class == 'autocomplete-user' ) {
			a_href_open  = '<a href="' + wpj_vars.user_profile_url + item_input + '" class="js-internal">';
			a_href_close = '</a>';
			item_icon    = '<i class="user icon"></i>';
		}

		var item_return =
			'<div class="autocomplete-item">'
				+ a_href_open
					+ '<div class="' + item_class + '" data-input="' + item_input + '">'
						+ cnt_open
							+ item_icon + item_html
						+ cnt_close
					+ '</div>'
				+ a_href_close
			+ '</div>';

		return item_return;
	}

	var action = 'search_autocomplete_action';
	var input  = validateInputContent( $input.val() );

	var data = {
		'action': action,
		'input' : input
	};

	jQuery.post( wpj_vars.ajaxurl, data, function( response ) {

		var arr = JSON.parse( response );

		var items_html = '';
		if ( input != '' && input != ' ' ) {
			items_html += '<div class="autocomplete-list">';

			if ( wpj_vars.allow_job ) {
				items_html += autocomplete_item_html( wpj_vars.jobs_label, '', 'autocomplete-title' );
				if ( arr['jobs'].length ) {
					for ( var i = 0; i < arr['jobs'].length; i++ ) {
						items_html += autocomplete_item_html( arr['jobs'][i], arr['jobs'][i], 'autocomplete-search-jobs' );
					}

				} else {
					items_html += autocomplete_item_html( input, input, 'autocomplete-search-jobs' );

				}
			}

			if ( wpj_vars.allow_request ) {
				items_html += autocomplete_item_html( wpj_vars.requests_label, '', 'autocomplete-title' );
				if ( arr['requests'].length ) {
					for ( var i = 0; i < arr['requests'].length; i++ ) {
						items_html += autocomplete_item_html( arr['requests'][i], arr['requests'][i], 'autocomplete-search-requests' );
					}

				} else {
					items_html += autocomplete_item_html( input, input, 'autocomplete-search-requests' );

				}
			}

			if ( wpj_vars.allow_users ) {
				items_html += autocomplete_item_html( wpj_vars.users_label, '', 'autocomplete-title' );
				items_html += autocomplete_item_html( '<span class="no-highlight">' + wpj_vars.search_users_label + '</span> ' + input, input, 'autocomplete-search-users' );
				if ( arr['users'].length ) {
					for ( var i = 0; i < arr['users'].length; i++ ) {
						if ( arr['companies'].length ) {
							items_html += autocomplete_item_html( arr['users'][i] + arr['companies'][i], arr['users'][i], 'autocomplete-user' );

						} else {
							items_html += autocomplete_item_html( arr['users'][i], arr['users'][i], 'autocomplete-user' );

						}
					}
				}
			}

			items_html += '</div>';
		}

		$container.find( '.autocomplete-list-container' ).html( items_html );

		$container.find( '.autocomplete-list-container .autocomplete-item' ).each( function() {
			jQuery( this ).find( '.autocomplete-text' ).highlight( input );
		});

		$container.removeClass( 'loading' );

		jQuery( 'a.js-internal' ).off( 'click.js-internal' ).on( 'click.js-internal', function() {
			var obj = {
				isExternal   : false,
				isTargetBlank: jQuery( this ).attr( 'target' ) ? jQuery( this ).attr( 'target' ) === '_blank' : false,
				currentUrl   : window.location.href,
				nextUrl      : jQuery( this ).attr( 'href' )
			};
			window.parent.postMessage( {data: obj}, "*" );
		});
	});
}