jQuery( document ).ready( function( $ ) {

	/* POST NEW - STEPS */

	// change tab when ckicking on tab header
	$( document ).on( 'click', '.js-tabs-wrapper .step', function( e ) {
		$( '.js-tabs-wrapper .step.active' ).removeClass( 'active' );
		$( this ).addClass( 'active' );
		$( '.js-tabs-wrapper .js-tab-wrapper .tab.active' ).removeClass( 'active' );

		var this_tab = $( $( '.js-tabs-wrapper .js-tab-wrapper .tab' ).get( $( this ).index() ) );
		this_tab.addClass( 'active' );

		var hash = $( this ).attr( "id" ).replace( "tab", "#step" );
		wpj_add_hash( hash );
	});

	// change tab when clicking next
	$( document ).on( 'click', '.post-new-wrapper .tab-controls a.right', function( e ) {
		e.preventDefault();

		$( '.js-tabs-wrapper .js-tab-wrapper .tab.active' ).removeClass( 'active' );

		var curent_tab = $( this ).parents( '.tab' ).index();
		$( $( '.js-tabs-wrapper .js-tab-wrapper .tab' ).get( curent_tab + 1 ) ).addClass( 'active' );
		$( '.js-tabs-wrapper .step.active' ).removeClass( 'active' );

		var this_tab = $( $( '.js-tabs-wrapper .step' ).get( curent_tab + 1 ) );
		this_tab.addClass( 'active' );

		var hash = this_tab.attr( "id" ).replace( "tab", "#step" );
		wpj_add_hash( hash );

		$( 'html, body' ).animate({ scrollTop: $( ".post-new-wrapper" ).offset().top - 108 }, 1000 );
	});

	// change tab when clicking previous
	$( document ).on( 'click', '.post-new-wrapper .tab-controls a.left', function( e ) {
		e.preventDefault();

		$( '.js-tabs-wrapper .js-tab-wrapper .tab.active' ).removeClass( 'active' );

		var curent_tab = $( this ).parents( '.tab' ).index();
		$( $( '.js-tabs-wrapper .js-tab-wrapper .tab' ).get( curent_tab - 1 ) ).addClass( 'active' );
		$( '.js-tabs-wrapper .step.active' ).removeClass( 'active' );

		var this_tab = $( $( '.js-tabs-wrapper .step' ).get( curent_tab - 1 ) );
		this_tab.addClass( 'active' );

		var hash = this_tab.attr( "id" ).replace( "tab", "#step" );
		wpj_add_hash( hash );
		$( 'html, body' ).animate({ scrollTop: $( ".post-new-wrapper" ).offset().top - 108 }, 1000 );
	});

	/* FILTER BUTTONS */
	$( document ).on( 'click', '.item.js-tab-item', function() {
		// change url
		var _link = wpj_vars.parent_url + $( this ).attr( 'data-tab' );
		history.pushState( null, null, _link );

		// change mobile dropdown option
		$( this ).parents( ".js-tab-to-dropdown" ).find( '.ui.dropdown' ).dropdown( 'set selected', $( '.item.js-tab-item.active' ).attr( 'data-tab' ) );

		// init images
		if ( typeof jQuery.fn.wpjLazyLoadRender == 'function' ) jQuery.fn.wpjLazyLoadRender();
	});

	/* BROWSER NAVIGATION */
	$( window ).on( 'popstate', function( e ) {
		// get active tab
		var active_tab = window.location.pathname.match( /([^\/]*)\/*$/ )[1];

		// change pc tab
		$( '.ui.secondary.menu' ).find( '.item' ).tab( 'change tab', active_tab );

		// change mobile dropdown option
		$( '.js-tab-to-dropdown' ).find( '.ui.dropdown' ).dropdown( 'set selected', active_tab );

		// init images
		if ( typeof jQuery.fn.wpjLazyLoadRender == 'function' ) jQuery.fn.wpjLazyLoadRender();
	});

});

function wpj_add_hash( hash ) {
	if ( history.pushState ) history.pushState( null, null, hash );
	else location.hash = hash;
}

function wpj_init_post_new_steps() {
	var tab_id = window.location.hash.replace( "#step", "#tab" );
	if ( tab_id ) {
		jQuery( '.js-tabs-wrapper .step.active' ).removeClass( 'active' );
		jQuery( tab_id ).addClass( 'active' );
		jQuery( '.js-tabs-wrapper .js-tab-wrapper .tab.active' ).removeClass( 'active' );

		var this_tab = jQuery( jQuery( ".js-tabs-wrapper .js-tab-wrapper .tab" ).get( jQuery( tab_id ).index() ) );
		this_tab.addClass( "active" );

		jQuery.fn.pageLoadToolTipInit();
	}
}