jQuery( document ).ready( function( $ ) {

	// open legend modal
	$( document ).on( 'click', '#status-messages-legend-link', function( e ) {
		$( '.ui.modal.legend.' + $( this ).attr( 'data-page' ) + '.' + $( this ).attr( 'data-tab' ) ).modal( 'setting', 'transition', 'fly down' ).modal( 'show' );
	});

	// export transactions  - modal
	$( document ).on( 'click', '.js-export-user-transactions-link', function() {
		$( '.ui.modal.js-export-user-transactions-modal' ).modal({
			onVisible: function(){
				$.fn.wpjCalendarInit();
				$( '.js-no-transaction-export-message' ).remove();
			},
			autofocus: false,
			transition: 'fly down',
			observeChanges: true
		})
		.modal( 'show' )
		.modal( 'refresh' );
	});

	// export transactions - action
	$( document ).on( 'click', '.js-export-user-transactions-action', function( e ) {
		$.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action    : 'export_transactions_action',
				user_id   : $( '.js-user-id' ).val(),
				user_name : $( '.js-user-name' ).val(),
				start_date: $( '.js-transactions-start-date' ).attr( 'data-timestamp' ),
				end_date  : $( '.js-transactions-end-date' ).attr( 'data-timestamp' )
			},
			beforeSend: function() {
				$( '.js-export-user-transactions-action' ).addClass( 'loading' );
				$( '.js-no-transaction-export-message' ).remove();
			},
			success: function( response ) {
				if ( response ) {

					/* make CSV downloadable */
					var today = new Date();

					var download_link = document.createElement( "a" );
					var file_data     = ['\ufeff' + response];

					var blob_object = new Blob( file_data, { type: "text/csv;charset=utf-8;" });

					var url = URL.createObjectURL( blob_object );
					download_link.href = url;

					var file_name = $( '.js-user-name' ).val() + '-transactions-' + today.getFullYear() + '-' + ( today.getMonth() + 1 ) + '-' + today.getDate();
					download_link.download = Hooks.apply_filters( 'wpj_export_user_transactions_filename_filter', file_name, $( '.js-user-name' ).val() );

					/* insert downlaod link to html */
					document.body.appendChild( download_link );
					download_link.click();
					document.body.removeChild( download_link );

					$( '.js-export-user-transactions-action' ).removeClass( 'loading' );
					$( '.ui.modal.js-export-user-transactions-modal' ).modal( 'hide' );

				} else {
					$( '.js-export-user-transactions-action' ).removeClass( 'loading' );
					$( '<div class="ui visible error message js-no-transaction-export-message">For the selected range, there are no transactions</div>' ).insertBefore( '.js-transacations-export-intervals' );

				}
			}
		});
	});

	// export transactions - interval selection
	$( document ).on( 'click', '.js-transacations-export-intervals .label', function( e ) {
		$( '.js-no-transaction-export-message' ).remove();
		$( '.js-transactions-start-date-input' ).calendar( 'set date', $( this ).attr( 'data-start-date' ) );
		$( '.js-transactions-end-date-input' ).calendar( 'set date', $( this ).attr( 'data-end-date' ) );
	});

	// change filter page url
	$( document ).on( 'change', '.filter-results-by', function() {
		var switch_filter = $( this ).dropdown( 'get value' );
		if ( switch_filter ) changeURL( wpj_vars.page_url + '?switch_filter=' + switch_filter );
	});

});

// hide post new row when field is disabled from admin
function wpj_hide_disabled_post_new_fields() {
	if ( jQuery( '.js-displayed-field' )[0] ) {
		jQuery( '.js-displayed-field' ).each( function() {
			jQuery( this ).parents( '.field' ).removeClass( 'hidden' );
			jQuery( this ).parents( '.fields' ).removeClass( 'hidden' );
		});
	}
}

function wpj_add_margin_bottom_to_legend() {
	jQuery( '.js-legend-link' ).parents( '.wpj-dashboard-table-wrapper' ).addClass( 'mb32' );
}