//---------------------------------------
// Vacation Mode
//---------------------------------------
jQuery( function( $ ) {

	$( document ).on( 'click', '#vacation_mode_toggle_ui, #js-vacation-mode-link', function() {
		$( '#vacation_mode_modal_ui' ).modal({
			onVisible: function(){
				$.fn.wpjCalendarInit();
			},
			onHide : function(){
				$( '#vacation_mode_toggle_ui' ).checkbox( 'toggle' );
			},
			autofocus: false,
			transition: 'fly down',
			observeChanges: true
		})
		.modal( 'show' )
		.modal( 'refresh' )
		;
	});

	// HELPERS
	$( document ).on( 'click', '.message .close', function( e ) {
		$( this )
			.closest( '.message' )
			.transition( 'fade' )
		;
	});

	function dismissableMessage( type, title, content ) {
		return '<div class="ui ' + type + ' message"><i class="close icon"></i><div class="header">' + title + '</div><p>' + content + '</p></div>';
	}

	// AJAX YES
	$( document ).on( 'click', '#vacation_mode_yes', function( e ) {
		e.preventDefault();

		var $button       = $( this );
		var $modal_cnt    = $( '#vacation_mode_modal_ui' );
		var $messages_cnt = $( '#vacation_mode_modal_ui .content .messages' );

		var away_reason          = validateInputContent( $( "#wpjobster_vacation_away_reason" ).val() );
		var start_date           = $( "#wpjobster_vacation_duration_start" ).val();
		var start_date_timestamp = $( "#wpjobster_vacation_duration_start" ).attr( 'data-timestamp' );
		var end_date             = $( "#wpjobster_vacation_duration_end" ).val();
		var end_date_timestamp   = $( "#wpjobster_vacation_duration_end" ).attr( 'data-timestamp' );

		jQuery.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action              : 'activate_vacation_mode_action',
				away_reason         : away_reason,
				start_date          : start_date,
				start_date_timestamp: start_date_timestamp,
				end_date            : end_date,
				end_date_timestamp  : end_date_timestamp
			},
			beforeSend: function() {
				$button.addClass( 'loading' );
			},
			success: function( response ) {

				if ( response == 'success' ) {
					$messages_cnt.html( dismissableMessage( 'success', wpj_vars.success, wpj_vars.success_saved ) );

					$modal_cnt
					.modal({
						transition: 'fly down',
					})
					.delay( 1000 )
					.queue( function() {
						$( this ).modal( 'hide' ).dequeue();
					});

				} else if ( response == 'err_already_in_vacation' ) {
					$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err, wpj_vars.err_already_in_vacation ) );

				} else if ( response == 'err_empty_start_date' ) {
					$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err, wpj_vars.err_empty_start_date ) );

				} else if ( response == 'err_small_start_date' ) {
					$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err, wpj_vars.err_small_start_date ) );

				} else if ( response == 'err_empty_end_date' ) {
					$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err, wpj_vars.err_empty_end_date ) );

				} else if ( response == 'err_small_end_date' ) {
					$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err, wpj_vars.err_small_end_date ) );

				} else {
					$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err_unknown, wpj_vars.err_try_again_later ) );
				}
			},
			error: function( response ) {
				$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err_unknown, wpj_vars.err_try_again_later ) );
			},
			complete: function() {
				$button.removeClass( 'loading' );
			}
		});

		return false;
	});

	// AJAX NO
	$( document ).on( 'click', '#vacation_mode_no', function( e ) {
		e.preventDefault();

		var $button       = $( this );
		var $modal_cnt    = $( '#vacation_mode_modal_ui' );
		var $messages_cnt = $( '#vacation_mode_modal_ui .content .messages' );

		jQuery.ajax({
			type : 'post',
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'deactivate_vacation_mode_action'
			},
			beforeSend: function() {
				$button.addClass( 'loading' );
			},
			success: function( response ) {

				if ( response == 'success' ) {
					$messages_cnt.html( dismissableMessage( 'success', wpj_vars.success, wpj_vars.success_saved ) );

					$modal_cnt
					.modal({
						transition: 'fly down',
					})
					.delay( 1000 )
					.queue( function() {
						$( this ).modal( 'hide' ).dequeue();
					});
				} else {
					$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err_unknown, wpj_vars.err_try_again_later ) );
				}
			},
			error: function( response ) {
				$messages_cnt.html( dismissableMessage( 'error', wpj_vars.err_unknown, wpj_vars.err_try_again_later ) );
			},
			complete: function() {
				$button.removeClass( 'loading' );
			}
		});

		return false;
	});
});