jQuery( document ).ready( function( $ ) {

	// user settings save
	$( document ).on( 'click', '.js-save-user-settings', function( e ) {
		e.preventDefault();

		var $this = $( this );
		var this_form = $( this ).parents( '.ui.form' );

		jQuery.ajax({
			type : 'POST',
			url  : wpj_vars.ajaxurl,
			data : 'action=save_user_settings_action&' + this_form.serialize(),
			beforeSend: function() {
				$this.addClass( 'ui button loading disabled' );
			},
			success: function( response ) {
				obj = JSON.parse( response );

				if ( obj.status == 'error' )
					$( '.js-save-user-settings' ).notify( obj.error, { position: 'top', className: 'error' } );

				else
					$( '.js-save-user-settings' ).notify( wpj_vars.success_saved, { position: 'top', className: 'success' } );

				Hooks.do_action( 'wpj_after_user_settings_saved' );
			},
			complete: function() {
				$this.removeClass( 'ui button loading disabled' );
			}
		});
	});

	// user account delete - modal
	$( document ).on( 'click', '.js-delete-user-account', function( e ) {
		e.preventDefault();

		jQuery( '.ui.modal.delete-account-modal-wrapper' )
			.modal( 'setting', 'transition', 'fly down' )
			.modal( 'show' );
	});

	// user account delete - action
	$( document ).on( 'click', '.js-delete-user-account-action', function( e ) {
		e.preventDefault();

		var $this = $( this );

		jQuery.ajax({
			type : 'POST',
			url  : wpj_vars.ajaxurl,
			data : {
				action: 'delete_user_account_action',
				uid: wpj_vars.uid
			},
			beforeSend: function() {
				$this.addClass( 'loading disabled' );
			},
			success: function( response ) {
				if ( response == 'not_allowed' ) {
					$this.removeClass( 'loading disabled' );

					$this.notify( wpj_vars.not_allowed_delete_account, { position: 'top', className: 'error' } );

				} else {
					$this.remove();

					window.location.replace( wpj_vars.site_URL );

				}
			}
		});
	});

});

// user profile details popup
function wpj_init_user_profile_tooltips() {
	if ( jQuery( '.content-wrapper' )[0] )
		jQuery( '.content-wrapper' ).popup({ on: 'hover' });
}