jQuery( document ).ready( function( $ ) {

	// Withdraw action
	$( document ).on( 'click', '.js-request-withdrawal', function ( e ) {

		var $this     = $( this );
		var this_form = $( this ).parents( '.ui.form' );

		$.ajax({
			type : 'POST',
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'request_withdrawal_action',
				method : $this.parents( '.item-content' ).find( 'input[name$="_withdraw"]' ).attr( 'name' ),
				details: $this.parents( '.item-content' ).find( 'input[name="details"]' ).last().val(),
				email  : $this.parents( '.item-content' ).find( 'input[name="email"]' ).val(),
				amount : $this.parents( '.item-content' ).find( 'input[name="amount"]' ).val()
			},
			beforeSend: function() {
				this_form.addClass( 'loading' );
			},
			success: function( response ) {
				obj = JSON.parse( response );

				// Reset amount field
				$this.parents( '.item-content' ).find( 'input[name="amount"]' ).val( '' );

				if ( obj.status == 'error' ) { // display the error
					$this.notify( obj.error, { position: 'top center', className: 'error' } );

				} else {
					// Display success message
					if ( $this.parents( '.kt-row-layout-inner' )[0] )
						$this.parents( '.kt-row-layout-inner' ).css( 'overflow', 'visible' );

					$this.notify( wpj_vars.withdrawal_request, { position: 'top center', className: 'success' } );

					// Refresh div content
					refreshContent( '.js-pending-withdrawals-list' );

					// Change tab
					history.pushState( null, null, wpj_vars.parent_url + 'payments' ); // change url

					wpj_change_kadence_active_tab( 'payments' ); // for page builder

					if ( $( '.ui.secondary.menu' )[0] ) $( '.ui.secondary.menu' ).find( '.item' ).tab( 'change tab', 'payments' ); // for code
					$( '.js-tab-to-dropdown' ).find( '.ui.dropdown' ).dropdown( 'set selected', 'payments' ); // for code - mobile

				}
			},
			error: function( response ) { // display the error
				$this.notify( 'Error: ' + response, { position: 'top center', className: 'error' } );
			},
			complete: function() { // remove loading
				this_form.removeClass( 'loading' );
			}
		});

	});

	// Resend Withdrawal Confirmation Email Validation
	$( document ).on( "click", "#resend_withdrawal_email", function( e ) {

		e.preventDefault();

		var $this = $( this );

		$.ajax({
			type : "POST",
			url  : wpj_vars.ajaxurl,
			data : {
				action : 'resend_withdrawal_confirmation_email_action',
				uid    : $( '.js-withdrawal-uid' ).html(),
				key    : $( '.js-withdrawal-key' ).html()
			},
			success: function( msg ) {

				if ( msg == 'success' ) {
					$this.notify( wpj_vars.email_send_lbl, { position: 'right', className: 'success' } );

				} else {
					$this.notify( wpj_vars.err_something_wrong, { position: 'right', className: 'error' } );

				}

			}
		});
	});

});