<?php if ( ! class_exists( 'WPJJobsNewEditFieldsContent' ) ) {

	class WPJJobsNewEditFieldsContent extends stdClass {

		/**
		 * @var WPJJobsNewEdit
		 */
		private WPJJobsNewEdit $jobsNewEditClass;

		/**
		 * @var array
		 */
		private array $params;

		/**
		 * @var mixed
		 */
		private $pid;

		public function __construct() {
			$this->params = func_get_args();

			if ( isset( $this->params['pid'] ) )
				$this->pid = $this->params['pid'];

			else
				$this->pid = WPJ_Form::get( 'jobid' );

			$this->jobsNewEditClass = new WPJJobsNewEdit();
		}

//-> *** GENERAL ***//

		public function separator( $type = '' ) { ?>

			<div class="ui <?php echo $type; ?> divider"></div>

		<?php }

// *** END GENERAL SECTION *** <-//

//-> *** JOB INFORMATION SECTION *** //

		public function title( $placeholder = '' ) {

			$post = get_post( $this->pid );

			$post_value = WPJ_Form::post( 'job_title', ( ( isset( $post->post_title ) && $post->post_title != 'Auto Draft' ) ? $post->post_title : '' ) ); ?>

			<div class="tooltip-handler js-tooltip-handler text-right" data-handler-id="job_title">
				<textarea
					placeholder="<?php echo $placeholder ? $placeholder : _x( 'The title of your job', 'Post new job', 'wpjobster' ); ?>"
					rows="2"
					class="job-title charlimit-jobtitle <?php echo wpj_get_job_rejected_input( 'title' ); ?> mb5"
					name="job_title"><?php echo $post_value; ?></textarea>

				<span class="charscounter"><?php _e( 'characters left', 'wpjobster' ); ?></span>
			</div>

		<?php }

		public function price( $placeholder = '' ) {

			$post_value = WPJ_Form::post( 'job_cost', get_post_meta( $this->pid, 'price', true ) );

			$post_price_type_value = WPJ_Form::post( 'price_type', get_post_meta( $this->pid, 'price_type', true ) );

			if ( get_post_meta( $this->pid, 'job_packages', true ) == 'yes' ) $post_price_type_value = 'package'; ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_price">

				<?php if ( wpj_get_option( 'wpjobster_price_type' ) == "fixed_amount" ) { ?>

					<div class="job-fixed-price">

						<?php echo wpj_show_price_classic( wpj_get_option( 'wpjobster_job_fixed_amount' ) ); ?>

						<input type="hidden" value="<?php echo wpj_get_option( 'wpjobster_job_fixed_amount' ); ?>" name="job_cost" />

					</div>

				<?php } elseif ( wpj_get_option( 'wpjobster_price_type' ) == "dropdown_values" ) {

					$dropdown_values = wpj_get_option( 'newcost' );

					if ( $dropdown_values ) { ?>

						<select class="ui dropdown" name="job_cost" id="job_cost">

							<?php foreach ( $dropdown_values as $cost ) { ?>

								<option <?php echo $cost == $post_value ? "selected='selected'" : ""; ?> value="<?php echo $cost; ?>">

									<?php echo wpj_show_price( $cost ); ?>

								</option>

							<?php } ?>

						</select>

					<?php } else {

						_e( 'Prices are not defined. Please contact the administrator of this site for help.', 'wpjobster' );

					}

				} else {

					if ( wpj_exist_job_price_type_enabled() ) { ?>

						<!-- Multiple type of prices -->
						<div class="ui right labeled input">
							<div class="ui action input">
								<div class="ui labeled input">
									<div class="ui label vertical-align-middle new-price-currency">

										<?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?>

									</div>

									<input
										<?php echo ( ( wpj_is_job_price_type_custom_only_enabled() || $post_price_type_value == 'custom' || $post_price_type_value == 'package' ) ? "disabled" : "" ); ?>
										placeholder="<?php echo $placeholder ? $placeholder : _x( 'The price of your job', 'Post new job', 'wpjobster' ); ?>"
										data-placeholder="<?php echo $placeholder ? $placeholder : _x( 'The price of your job', 'Post new job', 'wpjobster' ); ?>"
										data-packages="<?php _e( 'Packages only', 'wpjobster' ); ?>"
										data-customplaceholder="<?php _e( 'Custom offers only', 'wpjobster' ); ?>"
										type="number"
										value="<?php echo $post_value; ?>"
										step="any"
										name="job_cost"
										class="post-new-price"
									/>
								</div>

								<select name="price_type" class="ui compact selection dropdown select-new-price">

									<?php foreach ( wpj_get_job_price_types() as $key => $price_type ) {

										if ( wpj_is_job_price_type_enabled( $price_type ) ) { ?>

											<option
												<?php echo ( $post_price_type_value == $price_type ? "selected='selected'" : " " ); ?>
												value="<?php echo strtolower( $price_type ); ?>">

													<?php echo strtolower( wpj_translate_string( $price_type ) ); ?>

											</option>

										<?php }

									} ?>

								</select>
							</div>
						</div>

					<?php } else { ?>

						<!-- Free input text -->
						<div class="ui labeled input">
							<div class="ui label"><?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?></div>

							<input
								placeholder="<?php echo $placeholder ? $placeholder : _x( 'The price of your job', 'Post new job', 'wpjobster' ); ?>"
								type="number"
								value="<?php echo $post_value; ?>"
								step="any"
								name="job_cost"
								class="post-new-price"
							/>
						</div>

					<?php }
				} ?>

			</div>

		<?php }

		public function package() { ?>

			<div class="tooltip-handler js-tooltip-handler post-new-packages-wrapper" data-handler-id="job_package">

				<?php wpj_display_packages_for_post_new( $this->pid ); ?>

			</div>

		<?php }

		public function category( $placeholder = '' ) {

			$post_value = $this->jobsNewEditClass->getPostCategories( $this->pid ); ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_category">

				<?php wpj_display_categories_select(
					"job_cat",
					"id",
					$placeholder ? $placeholder : _x( 'Select Category', 'Post new job', 'wpjobster' ),
					"",
					"job_cat",
					"job_cat",
					$post_value['category'],
					false
				); ?>

			</div>

		<?php }

		public function subcategory( $placeholder = '', $required = true ) {

			$post_value = $this->jobsNewEditClass->getPostCategories( $this->pid ); ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_subcategory">
				<span id="job_subcategories" data-required="<?php echo $required; ?>">

					<?php wpj_display_subcategories_select(
						'job_cat',
						'id',
						$placeholder ? $placeholder : _x( 'Select Subcategory', 'Post new job', 'wpjobster' ),
						'',
						'subcat',
						'subcat',
						$post_value['category'],
						$post_value['subcategory'],
						false
					); ?>

				</span>

				<input id="subcategory_required" type="hidden" name="subcategory_required" value="<?php echo $required; ?>">
			</div>

		<?php }

		public function description( $placeholder = '' ) {

			$post = get_post( $this->pid );

			$post_value = WPJ_Form::post( 'job_description', ( isset( $post->post_content ) ? $post->post_content : '' ) ); ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_description">
				<div id="job_description_field" class="text-right">

					<?php if ( wpj_get_option( 'wpjobster_job_description_type' ) == 'wysiwyg' ) { // WYSIWYG TEXTAREA ?>

						<div class="job-description-wysiwyg">

							<?php wpj_display_wysiwyg_textarea( $this->pid, 'job_description', 'job_description', 'job_description_toolbar', '', $placeholder, $post_value, 'job_description', WPJ_Form::get( 'action' ) ); ?>

						</div>

					<?php } elseif ( wpj_get_option( 'wpjobster_job_description_type' ) == 'tinymce' ) { // TINYMCE TEXTAREA ?>

						<div
							class="tinyMCE-textarea-wrapper"
							data-name="job_description"
							data-rejected="<?php echo wpj_get_job_rejected_input( 'description' ); ?>"
							data-value="<?php echo $post_value; ?>"
						>

							<?php wpj_display_tinyMCE_textarea( 'job_description', wpj_get_job_rejected_input( 'description' ), $post_value ); ?>

						</div>

					<?php } else { // SIMPLE TEXTAREA ?>

						<textarea
							placeholder="<?php echo $placeholder ? $placeholder : _x( 'The description of your job', 'Post new job', 'wpjobster' ); ?>"
							rows="6"
							class="charlimit-jobdescription <?php echo wpj_get_job_rejected_input( 'description' ); ?> mb5"
							name="job_description"><?php echo str_replace( ['<br />', '</br>', '<br>'], "\n", $post_value ); ?></textarea>

						<span class="charscounter"><?php _e( 'characters left', 'wpjobster' ); ?></span>

					<?php } ?>

				</div>
			</div>

		<?php }

		public function tag( $placeholder = '' ) {

			if ( isset( $_POST['job_tags'] ) ) {
				$post_value = $_POST['job_tags'];

			} else {
				$i           = 0;
				$post_value  = '';
				$i_separator = '';

				$job_tags = wp_get_post_tags( $this->pid );

				if ( $job_tags ) {
					foreach ( $job_tags as $tag ) {
						$post_value .= $i_separator . $tag->name;

						$i++;

						if ( $i > 0 ) $i_separator = ', ';
					}
				}
			} ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_tag">
				<div class="input-block text-right">
					<input
						type="text"
						value="<?php echo $post_value; ?>"
						id="<?php echo wpj_get_job_rejected_input( 'tag' ) == 'rejected-input' ? 'rejected' : 'job_tags'; ?>"
						name="job_tags"
						class="<?php echo wpj_get_job_rejected_input( 'tag' ); ?> js-tags"
						placeholder="<?php echo $placeholder ? $placeholder : _x( 'The tags of your job', 'Post new job', 'wpjobster' ); ?>"
					/>

					<span class="charscounter">(<?php _e( 'separate your tags by comma', 'wpjobster' ); ?>)</span>
				</div>
			</div>

		<?php }

// *** END JOB INFORMATION SECTION *** <-//

//-> *** JOB BUYER SECTION *** //

		public function instruction( $placeholder = '', $required = true ) {

			$post_value = WPJ_Form::post( 'instruction_box', get_post_meta( $this->pid, 'instruction_box', true ) );
			$post_value = str_replace( '<br />', "", $post_value ); // if text contain <br /> as text ?>

			<div class="tooltip-handler js-tooltip-handler text-right" data-handler-id="job_instruction">

				<?php if ( wpj_get_option( 'wpjobster_buyer_instructions_job_enabled' ) == "yes" ) { ?>

					<div class="post-job-buyer-instructions">
						<div class="ui toggle checkbox buyer-instructions-checkbox mt0">
							<input
								type="checkbox"
								value="yes"
								name="buyer_instructions"
								<?php echo WPJ_Form::post( 'buyer_instructions', get_post_meta( $this->pid, 'buyer_instructions', true ) == 'yes' ? 'checked' : '' ); ?>
							/>

							<label><?php _e( 'Slide to display instructions to job page', 'wpjobster' ); ?></label>
						</div>
					</div>

				<?php } ?>

				<textarea
					data-required="<?php echo $required; ?>"
					placeholder="<?php echo $placeholder ? $placeholder : _x( 'The buyer instructions of your job', 'Post new job', 'wpjobster' ); ?>"
					rows="6"
					class="charlimit-jobinstruction mt5 <?php echo wpj_get_job_rejected_input( 'instruction' ); ?> mb5"
					name="instruction_box"><?php echo $post_value; ?></textarea>

				<span class="charscounter"><?php _e( 'characters left', 'wpjobster' ); ?></span>

				<input id="instruction_box_required" type="hidden" name="instruction_box_required" value="<?php echo $required; ?>">

			</div>

		<?php }

		public function faq( $placeholder = '', $required = false ) {

			$post_value = isset( $_POST['faq_question'] ) ? $_POST['faq_question'] : get_post_meta( $this->pid, 'faq', true ); ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_faq">

				<?php if ( $post_value ) {
					foreach ( $post_value as $key => $faq ) { ?>

						<div class="faq-wrapper">
							<div class="ui styled fluid accordion faq-item">
								<div class="title">

									<i class="angle down icon"></i>

									<?php echo isset( $_POST['faq_question'][$key] ) ? $_POST['faq_question'][$key] : $faq['question']; ?>

								</div>

								<div class="content">
									<p><?php _e( 'Question', 'wpjobster' ); ?></p>

									<input class="faq-question" data-required="<?php echo $required; ?>" placeholder="<?php _e( 'Question', 'wpjobster' ); ?>" type="text" name="faq_question[]" value="<?php echo isset( $_POST['faq_question'][$key] ) ? $_POST['faq_question'][$key] : $faq['question']; ?>" />

									<p><?php _e( 'Answer', 'wpjobster' ); ?></p>

									<textarea class="faq-answer" data-required="<?php echo $required; ?>" placeholder="<?php _e( 'Answer', 'wpjobster' ); ?>" rows="6" name="faq_answer[]"><?php echo isset( $_POST['faq_answer'][$key] ) ? $_POST['faq_answer'][$key] : $faq['answer']; ?></textarea>
								</div>
							</div>

							<a class="delete-faq js-delete-faq cursor-pointer"><i class="x icon"></i><?php _e( 'Delete FAQ', 'wpjobster' ); ?></a>
						</div>

					<?php }

				} else { ?>

					<div class="faq-wrapper">
						<div class="ui styled fluid accordion faq-item">
							<div class="title">

								<?php echo $placeholder ? $placeholder : _x( 'Insert your question and answer', 'Post new job', 'wpjobster' ); ?>

								<i class="angle down icon"></i>

							</div>

							<div class="content">
								<p><?php _e( 'Question', 'wpjobster' ); ?></p>

								<input class="faq-question" data-required="<?php echo $required; ?>" placeholder="<?php _e( 'Question', 'wpjobster' ); ?>" type="text" name="faq_question[]" />

								<p><?php _e( 'Answer', 'wpjobster' ); ?></p>

								<textarea class="faq-answer" data-required="<?php echo $required; ?>" placeholder="<?php _e( 'Answer', 'wpjobster' ); ?>" rows="6" name="faq_answer[]"></textarea>
							</div>

						</div>

						<a class="delete-faq js-delete-faq cursor-pointer">

							<i class="x icon"></i>

							<?php _e( 'Delete FAQ', 'wpjobster' ); ?>

						</a>

					</div>

				<?php } ?>

				<a class="add-faq js-add-faq cursor-pointer"><?php _e( '+ Add New FAQ', 'wpjobster' ); ?></a>

			</div>

		<?php }

		public function delivery( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no' || wpj_get_option( 'wpjobster_enable_instant_delivery' ) != 'no' ) {

				$post_value = WPJ_Form::post( 'max_days', get_post_meta( $this->pid, 'max_days', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_delivery">
					<select id="max_days" name="max_days" class="ui dropdown max-day-deliver js-displayed-field">

						<option value="" disabled selected hidden><?php echo $placeholder ? $placeholder : _x( 'Please select', 'Post new job', 'wpjobster' ); ?></option>

						<?php if ( wpj_get_option( 'wpjobster_enable_instant_delivery' ) != 'no' ) { ?>

							<option <?php echo $post_value == 'instant' || $post_value == 0 ? ' selected="selected" ' : ''; ?> value="instant">

								<?php _e( 'Instant', 'wpjobster' ); ?>

							</option>

						<?php }

						if ( wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no' ) {

							for ( $i_count = 1; $i_count <= wpj_get_option( 'wpjobster_job_max_delivery_days' ); $i_count++ ) { ?>

								<option <?php echo $i_count == $post_value ? ' selected="selected=" ' : ''; ?> value="<?php echo $i_count; ?>">

									<?php echo sprintf( _nx( '%d day', '%d days', $i_count, 'The delivery days for the job', 'wpjobster' ), $i_count ); ?>

								</option>

							<?php }

						} ?>

					</select>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function instant_delivery() {

			if ( wpj_get_option( 'wpjobster_enable_instant_delivery' ) != "no" ) {

				$post_value = WPJ_Form::post( 'hidden_files_instant_job_attachments', get_post_meta( $this->pid, 'job_any_attachments', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_instant_delivery">
					<div class="js-displayed-field">

						<?php if ( wpj_get_job_rejected_input( 'instant_delivery' ) == 'rejected-input' ) { ?>

							<div class="rejected-border rejected-border-uploader">

						<?php }

								wpj_display_file_upload_form( $secure = 1, "file_upload_instant_job_attachments", "hidden_files_instant_job_attachments", "instant_delivery" );

						if ( wpj_get_job_rejected_input( 'instant_delivery' ) == 'rejected-input' ) { ?>

							</div>

						<?php }

						if ( wpj_post_has_attachments( $post_value ) ) {

							wpj_display_attachments_list( $post_value, $this->pid, 'job_any_attachments' );

						} ?>

					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function shipping( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_enable_shipping' ) == "yes" ) {

				$post_value = WPJ_Form::post( 'shipping', get_post_meta( $this->pid, 'shipping', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler job-shipping-price" data-handler-id="job_shipping">
					<div class="ui labeled input js-displayed-field">
						<div class="ui label">

							<?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?>

						</div>

						<input
							type="number"
							step="any"
							size="5"
							placeholder="<?php echo $placeholder ? $placeholder : _x( 'The shipping price of your job', 'Post new job', 'wpjobster' ); ?>"
							name="shipping"
							value="<?php echo $post_value; ?>"
						/>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function lets_meet( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_lets_meet' ) == "yes" ) {

				$post_value = WPJ_Form::post( 'lets_meet', get_post_meta( $this->pid, 'lets_meet', true ) == 'yes' ? 'checked' : '' ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_lets_meet">
					<div class="js-displayed-field">
						<div class="ui toggle checkbox mt0">
							<input
								type="checkbox"
								value="yes"
								name="lets_meet"
								id="lets_meet"
								class="location-trigger js-lets-meet-trigger"
								<?php echo $post_value; ?>
							/>

							<label class="lets-meet-label">

								<?php echo $placeholder ?? _x( 'Slide to enable', 'Post new job - Let\'s meet', 'wpjobster' ); ?>

							</label>
						</div>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function location( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_location' ) == "yes" ) {
				$post_job_location_value = WPJ_Form::post( 'location_input', get_post_meta( $this->pid, 'location_input', true ) );
				$post_job_lat_value      = WPJ_Form::post( 'job_lat', get_post_meta( $this->pid, 'lat', true ) );
				$post_job_long_value     = WPJ_Form::post( 'job_long', get_post_meta( $this->pid, 'long', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_location">

					<div class="ui search js-location-autocomplete js-lets-meet-item js-displayed-field">
						<div class="ui clearable input">
							<input
								placeholder="<?php echo $placeholder ? $placeholder : _x( 'The location of your job', 'Post new job', 'wpjobster' ); ?>"
								type="text"
								data-replaceplaceholder="<?php _e( 'Select a valid location', 'wpjobster' ); ?>"
								class="prompt" value="<?php echo $post_job_location_value; ?>"
								name="location_input"
							/>

							<input
								id="lat"
								type="hidden"
								name="lat"
								value="<?php echo $post_job_lat_value; ?>"
							/>

							<input
								id="long"
								type="hidden"
								name="long"
								value="<?php echo $post_job_long_value; ?>"
							/>
						</div>

						<div class="results"></div>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function distance( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_location_distance' ) == "yes" ) {
				$post_value  = WPJ_Form::post( 'distance_input', get_post_meta( $this->pid, 'distance_input', true ) );
				$radius_unit = wpj_get_option( 'wpjobster_locations_unit' ) == 'miles' ? __( 'mi', "wpjobster" ) : __( 'km', "wpjobster" ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_distance">
					<div class="ui labeled input js-lets-meet-item js-displayed-field">
						<div class="ui label">

							<?php echo $radius_unit; ?>

						</div>

						<input
							placeholder="<?php echo $placeholder ? $placeholder : _x( 'The distance of your job', 'Post new job', 'wpjobster' ); ?>"
							type="number"
							value="<?php echo $post_value; ?>"
							name="distance_input"
						/>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function map( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_location_display_map_user_choice' ) == 'yes' ) {

				$post_value = WPJ_Form::post( 'display_map', get_post_meta( $this->pid, 'display_map', true ) == 'yes' ? 'checked' : '' ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_map">
					<div class="js-lets-meet-item js-displayed-field">
						<div class="ui toggle checkbox mt0">
							<input
								type="checkbox"
								name="display_map"
								value="yes"
								<?php echo $post_value; ?>
							/>

							<label class="lets-meet-label">

								<?php echo $placeholder ?? _x( 'Slide to enable', 'Post new job - Display map', 'wpjobster' ); ?>

							</label>
						</div>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

// *** END JOB BUYER SECTION *** <-//

//-> *** JOB MEDIA SECTION *** //

		public function cover() {

			if ( wpj_get_option( 'wpjobster_enable_job_cover' ) == 'yes' ) { ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_cover">

					<div class="js-displayed-field">

						<?php wpj_display_job_cover_upload_form( $this->pid ); ?>

					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function image() { ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_image">

			<?php if ( wpj_get_job_rejected_input( 'image' ) == 'rejected-input' ) { ?>

				<div class="rejected-border">

			<?php } ?>

			<?php wpj_display_image_upload_form( $this->pid, 'job', 'job', 'job_images' ); ?>

			<?php if ( wpj_get_job_rejected_input( 'image' ) == 'rejected-input' ) { ?>

				</div>

			<?php } ?>

		</div>

		<?php }

		public function video( $placeholder = '' ) {
			$enable_video_multiples = wpj_get_user_feature_status( 'wpjobster_enable_video_multiples', 'wpjobster_subscription_video_multiples_enabled' );

			if ( $enable_video_multiples == 'yes' && wpj_get_user_feature_value( 'vds', 'video_multiples' ) ) {
				$post_job_videos = isset( $_POST['video_link'] ) ? $_POST['video_link'] : get_post_meta( $this->pid, 'video_link', true );
				$post_value      = isset( $post_job_videos[0] ) && $post_job_videos[0] ? $post_job_videos[0] : false; ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_video">

					<div class="js-displayed-field">

						<div class="post-job-video-as-first-image">
							<div class="ui toggle checkbox post-job-video-as-first-image-checkbox mt0">
								<input
									type="checkbox"
									value="yes"
									name="video_as_job_thumbnail"
									<?php echo WPJ_Form::post( 'video_as_job_thumbnail', ( ! get_post_meta( $this->pid, 'video_as_job_thumbnail', true ) || get_post_meta( $this->pid, 'video_as_job_thumbnail', true ) == 'yes' ? 'checked' : '' ) ); ?>
								/>

								<label>

									<?php _e( 'Slide to display video thumbnail as first image of the job', 'wpjobster' ); ?>

								</label>
							</div>
						</div>

						<?php if ( $post_job_videos && is_array( $post_job_videos ) && $enable_video_multiples == 'yes' ) {

							foreach ( $post_job_videos as $key => $value ) { ?>

								<div class="video-wrapper">
									<input
										placeholder="<?php echo $placeholder ? $placeholder : _x( 'The URL of your video', 'Post new job', 'wpjobster' ); ?>"
										class="video-link <?php echo wpj_get_job_rejected_input( 'video' ); ?>"
										type="text"
										name="video_link[]"
										value="<?php echo $value; ?>"
									/>

									<a class="delete-video js-delete-video cursor-pointer">
										<i class="x icon"></i>

										<?php _e( 'Delete Video', 'wpjobster' ); ?>
									</a>
								</div>

							<?php }

						} else { ?>

							<div class="video-wrapper">
								<input
									placeholder="<?php echo $placeholder ? $placeholder : _x( 'The URL of your video', 'Post new job', 'wpjobster' ); ?>"
									class="video-link <?php echo wpj_get_job_rejected_input( 'video' ); ?>"
									type="text"
									name="video_link[]"
									value="<?php echo $post_value; ?>"
								/>

								<a class="delete-video js-delete-video cursor-pointer">
									<i class="x icon"></i>

									<?php _e( 'Delete Video', 'wpjobster' ); ?>
								</a>
							</div>

						<?php } ?>

					</div>

					<?php if ( $enable_video_multiples == 'yes' ) { ?>

						<a class="add-video js-add-video cursor-pointer">

							<?php _e( '+ Add New Video', 'wpjobster' ); ?>

						</a>

					<?php } ?>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function preview() {

			if ( wpj_get_option( 'wpjobster_job_attachments_enabled' ) == 'yes' ) {

				$post_value = WPJ_Form::post( 'hidden_files_preview_job_attachments', get_post_meta( $this->pid, 'preview_job_attachments', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_preview">

					<div class="js-displayed-field">

						<?php if ( wpj_get_job_rejected_input( 'preview' ) == 'rejected-input' ) { ?>

							<div class="rejected-border rejected-border-uploader">

						<?php } ?>

						<?php wpj_display_file_upload_form( $secure = 1, 'file_upload_preview_job_attachments', 'hidden_files_preview_job_attachments', 'work_preview' ); ?>

						<?php if ( wpj_get_job_rejected_input( 'preview' ) == 'rejected-input' ) { ?>

							</div>

						<?php }

						if ( wpj_post_has_attachments( $post_value ) ) {

							wpj_display_attachments_list( $post_value, $this->pid, 'preview_job_attachments' );

						} ?>

					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function audio() {

			if ( wpj_get_option( 'wpjobster_audio' ) == "yes" ) { ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_audio">

					<div class="js-displayed-field">

						<?php if ( wpj_get_job_rejected_input( 'audio' ) == 'rejected-input' ) { ?>

							<div class="rejected-border">

						<?php } ?>

						<?php wpj_display_audio_upload_form( $this->pid ); ?>

						<?php if ( wpj_get_job_rejected_input( 'audio' ) == 'rejected-input' ) { ?>

							</div>

						<?php } ?>

					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

// *** END JOB MEDIA SECTION *** <-//

//-> *** JOB EXTRA SECTION *** //

		public function extra_fast_delivery( $placeholder = '', $include_label = true ) {

			if ( $include_label === 'false' ) $include_label = false;

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra_fast_delivery', 'wpjobster_subscription_ex_fast_delivery_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'fast_delivery_multiples', 'fast_del_multiples' )
			) {

				$post_value = WPJ_Form::post( 'enable_extra_fast', get_post_meta( $this->pid, 'extra_fast_enabled', true ) == true ? 'checked' : '' ); ?>

				<div class="tooltip-handler js-tooltip-handler extra-fields" data-handler-id="job_extra_fast_delivery">

					<?php if ( $include_label ) { ?>

						<label>
							<span>

								<?php echo _x( 'Extra Fast Delivery', 'Post new job', 'wpjobster' ); ?>

							</span>
						</label>

					<?php } ?>

					<div class="ui toggle checkbox js-displayed-field mt0">
						<label>

							<?php echo $placeholder ?? _x( 'Slide to enable', 'Post new job - Extra Fast Delivery', 'wpjobster' ); ?>

						</label>

						<input
							type="checkbox"
							name="enable_extra_fast"
							id="enable_extra_fast"
							<?php echo $post_value; ?>
						/>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function extra_fast_delivery_price( $placeholder = '' ) {

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra_fast_delivery', 'wpjobster_subscription_ex_fast_delivery_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'fast_delivery_multiples', 'fast_del_multiples' )
			) {

				$post_value = WPJ_Form::post( 'extra_fast_price', get_post_meta( $this->pid, 'extra_fast_price', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_extra_fast_delivery_price">
					<div class="ui labeled input js-displayed-field">
						<div class="ui label">

							<?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?>

						</div>

						<input
							placeholder="<?php echo $placeholder ? $placeholder : _x( 'The price of extra fast delivery', 'Post new job', 'wpjobster' ); ?>"
							type="number"
							value="<?php echo $post_value; ?>"
							step="any"
							name="extra_fast_price"
							id="extra_fast_price"
							class="price-input"
						/>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function extra_fast_delivery_days( $placeholder = '' ) {

			if (
				wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no'
				&& wpj_get_user_feature_status( 'wpjobster_enable_extra_fast_delivery', 'wpjobster_subscription_ex_fast_delivery_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'fast_delivery_multiples', 'fast_del_multiples' )
			) {

				$post_value = WPJ_Form::post( 'max_days_fast', get_post_meta( $this->pid, 'extra_fast_days', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_extra_fast_delivery_days">
					<select id="max_days_fast" name="max_days_fast" class="max-day-deliver max_days_fast ui dropdown js-displayed-field">

						<option value="" disabled selected hidden>

							<?php echo $placeholder ? $placeholder : _x( 'Please select', 'Post new job', 'wpjobster' ); ?>

						</option>

						<?php if ( wpj_get_option( 'wpjobster_enable_instant_delivery' ) != "no" ) { ?>

							<option <?php echo $post_value == 'instant' ? ' selected="selected" ' : ''; ?> value="instant"><?php _e( 'Instant', 'wpjobster' ); ?></option>

						<?php }

						for ( $i_count = 1; $i_count <= 30; $i_count++ ) { ?>

							<option value="<?php echo $i_count; ?>" <?php echo $post_value == $i_count ? ' selected="selected" ' :''; ?>>

								<?php echo sprintf( _nx( '%d day', '%d days', $i_count, 'The delivery days for the extra fast delivery', 'wpjobster' ), $i_count ); ?>

							</option>

						<?php } ?>

					</select>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function additional_revision( $placeholder = '', $include_label = true ) {

			if ( $include_label === 'false' ) $include_label = false;

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra_additional_revision', 'wpjobster_subscription_additional_revision_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'add_rev_multiples', 'add_rev_multiples' )
			) {

				$post_value = WPJ_Form::post( 'enable_extra_revision', get_post_meta( $this->pid, 'extra_revision_enabled', true ) == true ? 'checked' : '' ); ?>

				<div class="tooltip-handler js-tooltip-handler extra-fields" data-handler-id="job_additional_revision">

					<?php if ( $include_label ) { ?>

						<label>
							<span><?php echo _x( 'Additional Revision', 'Post new job', 'wpjobster' ); ?></span>
						</label>

					<?php } ?>

					<div class="ui toggle checkbox js-displayed-field mt0">
						<label>

							<?php echo $placeholder ?? _x( 'Slide to enable', 'Post New Job - Additional Revision', 'wpjobster' ) ?>

						</label>

						<input
							type="checkbox"
							name="enable_extra_revision"
							id="enable_extra_revision"
							<?php echo $post_value; ?>
						/>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function additional_revision_price( $placeholder = '' ) {

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra_additional_revision', 'wpjobster_subscription_additional_revision_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'add_rev_multiples', 'add_rev_multiples' )
			) {

				$post_value = WPJ_Form::post( 'extra_revision_price', get_post_meta( $this->pid, 'extra_revision_price', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_additional_revision_price">
					<div class="ui labeled input js-displayed-field">
						<div class="ui label">

							<?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?>

						</div>

						<input
							placeholder="<?php echo $placeholder ? $placeholder : _x( 'The price of additional revision', 'Post new job', 'wpjobster' ); ?>"
							type="number"
							value="<?php echo $post_value; ?>"
							step="any"
							name="extra_revision_price"
							class="price-input"
						/>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function additional_revision_delivery_days( $placeholder = '' ) {

			if (
				wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no'
				&& wpj_get_user_feature_status( 'wpjobster_enable_extra_additional_revision', 'wpjobster_subscription_additional_revision_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'add_rev_multiples', 'add_rev_multiples' )
			) {

				$post_value = WPJ_Form::post( 'max_days_revision', get_post_meta( $this->pid, 'extra_revision_days', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_additional_revision_delivery_days">

					<select id="max_days_revision" name="max_days_revision" class="max-day-deliver ui dropdown js-displayed-field">

						<option value="" disabled selected hidden>

							<?php echo $placeholder ? $placeholder : _x( 'Please select', 'Post new job', 'wpjobster' ); ?>

						</option>

						<?php if ( wpj_get_option( 'wpjobster_enable_instant_delivery' ) != "no" ) { ?>

							<option <?php echo $post_value == 'instant' ? ' selected="selected" ' :''; ?> value="instant"><?php _e( 'Instant', 'wpjobster' ); ?></option>

						<?php }

						for ( $i_count = 1; $i_count <= 30; $i_count++ ) { ?>

							<option value="<?php echo $i_count; ?>" <?php echo $post_value == $i_count ? ' selected="selected" ' : ''; ?>>

								<?php echo sprintf( _nx( '%d day', '%d days', $i_count, 'The delivery days for the additional revision', 'wpjobster' ), $i_count ); ?>

							</option>

						<?php } ?>

					</select>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function additional_revision_multiple( $placeholder = '' ) {

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra_additional_revision', 'wpjobster_subscription_additional_revision_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'add_rev_multiples', 'add_rev_multiples' )
			) {

				$post_value = WPJ_Form::post( 'enable_multiples_revision', get_post_meta( $this->pid, 'extra_revision_multiples_enabled', true ) == true ? 'checked' : '' ); ?>

				<div class="tooltip-handler js-tooltip-handler extra-fields" data-handler-id="job_additional_revision_multiple">
					<div class="ui checkbox multiple-box js-displayed-field mt0">
						<label>

							<?php echo $placeholder ? $placeholder : _x( 'Multiple', 'Post new job', 'wpjobster' ); ?>

						</label>

						<input
							type="checkbox"
							name="enable_multiples_revision"
							id="enable_multiples_revision"
							<?php echo $post_value; ?>
						/>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function extra( $placeholder = '', $include_label = true ) {

			if ( $include_label === 'false' ) $include_label = false;

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra', 'wpjobster_subscription_noof_extras_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'extras', 'noof_extras', 0 )
			) {

				$post_value = WPJ_Form::post( 'enable_extra_1', get_post_meta( $this->pid, 'extra1_extra_enabled', true ) == true ? 'checked' : '' ); ?>

				<div class="tooltip-handler js-tooltip-handler extra-fields" data-handler-id="job_extra">

					<?php if ( $include_label ) { ?>

						<label>
							<span>

								<?php echo _x( 'Extra', 'Post new job', 'wpjobster' ); ?>

							</span>
						</label>

					<?php } ?>

					<div class="ui toggle checkbox extra-item js-displayed-field mt0">
						<label>

							<?php echo $placeholder ?? _x( 'Slide to enable', 'Post new job - Extra', 'wpjobster' ); ?>

						</label>

						<input
							type="checkbox"
							name="enable_extra_1"
							id="enable_extra_1"
							<?php echo $post_value; ?>
						/>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function extra_description( $placeholder = '' ) {

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra', 'wpjobster_subscription_noof_extras_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'extras', 'noof_extras', 0 )
			) {

				$post_value = WPJ_Form::post( 'extra1_content', get_post_meta( $this->pid, 'extra1_content', true ) );
				$post_value = str_replace( '<br />', "", $post_value ); // if text contain <br /> as text ?>

				<div class="tooltip-handler js-tooltip-handler text-right" data-handler-id="job_extra_description">

					<textarea
						placeholder="<?php echo $placeholder ? $placeholder : _x( 'The description of extra', 'Post new job', 'wpjobster' ); ?>"
						class="extra-item js-displayed-field charlimit-extradescription charlimit-extradescription-1 <?php echo wpj_get_job_rejected_input( 'extra1' ); ?> mb5"
						name="extra1_content"
						cols="40"
						rows="2"><?php echo $post_value; ?></textarea>

					<span class="charscounter"><?php _e( 'characters left', 'wpjobster' ); ?></span>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function extra_price( $placeholder = '' ) {

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra', 'wpjobster_subscription_noof_extras_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'extras', 'noof_extras', 0 )
			) {

				$post_value = WPJ_Form::post( 'extra1_price', get_post_meta( $this->pid, 'extra1_price', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_extra_price">
					<div class="ui labeled input extra-item js-displayed-field">
						<div class="ui label">

							<?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?>

						</div>

						<input
							placeholder="<?php echo $placeholder ? $placeholder : _x( 'The price of extra', 'Post new job', 'wpjobster' ); ?>"
							type="number"
							value="<?php echo $post_value; ?>"
							step="any"
							name="extra1_price"
							class="price-input"
						/>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function extra_delivery_days( $placeholder = '' ) {

			if (
				wpj_get_option( 'wpjobster_enable_delivery_time' ) != 'no'
				&& wpj_get_user_feature_status( 'wpjobster_enable_extra', 'wpjobster_subscription_noof_extras_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'extras', 'noof_extras', 0 )
			) {

				$post_value = WPJ_Form::post( 'max_days_1', get_post_meta( $this->pid, 'max_days_ex_1', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_extra_delivery_days">

					<select id="max_days_1" name="max_days_1" class="max-day-deliver extra-item js-displayed-field ui dropdown">

						<option value="" disabled selected hidden>

							<?php echo $placeholder ? $placeholder : _x( 'Please select', 'Post new job', 'wpjobster' ); ?>

						</option>

						<?php if ( wpj_get_option( 'wpjobster_enable_instant_delivery' ) != "no" ) { ?>

							<option <?php echo $post_value == 'instant' ? ' selected="selected" ' : ''; ?> value="instant"><?php _e( 'Instant', 'wpjobster' ); ?></option>

						<?php }

						for ( $i_count = 1; $i_count <= 30; $i_count++ ) { ?>

							<option value="<?php echo $i_count; ?>" <?php echo $post_value == $i_count ? ' selected="selected" ' :'' ?>>

								<?php echo sprintf( _nx( '%d day', '%d days', $i_count, 'The delivery days for the extras', 'wpjobster' ), $i_count ); ?>

							</option>

						<?php } ?>

					</select>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function extra_multiple( $placeholder = '' ) {

			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra', 'wpjobster_subscription_noof_extras_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'extras', 'noof_extras', 0 )
			) {

				if ( wpj_get_user_feature_status( 'wpjobster_enable_extra_multiples', 'wpjobster_subscription_extra_multiples_enabled' ) == 'yes' && wpj_get_user_feature_value( 'extramultiples', 'extra_multiples' ) > 1 ) {

					$post_value = WPJ_Form::post( 'enable_multiples_1', get_post_meta( $this->pid, 'extra1_enabled', true ) == true ? 'checked' : '' ); ?>

					<div class="tooltip-handler js-tooltip-handler multiple-box-wrapper" data-handler-id="job_extra_multiple">
						<div class="ui checkbox multiple-box extra-item js-displayed-field mt0">
							<label>

								<?php echo $placeholder ? $placeholder : _x( 'Multiple', 'Post new job', 'wpjobster' ); ?>

							</label>

							<input
								type="checkbox"
								name="enable_multiples_1"
								id="enable_multiples_1"
								<?php echo $post_value; ?>
							/>
						</div>

						<div class="delete-extra-wrapper">
							<a class="cursor-pointer delete-extra js-delete-extra">
								<i class="x icon"></i>

								<?php _e( 'Delete Extra', 'wpjobster' ); ?>
							</a>
						</div>
					</div>

				<?php } else { ?>

					<div class="disabled-field js-disabled-field"></div>

				<?php }

			} else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function add_new_extra_button( $placeholder = '' ) {
			if (
				wpj_get_user_feature_status( 'wpjobster_enable_extra', 'wpjobster_subscription_noof_extras_enabled' ) != 'no'
				&& wpj_get_user_feature_value( 'extras', 'noof_extras', 0 )
			) {

				if ( wpj_get_user_feature_value( 'extras', 'noof_extras' ) > 1 ) { ?>

					<a class="cursor-pointer add-extra js-add-extra js-displayed-field">

						<?php echo $placeholder ? $placeholder : _x( '+ Add New Extra', 'Post new job', 'wpjobster' ); ?>

					</a>

				<?php } else { ?>

					<div class="disabled-field js-disabled-field"></div>

				<?php }

			} else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }
		}

// *** END JOB EXTRA SECTION *** <-//

//-> *** JOB PUBLISH SECTION *** //

		public function tos( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_tos_type' ) != 'disabled' ) {
				$post         = get_post( wpj_get_option( 'wpjobster_terms_of_service_page_id' ) );
				$post_content = strip_tags( $post->post_content, '<p><a><ul><ol><li><b><strong><i><u><h1><h2><h3><h4><h5><h6>' );

				if ( strpos( $post_content, '</h3>' ) !== false ) {
					$post_content = strstr( $post_content, '<h3' ); // delete everything until the first paragraph
				}

				$post_value = function_exists( 'qtrans_use' ) && function_exists( 'qtrans_getLanguage' ) ? qtrans_use( qtrans_getLanguage(), $post_content, false ) : $post_content; ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="job_tos">
					<div class="js-displayed-field">

						<?php if ( wpj_get_option( 'wpjobster_tos_type' ) == 'show_on_page' ) { ?>

							<div class="terms-of-services-box">

								<?php echo $post_value; ?>

							</div>

						<?php } ?>

						<p>
							<div class="ui checkbox">
								<input
									type="checkbox"
									name="i_agree"
									value="1"
								/>

								<label>

									<?php echo sprintf(
										__( 'I agree to the %s.', 'wpjobster' ),
										'<a class="underline" href="' . get_permalink( wpj_get_option( 'wpjobster_terms_of_service_page_id' ) ) . '" class="" target="_blank">' . ( $placeholder ?: __( 'Terms of Service', 'wpjobster' ) ) . '</a>'
									); ?>

								</label>
							</div>
						</p>
					</div>
				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

// *** END JOB PUBLISH SECTION *** <-//

//-> *** PLUGINS SECTION *** //

		public function milestones( $placeholder = '' ) {

			do_action( 'wpj_post_new_milestone_table_content', $this->pid  );

		}

		public function video_call( $placeholder = '' ) {

			do_action( 'wpj_post_new_video_call_option', $this->pid  );

		}

// *** END PLUGINS SECTION *** <-//

	}

}