<?php if ( ! class_exists( 'WPJJobsNewEdit' ) ) {

	class WPJJobsNewEdit extends stdClass {

		private WPJ_Custom_Fields $custom_field;

		public function __construct() {
			add_action( 'wp_ajax_save_job_post_action', [ $this, 'savePostData' ] );
			add_action( 'wp_ajax_nopriv_save_job_post_action', [ $this, 'savePostData' ] );

			$this->custom_field = new WPJ_Custom_Fields( WPJ_Form::get( 'jobid' ), 'job' );
		}

		public static function init() { $class = __CLASS__; new $class; }

		public function getFieldsContent( $fields = '', $pid = '', $page_content = '' ) {
			if ( ! $pid ) {
				$pid = wpj_get_post_id( $pid );
			}

			if ( $fields['acf_fc_layout'] == 'job_field_separator' ) { // Separator
				$id            = 'field_separator';
				$class         = 'field_separator';
				$label         = 'no';
				$popup         = 'no';
				$page_content .= $this->getContentFromBuffer( 'separator', ['label' => $fields['label']] );

			} elseif ( strpos( $fields['acf_fc_layout'], 'custom_field' ) !== false ) { // Custom Fields
				$class         = 'cf';
				$jcf           = $this->custom_field->getFieldsContent( $fields );
				$label         = $jcf['label'];
				$popup         = $jcf['popup'];
				$page_content .= $jcf['content'];

			} else { // Job Fields
				$page_content .= $this->getContentFromBuffer( str_replace( 'job_', '', $fields['acf_fc_layout'] ),
					['placeholder' => isset( $fields['placeholder'] ) ? $fields['placeholder'] : '']
				);

			}

			// No Label Fields
			if ( in_array( $fields['acf_fc_layout'], apply_filters( 'wpj_post_new_job_no_label_fields_filter',
				[
					'job_package',
					'job_extra_fast_delivery',
					'job_additional_revision',
					'job_additional_revision_multiple',
					'job_extra',
					'job_extra_multiple',
					'job_add_new_extra_button'
				]
			) ) ) {
				$label = 'no';
			}

			// No Popup Fields
			if ( in_array( $fields['acf_fc_layout'], apply_filters( 'wpj_post_new_job_no_popup_fields_filter',
				[
					'job_package',
					'job_add_new_extra_button'
				]
			) ) ) {
				$popup = 'no';
			}

			// Hidden Fields
			if ( ! in_array( $fields['acf_fc_layout'], apply_filters( 'wpj_post_new_job_hiddenfields_filter',
				[
					'job_field_separator',
					'job_title',
					'job_price',
					'job_category',
					'job_subcategory',
					'job_description',
					'job_tag',
					'job_instruction',
					'job_faq',
					'job_image'
				]
			) ) ) {
				$parent_class = $class = 'hidden';
			}

			$return_arr = [
				'id'           => $id ?? '',
				'class'        => $class ?? '',
				'parent_class' => $parent_class ?? '',
				'label'        => $label ?? '',
				'popup'        => $popup ?? '',
				'field'        => $field ?? '',
				'instr'        => $fields['instructions'] ?? '',
				'f_rej_name'   => $fields['acf_fc_layout'] != 'job_extra_description' ? str_replace( 'job_', '', $fields['acf_fc_layout'] ) : 'extra1',
				'content'      => $page_content
			];

			return apply_filters( 'wpj_post_new_job_fields_content_filter', $return_arr, $pid, $fields );
		}

		public function validatePostData() {

			// Default
			$required_fields = [
				'job_title',
				'job_cat',
				'job_description',
				'job_cost'
			];

			// Subcategories
			$subcategories = get_term_children( WPJ_Form::post( 'job_cat' ), 'job_cat' );

			if ( $subcategories && WPJ_Form::post( 'subcategory_required' ) == 'true' ) {
				array_push( $required_fields, 'subcat' );
			}

			// Instructions to buyer
			if ( WPJ_Form::post( 'instruction_box_required' ) == 'true' ) {
				array_push( $required_fields, 'instruction_box' );
			}

			// Packages
			if ( wpj_get_option( 'wpjobster_packages_enabled' ) == 'yes' && isset( $_POST['price_type'] ) && $_POST['price_type'] == 'package' ) {
				if ( ! is_array( $required_fields ) ) {
					$required_fields = [];
				}

				$required_fields = array_diff( $required_fields, ['job_cost'] );

				$package_required_fields = apply_filters( 'wpj_job_package_required_fields_filter', ['package_name', 'package_description' ,'package_price'] );

				if ( $package_required_fields ) {
					$required_fields = array_merge( $required_fields, $package_required_fields );

				} else {
					$required_fields = $package_required_fields;

				}
			}

			// Custom
			if ( isset( $_POST['price_type'] ) && $_POST['price_type'] == 'custom' ) {
				$required_fields = array_diff( $required_fields, [ 'job_cost' ] );
			}

			// Verify empty required values
			$required_fields = apply_filters( 'wpj_job_required_fields_filter', $required_fields );

			if ( $required_fields ) {
				$requirements_met = true;

				foreach ( $required_fields as $key => $field ) {
					if (
						( ! is_array( $_POST[$field] ) && strlen( $_POST[$field] ) == 0 )
						|| ( is_array( $_POST[$field] ) && ! wpj_multidimensional_array_has_all_values( $_POST[$field] ) )
					) {
						$requirements_met = false; continue;
					}
				}
			}

			return ( $required_fields && $requirements_met ) || ! $required_fields;

		}

		public function savePostData( $pid = '', $action_type = '', $status = '', $forced = false ) {

			if ( isset( $_POST['aoe_form_submitted'] ) && ! is_demo_user() ) {

				$uid = get_current_user_id();

				$pid  = WPJ_Form::post( 'pid', wpj_get_post_id( $pid ) );
				$post = get_post( $pid );

				$action_type = WPJ_Form::post( 'action_type', $action_type );
				$status      = WPJ_Form::post( 'status', $status );

				$active_jobs_enabled = wpj_get_user_feature_status( 'wpjobster_enable_active_jobs', 'wpjobster_subscription_active_jobs_enabled' );
				$active_jobs_max     = wpj_get_user_feature_value( 'active_jobs', 'active_jobs' );
				$active_jobs_cnt     = intval( wpj_get_user_jobs_count( get_current_user_id(), 'active' ) );

				if ( $action_type == 'new-job' || ( $action_type == 'edit-job' && $uid == $post->post_author ) ) {

					if (
						isset( $_POST['post_new_or_edit_job_field'] )
						&& (
							wp_verify_nonce( $_POST['post_new_or_edit_job_field'], 'post_new_or_edit_job_action' )
							|| $forced
						)
					) {

						if ( $action_type == 'new-job' || ( $action_type == 'edit-job' && $status == 'publish' ) ) {

							if (
								(
									$active_jobs_enabled == 'yes'
									&& $active_jobs_cnt < $active_jobs_max
									&& $action_type == 'new-job'
								)
								|| $active_jobs_enabled == 'no'
								|| $action_type == 'edit-job'
							) {

								$custom_field = new WPJ_Custom_Fields( $pid, 'job' );

								// Activate the job
								update_post_meta( $pid, 'active', '1' );
								update_post_meta( $pid, 'closed', '0' );

								if ( $action_type == 'new-job' ) {
									update_post_meta( $pid, 'job_rating', '0' );
									update_post_meta( $pid, 'job_reviews', '0' );
								}

								// Custom fields
								$custom_field->saveFieldsContent();

								// Save each field
								foreach ( $_POST AS $key => $val ) {
									if ( is_string( $val ) ) {
										update_post_meta( $pid, $key, trim( htmlspecialchars( wpj_validate_input_content( $val ) ) ) );

									} elseif ( is_array( $val ) ) {
										update_post_meta( $pid, $key, array_values( array_filter( $val ) ) );

									} else {
										update_post_meta( $pid, $key, $val );

									}
								}

								// Title
								$job_title = trim( htmlspecialchars( $_POST['job_title'] ) );

								update_post_meta( $pid, 'title_variable', $job_title );
								update_post_meta( $pid, 'job_title', $job_title );

								// Price
								$job_cost = htmlspecialchars( WPJ_Form::post( 'job_cost', '' ) );

								if ( wpj_get_option( 'wpjobster_price_type' ) == 'fixed_amount' ) {
									$job_cost = wpj_get_option( 'wpjobster_job_fixed_amount' );
								}

								if ( ! $job_cost ) $job_cost = 0;

								update_post_meta( $pid, 'price', $job_cost );
								update_post_meta( $pid, 'price_type', WPJ_Form::post( 'price_type', '' ) );

								// Category & Subcategory
								$job_category = isset( $_POST['job_cat'] ) ? htmlspecialchars( $_POST['job_cat'] ) : '';
								$term         = get_term( $job_category, 'job_cat' );
								$job_category = isset( $term->slug ) ? $term->slug : '';
								$arr_cats     = [];
								$arr_cats[]   = $job_category;

								if ( ! empty( $_POST['subcat'] ) ) {
									$term = get_term( $_POST['subcat'], 'job_cat' );
									$project_category2 = $term->slug;

									$arr_cats[] = $project_category2;
								}

								wp_set_object_terms( $pid, $arr_cats ,'job_cat' );

								// Description
								if ( wpj_get_option( 'wpjobster_job_description_type' ) == 'wysiwyg' ) { // WYSIWYG TEXTAREA
									$job_description = wpj_get_allowed_html_tags_for_wysiwyg( WPJ_Form::post( 'job_description' ) );

								} elseif ( wpj_get_option( 'wpjobster_job_description_type' ) == 'tinymce' ) { // TINYMCE TEXTAREA
									$job_description = wp_kses_post( WPJ_Form::post( 'job_description' ) );

								} else {
									$job_description = substr( nl2br( strip_tags( htmlspecialchars( WPJ_Form::post( 'job_description' ) ) ) ), 0 , 2500 );

								}

								// Packages
								$packages = wpj_get_option( 'wpjobster_packages_enabled' );
								if ( $packages == 'yes' && isset( $_POST['price_type'] ) && $_POST['price_type'] == 'package' ) {
									update_post_meta( $pid, 'job_packages', 'yes' );

									if ( isset( $_POST['package_name'] ) ) {
										update_post_meta( $pid, 'package_name', $_POST['package_name'] );
										update_post_meta( $pid, 'package_name_1', $_POST['package_name'][0] );
										update_post_meta( $pid, 'package_name_2', $_POST['package_name'][1] );
										update_post_meta( $pid, 'package_name_3', $_POST['package_name'][2] );
									}

									if ( isset( $_POST['package_description'] ) ) {
										update_post_meta( $pid, 'package_description', $_POST['package_description'] );
										update_post_meta( $pid, 'package_description_1', $_POST['package_description'][0] );
										update_post_meta( $pid, 'package_description_2', $_POST['package_description'][1] );
										update_post_meta( $pid, 'package_description_3', $_POST['package_description'][2] );
									}

									if ( isset( $_POST['package_max_days'] ) ) {
										update_post_meta( $pid, 'package_max_days', $_POST['package_max_days'] );
										update_post_meta( $pid, 'package_max_days_1', $_POST['package_max_days'][0] );
										update_post_meta( $pid, 'package_max_days_2', $_POST['package_max_days'][1] );
										update_post_meta( $pid, 'package_max_days_3', $_POST['package_max_days'][2] );
									}

									if ( isset( $_POST['package_revisions'] ) ) {
										update_post_meta( $pid, 'package_revisions', $_POST['package_revisions'] );
										update_post_meta( $pid, 'package_revisions_1', $_POST['package_revisions'][0] );
										update_post_meta( $pid, 'package_revisions_2', $_POST['package_revisions'][1] );
										update_post_meta( $pid, 'package_revisions_3', $_POST['package_revisions'][2] );
									}

									if ( isset( $_POST['package_price'] ) ) {
										update_post_meta( $pid, 'package_price', $_POST['package_price'] );
										update_post_meta( $pid, 'package_price_1', $_POST['package_price'][0] );
										update_post_meta( $pid, 'package_price_2', $_POST['package_price'][1] );
										update_post_meta( $pid, 'package_price_3', $_POST['package_price'][2] );
									}

									$pck_custom_fields = [];

									if ( $_POST['pck-inp-custom-name'] ) {
										foreach ( $_POST['pck-inp-custom-name'] as $key => $value ) {
											if ( $value ) {
												$pck_custom_fields[] = [
													'name'     => $value,
													'basic'    => $_POST['pck-chk-value']['basic'][$key],
													'standard' => $_POST['pck-chk-value']['standard'][$key],
													'premium'  => $_POST['pck-chk-value']['premium'][$key],
												];
											}
										}

										update_post_meta( $pid, 'package_custom_fields', $pck_custom_fields );
									}

								} else {
									update_post_meta( $pid, 'job_packages', 'no' );

								}

								// Tags
								$job_tags = isset( $_POST['job_tags'] ) ? trim( htmlspecialchars( $_POST['job_tags'] ) ) : '';

								wp_set_post_tags( $pid, $job_tags);

								// Instructions to buyer to job page
								if ( isset( $_POST['buyer_instructions'] ) )
									update_post_meta( $pid, 'buyer_instructions', $_POST['buyer_instructions'] );

								else
									update_post_meta( $pid, 'buyer_instructions', 'no' );

								// Instructions to buyer
								$instruction_box = isset( $_POST['instruction_box'] ) ? substr( nl2br( strip_tags( htmlspecialchars( $_POST['instruction_box'] ) ) ), 0 , 2500 ) : '';

								update_post_meta( $pid, 'instruction_box', $instruction_box );

								// FAQ
								$faq = [];

								if ( isset( $_POST['faq_question'] ) ) {
									foreach ( $_POST['faq_question'] as $key => $question ) {
										if ( $question && $_POST['faq_answer'][$key] ) {
											$faq[] = [
												'question' => $question,
												'answer'   => $_POST['faq_answer'][$key]
											];
										}
									}
								}

								update_post_meta( $pid, 'faq', $faq );

								// Max Days
								$max_days = isset( $_POST['max_days'] ) ? trim( htmlspecialchars( $_POST['max_days'] ) ) : '';

								if ( $max_days == 'instant' ) {
									if ( isset( $_POST['price_type'] ) && ! in_array( $_POST['price_type'], wpj_get_job_no_days_price_types() ) ) {
										$max_days = 0;

										update_post_meta( $pid, 'instant', 1 );
									}
								}

								update_post_meta( $pid, 'max_days', (int) $max_days );

								// Instant Delivery
								if ( isset( $_POST['hidden_files_instant_job_attachments'] ) && $_POST['hidden_files_instant_job_attachments'] != '' ) {
									if ( $action_type == 'edit-job' ) {
										wpj_save_attachments( $_POST['hidden_files_instant_job_attachments'], $pid, 'job_any_attachments', 'edit' );

									} else {
										wpj_save_attachments( $_POST['hidden_files_instant_job_attachments'], $pid, 'job_any_attachments', 'new' );

									}

									update_post_meta( $pid, 'instant', 1 );

								} elseif ( $max_days != 'instant' ) {
									update_post_meta( $pid, 'instant', 0 );

								} elseif ( $max_days == 'instant' && isset( $_POST['price_type'] ) && in_array( $_POST['price_type'], wpj_get_job_no_days_price_types() ) ) {
									update_post_meta( $pid, 'instant', 0 );

								}

								// Shipping
								$enable_shipping = wpj_get_option( 'wpjobster_enable_shipping' );

								if ( $enable_shipping == 'yes' ) {
									$shipping = isset( $_POST['shipping'] ) ? trim( $_POST['shipping'] ) : '';

									if ( empty( $shipping ) || is_numeric( $shipping ) ) {
										update_post_meta( $pid, 'shipping', $shipping );

									} elseif ( $shipping != '' ) {
										update_post_meta( $pid, 'shipping', '' );

									}

								} else {
									update_post_meta( $pid, 'shipping', '' );

								}

								// Let's meet
								$lets_meet = trim( strip_tags( htmlspecialchars( isset( $_POST['lets_meet'] ) ? $_POST['lets_meet'] : '' ) ) );

								update_post_meta( $pid, 'lets_meet', $lets_meet );

								// Location
								$location = wpj_get_option( 'wpjobster_location' );

								if ( $location == 'yes' ) {
									$location_input = isset( $_POST['location_input'] ) ? htmlspecialchars( $_POST['location_input'] ) : '';
									$lat            = isset( $_POST['lat'] ) ? htmlspecialchars( $_POST['lat'] ) : '';
									$long           = isset( $_POST['long'] ) ? htmlspecialchars( $_POST['long'] ) : '';

									update_post_meta( $pid, 'location_input', trim( $location_input ) );
									update_post_meta( $pid, 'lat', trim( $lat ) );
									update_post_meta( $pid, 'long', trim( $long ) );
								}

								// Distance
								$distance = wpj_get_option( 'wpjobster_location_distance' );

								if ( $distance == 'yes' && isset( $_POST['distance_input'] ) ) {
									$distance_input = trim( htmlspecialchars( $_POST['distance_input'] ) );

									if ( is_numeric( $distance_input ) ) {
										update_post_meta( $pid, 'distance_input', $distance_input );
									}

								} else {
									update_post_meta( $pid, 'distance_input', '' );

								}

								// Display Map
								$location_display_map_user_choice = wpj_get_option( 'wpjobster_location_display_map_user_choice' );

								if ( $location_display_map_user_choice == 'yes' ) {
									$display_map = trim( strip_tags( htmlspecialchars( isset( $_POST['display_map'] ) ? $_POST['display_map'] : '' ) ) );

									update_post_meta( $pid, 'display_map', $display_map );
								}

								// Images
								$attachments = wpj_get_job_images( $pid );

								if ( $attachments ) {
									set_post_thumbnail( $pid, $attachments[0]->ID );
								}

								// Job Preview
								if ( isset( $_POST['hidden_files_preview_job_attachments'] ) && $_POST['hidden_files_preview_job_attachments'] != '' ) {
									if ( $action_type == 'edit-job' ) {
										wpj_save_attachments( $_POST['hidden_files_preview_job_attachments'], $pid, 'preview_job_attachments', 'edit' );

									} else {
										wpj_save_attachments( $_POST['hidden_files_preview_job_attachments'], $pid, 'preview_job_attachments', 'new' );

									}
								}

								// Video thumbnail as first image of the job
								if ( isset( $_POST['video_as_job_thumbnail'] ) )
									update_post_meta( $pid, 'video_as_job_thumbnail', $_POST['video_as_job_thumbnail'] );

								else
									update_post_meta( $pid, 'video_as_job_thumbnail', 'no' );

								// Video
								$y_link = isset( $_POST['video_link'] ) ? $_POST['video_link'] : '';
								$y_link = is_array( $y_link ) ? array_filter( $y_link ) : '';

								update_post_meta( $pid, 'video_link', $y_link );

								// Extra Fast Delivery
								if ( isset( $_POST['enable_extra_fast'] ) ) {
									$extra_fast_price = isset( $_POST['extra_fast_price'] ) ? trim( $_POST['extra_fast_price'] ) : '';
									$max_days_fast    = isset( $_POST['max_days_fast'] ) ? trim( $_POST['max_days_fast'] ) : '';

									update_post_meta( $pid, 'extra_fast_enabled', true );
									update_post_meta( $pid, 'extra_fast_price', $extra_fast_price );
									update_post_meta( $pid, 'extra_fast_days', $max_days_fast );

								} else {
									update_post_meta( $pid, 'extra_fast_enabled', false );

								}

								// Additional Revision
								if ( isset( $_POST['enable_extra_revision'] ) ) {
									$extra_revision_price = isset( $_POST['extra_revision_price'] ) ? trim( $_POST['extra_revision_price'] ) : '';
									$max_days_revision    = isset( $_POST['max_days_revision'] ) ? trim( $_POST['max_days_revision'] ) : '';

									update_post_meta( $pid, 'extra_revision_enabled', true );
									update_post_meta( $pid, 'extra_revision_price', $extra_revision_price );
									update_post_meta( $pid, 'extra_revision_days', $max_days_revision );

									if ( isset( $_POST['enable_multiples_revision'] ) ) {
										update_post_meta( $pid, 'extra_revision_multiples_enabled', true );

									} else {
										update_post_meta( $pid, 'extra_revision_multiples_enabled', false );

									}

								} else {
									update_post_meta( $pid, 'extra_revision_enabled', false );

								}

								// Extra
								for ( $i = 1; $i <= 10; $i++ ) {
									if ( isset( $_POST['enable_extra_' . $i] ) ) {
										$extra_content = isset( $_POST['extra' . $i . '_content'] ) ? substr( nl2br( strip_tags( htmlspecialchars( $_POST['extra' . $i . '_content'] ) ) ), 0 , 2500 ) : '';

										$extra_price = isset( $_POST['extra' . $i . '_price'] ) ? trim( $_POST['extra' . $i . '_price'] ) : '';
										$extra_days  = isset( $_POST['max_days_' . $i] ) ? trim( $_POST['max_days_' . $i] ) : '';

										update_post_meta( $pid, 'extra' . $i . '_extra_enabled', true );
										update_post_meta( $pid, 'extra' . $i . '_content', $extra_content );
										update_post_meta( $pid, 'extra' . $i . '_price', $extra_price );

										if ( ! empty( $extra_days ) && is_numeric( $extra_days ) && $extra_days > 0 ) {
											update_post_meta( $pid, 'max_days_ex_' . $i, $extra_days );

										} else {
											update_post_meta( $pid, 'max_days_ex_' . $i, 'instant' );

										}

										if ( isset( $_POST['enable_multiples_' . $i] ) ) {
											update_post_meta( $pid, 'extra' . $i . '_enabled', true );

										} else {
											update_post_meta( $pid, 'extra' . $i . '_enabled', false );

										}

									} else {
										update_post_meta( $pid, 'extra' . $i . '_extra_enabled', false );

									}
								}

								// Extra fields
								do_action( 'wpj_before_create_or_update_job_post', $uid, $pid );

								// Create the post
								$job_post                 = [];
								$job_post['ID']           = $pid;
								$job_post['post_title']   = $job_title;
								$job_post['post_content'] = $job_description;

								wp_update_post( $job_post );

								if ( $status == 'publish' && $this->validatePostData() ) {
									$redirect = wpj_get_option( 'wpjobster_post_new_job_redirection_page' );
									$url      = $redirect > 1 ? get_permalink( $redirect ) : get_permalink( wpj_get_option( 'wpjobster_my_account_page_id' ) );

									update_post_meta( $pid, 'is_draft','0' );

									wp_publish_post( $pid );

									$enable_admin_approve_job = wpj_get_option( 'wpjobster_admin_approve_job' );

									if ( $enable_admin_approve_job == 'yes' ) {
										$job_post['post_status'] = 'draft';

										wp_update_post( $job_post );

										update_post_meta( $pid, 'under_review', '1' );

										wpj_notify_user_translated( 'job_new', get_post_field( 'post_author', $pid ), ['##job_name##' => $job_title] );

										wpj_notify_user_translated( 'job_admin_new', 'admin', [
											'##username##' => wpj_get_user_display_type( get_post_field( 'post_author', $pid ) ),
											'##job_name##' => $job_title,
											'##job_link##' => admin_url( 'post.php?post=' . $pid . '&action=edit' )
										]);

										$url .= 'under-review';

									} else {

										$job_post['post_status'] = 'publish';

										wp_update_post( $job_post );

										update_post_meta( $pid, 'under_review', '0' );

										wpj_notify_user_translated( 'job_acc', get_post_field( 'post_author', $pid ), [
											'##job_name##' => $job_title,
											'##job_link##' => get_permalink( $pid )
										]);

										wpj_notify_user_translated( 'job_admin_acc', 'admin', [
											'##username##' => wpj_get_user_display_type( get_post_field( 'post_author', $pid ) ),
											'##job_name##' => $job_title,
											'##job_link##' => admin_url( 'post.php?post=' . $pid . '&action=edit' )
										]);

										do_action( 'wpj_after_job_published', $uid, $pid );

										if ( $active_jobs_enabled == 'yes' && $active_jobs_cnt > $active_jobs_max ) {
											update_post_meta( $pid, 'active', '0' );
											update_post_meta( $pid, 'deactivation_reason', 'active_jobs_exceeded' );

											$url .= '?active-jobs-exceeded=1';

										} else $url .= '?published-job=' . $pid;
									}

									if ( ! wpj_is_user_allowed_post_job( $uid, $job_cost ) ) {
										update_post_meta( $pid, 'active', '0' );
										update_post_meta( $pid, 'deactivation_reason', 'no_credits' );

										$url = wpj_get_payment_link() . 'topup?no_credits=1';

									}

									echo apply_filters( 'wpj_post_new_job_redirect_url_filter', $url, $pid );

								} else echo __( 'Complete all required fields.', 'wpjobster' );

							} else echo sprintf( __( 'You are not allowed to post a new job because you have reached the maximum number of jobs (%d) you are allowed to post.', 'wpjobster' ), wpj_get_user_feature_value( 'active_jobs', 'active_jobs' ) );

						} else echo __( 'No action type defined.', 'wpjobster' );

					} else echo __( 'Sorry, your nonce did not verify.', 'wpjobster' );

				} else echo __( 'You are not allowed to edit this job because you are not the author.', 'wpjobster' );

			} else echo __( 'Something went wrong. Please try again', 'wpjobster' );

			if ( wpj_is_ajax_call() ) wp_die();
		}

		public function getContentFromBuffer( $method_name = '', $params = [] ) {
			ob_start();

			$field_content_class = new WPJJobsNewEditFieldsContent();

			if ( $params )
				call_user_func_array( [ $field_content_class, $method_name ], $params );
			else
				call_user_func( [ $field_content_class, $method_name ] );

			return ob_get_clean();
		}

		public function getPostCategories( $pid = '' ) {
			$pid = wpj_get_post_id( $pid );

			$categories = wp_get_object_terms( $pid, 'job_cat', ['orderby' => 'term_order', 'order' => 'ASC'] );

			if ( isset( $categories[0] ) && $categories[0]->parent != 0 ) {
				$categories = array_reverse( $categories );
			}

			$job_category    = isset( $categories[0]->term_id ) ? $categories[0]->term_id : '';
			$job_subcategory = isset( $categories[1]->term_id ) ? $categories[1]->term_id : '';

			if ( ! empty( $_GET['category'] ) ) {
				$url_category = $_GET['category'];

				$term = get_term_by( 'term_id', $url_category, 'job_cat' );

				if ( $term && $term->parent != '0' ) {
					$job_category    = $term->parent;
					$job_subcategory = $term->term_id;
				
				} elseif ( $term ) {
					$job_category = $term->term_id;

				}
			}

			return [
				'category'    => WPJ_Form::post( 'job_cat', $job_category ),
				'subcategory' => WPJ_Form::post( 'subcat', $job_subcategory )
			];
		}

		public function getJobValidationStrings( $key = '' ) {

			/* Job title */
			$characters_jobtitle_min = wpj_get_option( 'wpj_job_title_character_limits' )[1];
			$characters_jobtitle_min = ( empty( $characters_jobtitle_min ) || $characters_jobtitle_min == 0 ) ? 15 : $characters_jobtitle_min;
			$characters_jobtitle_max = wpj_get_option( 'wpj_job_title_character_limits' )[2];
			$characters_jobtitle_max = ( empty( $characters_jobtitle_max ) || $characters_jobtitle_max == 0 ) ? 80 : $characters_jobtitle_max;

			/* Job description */
			$characters_jobdescription_min = wpj_get_option( 'wpj_job_description_character_limits' )[1];
			$characters_jobdescription_min = ( empty( $characters_jobdescription_min ) || $characters_jobdescription_min == 0 ) ? 0 : $characters_jobdescription_min;
			$characters_jobdescription_max = wpj_get_option( 'wpj_job_description_character_limits' )[2];
			$characters_jobdescription_max = ( empty( $characters_jobdescription_max ) || $characters_jobdescription_max == 0 ) ? 1000 : $characters_jobdescription_max;

			/* Instruction to buyer */
			$characters_jobinstr_min = wpj_get_option( 'wpj_job_instructions_character_limits' )[1];
			$characters_jobinstr_min = ( empty( $characters_jobinstr_min ) || $characters_jobinstr_min == 0 ) ? 0 : $characters_jobinstr_min;
			$characters_jobinstr_max = wpj_get_option( 'wpj_job_instructions_character_limits' )[2];
			$characters_jobinstr_max = ( empty( $characters_jobinstr_max ) || $characters_jobinstr_max == 0 ) ? 350 : $characters_jobinstr_max;

			/* Extra description */
			$characters_jobextra_description_min = wpj_get_option( 'wpj_job_extra_description_character_limits' )[1];
			$characters_jobextra_description_min = ( empty( $characters_jobextra_description_min ) || $characters_jobextra_description_min == 0 ) ? 0 : $characters_jobextra_description_min;
			$characters_jobextra_description_max = wpj_get_option( 'wpj_job_extra_description_character_limits' )[2];
			$characters_jobextra_description_max = ( empty( $characters_jobextra_description_max ) || $characters_jobextra_description_max == 0 ) ? 50 : $characters_jobextra_description_max;

			/* Package title */
			$characters_job_package_title_min = wpj_get_option( 'wpj_job_package_title_character_limits' )[1];
			$characters_job_package_title_min = ( empty( $characters_job_package_title_min ) || $characters_job_package_title_min == 0 ) ? 0 : $characters_job_package_title_min;
			$characters_job_package_title_max = wpj_get_option( 'wpj_job_package_title_character_limits' )[2];
			$characters_job_package_title_max = ( empty( $characters_job_package_title_max ) || $characters_job_package_title_max == 0 ) ? 120 : $characters_job_package_title_max;

			/* Package description */
			$characters_job_package_description_min = wpj_get_option( 'wpj_job_package_description_character_limits' )[1];
			$characters_job_package_description_min = ( empty( $characters_job_package_description_min ) || $characters_job_package_description_min == 0 ) ? 0 : $characters_job_package_description_min;
			$characters_job_package_description_max = wpj_get_option( 'wpj_job_package_description_character_limits' )[2];
			$characters_job_package_description_max = ( empty( $characters_job_package_description_max ) || $characters_job_package_description_max == 0 ) ? 1000 : $characters_job_package_description_max;

			/* Package price */
			$amount_job_package_price_min = wpj_get_option( 'wpj_package_amount_price_limits' )[1];

			if ( ! is_numeric( $amount_job_package_price_min ) || ! $amount_job_package_price_min || $amount_job_package_price_min == '0' || $amount_job_package_price_min < 0 ) {
				$amount_job_package_price_min = 0;
			}

			$amount_job_package_price_max = wpj_get_option( 'wpj_package_amount_price_limits' )[2];

			/* Price */
			if ( wpj_get_user_feature_status( 'wpjobster_enable_min_job_amount', 'wpjobster_subscription_min_job_price_enabled' ) != 'no' ) {
				$amount_jobprice_min = wpj_get_user_feature_value( 'min_amount', 'min_job_price' );

			} else {
				$amount_jobprice_min = 0;

			}

			if ( wpj_get_user_feature_status( 'wpjobster_enable_max_job_amount', 'wpjobster_subscription_max_job_price_enabled' ) != 'no' ) {
				$amount_jobprice_max = wpj_get_user_feature_value( 'max_amount', 'max_job_price' );

			} else {
				$amount_jobprice_max = '';

			}

			/* Extra price */
			if ( wpj_get_user_feature_status( 'wpjobster_enable_min_extra_amount', 'wpjobster_subscription_min_extra_price_enabled' ) != 'no' ) {
				$amount_jobextra_price_min = wpj_get_user_feature_value( 'min_extra_amount', 'min_extra_price' );

			} else {
				$amount_jobextra_price_min = 0;

			}

			if ( wpj_get_user_feature_status( 'wpjobster_enable_max_extra_amount', 'wpjobster_subscription_max_extra_price_enabled' ) != 'no' ) {
				$amount_jobextra_price_max = wpj_get_user_feature_value( 'max_extra_amount', 'max_extra_price' );

			} else {
				$amount_jobextra_price_max = '';

			}

			$strings = [
				'job_title_blank'        => __( 'You cannot leave the job title blank.', 'wpjobster' ),
				'job_title_min'          => sprintf( __( 'The job title field needs to have at least %d characters.', 'wpjobster' ), $characters_jobtitle_min ),
				'job_title_max'          => sprintf( __( 'The job title field needs to have at most %d characters.', 'wpjobster' ), $characters_jobtitle_max ),

				'job_price_blank'        => __( 'You cannot leave the job price blank.', 'wpjobster' ),
				'job_price_numeric'      => __( 'The job price must be numeric. No strings allowed.', 'wpjobster' ),
				'job_price_min'          => sprintf( __( 'The job price must be higher than or equal to %d.', 'wpjobster' ), $amount_jobprice_min ),
				'job_price_max'          => sprintf( __( 'The job price must be lower than or equal to %d.', 'wpjobster' ), $amount_jobprice_max ),

				'job_category_blank'     => __( 'You cannot leave the job category blank.', 'wpjobster' ),

				'job_subcategory_blank'  => __( 'You cannot leave the job subcategory blank.', 'wpjobster' ),

				'job_description_blank'  => __( 'You cannot leave the job description blank.', 'wpjobster' ),
				'job_description_min'    => sprintf( __( 'The job description field needs to have at least %d characters.', 'wpjobster' ), $characters_jobdescription_min ),
				'job_description_max'    => sprintf( __( 'The job description field needs to have at most %d characters.', 'wpjobster' ), $characters_jobdescription_max ),

				'job_instructions_blank' => __( 'You cannot leave the buyer instructions blank.', 'wpjobster' ),
				'job_instructions_min'   => sprintf( __( 'The buyer instructions field needs to have at least %d characters.', 'wpjobster' ), $characters_jobinstr_min ),
				'job_instructions_max'   => sprintf( __( 'The buyer instructions field needs to have at most %d characters.', 'wpjobster' ), $characters_jobinstr_max ),

				'job_faq_blank'          => __( 'You cannot leave the job faq blank.', 'wpjobster' ),

				'job_max_days_blank'     => __( 'You cannot leave the job max days to deliver blank.', 'wpjobster' ),
				'job_instant_file_blank' => __( 'You need to upload at least one instant delivery file for your job', 'wpjobster' ),

				'job_shipping_numeric'   => __( 'The shipping price must be numeric. No strings allowed.', 'wpjobster' ),

				'job_image_blank'        => __( 'You need to upload at least one image for your job', 'wpjobster' ),
				'job_image_error'        => __( 'You need to check upload image error for your job', 'wpjobster' ),

				'job_audio_blank'        => __( 'You need to upload at least one audio for your job', 'wpjobster' ),

				'job_video_invalid'      => __( 'The video link is invalid', 'wpjobster' ),

				'job_efd_price_blank'    => __( 'You cannot leave the job extra fast delivery price blank.', 'wpjobster' ),
				'job_efd_price_numeric'  => __( 'The job extra fast delivery price must be numeric. No strings allowed.', 'wpjobster' ),
				'job_efd_price_min'      => sprintf( __( 'The job extra fast delivery price must be higher than or equal to %d.', 'wpjobster' ), $amount_jobextra_price_min ),
				'job_efd_price_max'      => sprintf( __( 'The job extra fast delivery price must be lower than or equal to %d.', 'wpjobster' ), $amount_jobextra_price_max ),
				'job_efd_max_days_blank' => __( 'You cannot leave the job extra fast delivery max days blank.', 'wpjobster' ),
				'job_efd_max_days_max'   => __( 'The job extra fast delivery max days must be lower than max days.', 'wpjobster' ),

				'job_ar_price_blank'     => __( 'You cannot leave the job additional revision price blank.', 'wpjobster' ),
				'job_ar_price_numeric'   => __( 'The job additional revision price must be numeric. No strings allowed.', 'wpjobster' ),
				'job_ar_price_min'       => sprintf( __( 'The job additional revision price must be higher than or equal to %d.', 'wpjobster' ), $amount_jobextra_price_min ),
				'job_ar_price_max'       => sprintf( __( 'The job additional revision price must be lower than or equal to %d.', 'wpjobster' ), $amount_jobextra_price_max ),
				'job_ar_max_days_blank'  => __( 'You cannot leave the job additional revision delivery max days blank.', 'wpjobster' ),

				'job_tos_uncheck'        => __( 'You must agree to the terms and conditions', 'wpjobster' )
			];

			for ( $i = 1; $i <= 3; $i++ ) {
				$strings['job_pck_name_blank' . $i]        = sprintf( __( 'You cannot leave the package %d name blank.', 'wpjobster' ), $i );
				$strings['job_pck_name_min' . $i]          = sprintf( __( 'The package %d field needs to have at least %d characters.', 'wpjobster' ), $i, $characters_job_package_title_min );
				$strings['job_pck_name_max' . $i]          = sprintf( __( 'The package %d field needs to have at most %d characters.', 'wpjobster' ), $i, $characters_job_package_title_max );

				$strings['job_pck_description_blank' . $i] = sprintf( __( 'You cannot leave the package %d description blank.', 'wpjobster' ), $i );
				$strings['job_pck_description_min' . $i]   = sprintf( __( 'The package %d field needs to have at least %d characters.', 'wpjobster' ), $i, $characters_job_package_description_min );
				$strings['job_pck_description_max' . $i]   = sprintf( __( 'The package %d field needs to have at most %d characters.', 'wpjobster' ), $i, $characters_job_package_description_max );

				$strings['job_pck_price_blank' . $i]       = sprintf( __( 'You cannot leave the package %d price blank.', 'wpjobster' ), $i );
				$strings['job_pck_price_numeric' . $i]     = sprintf( __( 'The package %d price must be numeric. No strings allowed.', 'wpjobster' ), $i );
				$strings['job_pck_price_min' . $i]         = sprintf( __( 'The package %d price must be higher than or equal to %d.', 'wpjobster' ), $i, $amount_job_package_price_min );
				$strings['job_pck_price_max' . $i]         = sprintf( __( 'The package %d price must be lower than or equal to %d.', 'wpjobster' ), $i, $amount_job_package_price_max );
			}

			for ( $j = 1; $j <= 10; $j++ ) {
				$strings['job_extra_desc_blank' . $j]     = sprintf( __( 'You cannot leave the job extra %d description blank.', 'wpjobster' ), $j );
				$strings['job_extra_desc_min' . $j]       = sprintf( __( 'The job extra %d description field needs to have at least %d characters.', 'wpjobster' ), $j, $characters_jobextra_description_min );
				$strings['job_extra_desc_max' . $j]       = sprintf( __( 'The job extra %d description field needs to have at most %d characters.', 'wpjobster' ), $j, $characters_jobextra_description_max );

				$strings['job_extra_max_days_blank' . $j] = sprintf( __( 'You cannot leave the job extra %d delivery max days blank.', 'wpjobster' ), $j );

				$strings['job_extra_price_blank' . $j]    = sprintf( __( 'You cannot leave the job extra %d price blank.', 'wpjobster' ), $j );
				$strings['job_extra_price_numeric' . $j]  = sprintf( __( 'The job extra %d price must be numeric. No strings allowed.', 'wpjobster' ), $j );
				$strings['job_extra_price_min' . $j]      = sprintf( __( 'The job extra %d price must be higher than or equal to %d.', 'wpjobster' ), $j, $amount_jobextra_price_min );
				$strings['job_extra_price_max' . $j]      = sprintf( __( 'The job extra %d price must be lower than or equal to %d.', 'wpjobster' ), $j, $amount_jobextra_price_max );
			}

			$strings = apply_filters( 'wpj_job_validation_strings_list_filter', $strings );

			if ( $key )
				return $strings[$key];

			else
				return $strings;

		}

		public function getExtrasInfo( $pid = '' ) {

			$pid = wpj_get_post_id( $pid );

			$post_job_extra = $post_job_extra_description = $post_job_extra_price = $post_job_extra_max_days = $post_job_extra_multiple = '';

			$extra_enable = $extra_description = $extra_price = $extra_max_days = $extra_multiple = $rej_comment = [];

			for ( $i = 1; $i <= wpj_get_user_feature_value( 'extras', 'noof_extras', 10 ); $i++ ) {

				// enable
				$post_job_extra = WPJ_Form::post( 'enable_extra_' . $i, get_post_meta( $pid, 'extra' . $i . '_extra_enabled', true ) );
				$extra_enable[] = $post_job_extra == 'on' || ( $post_job_extra && ! isset( $_POST['aoe_form_submitted'] ) ) ? 'yes' : '';

				// description
				$post_job_extra_description = WPJ_Form::post( 'extra' . $i . '_content', get_post_meta( $pid, 'extra' . $i . '_content', true ) );
				$extra_description[] = $post_job_extra_description ? wpj_stripslashes( wpj_br_to_nl( $post_job_extra_description ) ) : '';

				// price
				$post_job_extra_price = WPJ_Form::post( 'extra' . $i . '_price', get_post_meta( $pid, 'extra' . $i . '_price', true ) );
				$extra_price[] = $post_job_extra_price ? $post_job_extra_price : '';

				// max days
				$post_job_extra_max_days = WPJ_Form::post( 'max_days_' . $i, get_post_meta( $pid, 'max_days_ex_' . $i, true ) );
				$extra_max_days[] = $post_job_extra_max_days ? $post_job_extra_max_days : '';

				// multiple
				$post_job_extra_multiple = WPJ_Form::post( 'enable_multiples_' . $i, get_post_meta( $pid, 'extra' . $i . '_enabled', true ) );
				$extra_multiple[] = $post_job_extra_multiple == 'on' || ( $post_job_extra_multiple && ! isset( $_POST['aoe_form_submitted'] ) ) ? 'yes' : '';

				// rejected
				${ 'rejected_extra' . $i } = get_post_meta( $pid, 'rejected_extra' . $i, true );
				${ 'rejected_' . $i . '_comment' } = get_post_meta( $pid, 'rejected_extra' . $i . '_comment', true );
				$rej_comment[] = ${ 'rejected_extra' . $i } == 1 ? ${ 'rejected_' . $i . '_comment' } : '';
			}

			return [
				'post_job_extra'             => $post_job_extra,
				'extra_enable'               => $extra_enable,
				'post_job_extra_description' => $post_job_extra_description,
				'extra_description'          => $extra_description,
				'post_job_extra_price'       => $post_job_extra_price,
				'extra_price'                => $extra_price,
				'post_job_extra_max_days'    => $post_job_extra_max_days,
				'extra_max_days'             => $extra_max_days,
				'post_job_extra_multiple'    => $post_job_extra_multiple,
				'extra_multiple'             => $extra_multiple,
				'rej_comment'                => $rej_comment
			];
		}

	}

}

add_action( 'admin_init', [ 'WPJJobsNewEdit', 'init' ] );