<?php if ( ! class_exists( 'WPJRequestsNewEditFieldsContent' ) ) {

	class WPJRequestsNewEditFieldsContent extends stdClass
	{

		/**
		 * @var WPJRequestsNewEdit
		 */
		private WPJRequestsNewEdit $requestsNewEditClass;

		/**
		 * @var array
		 */
		private array $params;

		/**
		 * @var mixed
		 */
		private $pid;

		public function __construct() {
			$this->params = func_get_args();

			if ( isset( $this->params['pid'] ) )
				$this->pid = $this->params['pid'];

			else
				$this->pid = WPJ_Form::get( 'requestid' );

			$this->requestsNewEditClass = new WPJRequestsNewEdit();
		}

		public function separator( $type = '' ) { ?>

			<div class="ui <?php echo $type; ?> divider"></div>

		<?php }

		public function title( $placeholder = '' ) {

			$post = get_post( $this->pid );

			$post_value = WPJ_Form::post( 'request_title', ( ( isset( $post->post_title ) && $post->post_title != 'Auto Draft' ) ? $post->post_title : '' ) ); ?>

			<div class="tooltip-handler js-tooltip-handler text-right" data-handler-id="request_title">

				<input
					placeholder="<?php echo $placeholder ? $placeholder : _x( 'The title of your request', 'Post new request', 'wpjobster' ); ?>"
					type="text"
					size="40"
					class="charlimit-request-title <?php echo wpj_get_request_rejected_input( 'title', $this->pid ); ?> mb5"
					name="request_title"
					value="<?php echo $post_value; ?>"
				/>
				<span class="charscounter"><?php _e( ' characters left', 'wpjobster' ); ?></span>

			</div>

		<?php }

		public function description( $placeholder = '' ) {

			$post = get_post( $this->pid );

			$post_value = WPJ_Form::post( 'request_description', ( ( isset( $post->post_content ) && $post->post_content != 'Auto Draft' ) ? $post->post_content : '' ) ); ?>

			<div class="tooltip-handler js-tooltip-handler text-right" data-handler-id="request_description">

				<textarea
					class="charlimit-request-description <?php echo wpj_get_request_rejected_input( 'description', $this->pid ); ?> mb5"
					name="request_description"
					id="request_description"
					placeholder="<?php echo $placeholder ? $placeholder : _x( 'The description of your request', 'Post new request', 'wpjobster' ); ?>"><?php echo $post_value; ?></textarea>

				<?php if ( apply_filters( 'wpj_request_characters_left_filter', true ) ) { ?>

					<span class="charscounter"><?php _e( ' characters left', 'wpjobster' ); ?></span>

				<?php } ?>

			</div>

		<?php }

		public function category( $placeholder = '' ) {

			$post_value = $this->requestsNewEditClass->getPostCategories(); ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_category">

				<?php wpj_display_categories_select(
					"job_cat",
					"slug",
					$placeholder ? $placeholder : _x( 'Select Category', 'Post new request', 'wpjobster' ),
					"",
					"request_category",
					"request_category",
					$post_value['category'],
					wpj_get_option( 'wpjobster_display_request_multiple_categories' ) == 'yes'
				); ?>

			</div>

		<?php }

		public function subcategory( $placeholder = '' ) {

			$post_value = $this->requestsNewEditClass->getPostCategories(); ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_subcategory">

				<span id="request_subcategories">

					<?php wpj_display_subcategories_select(
						'job_cat',
						'slug',
						$placeholder ? $placeholder : _x( 'Select Subcategory', 'Post new request', 'wpjobster' ),
						'',
						'subcat',
						'subcat',
						$post_value['category'],
						$post_value['subcategory'],
						wpj_get_option( 'wpjobster_display_request_multiple_categories' ) == 'yes'
					); ?>

				</span>

			</div>

		<?php }

		public function tags( $placeholder = '' ) {

			if ( isset( $_POST['request_tags'] ) ) $post_value = $_POST['request_tags'];
			else {
				$request_tags = wp_get_post_tags( $this->pid );
				$i = 0; $post_value = ''; $i_separator = '';
				if ( $request_tags ) {
					foreach ( $request_tags as $tag ) {
						$post_value .= $i_separator . $tag->name; $i++;
						if ( $i > 0 ) { $i_separator = ', '; }
					}
				}
			} ?>

			<div class="tooltip-handler js-tooltip-handler text-right" data-handler-id="request_tags">

				<div class="input-block">
					<input
						type="text"
						id="<?php echo wpj_get_request_rejected_input( 'tags' ) == 'rejected-input' ? 'rejected' : 'request_tags'; ?>"
						name="request_tags"
						class="<?php echo wpj_get_request_rejected_input( 'tags', $this->pid ); ?> js-tags"
						size="50"
						value="<?php echo $post_value; ?>"
						placeholder="<?php echo $placeholder ? $placeholder : _x( 'The tags of your request', 'Post new request', 'wpjobster' ); ?>"
					/>
					<span class="charscounter"><?php echo '(' . __( 'separate your tags by comma', 'wpjobster' ) . ')'; ?></span>
				</div>

			</div>

		<?php }

		public function autoclose( $placeholder = '' ) {
			$post_value = WPJ_Form::post( 'request_autoclose', get_post_meta( $this->pid, 'request_autoclose', true ) ) == 'yes' ? 'checked' : ''; ?>

			<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_autoclose">

				<div class="ui toggle checkbox mt0">
					<input
						type="checkbox"
						value="yes"
						name="request_autoclose"
						id="request_autoclose"
						<?php echo $post_value; ?>
					/>
					<label><?php echo $placeholder ? $placeholder : _x( 'Slide to enable', 'Post new request - Autoclose', 'wpjobster' ); ?></label>
				</div>

			</div>

		<?php }

		public function delivery( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_max_deliv' ) == "yes" ) {
				$post_value = WPJ_Form::post( 'request_delivery', get_post_meta( $this->pid, 'request_delivery', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_delivery">

					<select name="request_delivery" class="ui fluid selection dropdown clearable js-displayed-field" id="request_delivery">
						<option value="" disabled selected hidden><?php echo $placeholder ? $placeholder : _x( 'Expected delivery', 'Post new request', 'wpjobster' ); ?></option>";

						<?php for ( $i = 1; $i <= wpj_get_option( 'wpjobster_request_max_delivery_days' ); $i++ ) {
							$days_plural = sprintf( _n( '%d day', '%d days', $i, 'wpjobster' ), $i ); ?>

							<option <?php echo $post_value == $i ? "selected='selected'" : ''; ?> value="<?php echo $i; ?>"><?php echo $days_plural; ?></option>

						<?php } ?>

					</select>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function deadline( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_deadline' ) == "yes" ) {
				$post_value = WPJ_Form::post( 'request_deadline', get_post_meta( $this->pid, 'request_deadline', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_deadline">

					<div class="ui calendar js-calendar js-displayed-field">
						<div class="ui input left icon fluid">
							<i class="calendar alternate outline icon"></i>
							<input
								class="<?php echo wpj_get_request_rejected_input( 'deadline', $this->pid ); ?>"
								type="text"
								placeholder="<?php echo $placeholder ? $placeholder : _x( 'The deadline of your request', 'Post new request', 'wpjobster' ); ?>"
								id="request_deadline"
								value="<?php echo $post_value; ?>"
								name="request_deadline"
							/>
						</div>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function budget_from( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_budget' ) == "yes" ) {
				$post_value = WPJ_Form::post( 'request_budget_from', get_post_meta( $this->pid, 'request_budget_from', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_budget_from">

					<div class="ui labeled input fluid js-displayed-field <?php echo wpj_get_request_rejected_input( 'budget_from', $this->pid ); ?>">
						<div class="ui basic label vertical-align-middle"><?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?></div>
						<input
							type="number"
							min="0"
							step="0.01"
							placeholder="<?php echo $placeholder ? $placeholder : _x( 'The price at which your request starts', 'Post new request', 'wpjobster' ); ?>"
							id="request_budget_from"
							value="<?php echo $post_value; ?>"
							name="request_budget_from"
						/>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function budget_to( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_budget' ) == "yes" ) {
				$post_value = WPJ_Form::post( 'request_budget_to', get_post_meta( $this->pid, 'request_budget_to', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_budget_to">

					<div class="ui labeled input fluid js-displayed-field <?php echo wpj_get_request_rejected_input( 'budget_to', $this->pid ); ?>">
						<div class="ui basic label vertical-align-middle"><?php echo wpj_get_currency_symbol_by_name( wpj_get_site_default_currency() ); ?></div>
						<input
							type="number"
							min="0"
							step="0.01"
							placeholder="<?php echo $placeholder ? $placeholder : _x( 'The price at which your request ends', 'Post new request', 'wpjobster' ); ?>"
							id="request_budget_to"
							value="<?php echo $post_value; ?>"
							name="request_budget_to"
						/>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function lets_meet( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_lets_meet' ) == "yes" ) {
				$post_value = WPJ_Form::post( 'request_lets_meet', get_post_meta( $this->pid, 'request_lets_meet', true ) ) == 'yes' ? 'checked' : ''; ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_lets_meet">

					<div class="js-displayed-field">
						<div class="ui toggle checkbox mt0">
							<input
								type="checkbox"
								value="yes"
								name="request_lets_meet"
								id="request_lets_meet"
								class="location-trigger js-lets-meet-trigger"
								<?php echo $post_value; ?>
							/>
							<label><?php echo $placeholder ? $placeholder : _x( 'Slide to enable', 'Post new request - Let\'s meet', 'wpjobster' ); ?></label>
						</div>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function location( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_location' ) == 'yes' ) {
				$post_location = WPJ_Form::post( 'request_location', get_post_meta( $this->pid, 'request_location', true ) );
				$post_lat      = WPJ_Form::post( 'request_lat', get_post_meta( $this->pid, 'request_lat', true ) );
				$post_long     = WPJ_Form::post( 'request_long', get_post_meta( $this->pid, 'request_long', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_location">

					<div class="ui search js-location-autocomplete location-autocomplete js-lets-meet-item js-displayed-field">
						<div class="ui clearable input fluid">
							<input
								placeholder="<?php echo $placeholder ? $placeholder : _x( 'The location of your request', 'Post new request', 'wpjobster' ); ?>"
								type="text"
								data-replaceplaceholder="<?php _e( 'Select a valid location', 'wpjobster' ); ?>"
								id="request_location"
								value="<?php echo $post_location; ?>"
								name="request_location"
								class="prompt"
							/>
							<input
								id="request_lat"
								type="hidden"
								name="request_lat"
								value="<?php echo $post_lat; ?>"
							/>
							<input
								id="request_long"
								type="hidden"
								name="request_long"
								value="<?php echo $post_long; ?>"
							/>
						</div>
						<div class="results"></div>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function pick_up_location( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_pick_up_location' ) == 'yes' ) {
				$post_pick_up_location = WPJ_Form::post( 'request_pick_up_location', get_post_meta( $this->pid, 'request_pick_up_location', true ) );
				$post_pick_up_lat      = WPJ_Form::post( 'request_pick_up_lat', get_post_meta( $this->pid, 'request_pick_up_lat', true ) );
				$post_pick_up_long     = WPJ_Form::post( 'request_pick_up_long', get_post_meta( $this->pid, 'request_pick_up_long', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_pick_up_location">

					<div class="ui search js-location-autocomplete location-autocomplete js-lets-meet-item js-displayed-field">
						<div class="ui clearable input fluid">
							<input
								placeholder="<?php echo $placeholder ? $placeholder : _x( 'The pick up location of your request', 'Post new request', 'wpjobster' ); ?>"
								type="text"
								data-replaceplaceholder="<?php _e( 'Select a valid location', 'wpjobster' ); ?>"
								id="request_pick_up_location"
								value="<?php echo $post_pick_up_location; ?>"
								name="request_pick_up_location"
								class="prompt"
							/>
							<input
								id="request_pick_up_lat"
								type="hidden"
								name="request_pick_up_lat"
								value="<?php echo $post_pick_up_lat; ?>"
							/>
							<input
								id="request_pick_up_long"
								type="hidden"
								name="request_pick_up_long"
								value="<?php echo $post_pick_up_long; ?>"
							/>
						</div>
						<div class="results"></div>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function drop_off_location( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_drop_off_location' ) == 'yes' ) {
				$post_drop_off_location = WPJ_Form::post( 'request_drop_off_location', get_post_meta( $this->pid, 'request_drop_off_location', true ) );
				$post_drop_off_lat      = WPJ_Form::post( 'request_drop_off_lat', get_post_meta( $this->pid, 'request_drop_off_lat', true ) );
				$post_drop_off_long     = WPJ_Form::post( 'request_drop_off_long', get_post_meta( $this->pid, 'request_drop_off_long', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_drop_off_location">

					<div class="ui search js-location-autocomplete location-autocomplete js-lets-meet-item js-displayed-field">
						<div class="ui clearable input fluid">
							<input
								placeholder="<?php echo $placeholder ? $placeholder : _x( 'The drop off location of your request', 'Post new request', 'wpjobster' ); ?>"
								type="text"
								data-replaceplaceholder="<?php _e( 'Select a valid location', 'wpjobster' ); ?>"
								id="request_drop_off_location"
								value="<?php echo $post_drop_off_location; ?>"
								name="request_drop_off_location"
								class="prompt"
							/>
							<input
								id="request_drop_off_lat"
								type="hidden"
								name="request_drop_off_lat"
								value="<?php echo $post_drop_off_lat; ?>"
							/>
							<input
								id="request_drop_off_long"
								type="hidden"
								name="request_drop_off_long"
								value="<?php echo $post_drop_off_long; ?>"
							/>
						</div>
						<div class="results"></div>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function start_date( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_date' ) == "yes" ) {
				$post_value = WPJ_Form::post( 'request_start_date', get_post_meta( $this->pid, 'request_start_date', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_start_date">

					<div class="ui calendar js-calendar js-displayed-field">
						<div class="ui input left icon fluid">
							<i class="calendar alternate outline icon"></i>
							<input
								class="<?php echo wpj_get_request_rejected_input( 'start_date', $this->pid ); ?>"
								type="text"
								placeholder="<?php echo $placeholder ? $placeholder : _x( 'Start date of your request', 'Post new request', 'wpjobster' ); ?>"
								id="request_start_date"
								value="<?php echo $post_value; ?>"
								name="request_start_date"
							/>
						</div>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function end_date( $placeholder = '' ) {

			if ( wpj_get_option( 'wpjobster_request_date' ) == "yes" ) {
				$post_value = WPJ_Form::post( 'request_end_date', get_post_meta( $this->pid, 'request_end_date', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_end_date">

					<div class="ui calendar js-calendar js-displayed-field">
						<div class="ui input left icon fluid">
							<i class="calendar alternate outline icon"></i>
							<input
								class="<?php echo wpj_get_request_rejected_input( 'end_date', $this->pid ); ?>"
								type="text"
								placeholder="<?php echo $placeholder ? $placeholder : _x( 'End date of your request', 'Post new request', 'wpjobster' ); ?>"
								id="request_end_date"
								value="<?php echo $post_value; ?>"
								name="request_end_date"
							/>
						</div>
					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

		public function attachments() {

			if ( wpj_get_option( 'wpjobster_request_file_upload' ) == "yes" ) {
				$post_value = WPJ_Form::post( 'request_attachments', get_post_meta( $this->pid, 'request_attachments', true ) ); ?>

				<div class="tooltip-handler js-tooltip-handler" data-handler-id="request_attachments">

					<div class="js-displayed-field">

						<?php if ( wpj_get_request_rejected_input( 'attachments', $this->pid ) == 'rejected-input' ) { ?>

							<div class="rejected-border rejected-border-uploader">

						<?php }

								wpj_display_file_upload_form( $secure = 1, "file_upload_request_attachments", "request_attachments", "request" );

						if ( wpj_get_request_rejected_input( 'attachments', $this->pid ) == 'rejected-input' ) { ?>

							</div>

						<?php }

						if ( wpj_post_has_attachments( $post_value ) ) {

							wpj_display_attachments_list( $post_value, $this->pid, 'request_attachments' );

						} ?>

					</div>

				</div>

			<?php } else { ?>

				<div class="disabled-field js-disabled-field"></div>

			<?php }

		}

	}

}