<?php if ( ! class_exists( 'WPJUserProfileFieldsContent' ) ) {

	class WPJUserProfileFieldsContent extends stdClass {

		/**
		 * @var array|false|int|string|WP_User
		 */
		private $user;

		public function __construct() {
			$this->user = wpj_get_URL_user( 'userdata' );
		}

		public function display_field_content( $section = '', $label = '', $value = '', $class = '', $button = false, $no_ul = false, $tooltip = false ) {
			if ( $section ) {
				if ( $value ) {
					if ( $section == 'white_sidebar' ) { ?>

						<div data-uid="<?php echo wpj_get_user_id(); ?>" class="user-info-list content-wrapper user-<?php echo $class; ?>-wrapper"<?php echo $tooltip ? ' data-html="' . $tooltip . '" data-position="top right"' : ''; ?>>

							<?php if ( $no_ul != true ) { echo '<ul><li>'; } ?>

								<!-- Label -->
								<?php if ( $label ) { echo '<p>' . $label . ':</p>'; } ?>

								<!-- Value -->
								<?php echo $class == 'vacation_mode' ? $value : '<span>' . $value . '</span>';

							if ( $no_ul != true ) { echo '</li></ul>'; } ?>

						</div>

					<?php } elseif ( $section == 'transparent_sidebar' ) { ?>

						<div class="info-widget user-<?php echo $class; ?>-wrapper">

							<h3 class="widget-title"><?php if ( $label ) { echo $label; } ?></h3>

							<?php if ( wpj_get_user_id() == get_current_user_id() ) {

								if ( $button && $button == 'edit' ) { ?>

									<a data-type="<?php echo $class; ?>" class="edit-info user-edit-item">
										<i data-type="languages" class="user-edit-language pencil alternate icon"></i>
									</a>

								<?php } elseif ( $button && strpos( $button, 'new' ) !== false ) {
									$indx = explode( '-', $button ); ?>

									<a data-type="<?php echo $class; ?>" class="edit-info user-new-item" data-indx="<?php echo isset( $indx[1] ) ? $indx[1] : 0; ?>">
										<i class="plus icon"></i>
									</a>

								<?php }

							} ?>

							<div data-uid="<?php echo wpj_get_user_id(); ?>" class="content-wrapper <?php echo $class; ?>-content"<?php echo $tooltip ? ' data-html="' . $tooltip . '" data-position="top left"' : ''; ?>>

								<?php echo $value; ?>

							</div>

						</div>

					<?php } elseif ( $section == 'main_content' ) { ?>

						<div class="profile-main-content user-<?php echo $class; ?>-wrapper" id="all-<?php echo $class; ?>-section">

							<h3 class="widget-title">
								<b>
									<?php if ( $label ) { echo $label; } ?>
								</b>
							</h3>

							<?php if ( wpj_get_user_id() == get_current_user_id() ) {
								if ( $button && $button == 'edit' ) { ?>

									<a data-type="<?php echo $class; ?>" class="edit-info user-edit-item">
										<i data-type="languages" class="user-edit-language grey pencil alternate edit-info icon"></i>
									</a>

								<?php } elseif ( $button && strpos( $button, 'new' ) !== false ) {
									$indx = explode( '-', $button ); ?>

									<a data-type="<?php echo $class; ?>" class="edit-info user-new-item" data-indx="<?php echo isset( $indx[1] ) ? $indx[1] : 0; ?>">
										<i class="plus icon"></i>
									</a>

								<?php }
							} ?>

							<div data-uid="<?php echo wpj_get_user_id(); ?>" class="content-wrapper <?php echo $class; ?>-content"<?php echo $tooltip ? ' data-html="' . $tooltip . '" data-position="top left"' : ''; ?>>

								<?php echo $value; ?>

							</div>

							<div class="ui hidden divider"></div>

						</div>

					<?php } elseif ( $section == 'icons' ) {

						$field = wpj_get_acf_field_data( $section, $class, '', 'field' );

						$icon          = ! empty( $field['icon'] ) ? $field['icon'] : 'settings';
						$icon_colour   = ! empty( $field['icon_colour'] ) ? $field['icon_colour'] : '#333333';

						$label_colour  = ! empty( $field['label_colour'] ) ? $field['label_colour'] : '#000000';
						$value_colour  = ! empty( $field['value_colour'] ) ? $field['value_colour'] : '#ababab;';

						$display_label    = ! empty( $field['display_label'] ) ? $field['display_label'] : 'yes';
						$display_location = ! empty( $field['display_location'] ) ? $field['display_location'] : '';

						if (
							( $display_location == 'current_user' && wpj_get_user_id() == get_current_user_id() )
							|| ( $display_location == 'other_user' && wpj_get_user_id() != get_current_user_id() )
							|| $display_location == 'both_users'
							|| $display_location == ''
						) { ?>

							<div class="ui card icons-wrapper">

								<h3 class="ui center aligned icon header">

									<i style="color: <?php echo $icon_colour; ?>;" class="<?php echo $icon; ?> icon"></i>

									<div class="content">

										<?php if ( $display_label == 'yes' ) { echo '<span class="header" style="color: ' . $label_colour . ';">' . $label . '</span>'; } ?>

										<div data-uid="<?php echo wpj_get_user_id(); ?>" style="color: <?php echo $value_colour; ?>;" class="sub header content-wrapper"<?php echo $tooltip ? ' data-html="' . $tooltip . '" data-position="bottom center"' : ''; ?>><?php echo $value; ?></div>

									</div>

								</h3>

							</div>

						<?php }
					}
				}
			}
		}

		public function country( $section = 'white_sidebar', $f_name = 'country' ) {
			$country_code = get_user_meta( wpj_get_user_id(), 'country_code', true );
			$country_name = wpj_get_country_name_by_code( $country_code );

			if ( $country_name && is_string ( $country_name ) ) {
				$label = _x( 'From', 'User Profile Page', 'wpjobster' );
				$value = '<i class="' . strtolower( $country_code ) . ' flag"></i>' . $country_name;

				$this->display_field_content( $section, $label, $value, $f_name );
			}
		}

		public function distance( $section = 'white_sidebar', $f_name = 'distance' ) {
			if (
				wpj_get_option( 'wpjobster_html5_geolocation_enable' ) == 'yes'
				&& ( $distance = wpj_get_distance_to_job_location( 'user', wpj_get_user_id() ) )
			) {
				$label = _x( 'Distance', 'User Profile Page', 'wpjobster' );
				$value = $distance;

				$this->display_field_content( $section, $label, $value, $f_name );
			}
		}

		public function registered_date( $section = 'white_sidebar', $f_name = 'registered_date' ) {
			$reg         = $this->user->user_registered;
			$date_format = wpj_get_option( 'date_format' );

			$label = _x( 'Member Since', 'User Profile Page', 'wpjobster' );
			$value = strtotime( $reg ) > 0 ? wpj_date( $date_format, strtotime( $reg ) ) : __( 'There is no record of the date', 'wpjobster' );

			$this->display_field_content( $section, $label, $value, $f_name );
		}

		public function avg_response_time( $section = 'white_sidebar', $f_name = 'avg_response_time' ) {
			$label = _x( 'Avg. Response Time', 'User Profile Page', 'wpjobster' );
			$value = wpj_get_user_avg_response_time( wpj_get_user_id() );

			$this->display_field_content( $section, $label, $value, $f_name );
		}

		public function recent_delivery( $section = 'white_sidebar', $f_name = 'recent_delivery' ) {
			$recent_delivery_section = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $recent_delivery_section ) {
				$label = _x( 'Recent Delivery', 'User Profile Page', 'wpjobster' );
				$value = wpj_get_user_recent_delivery( wpj_get_user_id() );

				$this->display_field_content( $section, $label, $value, $f_name );
			}
		}

		public function last_seen( $section = 'white_sidebar', $f_name = 'last_seen' ) {
			if ( wpj_get_option( 'wpjobster_enable_last_seen' ) != 'no' ) {
				$label = _x( 'Last Seen', 'User Profile Page', 'wpjobster' );
				$value = wpj_get_last_visit( wpj_get_user_id() );

				$this->display_field_content( $section, $label, $value, $f_name );
			}
		}

		public function completed_jobs( $section = 'white_sidebar', $f_name = 'completed_jobs' ) {
			$is_seller = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			$label = _x( 'Completed Jobs', 'User Profile Page', 'wpjobster' );

			$as_seller = wpj_get_sales_orders( wpj_get_user_id(), 'completed' ) ? intval( wpj_get_sales_orders( wpj_get_user_id(), 'completed' ) ) : __( 'None', 'wpjobster' );
			$as_buyer  = wpj_get_shopping_orders( wpj_get_user_id(), 'completed' ) ? intval( wpj_get_shopping_orders( wpj_get_user_id(), 'completed' ) ) : __( 'None', 'wpjobster' );

			$value = intval( wpj_get_sales_orders( wpj_get_user_id(), 'completed' ) ) + intval( wpj_get_shopping_orders( wpj_get_user_id(), 'completed' ) );

			if ( ! $value ) { $value = __( 'None', 'wpjobster' ); }

			$tooltip = sprintf( __( 'As buyer: %s', 'wpjobster' ), $as_buyer );

			if ( $is_seller ) {
				$tooltip .= '<br>';
				$tooltip .= sprintf( __( 'As seller: %s', 'wpjobster' ), $as_seller );
			}

			$this->display_field_content( $section, $label, $value, $f_name, '', '', $tooltip );
		}

		public function cancelled_jobs( $section = 'white_sidebar', $f_name = 'cancelled_jobs' ) {
			$is_seller = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			$label = _x( 'Cancelled Jobs', 'User Profile Page', 'wpjobster' );

			$as_seller = wpj_get_sales_orders( wpj_get_user_id(), 'cancelled' ) ? intval( wpj_get_sales_orders( wpj_get_user_id(), 'cancelled' ) ) : __( 'None', 'wpjobster' );
			$as_buyer  = wpj_get_shopping_orders( wpj_get_user_id(), 'cancelled' ) ? intval( wpj_get_shopping_orders( wpj_get_user_id(), 'cancelled' ) ) : __( 'None', 'wpjobster' );

			$value = intval( wpj_get_sales_orders( wpj_get_user_id(), 'cancelled' ) ) + intval( wpj_get_shopping_orders( wpj_get_user_id(), 'cancelled' ) );

			if ( ! $value ) { $value = __( 'None', 'wpjobster' ); }

			$tooltip = sprintf( __( 'As buyer: %s', 'wpjobster' ), $as_buyer );

			if ( $is_seller ) {
				$tooltip .= '<br>';
				$tooltip .= sprintf( __( 'As seller: %s', 'wpjobster' ), $as_seller );
			}

			$this->display_field_content( $section, $label, $value, $f_name, '', '', $tooltip );
		}

		public function ongoing_jobs( $section = 'white_sidebar', $f_name = 'ongoing_jobs' ) {
			$is_seller = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			$label = _x( 'Ongoing Jobs', 'User Profile Page', 'wpjobster' );

			$as_seller = wpj_get_sales_orders( wpj_get_user_id(), 'active' ) ? intval( wpj_get_sales_orders( wpj_get_user_id(), 'active' ) ) : __( 'None', 'wpjobster' );
			$as_buyer  = wpj_get_shopping_orders( wpj_get_user_id(), 'active' ) ? intval( wpj_get_shopping_orders( wpj_get_user_id(), 'active' ) ) : __( 'None', 'wpjobster' );

			$value = intval( wpj_get_sales_orders( wpj_get_user_id(), 'active' ) ) + intval( wpj_get_shopping_orders( wpj_get_user_id(), 'active' ) );

			if ( ! $value ) { $value = __( 'None', 'wpjobster' ); }

			$tooltip = sprintf( __( 'As buyer: %s', 'wpjobster' ), $as_buyer );

			if ( $is_seller ) {
				$tooltip .= '<br>';
				$tooltip .= sprintf( __( 'As seller: %s', 'wpjobster' ), $as_seller );
			}

			$this->display_field_content( $section, $label, $value, $f_name, '', '', $tooltip );
		}

		public function posted_jobs( $section = 'white_sidebar', $f_name = 'posted_jobs' ) {
			$posted_jobs_section = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $posted_jobs_section ) {
				$label = _x( 'Posted Jobs', 'User Profile Page', 'wpjobster' );
				$value = wpj_get_user_jobs_count( wpj_get_user_id(), 'active' ) ? intval( wpj_get_user_jobs_count( wpj_get_user_id(), 'active' ) ) : __( 'None', 'wpjobster' );

				$this->display_field_content( $section, $label, $value, $f_name );
			}
		}

		public function completed_requests( $section = 'white_sidebar', $f_name = 'completed_requests' ) {
			$label = _x( 'Completed Requests', 'User Profile Page', 'wpjobster' );
			$value = wpj_get_shopping_orders( wpj_get_user_id(), 'completed_custom_offer' ) ? intval( wpj_get_shopping_orders( wpj_get_user_id(), 'completed_custom_offer' ) ) : __( 'None', 'wpjobster' );

			$this->display_field_content( $section, $label, $value, $f_name );
		}

		public function cancelled_requests( $section = 'white_sidebar', $f_name = 'cancelled_requests' ) {
			$label = _x( 'Cancelled Requests', 'User Profile Page', 'wpjobster' );
			$value = wpj_get_shopping_orders( wpj_get_user_id(), 'cancelled_custom_offer' ) ? intval( wpj_get_shopping_orders( wpj_get_user_id(), 'cancelled_custom_offer' ) ) : __( 'None', 'wpjobster' );

			$this->display_field_content( $section, $label, $value, $f_name );
		}

		public function ongoing_requests( $section = 'white_sidebar', $f_name = 'ongoing_requests' ) {
			$label = _x( 'Ongoing Requests', 'User Profile Page', 'wpjobster' );
			$value = wpj_get_shopping_orders( wpj_get_user_id(), 'active_custom_offer' ) ? intval( wpj_get_shopping_orders( wpj_get_user_id(), 'active_custom_offer' ) ) : __( 'None', 'wpjobster' );

			$this->display_field_content( $section, $label, $value, $f_name );
		}

		public function posted_requests( $section = 'white_sidebar', $f_name = 'posted_requests' ) {
			$label = _x( 'Posted Requests', 'User Profile Page', 'wpjobster' );
			$value = wpj_get_user_requests( wpj_get_user_id(), 'active', 'count' ) ? intval( wpj_get_user_requests( wpj_get_user_id(), 'active', 'count' ) ) : __( 'None', 'wpjobster' );

			$this->display_field_content( $section, $label, $value, $f_name );
		}

		public function vacation_mode( $section = 'white_sidebar', $f_name = 'vacation_mode' ) {
			$vacation_section = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );
			if ( $vacation_section ) {
				if ( wpj_get_user_id() == get_current_user_id() ) {
					$label = _x( 'Vacation Mode', 'User Profile Page', 'wpjobster' );

					ob_start();

					wpj_display_vacation_mode_button();

					$value = ob_get_contents(); ob_end_clean();

					$this->display_field_content( $section, $label, $value, $f_name );
				}
			}
		}

		public function edit_profile_link( $section = 'white_sidebar', $f_name = 'edit_profile_link' ) {
			if ( wpj_get_user_id() == get_current_user_id() ) {
				$personal_info_pg_lnk = get_permalink( wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ) );

				$value = '<div class="bottom-content"><a href="' . $personal_info_pg_lnk . '" title="" class="text">' . __( 'Edit Profile', 'wpjobster' ) . '</a></div>';
				$this->display_field_content( $section, '', $value, $f_name, '', true );
			}
		}

		public function contact_me( $section = 'white_sidebar', $f_name = 'contact_me' ) {
			$contact_section = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if (
				$contact_section
				|| wpj_users_have_conversations( get_current_user_id(), wpj_get_user_id() )
				|| wpj_users_have_transactions( get_current_user_id(), wpj_get_user_id() )
			) {
				if ( wpj_get_user_id() != get_current_user_id() ) {
					$value = '
						<div class="bottom-content">
							<a onclick="return wpj_chat_open_box( ' . wpj_get_user_id() . ', event )" class="ui fluid primary button ' . ( ! is_user_logged_in() ? 'login-link' : '' ) . '" href="' . wpj_get_pm_link( $this->user->user_nicename ) . '">' . __( 'Contact Me', 'wpjobster' ) . '</a>
						</div>
					';

					$this->display_field_content( $section, '', $value, $f_name, '', true );
				}
			}
		}

		public function request_custom_offer( $section = 'white_sidebar', $f_name = 'request_custom_offer' ) {
			$request_offer_btn = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $request_offer_btn && wpj_get_user_id() != get_current_user_id() ) {
				$value = '<div class="bottom-content">';

					ob_start();

					wpj_display_custom_offer_button( [
						'unique_id'       => 'user_request_' . wpj_get_user_id(),
						'id'              => wpj_get_user_id(),
						'title'           => __( 'Request Custom Offer', 'wpjobster' ),
						'offer_type'      => 'request',
						'current_user_id' => get_current_user_id(),
						'post_author_id'  => wpj_get_user_id(),
						'page'            => 'user_profile'
					] );

					$value .= ob_get_contents(); ob_end_clean();

				$value .= '</div>';

				$this->display_field_content( $section, '', $value, $f_name, '', true );
			}
		}

		public function description( $section = 'transparent_sidebar', $f_name = 'description' ) {
			$label = _x( 'Description', 'User Profile Page', 'wpjobster' );

			ob_start();

			$desc_content = wpj_apply_filter_to_string( get_user_meta( wpj_get_user_id(), 'description', true ), false, 'userprofiles' ); ?>

			<div class="description">
				<?php $desc_val = trim( strip_tags( $desc_content ) );

				if ( $desc_val ) {
					if ( wpj_get_option( 'wpjobster_wysiwyg_for_profile' ) != 'yes' ) {
						echo '<p>' . wpj_stripslashes( $desc_content ) . '</p>';

					} else {
						echo wpj_get_allowed_html_tags_for_wysiwyg( $desc_content );

					}

				} else echo '<p class="no_item">' . __( 'Click on "Edit Description" to add a Description.', 'wpjobster' ) . '</p>'; ?>

			</div>

			<?php $value = ob_get_contents();

			ob_end_clean();

			if ( $desc_content || wpj_get_user_id() == get_current_user_id() ) {
				$this->display_field_content( $section, $label, $value, $f_name, 'edit', true );
			}
		}

		public function languages( $section = 'transparent_sidebar', $f_name = 'languages' ) {
			$label = _x( 'Languages', 'User Profile Page', 'wpjobster' );

			ob_start();

			$languages = get_user_meta( wpj_get_user_id(), 'user_languages', true );

			if ( $languages ) {
				foreach ( $languages as $language => $proficiency ) { ?>

					<span class="<?php echo ucfirst( $language ); ?>">
						<input readonly type="text" class="inp_language not_editable di" value="<?php echo ucfirst( $language ); ?>" />

						<select class="ui dropdown inp_proficiency not_editable" name="inp_proficiency">
							<option <?php if ( $proficiency == 'elementary' ) echo 'selected="selected"'; ?> value="elementary"><?php _e( 'Elementary', 'wpjobster' ); ?></option>
							<option <?php if ( $proficiency == 'limited' ) echo 'selected="selected"'; ?> value="limited"><?php _e( 'Limited', 'wpjobster' ); ?></option>
							<option <?php if ( $proficiency == 'professional' ) echo 'selected="selected"'; ?> value="professional"><?php _e( 'Professional', 'wpjobster' ); ?></option>
							<option <?php if ( $proficiency == 'native' ) echo 'selected="selected"'; ?> value="native"><?php _e( 'Native / Bilingual', 'wpjobster' ); ?></option>
						</select>

						<?php if ( wpj_get_user_id() == get_current_user_id() ) { ?>

							<div class="action-icons">
								<div class="di" data-inverted="" data-tooltip="<?php _e( 'Edit', 'wpjobster' ); ?>" data-position="<?php echo is_rtl() ? 'top right' : 'top center'; ?>">
									<i data-type="languages" class="user-edit-language pencil alternate icon"></i>
								</div>

								<div class="di" data-inverted="" data-tooltip="<?php _e( 'Delete', 'wpjobster' ); ?>" data-position="<?php echo is_rtl() ? 'top right' : 'top center'; ?>">
									<i data-type="languages" class="user-remove-item grey remove icon"></i>
								</div>
							</div>

						<?php } ?>

					</span>

				<?php }

			} else echo '<p class="no_item">' . __( 'Click on "Add New" to add a new Language.', 'wpjobster' ) . '</p>';

			$value = ob_get_contents();

			ob_end_clean();

			$languages_section = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $languages_section ) {
				if ( $languages || wpj_get_user_id() == get_current_user_id() ) {
					$this->display_field_content( $section, $label, $value, $f_name, 'new', true );
				}
			}
		}

		public function skills( $section = 'transparent_sidebar', $f_name = 'skills' ) {
			$label = _x( 'Skills', 'User Profile Page', 'wpjobster' );

			ob_start();

			$skills   = get_user_meta( wpj_get_user_id(), 'user_skills', true );
			$thumbsup = get_user_meta( wpj_get_user_id(), 'user_skills_thumbsup', true );

			if ( wpj_get_user_id() == get_current_user_id() ) wpj_display_skill_info_notice();

			if ( $skills ) {
				foreach ( $skills as $key => $skill ) {
					$skill_name = isset( $skill['name'] ) ? trim( $skill['name'] ) : trim( $skill );
					$skill_slug = isset( $skill['slug'] ) ? trim( $skill['slug'] ) : sanitize_title_with_dashes( $skill );
					$skill_logo = ! empty( $skill['slug'] ) ? wpj_get_attachment_image_url( $skill['logo'], 'thumb_picture_size' ) : ''; ?>

					<span class="pr skill-wrapper" data-slug="<?php echo $skill_slug; ?>">

						<?php if ( $skill_logo ) { ?>

							<a href="<?php echo wpj_get_attachment_image_url( $skill['logo'], 'full' ); ?>">
								<img src="<?php echo $skill_logo; ?>" class="skill-logo" alt="">
							</a>

						<?php } ?>

						<span class="skill-name"><?php echo $skill_name; ?></span>

						<span class="bull">&bull;</span>

						<span class="skill-thmbsup"><?php echo isset( $thumbsup[$skill_slug] ) && is_numeric( $thumbsup[$skill_slug] ) ? $thumbsup[$skill_slug] : 0; ?></span>

						<?php if ( wpj_get_user_id() == get_current_user_id() ) { ?>

							<div class="ui mini circular label remove-skill-wrapper">
								<i data-type="skills" class="user-remove-item remove icon di"></i>
							</div>

						<?php } ?>

					</span>

				<?php }

			} else { ?>

				<p class="no_item"><?php _e( 'Click on "Add New" to add a new Skill.', 'wpjobster' ); ?></p>

			<?php } ?>

			<div class="new_item new-skill-wrapper" style="display: none">
				<div class="ui icon input">

					<input placeholder="<?php _e( 'Skill', 'wpjobster' ); ?>" class="up_skills" type="text" name="skill" />

					<?php wpj_display_skill_upload_form(); ?>

				</div>
			</div>

			<?php $value = ob_get_contents();

			ob_end_clean();

			$skills_section = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $skills_section ) {
				if ( $skills || wpj_get_user_id() == get_current_user_id() ) {
					$this->display_field_content( $section, $label, $value, $f_name, 'new', true );
				}
			}
		}

		public function education( $section = 'transparent_sidebar', $f_name = 'education' ) {
			$label = _x( 'Education', 'User Profile Page', 'wpjobster' );

			ob_start();

			$educations = get_user_meta( wpj_get_user_id(), 'user_educations', true );

			if ( $educations ) {

				foreach ( $educations as $ed_key => $ed_value ) {

					wpj_init_new_education_modal( $ed_key ); ?>

					<span id="education-item" class="<?php echo $ed_key; ?>">

						<?php if ( wpj_get_user_id() == get_current_user_id() ) { ?>

							<div class="right di">
								<div class="di" data-inverted="" data-tooltip="<?php _e( 'Edit', 'wpjobster' ); ?>" data-position="<?php echo is_rtl() ? 'top right' : 'top center'; ?>">
									<i data-type="education" class="user-edit-item pencil alternate icon" data-indx="<?php echo $ed_key; ?>"></i>
								</div>

								<div class="di" data-inverted="" data-tooltip="<?php _e( 'Delete', 'wpjobster' ); ?>" data-position="<?php echo is_rtl() ? 'top right' : 'top center'; ?>">
									<i data-type="education" class="user-remove-item grey remove icon"></i>
								</div>
							</div>

						<?php } ?>

						<div class="school-itm"><?php echo $ed_value['school']; ?></div>

						<?php if ( $ed_value['degree'] ) { ?>

							<div class="degree-itm di"><?php echo $ed_value['degree']; if ( $ed_value['study'] || $ed_value['grade'] ) echo ', '; ?></div>

						<?php }

						if ( $ed_value['study'] ) { ?>

							<div class="study-itm di"><?php echo $ed_value['study']; if ( $ed_value['grade'] ) echo ', '; ?></div>

						<?php }

						if ( $ed_value['grade'] ) { ?>

							<div class="grade-itm di"><?php echo $ed_value['grade']; ?></div>

						<?php } ?>

						<div class="from-to-itm">

							<?php if ( $ed_value['from'] ) { ?>

								<div class="from-itm di"><?php echo $ed_value['from']; ?></div>

							<?php }

							if ( $ed_value['from'] && $ed_value['to'] ) echo '-';

							if ( $ed_value['to'] ) { ?>

								<div class="to-itm di"><?php echo $ed_value['to']; ?></div>

							<?php } ?>

						</div>

						<?php if ( $ed_value['activities'] ) { ?>

							<div class="activities-itm"><?php echo sprintf( __( 'Activities and Societies: %s', 'wpjobster' ), $ed_value['activities'] ); ?></div>

						<?php } ?>

						<div class="mt10"></div>

						<?php if ( $ed_value['description'] ) { ?>

							<div class="description-itm"><?php echo $ed_value['description']; ?></div>

						<?php }

						if ( $ed_value['attachments'] ) { ?>

							<div class="mt10"></div>

							<div class="attachments-itm">

								<?php if ( wpj_post_has_attachments( $ed_value['attachments'] ) ) {
									wpj_display_attachments_list( $ed_value['attachments'], wpj_get_user_id(), '', false, '', true, false );
								} ?>

							</div>

						<?php } ?>

					</span>

					<?php if ( next( $educations ) == true ) { ?>

						<div class="ui hidden divider"></div>

					<?php }
				}

			} else echo '<p class="no_item">' . __( 'Click on "Add New" to add a new Education.', 'wpjobster' ) . '</p>';

			wpj_init_new_education_modal( $educations ? array_key_last( $educations ) + 1 : '0' );

			$value = ob_get_contents(); ob_end_clean();

			$education_section = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $education_section ) {
				if ( $educations || wpj_get_user_id() == get_current_user_id() ) {
					$this->display_field_content( $section, $label, $value, $f_name, 'new-' . ( $educations ? array_key_last( $educations ) + 1 : '0' ), true );
				}
			}
		}

		public function certification( $section = 'transparent_sidebar', $f_name = 'certification' ) {
			$label = _x( 'Certification', 'User Profile Page', 'wpjobster' );

			ob_start();

			$certifications = get_user_meta( wpj_get_user_id(), 'user_certifications', true );

			if ( $certifications ) {

				foreach ( $certifications as $ct_key => $ct_value ) {

					wpj_init_new_certification_modal( $ct_key ); ?>

					<span id="certification-item" class="<?php echo $ct_key; ?>">

						<?php if ( wpj_get_user_id() == get_current_user_id() ) { ?>

							<div class="right di">
								<div class="di" data-inverted="" data-tooltip="<?php _e( 'Edit', 'wpjobster' ); ?>" data-position="<?php echo is_rtl() ? 'top right' : 'top center'; ?>">
									<i data-type="certification" class="user-edit-item pencil alternate icon" data-indx="<?php echo $ct_key; ?>"></i>
								</div>

								<div class="di" data-inverted="" data-tooltip="<?php _e( 'Delete', 'wpjobster' ); ?>" data-position="<?php echo is_rtl() ? 'top right' : 'top center'; ?>">
									<i data-type="certification" class="user-remove-item grey remove icon"></i>
								</div>
							</div>

						<?php } ?>

						<div class="certification-name-itm"><?php echo $ct_value['certification_name']; ?></div>

						<div class="date-itm">

							<?php if ( $ct_value['from_month'] ) { ?>

								<div class="from-month-itm di">

									<?php echo wpj_date_number_to_string_short( $ct_value['from_month'] ); ?>

								</div>

							<?php }

							if ( $ct_value['from_year'] ) { ?>

								<div class="from-year-itm di">

									<?php echo $ct_value['from_year']; ?>

								</div>

							<?php }

							if ( ( $ct_value['from_month'] || $ct_value['from_year'] ) && ( $ct_value['to_month'] || $ct_value['to_year'] || $ct_value['certification_not_expire'] == 'on' ) ) {
								echo '&#8212;';
							}

							if ( $ct_value['certification_not_expire'] == 'on' ) { ?>

								<div class="present-itm di"><?php _e( 'Present', 'wpjobster' ); ?></div>

							<?php } else {

								if ( $ct_value['to_month'] ) { ?>

									<div class="to-month-itm di">

										<?php echo wpj_date_number_to_string_short( $ct_value['to_month'] ); ?>

									</div>

								<?php }

								if ( $ct_value['to_year'] ) { ?>

									<div class="to-year-itm di">

										<?php echo $ct_value['to_year']; ?>

									</div>

								<?php }

							}

							if (
								(
									$ct_value['from_month']
									|| $ct_value['from_year']
									|| $ct_value['to_month']
									|| $ct_value['to_year']
								)
								&& $ct_value['license_number']
								|| $ct_value['certification_not_expire'] == 'on'
							) {
								echo '<span class="bullet">&#8226;</span>';
							}

							if ( $ct_value['license_number'] ) { ?>

								<div class="license-number-itm di">

									<?php echo $ct_value['license_number']; ?>

								</div>

							<?php } ?>

						</div>

						<?php if ( $ct_value['certification_authority'] ) { ?>

							<div class="certification-authority-itm">

								<?php echo sprintf( __( 'Authority: %s', 'wpjobster' ), $ct_value['certification_authority'] ); ?>

							</div>

						<?php }

						if ( $ct_value['certification_url'] ) {

							if ( strpos( $ct_value['certification_url'], 'http' ) === false )
								$certificate_link = 'http://' . $ct_value['certification_url'];
							else
								$certificate_link = $ct_value['certification_url']; ?>

							<div class="certification-url-itm">

								<?php echo '<a target="_blank" href="' . $certificate_link . '">' . __( 'See certificate', 'wpjobster' ) . '</a>'; ?>

							</div>

						<?php } ?>

					</span>

					<?php if ( next( $certifications ) == true ) { ?>

						<div class="ui hidden divider"></div>

					<?php }

				}

			} else echo '<p class="no_item">' . __( 'Click on "Add New" to add a new Certification.', 'wpjobster' ) . '</p>';

			wpj_init_new_certification_modal( $certifications ? array_key_last( $certifications ) + 1 : '0' );

			$value = ob_get_contents(); ob_end_clean();

			$certification_section = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $certification_section ) {
				if ( $certifications || wpj_get_user_id() == get_current_user_id() ) {
					$this->display_field_content( $section, $label, $value, $f_name, 'new-' . ( $certifications ? array_key_last( $certifications ) + 1 : '0' ), true );
				}
			}
		}

		public function social_media_links( $section = 'transparent_sidebar', $f_name = 'social_media_links' ) {
			if ( wpj_get_option( 'wpjobster_enable_user_social_media' ) == 'yes' ) {
				$label = _x( 'Social Media', 'User Profile Page', 'wpjobster' );

				$providers = wpj_get_user_social_media_providers();

				$value = '';

				if ( $providers ) {
					foreach ( $providers as $key => $provider ) {
						$current_value = preg_replace( "(^https?://)", "", get_user_meta( wpj_get_user_id(), 'social_media_' . $key, true ) );

						if ( $current_value ) {
							$value .= '<a href="https://' . $current_value . '"><i class="ui circular icon ' . $provider['icon'] . '"></i></a>';
						}

					}
				}

				$this->display_field_content( $section, $label, $value, $f_name );
			}
		}

		public function vacation( $section = 'main_content', $f_name = 'vacation' ) {
			ob_start();

			if ( ! empty( wpj_get_user_vacation( wpj_get_user_id() ) ) && wpj_get_user_id() != get_current_user_id() ) { ?>

				<div class="df flex-thumb-text grid ui segment user-info-wrapper user-vacancy-box">

					<div class="vacancy-image-wrapper">
						<img src="<?php echo get_template_directory_uri() . '/assets/images/user/suitacase-icon.svg'; ?>" class="vacancy-icon-image" alt="">
					</div>

					<div>

						<h2>
							<?php echo sprintf( __( '%s is Unavailable <span class="vacancy-date">until %s</span>', 'wpjobster' ), wpj_get_user_display_type( wpj_get_user_id() ), wpj_date( wpj_get_option( 'date_format' ), wpj_get_user_vacation( wpj_get_user_id() )['end'], false ) ); ?>
						</h2>

						<p class="description-user-vacancy">
							<?php echo sprintf( __( 'In the meantime, you can contact %s', 'wpjobster' ), '<a href="' . wpj_get_pm_link( wpj_get_user_id() ) . '" class="username-vacancy-contact">' . wpj_get_user_display_type( wpj_get_user_id() ) . '</a>' ); ?>
						</p>

						<p class="user-vacancy-message">
							<?php echo sprintf( __( '“Hey, %s, but I\'ll be happy to work with you when I\'m available again.”', 'wpjobster' ), wpj_get_user_vacation( wpj_get_user_id() )['reason'] ); ?>
						</p>

					</div>

				</div>

			<?php }

			$value = ob_get_contents();

			ob_end_clean();

			$this->display_field_content( $section, __( 'Vacation', 'wpjobster' ), $value, $f_name, '', true );
		}

		public function portfolio( $section = 'main_content', $f_name = 'portfolio' ) {
			$display_my_portfolio = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $display_my_portfolio == 'true' || wpj_get_user_id() != get_current_user_id() ) {

				$slider_enabled = wpj_get_option( 'wpjobster_enable_user_profile_portfolio' );
				
				if ( $slider_enabled == 'yes' ) {

					if ( function_exists( 'wpj_get_portfolio_images' ) ) {
						$portfolio_images = wpj_get_portfolio_images( wpj_get_user_id(), wpj_get_media_max_upload_number( 'portfolio' ) );

					} else {
						$portfolio_images = [];

					}

					if ( $portfolio_images || wpj_get_user_id() == get_current_user_id() ) {

						if ( substr( $this->user->user_login, -1 ) == 's' ) {
							$user_display_name = sprintf( __( "%s' Portfolio", "wpjobster" ), ucfirst( wpj_get_user_display_type( wpj_get_user_id() ) ) );

						} else {
							$user_display_name = sprintf( __( "%s's Portfolio", "wpjobster" ), ucfirst( wpj_get_user_display_type( wpj_get_user_id() ) ) );

						}

						$portfolio_title = wpj_get_user_id() == get_current_user_id() ? _x( 'My Portfolio', 'User Profile Page', 'wpjobster' ) : ucfirst( $user_display_name );

						$label = $portfolio_title;

						ob_start();

						if ( wpj_get_user_id() == get_current_user_id() ) {
							if ( $portfolio_images ) { ?>

								<a data-type="" class="edit-info edit-info-bg js-toggle-portfolio-handler">
									<i data-type="languages" class="user-edit-language grey pencil alternate edit-info icon"></i>
								</a>

							<?php } ?>

							<a data-type="" class="edit-info edit-info-bg js-refresh-portfolio-handler" <?php if ( $portfolio_images ) { ?>style="display: none;"<?php } ?>>
								<?php _e( 'Refresh', 'wpjobster' ); ?>
							</a>

						<?php }

						if ( $portfolio_images ) { ?>

							<div class="js-image-attachments-carousel bordered-lightbox-carousel owl-carousel owl-theme">

								<?php foreach ( $portfolio_images as $portfolio_image ) {
									$image_id    = $portfolio_image->ID;
									$image_thumb = wpj_get_attachment_image_url( $image_id, 'thumb_picture_size' );
									$image_src   = wpj_get_attachment_image_url( $image_id, 'full' );

									if ( ! $image_src ) {
										$video_url = wp_get_attachment_url( $image_id );
										$extension = pathinfo( $video_url, PATHINFO_EXTENSION );
										$mime_type = wpj_get_mimes_types_list( $extension ); ?>

										<div class="item">
											<video controls>
												<source src="<?= $video_url; ?>" type="<?= esc_attr( $mime_type ); ?>">

												<?php _e( 'Your browser does not support the video tag.', 'wpjobster' ); ?>
											</video>
										</div>

									<?php } else { ?>

										<div class="item">
											<a href="<?php echo $image_src; ?>" data-featherlight="<?php echo $image_src; ?>" data-featherlight-variant="wpj-featherlight">
												<img class="portfolio-image" src="<?php echo $image_thumb; ?>" alt="">
											</a>
										</div>

									<?php }

								} ?>

							</div>

						<?php }

						if ( wpj_get_user_id() == get_current_user_id() ) { ?>

							<div class="js-profile-portfolio-uploader" <?php if ( $portfolio_images ) { ?>style="display: none;"<?php } ?>>

								<?php wpj_display_image_upload_form( wpj_get_user_id(), 'portfolio', 'user-portfolio', 'portfolio_images' ); ?>

							</div>

						<?php }


						$value = ob_get_contents();

						ob_end_clean();

						$this->display_field_content( $section, $label, $value, $f_name, '', true );

					} // END IF ( $portfolio_images || wpj_get_user_id() == get_current_user_id() )
				} // END IF $slider_enabled == 'yes'
			} // END IF $display_my_portfolio == 'true' || wpj_get_user_id() != get_current_user_id()
		}

		public function jobs( $section = 'main_content', $f_name = 'jobs' ) {
			$display_my_jobs = apply_filters( 'hide_for_buyers', true, wpj_get_user_id() );

			if ( $display_my_jobs == 'true' ) {
				if ( wpj_get_option( 'wpjobster_enable_jobs_section_on_user_profile' ) != 'no' ) {
					if ( substr( $this->user->user_login, -1 ) == 's' ) {
						$user_display_name = sprintf( __( "%s' Jobs", "wpjobster" ), ucfirst( wpj_get_user_display_type( wpj_get_user_id() ) ) );

					} else {
						$user_display_name = sprintf( __( "%s's Jobs", "wpjobster" ), ucfirst( wpj_get_user_display_type( wpj_get_user_id() ) ) );

					}

					$jobs_title = wpj_get_user_id() == get_current_user_id() ? _x( 'My Jobs', 'User Profile Page', 'wpjobster' ) : ucfirst( $user_display_name );

					$label = $jobs_title;

					ob_start();

					$meta_query = [
						[
							'key'     => 'active',
							'value'   => '1',
							'compare' => '='
						]
					];

					$wpj_job = new WPJ_Load_More_Posts(
						[
							'post_status'     => 'publish',
							'post_type'       => 'job',
							'function_name'   => 'wpj_display_job_card_layout',
							'author'          => wpj_get_user_id(),
							'meta_query'      => $meta_query,
							'container_class' => 'ui three cards'
						]
					);

					if ( $wpj_job->have_rows() ) {
						wpj_display_post_layout_switcher( 'grid-switch-absolute user-profile-jobs' );

						echo '<div><div>'; // do not delete these two divs - load more wrapper

							$wpj_job->show_list_fnc();

						echo '</div></div>';

					} else {
						echo '<div class="wpj-bordered-container p15">' . __( 'Sorry, there are no posted jobs yet.', 'wpjobster' ) . '</div>';

					}

					$value = ob_get_contents();

					ob_end_clean();

					$this->display_field_content( $section, $label, $value, $f_name, '', true );
				}
			}
		}

		public function reviews( $section = 'main_content', $f_name = 'reviews' ) {

			if ( substr( $this->user->user_login, -1 ) == 's' )
				$user_display_name = sprintf( __( "%s' Reviews", "wpjobster" ), ucfirst( wpj_get_user_display_type( wpj_get_user_id() ) ) );
			else
				$user_display_name = sprintf( __( "%s's Reviews", "wpjobster" ), ucfirst( wpj_get_user_display_type( wpj_get_user_id() ) ) );

			$reviews_title = wpj_get_user_id() == get_current_user_id() ? _x( 'My Reviews', 'User Profile Page', 'wpjobster' ) : ucfirst( $user_display_name );

			$label = $reviews_title;

			ob_start();

			wpj_display_user_reviews_list();

			$value = ob_get_contents();

			ob_end_clean();

			$this->display_field_content( $section, $label, $value, $f_name, '', true );

		}

		public function custom_icons_link( $section = 'white_sidebar', $f_name = 'custom_icons_link' ) {
			$field = wpj_get_acf_field_data( $section, $f_name, '', 'field' );

			$label_value = ! empty( $field['label_value'] ) ? $field['label_value'] : '';
			$link_url    = ! empty( $field['link_url'] ) ? $field['link_url'] : '#';
			$link_text   = ! empty( $field['link_text'] ) ? $field['link_text'] : __( 'Click To View', 'wpjobster' );
			$link_colour = ! empty( $field['link_colour'] ) ? $field['link_colour'] : '#000000';

			$value = '<a style="color: ' . $link_colour . '" class="fs14" href="' . $link_url . '">' . $link_text . '</a>';

			$this->display_field_content( $section, $label_value, $value, $f_name, '', true );
		}

	}

}