<?php if ( ! class_exists( 'WPJUserProfile' ) ) {

	class WPJUserProfile extends stdClass {

		/**
		 * @var array|false|int|mixed|stdClass|string|WP_User
		 */
		private $uid;

		/**
		 * @var int
		 */
		private int $cuid;

		/**
		 * @var WPJ_Custom_Fields
		 */
		private WPJ_Custom_Fields $custom_field;

		/**
		 * @var WPJUserProfileFieldsContent
		 */
		private WPJUserProfileFieldsContent $fields_content_class;

		public static function init() { $class = __CLASS__; new $class; }

		public function __construct() {
			$this->uid  = wpj_get_user_id();
			$this->cuid = get_current_user_id();

			$this->custom_field         = new WPJ_Custom_Fields( get_current_user_id(), 'up' );
			$this->fields_content_class = new WPJUserProfileFieldsContent();

			add_action( 'wp_ajax_save_user_description_content', [$this, 'save_user_description'] );
			add_action( 'wp_ajax_nopriv_save_user_description_content', [$this, 'save_user_description'] );

			add_action( 'wp_ajax_save_user_language_content', [$this, 'save_user_language'] );
			add_action( 'wp_ajax_nopriv_save_user_language_content', [$this, 'save_user_language'] );

			add_action( 'wp_ajax_change_user_language_content', [$this, 'change_user_language'] );
			add_action( 'wp_ajax_nopriv_change_user_language_content', [$this, 'change_user_language'] );

			add_action( 'wp_ajax_remove_user_language_content', [$this, 'remove_user_language'] );
			add_action( 'wp_ajax_nopriv_remove_user_language_content', [$this, 'remove_user_language'] );

			add_action( 'wp_ajax_save_user_skill_content', [$this, 'save_user_skill'] );
			add_action( 'wp_ajax_nopriv_save_user_skill_content', [$this, 'save_user_skill'] );

			add_action( 'wp_ajax_remove_user_skill_content', [$this, 'remove_user_skill'] );
			add_action( 'wp_ajax_nopriv_remove_user_skill_content', [$this, 'remove_user_skill'] );

			add_action( 'wp_ajax_save_user_tagline_content', [$this, 'save_user_tagline'] );
			add_action( 'wp_ajax_nopriv_save_user_tagline_content', [$this, 'save_user_tagline'] );

			add_action( 'wp_ajax_save_user_education_content', [$this, 'save_user_education'] );
			add_action( 'wp_ajax_nopriv_save_user_education_content', [$this, 'save_user_education'] );

			add_action( 'wp_ajax_remove_user_education_content', [$this, 'remove_user_education'] );
			add_action( 'wp_ajax_nopriv_remove_user_education_content', [$this, 'remove_user_education'] );

			add_action( 'wp_ajax_save_user_certification_content', [$this, 'save_user_certification'] );
			add_action( 'wp_ajax_nopriv_save_user_certification_content', [$this, 'save_user_certification'] );

			add_action( 'wp_ajax_remove_user_certification_content', [$this, 'remove_user_certification'] );
			add_action( 'wp_ajax_nopriv_remove_user_certification_content', [$this, 'remove_user_certification'] );
		}

		public function getFieldsContent( $section ) {
			$Custom_Fields = new WPJ_Custom_Fields( wpj_get_user_id(), 'up' );

			if ( function_exists( 'have_rows' ) && function_exists( 'get_field' ) ) {
				if ( have_rows( $section ) ) {
					foreach ( get_field( $section ) as $ws_key => $ws_value ) {
						$f_name = $ws_value['acf_fc_layout'];

						if ( strpos( $f_name, 'custom_field' ) !== false )
							$Custom_Fields->displayFieldsContent( $section, $ws_value );

						elseif ( method_exists( $this->fields_content_class, $f_name ) )
							$this->fields_content_class->$f_name( $section, $f_name );
					}
				}
			}
		}

		// Save user description
		public function save_user_description() {
			$content = wpj_get_allowed_html_tags_for_wysiwyg( $_POST['item'] );
			$uid     = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				update_user_meta( $uid, 'description', $content );
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Save new languages
		public function save_user_language() {
			$language    = $_POST['language'] ? wpj_validate_input_content( $_POST['language'] ) : '';
			$proficiency = $_POST['proficiency'] ? wpj_validate_input_content( $_POST['proficiency'] ) : '';
			$uid         = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				if ( $language && $proficiency ) {
					$languages[$language] = $proficiency;

					$current_arr = get_user_meta( $uid, 'user_languages', true );

					if ( ! $current_arr ) {
						update_user_meta( $uid, 'user_languages', $languages );

					} else {
						$current_arr[$language] = $proficiency;
						update_user_meta( $uid, 'user_languages', $current_arr );

					}
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Edit a language
		public function change_user_language() {
			$old_language    = $_POST['old_language'] ? wpj_validate_input_content( $_POST['old_language'] ) : '';
			$language        = $_POST['language'] ? wpj_validate_input_content( $_POST['language'] ) : '';
			$proficiency     = $_POST['proficiency'] ? wpj_validate_input_content( $_POST['proficiency'] ) : '';
			$uid             = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				if ( $language && $proficiency ) {
					$current_arr = get_user_meta( $uid, 'user_languages', true );
					$new_languages_arr = wpj_change_array_key( $current_arr, $old_language, $language );
					$new_languages_arr[$language] = $proficiency;

					update_user_meta( $uid, 'user_languages', $new_languages_arr );
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Remove a language
		public function remove_user_language() {
			$language = $_POST['item'] ? wpj_validate_input_content( $_POST['item'] ) : '';
			$uid      = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				$current_arr = get_user_meta( $uid, 'user_languages', true );

				if ( $current_arr ) {
					foreach ( $current_arr as $key => $value ) {
						if ( strtolower( $key ) == strtolower( $language ) ) {
							unset( $current_arr[$key] );
						}
					}

					update_user_meta( $uid, 'user_languages', $current_arr );
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Save new skill
		public function save_user_skill() {
			$uid = $_POST['uid'];

			$skill      = $_POST['item'] ? wpj_stripslashes( wpj_validate_input_content( $_POST['item'] ) ) : '';
			$skill_logo = ! empty( $_POST['item_logo'] ) ? $_POST['item_logo'] : '';

			if ( $uid == $this->cuid ) {
				$save = true;

				if ( $skill ) {
					$current_arr = get_user_meta( $uid, 'user_skills', true );

					if ( ! $current_arr ) {
						update_user_meta( $uid, 'user_skills', [ [
							'slug' => sanitize_title_with_dashes( $skill ),
							'name' => $skill,
							'logo' => $skill_logo
						] ] );

					} else {
						foreach ( $current_arr as $key => $value ) {
							if ( $value['slug'] == sanitize_title_with_dashes( $skill ) ) {
								$save = false; break;
							}
						}

						if ( $save ) {
							$current_arr[] = [
								'slug' => sanitize_title_with_dashes( $skill ),
								'name' => $skill,
								'logo' => $skill_logo,
							];

							update_user_meta( $uid, 'user_skills', $current_arr );
						}
					}
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Remove a skill
		public function remove_user_skill() {
			$skill = $_POST['item'] ? wpj_stripslashes( wpj_validate_input_content( $_POST['item'] ) ) : '';
			$uid   = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				$current_arr = get_user_meta( $uid, 'user_skills', true );

				if ( $current_arr ) {
					foreach ( $current_arr as $key => $value ) {
						if ( $value['slug'] == $skill ) {
							unset( $current_arr[$key] );
						}
					}

					update_user_meta( $uid, 'user_skills', $current_arr );
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Save user tagline
		public function save_user_tagline() {
			$tagline = $_POST['item'] ? wpj_validate_input_content( $_POST['item'] ) : '';
			$uid     = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				update_user_meta( $uid, 'user_tagline', $tagline );
			}
		}

		// Save user education
		public function save_user_education() {
			$uid = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				$current_arr = get_user_meta( $uid, 'user_educations', true );

				if ( ! $current_arr ) { $current_arr = []; }

				$indx = isset( $_POST['indx'] ) ? $_POST['indx'] : 0;

				if ( $_POST["user_school"] ) {
					$media_attachments = $_POST['hidden_files_media_attachments_' . $indx];

					if ( isset( $current_arr[$indx]['attachments'] ) ) {
						$media_attachments_arr          = explode( ",", $media_attachments );
						$existing_media_attachments     = $current_arr[$indx]['attachments'];
						$existing_media_attachments_arr = explode( ",", $existing_media_attachments );
						$new_media_attachments_arr      = array_merge( $media_attachments_arr, $existing_media_attachments_arr );
						$media_attachments              = implode( ",", $new_media_attachments_arr );
					}

					$current_arr[$indx]['school']      = wpj_validate_input_content( WPJ_Form::post( 'user_school' ) );
					$current_arr[$indx]['degree']      = wpj_validate_input_content( WPJ_Form::post( 'user_degree' ) );
					$current_arr[$indx]['grade']       = wpj_validate_input_content( WPJ_Form::post( 'user_grade' ) );
					$current_arr[$indx]['study']       = wpj_validate_input_content( WPJ_Form::post( 'user_field_of_study' ) );
					$current_arr[$indx]['activities']  = wpj_validate_input_content( WPJ_Form::post( 'user_activities_and_societies' ) );
					$current_arr[$indx]['from']        = wpj_validate_input_content( WPJ_Form::post( 'user_from_year' ) );
					$current_arr[$indx]['to']          = wpj_validate_input_content( WPJ_Form::post( 'user_to_year' ) );
					$current_arr[$indx]['description'] = wpj_validate_input_content( WPJ_Form::post( 'user_description' ) );
					$current_arr[$indx]['attachments'] = $media_attachments;

					update_user_meta( $uid, 'user_educations', $current_arr );
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Remove a education
		public function remove_user_education() {
			$education = $_POST['item'] ? wpj_validate_input_content( $_POST['item'] ) : '';
			$uid       = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				$current_arr = get_user_meta( $uid, 'user_educations', true );

				if ( $current_arr ) {
					foreach ( $current_arr as $key => $value ) {
						if ( $key == $education ) {
							unset( $current_arr[$key] );
						}
					}

					update_user_meta( $uid, 'user_educations', $current_arr );
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Save user certification
		public function save_user_certification() {
			$uid = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				$current_arr = get_user_meta( $uid, 'user_certifications', true );

				if ( ! $current_arr ) { $current_arr = []; }

				$indx = isset( $_POST['indx'] ) ? $_POST['indx'] : 0;

				if ( $_POST["user_certification_name"] ) {
					$current_arr[$indx]['certification_name']       = wpj_validate_input_content( WPJ_Form::post( 'user_certification_name', '' ) );
					$current_arr[$indx]['certification_authority']  = wpj_validate_input_content( WPJ_Form::post( 'user_certification_authority', '' ) );
					$current_arr[$indx]['license_number']           = wpj_validate_input_content( WPJ_Form::post( 'user_license_number', '' ) );
					$current_arr[$indx]['from_month']               = wpj_validate_input_content( WPJ_Form::post( 'user_from_month', '' ) );
					$current_arr[$indx]['to_month']                 = wpj_validate_input_content( WPJ_Form::post( 'user_to_month', '' ) );
					$current_arr[$indx]['from_year']                = wpj_validate_input_content( WPJ_Form::post( 'user_from_year', '' ) );
					$current_arr[$indx]['to_year']                  = wpj_validate_input_content( WPJ_Form::post( 'user_to_year', '' ) );
					$current_arr[$indx]['certification_not_expire'] = wpj_validate_input_content( WPJ_Form::post( 'user_certification_not_expire', 'no'  ));
					$current_arr[$indx]['certification_url']        = wpj_validate_input_content( WPJ_Form::post( 'user_certification_url', '' ) );

					update_user_meta( $uid, 'user_certifications', $current_arr );
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

		// Remove a certificate
		public function remove_user_certification() {
			$certification = $_POST['item'] ? wpj_validate_input_content( $_POST['item'] ) : '';
			$uid           = $_POST['uid'];

			if ( $uid == $this->cuid ) {
				$current_arr = get_user_meta( $uid, 'user_certifications', true );

				if ( $current_arr ) {
					foreach ( $current_arr as $key => $value ) {
						if ( $key == $certification ) {
							unset( $current_arr[$key] );
						}
					}

					update_user_meta( $uid, 'user_certifications', $current_arr );
				}
			}

			if ( wpj_is_ajax_call() ) wp_die();
		}

	}

}

add_action( 'admin_init', ['WPJUserProfile', 'init'] );