<?php
/**
 * WPJ_Cache_Helper class.
 *
 * @package WPJobster
 * @subpackage Jobster
 * @since Jobster v6.0.0
 */

if ( ! defined( 'ABSPATH' ) ) exit;

/**
 * WPJ_Cache_Helper.
 */
class WPJ_Cache_Helper extends stdClass {

	/**
	 * Initializes the object instance
	 */
	public function __construct() {
		/**
		 * Warning: You can only use conditional query tags after the posts_selection action hook in WordPress
		 * (the wp action hook is the first one through which you can use these conditionals).
		 * https://codex.wordpress.org/Conditional_Tags
		 */
		add_action( 'wp', [ $this, 'init' ], 0 );
	}

	/**
	 * Prevent caching on certain pages
	 *
	 * @return void
	 */
	public function init() {
		if ( ! is_blog_installed() ) return;

		$nocache_page_ids = array_filter( [
			// wpj_get_option( 'wpjobster_not_found_page_id' ),                 // 404
			// wpj_get_option( 'wpjobster_all_categories_page_id' ),            // All Categories
			// wpj_get_option( 'wpjobster_all_news_page_id' ),                  // All News
			wpj_get_option( 'wpjobster_my_account_all_notifications_page_id' ), // All Notifications
			wpj_get_option( 'wpjobster_all_proposals_page_id' ),                // All Proposals
			wpj_get_option( 'wpjobster_all_requests_page_id' ),                 // All Requests
			wpj_get_option( 'wpjobster_badges_page_id' ),                       // Badges
			// wpj_get_option( 'wpjobster_all_blog_posts_page_id' ),            // Blog Posts
			wpj_get_option( 'wpjobster_checkout_page_id' ),                     // Checkout
			wpj_get_option( 'wpjobster_email_settings_page_id' ),               // Email Settings
			wpj_get_option( 'wpjobster_feature_page_id' ),                      // Feature Job
			// wpj_get_option( 'main_page_url' ),                               // Homepage
			wpj_get_option( 'main_page_url_user' ),                             // Homepage - Loggedin
			// wpj_get_option( 'wpjobster_how_it_works_page_id' ),              // How It Works?
			// wpj_get_option( 'wpjobster_levels_page_id' ),                    // Levels
			wpj_get_option( 'wpjobster_my_account_page_id' ),                   // My Account
			wpj_get_option( 'wpjobster_my_favorites_page_id' ),                 // My Favorites
			wpj_get_option( 'wpjobster_my_requests_page_id' ),                  // My Requests
			wpj_get_option( 'wpjobster_order_page_id' ),                        // Order
			wpj_get_option( 'wpjobster_my_account_payments_page_id' ),          // Payments
			wpj_get_option( 'wpjobster_post_new_page_id' ),                     // Post New or Edit Job
			wpj_get_option( 'wpjobster_new_request_page_id' ),                  // Post New or Edit Request
			// wpj_get_option( 'wpjobster_privacy_policy_page_id' ),            // Privacy Policy
			wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' ),         // Private Messages
			wpj_get_option( 'wpjobster_my_account_reviews_page_id' ),           // Reviews/Feedback
			wpj_get_option( 'wpjobster_my_account_sales_page_id' ),             // Sales
			// wpj_get_option( 'wpjobster_advanced_search_id' ),                // Search Jobs
			// wpj_get_option( 'wpjobster_advanced_search_request_page_id' ),   // Search Requests
			// wpj_get_option( 'wpjobster_search_user_page_id' ),               // Search Users
			wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ),     // Settings
			wpj_get_option( 'wpjobster_my_account_shopping_page_id' ),          // Shopping
			// wpj_get_option( 'wpjobster_single_blog_page_id' ),               // Single Blog
			// wpj_get_option( 'wpjobster_single_job_page_id' ),                // Single Job
			// wpj_get_option( 'wpjobster_single_news_page_id' ),               // Single News
			// wpj_get_option( 'wpjobster_single_request_page_id' ),            // Single Request
			wpj_get_option( 'wpjobster_subscriptions_page_id' ),                // Subscriptions
			// wpj_get_option( 'wpjobster_terms_of_service_page_id' ),          // Terms of Service
			wpj_get_option( 'wpjobster_topup_order_page_id' ),                  // TopUp Order
			wpj_get_option( 'wpjobster_user_profile_page_id' ),                 // User Profile
			wpj_get_option( 'wpjobster_verify_email_page_id' ),                 // Verify Email
			wpj_get_option( 'wpjobster_verify_phone_page_id' ),                 // Verify Phone
		] );

		if ( is_page( $nocache_page_ids ) ) $this->nocache();
	}

	/**
	 * Set nocache constants and headers.
	 *
	 * @access private
	 * @return void
	 */
	private function nocache() {
		if ( ! defined( 'DONOTCACHEPAGE' ) ) {
			define( "DONOTCACHEPAGE", "true" );
		}

		nocache_headers();
	}
}

new WPJ_Cache_Helper();