<?php if ( ! class_exists( 'WPJ_Custom_Fields' ) ) {

	class WPJ_Custom_Fields extends \stdClass {

		/**
		 * PUBLIC VARS
		 */
		public $_id, $_cf_page;

		/**
		 * CONSTRUCTOR
		 */
		public function __construct( $_id = '', $_cf_page = '' ) {
			$this->pid  = $_id;
			$this->page = $_cf_page;

			if ( $this->page && ! $this->pid ) {
				if ( isset( $_GET[$this->page . 'id'] ) ) {
					$this->pid = WPJ_Form::get( $this->page . 'id' );
				} elseif ( is_user_logged_in() ) {
					$this->pid = wpj_get_auto_draft_post( get_current_user_id(), $this->page );
				}
			}
		}

		/**
		 * WP GET META
		 */
		public function meta_fnc_get( $id, $key, $single ) {
			return $this->page == 'up' ? get_user_meta( $id, $key, $single ) : get_post_meta( $id, $key, $single );
		}

		/**
		 * WP UPDATE META
		 */
		public function meta_fnc_update( $id, $key, $value ) {
			return $this->page == 'up' ? update_user_meta( $id, $key, $value ) : update_post_meta( $id, $key, $value );
		}

		/**
		 * INPUT
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param number $placeholder
		 *   @param number $value
		 *   @param number $size
		 *   @param number $min
		 *   @param number $max
		 *   @param number $step
		 *   @param number $maxlength
		 *   @param string $pattern
		 *   @param string $labeled
		 *   @param string $label_content
		 *   @param string $label_left_content
		 *   @param string $label_right_content
		 *   @param string $label_alignment
		 *   @param string $with_icon
		 *   @param string $icon_alignment
		 *   @param string $icon_class
		 *   @param string $dial_code
		 *   @param bool   $disabled
		 *   @param bool   $required
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function input_fields( $params ) { extract( $params );
			$ret = '';

			if ( empty( $sub_type ) ) $sub_type = 'text';
			if ( empty( $display_for ) ) $display_for = 'both';
			if ( WPJ_Form::isSetHasValue( $params, 'labeled' ) && empty( $label_alignment ) ) $label_alignment = 'left';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) ) {

				// Input with Icon & Label
				if (
					WPJ_Form::isSetHasValue( $params, 'labeled' ) && $labeled == 'yes'
					&& WPJ_Form::isSetHasValue( $params, 'with_icon' ) && $with_icon == 'yes'
					&& $display_for != 'admin'
				) {
					$ret .= '<div class="ui fluid labeled icon input">';
						$ret .= '<div class="ui label">' . $label_content . '</div>';
				}

				// Input with Icon
				elseif ( WPJ_Form::isSetHasValue( $params, 'with_icon' ) && $with_icon == 'yes' && $display_for != 'admin' ) {
					$ret .= '<div class="ui fluid ' . $icon_alignment . ' icon input">';
				}

				// Input labeled
				elseif ( WPJ_Form::isSetHasValue( $params, 'labeled' ) && $labeled == 'yes' && $display_for != 'admin' ) {
					$lbl_alignment = $label_alignment == 'left' ? '' : 'right';

					$ret .= '<div class="ui fluid ' . $lbl_alignment . ' labeled input">';

						if ( WPJ_Form::isSetHasValue( $params, 'label_content' ) && $label_alignment == 'left' ) {
							$ret .= '<div class="ui label">' . $label_content . '</div>';
						} elseif ( WPJ_Form::isSetHasValue( $params, 'label_left_content' ) && $label_alignment == 'both' ) {
							$ret .= '<label class="ui label">' . $label_left_content . '</label>';
						}
				}

				// Normal Input
				else {
					$ret .= '<div class="ui fluid input">';
				}

					$ret .= '<input type="' . $sub_type . '" name="' . $name . '"';

						if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'placeholder' ) ) { $ret .= ' placeholder="' . $placeholder . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'value' ) ) { $ret .= ' value="' . $value . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'min' ) ) { $ret .= ' min="' . $min . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'max' ) ) { $ret .= ' max="' . $max . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'maxlength' ) ) { $ret .= ' maxlength="' . $maxlength . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'step' ) ) { $ret .= ' step="' . $step . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'size' ) ) { $ret .= ' size="' . $size . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'pattern' ) ) { $ret .= ' pattern="' . $pattern . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) {
							if ( isset( $class ) ) $class .= ' cf-required';
							else $class = 'cf-required';

							$params['class'] = 'cf-required';

							$ret .= ' required';
							$ret .= ' data-validation-message="' . WPJ_Form::isSetHasValue( $params, 'required' ) . '"';
						}

						if ( WPJ_Form::isSetHasValue( $params, 'class' ) ) { $ret .= ' class="' . $class . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

						if ( WPJ_Form::isSetHasValue( $params, 'dial_code' ) && $dial_code == 'yes' ) {
							if ( ! isset( $class ) ) { $ret .= ' class="cell_number"'; } else { $class .= ' cell_number'; }

							if ( wpj_get_option( 'wpjobster_phone_country_select' ) != 'autodetect' ) $default_country = wpj_get_option( 'wpjobster_phone_country_select' );
							else $default_country = wpj_get_country_code_by_ip( wpj_get_user_ip() );

							$ret .= ' data-default-country="' . $default_country . '"';
							$ret .= ' data-only-countries="' . apply_filters( 'wpj_phone_prefixes_intltelinput_filter', '' ) . '"';
							$ret .= ' data-country="' . get_user_meta( get_current_user_id(), 'country_code', true ) . '"';
						}

					$ret .= ' />';

				if ( WPJ_Form::isSetHasValue( $params, 'with_icon' ) && $with_icon == 'yes' && $display_for != 'admin' ) {
						$ret .= '<i class="' . ( $icon_class ? $icon_class : 'search' ) . ' icon"></i>';
					$ret .= '</div>';
				}

				elseif ( WPJ_Form::isSetHasValue( $params, 'labeled' ) && $labeled == 'yes' && $display_for != 'admin' ) {

						if ( WPJ_Form::isSetHasValue( $params, 'label_content' ) && $label_alignment == 'right' ) {
							$ret .= '<div class="ui label">' . $label_content . '</div>';
						} elseif ( WPJ_Form::isSetHasValue( $params, 'label_right_content' ) && $label_alignment == 'both' ) {
							$ret .= '<div class="ui basic label">' . $label_right_content . '</div>';
						}

					$ret .= '</div>';
				}

				else {
					$ret .= '</div>';
				}

			}

			return $ret;
		}

		/**
		 * DEFINED VALUES
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $label_class
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $class
		 *   @param number $id
		 *   @param string $select_search
		 *   @param string $values
		 *   @param bool   $required
		 *   @param bool   $disabled
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function defined_value_fields( $params ) { extract( $params );
			$ret = '';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) && WPJ_Form::isSetHasValue( $params, 'values' ) ) {
				if ( is_array( $values ) ) {

					if ( ! WPJ_Form::isSetHasValue( $params, 'class' ) ) $class = '';

					if ( $type == 'select' ) {
						$select_name     = WPJ_Form::isSetHasValue( $params, 'multiple' ) ? $name . '[]' : $name;
						$select_multiple = WPJ_Form::isSetHasValue( $params, 'multiple' ) ? ' multiple="multiple" ' : ' ';
						$search          = WPJ_Form::isSetHasValue( $params, 'select_search' ) && $select_search == 'yes' && $display_for != 'admin' ? ' search ' : ' ';

						if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) { $class .= ' cf-required'; }

						$ret .= '<select' . $select_multiple . 'name="' . $select_name . '" class="ui fluid clearable ' . $search . ' dropdown ' . $class . '"';

							if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

							if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

						$ret .= '>';

						if ( WPJ_Form::isSetHasValue( $params, 'placeholder' ) ) {
							$ret .= '<option value="">' . $placeholder . '</option>';

						} else {
							$ret .= '<option value="">' . __( 'Choose an option', 'wpjobster' ) . '</option>';

						}
					}

					foreach ( $values as $key => $option_name ) {
						$option_value_meta = $value;
						$option_value      = ! empty( $val_from_key ) ? $key : str_replace( ' ', '_', $option_name );
						$selected_html     = $type == 'select' ? ' selected="selected" ' : ' checked ';

						if ( is_array( $option_value_meta ) ) {
							foreach ( $option_value_meta as $key => $val ) {
								$option_value_meta[$key] = str_replace( ' ', '_', $val );
							}
							$selected = in_array( $option_value, $option_value_meta ) ? $selected_html : '';

						} else {
							$option_value_meta = str_replace( ' ', '_', $option_value_meta );
							$selected = $option_value_meta == $option_value ? $selected_html : '';

						}

						if ( ! $option_value ) $selected = '';

						if ( $type == 'select' ) {

							// Select
							$ret .= '<option ' . $selected . ' value="' . $option_value . '">' . $option_name . '</option>';

						} else {

							// Checkbox/Radio
							$name_multiple = $type != 'radio' ? '[]' : '';
							$disabled      = WPJ_Form::isSetHasValue( $params, 'disabled' ) ? ' disabled' : '';

							$ret .= '<div class="ui ' . $type . ' checkbox ' . $selected . $disabled . '">';
								$ret .= '<input name="' . $name . $name_multiple . '" type="hidden" value="0" />';
								$ret .= '<input name="' . $name . $name_multiple . '" type="' . $type . '" ' . $selected;

									if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

									if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) { $class .= ' cf-required'; }

									if ( WPJ_Form::isSetHasValue( $params, 'class' ) || $class ) { $ret .= ' class="' . $class . '"'; }

									if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

									$ret .= ' value="' . $option_value . '"';

								$ret .= ' />';

								$ret .= '<label class="' . ( WPJ_Form::isSetHasValue( $params, 'label_class' ) ? $label_class : '' ) . '">' . $option_name . '</label>';
							$ret .= '</div><br>';

						}
					}

					if ( $type == 'select' ) { $ret .= '</select>'; }

				} else {

					$ret .= __( 'Defined values have a wrong format', 'wpjobster' );

				}
			} else {

				$ret .= __( 'Defined values are missing', 'wpjobster' );

			}

			return $ret;
		}

		/**
		 * TEXTAREA
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param string $placeholder
		 *   @param string $value
		 *   @param string $wrap
		 *   @param number $cols
		 *   @param number $rows
		 *   @param number $maxlength
		 *   @param bool   $resizable
		 *   @param bool   $required
		 *   @param bool   $disabled
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function textarea_fields( $params ) { extract( $params );
			$ret = '';

			if ( empty( $type ) ) $type = 'textarea';
			if ( empty( $display_for ) ) $display_for = 'both';
			if ( empty( $class ) ) $class = 'both';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) ) {
				if ( $type == 'textarea' || ( $display_for == 'admin' && $type == 'wysiwyg' ) ) {

					$ret .= '<textarea name="' . $name . '"';

						if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'placeholder' ) ) { $ret .= ' placeholder="' . $placeholder . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'cols' ) ) { $ret .= ' cols="' . $cols . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'rows' ) ) { $ret .= ' rows="' . $rows . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'maxlength' ) ) { $ret .= ' maxlength="' . $maxlength . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'resizable' ) === false ) { $ret .= ' style="resize: none;"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'wrap' ) ) { $ret .= ' wrap="' . $wrap . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) { $class .= ' cf-required'; }

						if ( WPJ_Form::isSetHasValue( $params, 'class' ) || $class ) { $ret .= ' class="' . $class . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

					$ret .= '>';

					$ret .= str_replace( '<br />', "", $value );

					$ret .= '</textarea>';

				} elseif ( $type == 'wysiwyg' ) {

					if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) { $class .= ' cf-required'; }

					if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $disabled = true; } else { $disabled = false; }

					ob_start(); wpj_display_wysiwyg_textarea( $this->pid, $name, $name, $name . '_toolbar', $class, $placeholder, $value, $name, '', '', false, $disabled );
					$ret = ob_get_contents(); ob_end_clean();

				}
			}

			return $ret;
		}

		/**
		 * DATE
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param string $placeholder
		 *   @param string $time_format
		 *   @param bool   $required
		 *   @param bool   $disabled
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function date_fields( $params ) { extract( $params );
			$ret = '';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) ) {
				$time_f = $time_format == '24h' ? 'false' : 'true';
				$value  = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $this->fields['slug'] . '_date_field', true );

				if ( ! $value ) { /* for date old meta */
					$value  = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $this->fields['slug'], true );
				}

				$ret .= '<div data-timeformat="' . $time_f . '" data-datetype=' . $type . ' class="ui calendar js-calendar" id="' . $name . '">';

					$ret .= '<div class="ui input left icon">';

						$ret .= '<i class="calendar alternate outline icon"></i>';

						if ( $display_for == 'admin' ) {
							if ( $sub_type == 'time' ) { $inp_type = 'time'; $date_format = 'H:i'; }
							elseif ( $sub_type == 'date' ) { $inp_type = 'date'; $date_format = 'Y-m-d'; }
							elseif ( $sub_type == 'datetime' ) { $inp_type = 'datetime-local'; $date_format = 'Y-m-d\TH:i:s'; }

							$value = $value ? date( $date_format, $value ) : '';
						}

						$ret .= '<input type="' . ( $display_for == 'admin' ? $inp_type : 'text' ) . '" name="' . $name . '_date_field"';

							if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

							if ( WPJ_Form::isSetHasValue( $params, 'placeholder' ) ) { $ret .= ' placeholder="' . $placeholder . '"'; }

							$ret .= ' value="' . $value . '"';

							if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) { $class .= ' cf-required'; }

							if ( WPJ_Form::isSetHasValue( $params, 'class' ) || $class ) { $ret .= ' class="' . $class . '"'; }

							if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

						$ret .= ' />';

					$ret .= '</div>';

				$ret .= '</div>';
			}

			return $ret;
		}

		/**
		 * FILE
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function file( $params ) { extract( $params );
			$ret = '';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) ) {
				if ( $display_for != 'admin' ) {
					ob_start(); wpj_display_file_upload_form( $secure = 1, 'file_upload_' . $name . '_attachments', $name . '_attachments', $name );
					$ret .= ob_get_contents(); ob_end_clean();
				}

				$value = $this->meta_fnc_get( $this->pid, $name . '_attachments', true );

				if ( ! $value ) { /* for job and user profile old meta */
					$value = $this->meta_fnc_get( $this->pid, 'cfield_hidden_files_' . str_replace( 'job_', '', $name ) . '_attachments', true );
					if ( ! $value ) {
						$value = $this->meta_fnc_get( $this->pid, 'up_cfield_hidden_files_' . $name . '_attachments', true );
					}
				}

				if ( wpj_post_has_attachments( $value ) ) {
					ob_start(); wpj_display_attachments_list( $value, $this->pid, $name . '_attachments' );
					$ret .= ob_get_contents(); ob_end_clean();
				}
			}

			return $ret;
		}

		/**
		 * LINK
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param string $link_name
		 *   @param string $link_url
		 *   @param string $link_rel
		 *   @param string $link_target
		 *   @param bool   $required
		 *   @param bool   $disabled
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function link( $params ) { extract( $params );
			$ret = '';

			if ( $link_url ) {

				$ret .= '<a href="' . $link_url . '"';

					if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

					if ( WPJ_Form::isSetHasValue( $params, 'class' ) ) { $ret .= ' class="' . $class . '"'; }

					if ( WPJ_Form::isSetHasValue( $params, 'link_rel' ) ) { $ret .= ' rel="' . $link_rel . '"'; }

					if ( WPJ_Form::isSetHasValue( $params, 'link_target' ) ) { $ret .= ' target="' . $link_target . '"'; }

				$ret .= '>' . $link_name . '</a>';

			} else {

				$ret .= __( 'The URL address is missing', 'wpjobster' );

			}

			return $ret;
		}

		/**
		 * BUTTON
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param string $button_name
		 *   @param string $btn_url
		 *   @param string $btn_shape
		 *   @param string $btn_width
		 *   @param string $btn_size
		 *   @param string $btn_bg_color
		 *   @param string $btn_bg_color_custom
		 *   @param string $btn_text_color_custom
		 *   @param bool   $btn_text_color
		 *   @param bool   $btn_text_color_custom
		 *   @param bool   $disabled
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function button( $params ) { extract( $params );
			$ret = '';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) ) {

				$ret .= '<style>';
					if ( $sub_type == 'basic' ) {
						$ret .= '
							.ui.basic.btn-bg-custom-color { box-shadow: 0 0 0 1px' . $btn_bg_color_custom . ' inset !important }
							.ui.basic.btn-text-custom-color { color: ' . $btn_text_color_custom . ' !important }
						';
					} else {
						$ret .= '
							.btn-bg-custom-color { background-color: ' . $btn_bg_color_custom . ' !important }
							.btn-text-custom-color { color: ' . $btn_text_color_custom . ' !important }
						';
					}
				$ret .= '</style>';

				$ret .= '<button onclick="location.href=\'' . $btn_url . '\';" class="ui button ' . $sub_type;

					if ( WPJ_Form::isSetHasValue( $params, 'class' ) ) { $ret .= ' ' . $class; }

					if ( WPJ_Form::isSetHasValue( $params, 'btn_shape' ) == 'circular' ) { $ret .= ' circular'; }

					if ( WPJ_Form::isSetHasValue( $params, 'btn_width' ) == 'fluid' ) { $ret .= ' fluid'; }

					if ( WPJ_Form::isSetHasValue( $params, 'btn_size' ) ) { $ret .= ' ' . $btn_size; }

					if ( WPJ_Form::isSetHasValue( $params, 'btn_bg_color' ) ) {
						$btn_bg_color = $btn_bg_color == 'custom' ? 'btn-bg-custom-color' : $btn_bg_color;
						$ret .= ' ' . $btn_bg_color;
					}

					if ( WPJ_Form::isSetHasValue( $params, 'btn_text_color' ) ) {
						$btn_text_color = $btn_text_color == 'custom' ? 'btn-text-custom-color' : $btn_text_color;
						$ret .= ' ' . $btn_text_color;
					}

					$ret .= '"'; // end class

					if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

					if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

				$ret .= '>';

					$ret .= $button_name;

				$ret .= '</button>';
			}

			return $ret;
		}

		/**
		 * TAGS
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param bool   $required
		 *   @param bool   $disabled
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function tags( $params ) { extract( $params );
			$ret = '';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) ) {

				if ( empty( $class ) )
					$class = '';

				if ( empty( $value ) && ! empty( $this->fields['slug'] ) )
					$value = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $this->fields['slug'], true );

				$ret .= '<div class="input-block text-right">';

					if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) { $class .= ' cf-required'; }

					$ret .= '<input type="text" name="' . $name . '" class="js-tags ' . $class . '"';

						if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

						$ret .= ' value="' . $value . '"';

					$ret .= ' />';

					$ret .= '<span class="charscounter">(' . __( 'separate your tags by comma', 'wpjobster' ) . ')</span>';

				$ret .= '</div>';
			}

			return $ret;
		}

		/**
		 * SLIDER
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param bool   $required
		 *   @param bool   $disabled
		 * @return html $ret
		 */
		public function slider( $params ) { extract( $params );
			$ret = '';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) ) {
				if ( ! WPJ_Form::isSetHasValue( $params, 'class' ) ) $class = '';
				if ( ! WPJ_Form::isSetHasValue( $params, 'sub_type' ) ) $sub_type = 'toggle';

				$checked     = $value == 'on' ? 'checked' : '';
				$slider_type = $sub_type == 'simple' ? 'slider' : 'toggle';
				$disabled    = WPJ_Form::isSetHasValue( $params, 'disabled' ) ? ' disabled' : '';

				$ret .= '<div class="ui ' . $slider_type . ' checkbox' . $disabled . '">';

					if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) { $class .= ' cf-required'; }

					$ret .= '<input type="hidden" name="' . $name . '" value="' . ( $value == 'on' ? 'on' : 'off' ) . '"';

						if ( WPJ_Form::isSetHasValue( $params, 'class' ) || $class ) { $ret .= ' class="' . $class . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

						if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

					$ret .= ' />';

					$ret .= '<input type="checkbox"' . $checked . ' value="on" class="slider_field" />';

					$ret .= '<label>' . WPJ_Form::isSetHasValue( $params, 'label' ) . '</label>';

				$ret .= '</div>';
			}

			return $ret;
		}

		/**
		 * GOOGLE MAP LOCATION
		 * @param array $params
		 *   @param string $name
		 *   @param string $label
		 *   @param string $show_label
		 *   @param string $show_popup
		 *   @param string $type
		 *   @param string $sub_type
		 *   @param string $class
		 *   @param number $id
		 *   @param bool   $required
		 *   @param bool   $disabled
		 *   @param string $display_for
		 * @return html $ret
		 */
		public function googleMap( $params ) { extract( $params );
			$ret = '';

			if ( ! WPJ_Form::isSetHasValue( $params, 'class' ) ) $class = '';

			if ( WPJ_Form::isSetHasValue( $params, 'name' ) ) {

				// Location
				if ( WPJ_Form::isSetHasValue( $params, 'required' ) ) { $class .= ' cf-required'; }

				$ret .= '<div class="ui search js-location-autocomplete">';

					$ret .= '<div class="ui fluid clearable input">';

						$ret .= '<input type="text" name="' . $name . '" class="prompt br6' . $class . '"';

							if ( WPJ_Form::isSetHasValue( $params, 'placeholder' ) ) { $ret .= ' placeholder="' . $placeholder . '"'; }

							if ( WPJ_Form::isSetHasValue( $params, 'placeholder' ) ) { $ret .= ' data-replaceplaceholder="' . $placeholder . '"'; }

							if ( WPJ_Form::isSetHasValue( $params, 'id' ) ) { $ret .= ' id="' . $id . '"'; }

							if ( WPJ_Form::isSetHasValue( $params, 'value' ) ) { $ret .= ' value="' . $value . '"'; }

							if ( WPJ_Form::isSetHasValue( $params, 'disabled' ) ) { $ret .= ' disabled'; }

						$ret .= ' />';

						// Latitude
						if ( ! isset( $value_lat ) ) {
							$value_lat = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $this->fields['slug'] . '_lat', true );
						}

						$latitude_name   = WPJ_Form::isSetHasValue( $params, 'latitude_name' ) ? $latitude_name : $name . '_lat';
						$longitude_name  = WPJ_Form::isSetHasValue( $params, 'longitude_name' ) ? $longitude_name : $name . '_long';

						if ( WPJ_Form::isSetHasValue( $params, 'id' ) || WPJ_Form::isSetHasValue( $params, 'latitude_id' ) ) {
							$latitude_id  = WPJ_Form::isSetHasValue( $params, 'latitude_id' ) ? $latitude_id : $id . '_lat';
						}
						if ( WPJ_Form::isSetHasValue( $params, 'id' ) || WPJ_Form::isSetHasValue( $params, 'longitude_id' ) ) {
							$longitude_id = WPJ_Form::isSetHasValue( $params, 'longitude_id' ) ? $longitude_id : $id . '_long';
						}

						if ( WPJ_Form::isSetHasValue( $params, 'class' ) || WPJ_Form::isSetHasValue( $params, 'latitude_class' ) ) {
							$latitude_class  = WPJ_Form::isSetHasValue( $params, 'latitude_class' ) ? $latitude_class : $class . '-lat';
						}
						if ( WPJ_Form::isSetHasValue( $params, 'class' ) || WPJ_Form::isSetHasValue( $params, 'longitude_class' ) ) {
							$longitude_class = WPJ_Form::isSetHasValue( $params, 'longitude_class' ) ? $longitude_class : $class . '-long';
						}

						$ret .= '<input type="hidden" name="' . $latitude_name . '"';

							if ( ! empty( $latitude_id ) ) { $ret .= ' id="' . $latitude_id . '"'; }

							if ( ! empty( $latitude_class ) ) { $ret .= ' class="' . $latitude_class . '"'; }

							$ret .= ' value="' . $value_lat . '"';

						$ret .= ' />';

						// Longitude
						if ( ! isset( $value_long ) ) {
							$value_long = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $this->fields['slug'] . '_long', true );
						}

						$ret .= '<input type="hidden" name="' . $longitude_name . '"';

							if ( ! empty( $longitude_id ) ) { $ret .= ' id="' . $longitude_id . '"'; }

							if ( ! empty( $longitude_class ) ) { $ret .= ' class="' . $longitude_class . '"'; }

							$ret .= ' value="' . $value_long . '"';

						$ret .= ' />';

					$ret .= '</div>';

					$ret .= '<div class="results"></div>';

				$ret .= '</div>';

			}

			return $ret;
		}

		/**
		 * SHORTCODE
		 * @param array $params
		 *   @param string $shortcode
		 * @return html $ret
		 */
		public function shortcode( $params ) { extract( $params );
			$ret = '';

			if ( $shortcode ) {

				if ( is_page( wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ) ) ) {
					if ( preg_match_all( '/' . get_shortcode_regex() . '/s', $shortcode, $matches ) && array_key_exists( 3, $matches ) ) { parse_str( $matches[3][0], $output );
						$field_name = str_replace( ['"', "'"], "", $output['field'] );
						$ret .= '<input name="' . $this->page . '_cfield_' . $field_name . '_shortcode" type="text" value="' . get_user_meta( get_current_user_id(), $field_name, true ) . '" />';
					}

				} else {
					$ret .= do_shortcode( $shortcode );

				}

			}

			return $ret;
		}

		/**
		 * GET FIELDS CONTENT
		 * @param array $fields
		 * @param string $display_for
		 * @return array content, popup, label
		 */
		public function getFieldsContent( $fields = '', $display_for = 'public' ) {
			$this->fields = $fields;

			if ( $this->fields['type'] == 'text' && $this->fields['input_type'] ) {
				$f_sub_type = $this->fields['input_type'];
			} elseif ( $this->fields['type'] == 'select' && $this->fields['select_type'] ) {
				$f_sub_type = $this->fields['select_type'];
			} elseif ( $this->fields['type'] == 'slider' && $this->fields['slider_type'] ) {
				$f_sub_type = $this->fields['slider_type'];
			} elseif ( $this->fields['type'] == 'button' && $this->fields['button_type'] ) {
				$f_sub_type = $this->fields['button_type'];
			} else {
				$f_sub_type = $this->fields['type'];
			}

			$popup = WPJ_Form::isSetHasValue( $this->fields, 'show_instructions_popup' ) == 'false' ? 'no' : 'yes';
			$label = $this->fields['show_label'] == 'false' ? 'no' : 'yes';

			$value = $this->fields['input_value'];
			if ( ! $value || $value == '-' ) {
				$value = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $this->fields['slug'], true );

				if ( ! $value ) { /* for job old meta */
					$value = $this->meta_fnc_get( $this->pid, 'cfield_' . $this->fields['slug'], true );
				}
			}

			$value = apply_filters( 'wpj_' . $this->page . '_value_filter', $value, $this->pid, $this->page . '_cfield_' . $this->fields['slug'] );

			$params =  [
				'name'                  => $this->page . '_cfield_' . $this->fields['slug'],
				'label'                 => $this->fields['label'],
				'show_label'            => $this->fields['show_label'],
				'show_popup'            => WPJ_Form::isSetHasValue( $this->fields, 'show_instructions_popup' ),

				'type'                  => $this->fields['type'],
				'sub_type'              => $f_sub_type,

				'class'                 => $this->fields['class'],
				'id'                    => $this->fields['id'],

				'placeholder'           => $this->fields['placeholder'],

				'value'                 => $value,
				'values'                => $this->fields['values'],

				'select_search'         => $this->fields['enable_search_inside_select_option'],

				'time_format'           => $this->fields['time_format'],

				'size'                  => $this->fields['input_size'],
				'min'                   => $this->fields['input_min'],
				'max'                   => $this->fields['input_max'],
				'step'                  => $this->fields['input_step'],
				'maxlength'             => $this->fields['input_maxlength'],
				'pattern'               => $this->fields['input_pattern'],

				'labeled'               => $this->fields['input_labeled'],
				'label_content'         => $this->fields['input_label_content'],
				'label_left_content'    => $this->fields['input_label_left_content'],
				'label_right_content'   => $this->fields['input_label_right_content'],
				'label_alignment'       => $this->fields['input_label_alignment'],

				'with_icon'             => $this->fields['input_with_icon'],
				'icon_alignment'        => $this->fields['input_icon_alignment'],
				'icon_class'            => $this->fields['input_icon'],

				'dial_code'             => $this->fields['show_dial_code'],

				'cols'                  => $this->fields['textarea_cols'],
				'rows'                  => $this->fields['textarea_rows'],
				'resizable'             => $this->fields['textarea_resizable'],
				'wrap'                  => $this->fields['textarea_wrap'],

				'link_name'             => $this->fields['link_name'],
				'link_url'              => $this->fields['link_url'],
				'link_rel'              => $this->fields['link_rel'],
				'link_target'           => $this->fields['link_target'],

				'shortcode'             => ! empty( $this->fields['shortcode'] ) ? $this->fields['shortcode'] : '',

				'button_name'           => $this->fields['button_name'],
				'btn_url'               => $this->fields['button_url'],
				'btn_shape'             => $this->fields['button_shape'],
				'btn_width'             => $this->fields['button_width'],
				'btn_size'              => $this->fields['button_size'],
				'btn_bg_color'          => $this->fields['button_background_color'],
				'btn_bg_color_custom'   => $this->fields['button_custom_background_color'],
				'btn_text_color'        => $this->fields['button_text_color'],
				'btn_text_color_custom' => $this->fields['button_custom_text_color'],

				'disabled'              => $this->fields['disabled'],
				'required'              => $this->fields['required'],

				'display_for'           => $display_for
			];

			if ( $this->fields['type'] == 'text' ) {
				$content = $this->input_fields( $params );
			} elseif ( $this->fields['type'] == 'checkbox' || $this->fields['type'] == 'radio' || $this->fields['type'] == 'select' ) {
				$content = $this->defined_value_fields( $params );
			} elseif ( $this->fields['type'] == 'textarea' || $this->fields['type'] == 'wysiwyg' ) {
				$content = $this->textarea_fields( $params );
			} elseif  ( $this->fields['type'] == 'date' || $this->fields['type'] == 'time' || $this->fields['type'] == 'datetime' ) {
				$content = $this->date_fields( $params );
			} else {
				$method  = $this->fields['type'];
				$content = $this->$method( $params );
			}

			return [
				'content' => $content,
				'popup'   => $popup,
				'label'   => $label
			];
		}

		/**
		 * SAVE FIELD VALUES
		 */
		public function saveFieldsContent() {
			if ( isset( $_POST ) && $this->page ) {
				foreach ( $_POST as $key => $val ) {
					if ( strpos( $key, $this->page . '_cfield' ) !== false ) {

						if ( strpos( $key, '_attachments' ) !== false ) {
							// Save FILES
							if ( isset( $_POST[$key] ) && $_POST[$key] != "" ) {
								if ( $this->page != 'up' ) {
									if ( WPJ_Form::get( 'action' ) == 'edit-' . $this->page ) {
										wpj_save_attachments( $_POST[$key], $this->pid, $key, 'edit' );

									} else {
										wpj_save_attachments( $_POST[$key], $this->pid, $key, 'new' );

									}

								} else {
									wpj_save_attachments( $_POST[$key], $this->pid, $key, 'edit', 'user' );

								}
							}

						} elseif ( strpos( $key, '_date_field' ) !== false ) {
							// Save DATE INPUTES
							$val = wpj_is_timestamp( $val ) ? $val : strtotime( $val );
							$this->meta_fnc_update( $this->pid, $key, $val );

						} elseif ( strpos( $key, '_shortcode' ) !== false ) {
							$field_name = explode( '_', $key );
							$this->meta_fnc_update( $this->pid, $field_name[2], $val );

						} else {
							// Save INPUTS
							$this->meta_fnc_update( $this->pid, $key, $val );

						}

					}
				}
			}
		}

		/**
		 * DISPLAY FIELDS CONTENT BY LOCATION
		 * @param string $current_page
		 */
		public function displayFieldsContent( $current_page = '', $single_field = [] ) {

			$fields = '';
			if ( function_exists( 'get_field' ) ) {
				if ( $this->page == 'request' ) {
					$fields = get_field( 'request_fields', wpj_get_option( 'wpjobster_new_request_page_id' ) );

				} elseif ( $this->page == 'job' ) {
					$fields = get_field( 'job_fields', wpj_get_option( 'wpjobster_post_new_page_id' ) );

				} elseif ( $this->page == 'up' ) {
					$fields = get_field( $current_page, wpj_get_option( 'wpjobster_user_profile_page_id' ) );

				}
			}

			if ( $fields ) {

				$fields_data = [];

				foreach ( $fields as $fs_key => $field ) {

					$is_single_field = $single_field ? $single_field == $field : true;

					if ( strpos( $field['acf_fc_layout'], 'custom_field' ) !== false && $is_single_field ) {

						if (
							( ! isset ( $field['display_location'] ) && $this->page == 'up' ) ||
							( is_array( $field['display_location'] ) && in_array( $current_page, $field['display_location'] ) )
						) {

							$field_label    = $field['label'];
							$field_slug     = $field['slug'];
							$field_type     = $field['type'];
							$field_sub_type = $field['input_type'];

							if ( $field_type == 'datetime' || $field_type == 'date' || $field_type == 'time' ) {

								$field_value_meta = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $field_slug . '_date_field', true );

								if ( ! $field_value_meta ) {  /* for date old meta */
									$field_value_meta  = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $field_slug, true );
								}

							} elseif ( $field_type == 'tags' ) {

								$field_value_meta = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $field_slug, true );

							} else {

								$field_value_meta = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $field_slug, true );

								if ( ! $field_value_meta ) { /* for job old meta */
									$field_value_meta = $this->meta_fnc_get( $this->pid, 'cfield_' . $field_slug, true );
								}
							}

							if ( is_array( $field_value_meta ) ) {
								$field_value = implode( ', ', str_replace( '_', ' ', $field_value_meta ) );
							} else {
								$field_value = str_replace( '_', ' ', $field_value_meta );
							}

							$field_value_attch = $this->meta_fnc_get( $this->pid, $this->page . '_cfield_' . $field_slug . '_attachments', true );

							if ( ! $field_value_attch ) { /* for job and user profile old meta */

								$field_value_attch = $this->meta_fnc_get( $this->pid, 'cfield_hidden_files_cfield_' . $field_slug . '_attachments', true );

								if ( ! $field_value_attch ) {
									$field_value_attch = $this->meta_fnc_get( $this->pid, 'up_cfield_hidden_files_up_cfield_' . $field_slug . '_attachments', true );
								}

							}

							if ( $field_value || $field_type == 'link' || $field_type == 'button' ) {

								if ( $field_type == 'time' ) {

									$field_value = wpj_date( wpj_get_option( 'time_format' ) ? wpj_get_option( 'time_format' ) : 'H:i:s', $field_value );

								} elseif ( $field_type == 'date' ) {

									$field_value = wpj_date( wpj_get_option( 'date_format' ) ? wpj_get_option( 'date_format' ) : 'Y-m-d', $field_value );

								} elseif ( $field_type == 'datetime' ) {

									$date = wpj_get_option( 'date_format' ) ? wpj_get_option( 'date_format' ) : 'Y-m-d';
									$time = wpj_get_option( 'time_format' ) ? wpj_get_option( 'time_format' ) : 'H:i:s';

									$field_value = wpj_date( $date, $field_value ) .' '. wpj_date( $time, $field_value );

								} elseif ( $field_type == 'link' || $field_type == 'button' ) {

									$field_value = $this->getFieldsContent( $field )['content'];

								} elseif ( $field_type == 'slider' ) {

									$field_value = $field_value == 'on' ? _x( 'Yes', 'Custom field slider value', 'wpjobster' ) : _x( 'No', 'Custom field slider value', 'wpjobster' );

								} elseif ( $field_sub_type == 'color' ) {

									$field_value = '<span style="background-color: ' . $field_value . '; padding: 2px 5px;">' . $field_value . '</span>';

								} elseif ( $field_sub_type == 'url' ) {

									$field_value = '<a rel="nofollow" target="_blank" href="' . $field_value_meta . '">' . $field_value_meta . '</a>';

								} else echo '<style>.job-additional-details-row-wrapper{display:none;}</style>'; // for page builder

							} else echo '<style>.job-additional-details-row-wrapper{display:none;}</style>'; // for page builder

							$fields_data[] = [
								'current_page' => $current_page,
								'field'        => $field,
								'type'         => $field_type,
								'label'        => $field_label,
								'slug'         => $field_slug,
								'value'        => $field_value,
								'attch_value'  => $field_value_attch
							];

						} else echo '<style>.job-additional-details-row-wrapper{display:none;}</style>'; // for page builder

					} else echo '<style>.job-additional-details-row-wrapper{display:none;}</style>'; // for page builder
				}

				echo $this->{'get_' . $this->page . '_html_content'}( $fields_data );

			} else echo '<style>.job-additional-details-row-wrapper{display:none;}</style>'; // for page builder
		}

		/**
		 * DISPLAY HTML CONTENT FOR JOBS FIELDS VALUE
		 * @param array $fields
		 * @return html $ret
		 */
		public function get_job_html_content( $fields = [] ) {
			$ret = '';

			if ( $fields ) {

				// display as separate segment
				foreach ( $fields as $key => $params ) {

					if ( $params['value'] || $params['type'] == 'link' || $params['type'] == 'button' || wpj_post_has_attachments( $params['attch_value'] ) ) {

						$icon_class = WPJ_Form::isSetHasValue( $params['field'], 'title_icon' ) ? $params['field']['title_icon'] : 'info circle';
						$with_icon  = WPJ_Form::isSetHasValue( $params['field'], 'title_with_icon' ) && $params['current_page'] != 'chat_box' ? '<i class="' . $icon_class . ' icon cf-icon"></i>' : '';
						$h_size     = $params['current_page'] != 'chat_box' ? '2' : '3';

						if ( WPJ_Form::isSetHasValue( $params['field'], 'display_as' ) != 'common_tab' ) {

							if ( $params['current_page'] != 'chat_box' ) { $ret .= '<div class="ui segment">'; }

								$ret .= '<div class="' . $params['current_page'] . '-cf-title ' . $params['slug'] . '-cf-title ' . ( $params['current_page'] != 'chat_box' ? 'toggle-arrow js-toggle-arrow' : 'order-instructions' ) . '">';
									$ret .= '<h' . $h_size . '>' . $with_icon . $params['label'] . '</h' . $h_size . '>';
								$ret .= '</div>';

								if ( $params['current_page'] != 'chat_box' ) { $ret .= '<div class="ui divider"></div>'; }

								$ret .= '<div class="' . $params['slug'] . '-cf-content ' . $params['current_page'] . '-cf-content">';
									$ret .= '<p>' . $params['value'] . '</p>';

									if ( $params['type'] == 'googleMap' ) {
										$ret .= '<iframe class="request-google-map" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q=' . $params['value'] . '&output=embed"></iframe>';
									}

									if ( wpj_post_has_attachments( $params['attch_value'] ) ) {
										ob_start(); wpj_display_attachments_list( $params['attch_value'], $this->pid, $this->page . '_cfield_' . $params['slug'] . '_attachments', false, $params['label'], true, false );
										$ret .= ob_get_contents(); ob_end_clean();
									}
								$ret .= '</div>';

							if ( $params['current_page'] != 'chat_box' ) { $ret .= '</div>'; }

						} else {

							$common_tab_exists = true;

						}

					}

				}

				// display to additional details segment
				if ( isset( $common_tab_exists ) ) {

					if ( $params['current_page'] != 'chat_box' ) { $ret .= '<div class="ui segment">'; }

						$with_icon = $params['current_page'] != 'chat_box' ? '<i class="info circle icon mr10"></i>' : '';
						$h_size    = $params['current_page'] != 'chat_box' ? '2' : '3';

						$ret .= '<div class="' . $params['current_page'] . '-cf-title ' . $params['slug'] . '-cf-title ' . ( $params['current_page'] != 'chat_box' ? 'toggle-arrow js-toggle-arrow' : 'order-instructions' ) . '">';
							$ret .= '<h' . $h_size . '>' . $with_icon .  __( 'Additional Details', 'wpjobster' ) . '</h' . $h_size . '>';
						$ret .= '</div>';

						if ( $params['current_page'] != 'chat_box' ) { $ret .= '<div class="ui divider"></div>'; }

						$ret .= '<div class="' . $params['slug'] . '-cf-content ' . $params['current_page'] . '-cf-content">';

							foreach ( $fields as $key => $params ) {

								if ( $params['value'] || $params['type'] == 'link' || $params['type'] == 'button' || wpj_post_has_attachments( $params['attch_value'] ) ) {

									if ( WPJ_Form::isSetHasValue( $params['field'], 'display_as' ) == 'common_tab' ) {
										$ret .= '<div class="mb10"></div><b>' . $params['label'] . '</b><br>' . $params['value'];

										if ( wpj_post_has_attachments( $params['attch_value'] ) ) {
											ob_start(); wpj_display_attachments_list( $params['attch_value'], $this->pid, $this->page . '_cfield_' . $params['slug'] . '_attachments', false, '', true, false );
											$ret .= ob_get_contents(); ob_end_clean();
										}
									}
								}
							}

						$ret .= '</div>';

					if ( $params['current_page'] != 'chat_box' ) { $ret .= '</div>'; }

				}

			}

			return $ret;
		}

		/**
		 * DISPLAY HTML CONTENT FOR REQUEST FIELDS VALUE
		 * @param array $fields
		 * @return html $ret
		 */
		public function get_request_html_content( $fields = [] ) {
			$ret = '';

			foreach ( $fields as $key => $params ) {
				if ( $params['value'] || $params['type'] == 'link' || $params['type'] == 'button' || wpj_post_has_attachments( $params['attch_value'] ) ) {

					$ret .= '<div class="mb5 ' . $params['slug'] . ' ' . $params['current_page'] . '">';
						$ret .= '<span class="' . $this->page . '-label">' . $params['label'] . '</span>';
						$ret .= '<span class="punctuation-colon">: </span>';
						$ret .= '<span class="' . $this->page . '-value">' . $params['value'] . '</span>';
					$ret .=  '</div>';

					if ( $params['type'] == 'googleMap' ) {
						if ( $params['current_page'] == 'single_request' ) {
							$ret .= '<iframe class="request-google-map" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q=' . $params['value'] . '&output=embed"></iframe>';
						} else {
							$ret .= '<div class="request-map" data-address="' . $params['value'] . '"></div>';
						}
					}

					if ( wpj_post_has_attachments( $params['attch_value'] ) ) {
						$ret .= '<div class="mb5 attachments ' . $params['slug'] . ' ' . $params['current_page'] . '">';
							ob_start(); wpj_display_attachments_list( $params['attch_value'], $this->pid, $this->page . '_cfield_' . $params['slug'] . '_attachments', false, $params['label'], true, false );
							$ret .= ob_get_contents(); ob_end_clean();
						$ret .=  '</div>';
					}

				}
			}

			return $ret;
		}

		/**
		 * DISPLAY HTML CONTENT FOR USER PROFILE FIELDS VALUE
		 * @param array $fields
		 * @return html $ret
		 */
		public function get_up_html_content( $fields = [] ) {
			$ret = '';

			foreach ( $fields as $key => $params ) {
				if ( $params['value'] || $params['type'] == 'link' || $params['type'] == 'button' || $params['type'] == 'shortcode' || wpj_post_has_attachments( $params['attch_value'] ) ) {
					if ( wpj_post_has_attachments( $params['attch_value'] ) ) {
						ob_start(); wpj_display_attachments_list( $params['attch_value'], $this->pid, $this->page . '_cfield_' . $params['slug'] . '_attachments', false, $params['label'], false, false );
						$value = ob_get_contents(); ob_end_clean();

					} elseif ( $params['type'] == 'shortcode' ) {
						$value = do_shortcode( $params['field']['shortcode'] );

					} else {
						$value = $params['value'];

					}

					ob_start(); wpj_show_user_field_content( $params['current_page'], $params['label'], $value, 'up_custom_field' );

					$ret .= ob_get_contents(); ob_end_clean();

					if ( $params['type'] == 'googleMap' ) {
						$ret .= '<iframe class="request-google-map" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q=' . $params['value'] . '&output=embed"></iframe>';
					}
				}
			}

			return $ret;
		}

	}

}