<?php

/**
 * Check if $_GET or $_POST isset in order to assign it to a variable
 *
 * @package WPJobster
 * @subpackage Jobster
 * @since Jobster v3.5.0
 */

if ( ! class_exists( 'WPJ_Form' ) ) {
	class WPJ_Form extends stdClass {
		static function get( $key, $default_value = '' ) {
			if ( isset( $_GET[$key] ) ) {
				$value = is_array( $_GET[$key] ) ? array_map( 'trim', $_GET[$key] ) : trim( $_GET[$key] );

			} else {
				$value = $default_value;

			}

			return $value;
		}

		static function post( $key, $default_value = '' ) {
			if ( isset( $_POST[$key] ) ) {
				$value = is_array( $_POST[$key] ) ? array_map( 'trim', $_POST[$key] ) : trim( $_POST[$key] );

			} else {
				$value = $default_value;

			}

			return $value;
		}

		static function request( $key, $default_value = '' ) {
			if ( isset( $_REQUEST[$key] ) ) {
				$value = is_array( $_REQUEST[$key] ) ? array_map( 'trim', $_REQUEST[$key] ) : trim( $_REQUEST[$key] );

			} else {
				$value = $default_value;

			}

			return $value;
		}

		static function cookie( $key, $default_value = '' ) {
			if ( isset( $_COOKIE[$key] ) ) {
				$value = is_array( $_COOKIE[$key] ) ? array_map( 'trim', $_COOKIE[$key] ) : trim( $_COOKIE[$key] );

			} else {
				$value = $default_value;

			}

			return $value;
		}

		static function isSetHasValue( $array, $key ) {
			if ( $array && $key ) {
				$array = array_change_key_case( $array, CASE_LOWER );
				$key   = strtolower( $key );

				if ( isset( $array[$key] ) && $array[$key] && $array[$key] != 'false' ) {
					return $array[$key];
				}
			}

			return false;
		}

		static function optionHasValue( $option_name = '', $default = '' ) {
			$current_opt = wpj_get_option( $option_name );

			if ( $option_name ) {
				if ( ! empty( trim( $current_opt ) ) ) {
					return $current_opt;

				} elseif ( $default ) {
					return $default;

				}
			}

			return 0;
		}
	}
}