<?php
if ( ! function_exists( 'wpj_display_recaptcha_field' ) ) {
	function wpj_display_recaptcha_field( $identifier = 'g-recaptcha' ) {
		if ( $identifier == 'default_login' ) {
			$option = 'wpjobster_enable_user_login_reCaptcha';
		} elseif ( $identifier == 'default_register' ) {
			$option = 'wpjobster_enable_user_register_reCaptcha';
		}

		if (
			! empty( $option )
			&& wpj_get_option( $option ) == 'yes'
			&& wpj_get_option( 'wpjobster_recaptcha_api_key' )
			&& wpj_get_option( 'wpjobster_recaptcha_api_secret' )
		) {
			wpj_get_template( 'elements/authentication/recaptcha-field-template.php', [
				'identifier'           => $identifier,
				'language_code'        => substr( get_bloginfo ( 'language' ), 0, 2 ),
				'reCaptcha_enabled'    => wpj_get_option( 'wpjobster_enable_user_reCaptcha' ),
				'reCaptcha_api_key'    => wpj_get_option( 'wpjobster_recaptcha_api_key' ),
				'recaptcha_api_secret' => wpj_get_option( 'wpjobster_recaptcha_api_secret' )
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_2fa_field' ) ) {
	function wpj_display_2fa_field() {
		if ( wpj_get_option( 'wpjobster_enable_user_2fa' ) == 'yes' && get_user_meta( wpj_get_user_id_by_IP(), 'user_2fa', true ) == 'on' ) {
			include_once get_template_directory() . '/vendor/google-authenticator/FixedBitNotation.php';
			include_once get_template_directory() . '/vendor/google-authenticator/GoogleAuthenticatorInterface.php';
			include_once get_template_directory() . '/vendor/google-authenticator/GoogleAuthenticator.php';
			include_once get_template_directory() . '/vendor/google-authenticator/GoogleQrUrl.php';
			include_once get_template_directory() . '/vendor/google-authenticator/RuntimeException.php';

			$g = new \Sonata\GoogleAuthenticator\GoogleAuthenticator();

			$secret = get_user_meta( preg_replace( "/[^0-9]/", "", wpj_get_user_ip() ), '2fa_secret_code', true );

			if ( ! $secret ) {
				$secret = $g->generateSecret();

				update_user_meta( preg_replace( "/[^0-9]/", "", wpj_get_user_ip() ), '2fa_secret_code', $secret );
			}

			wpj_get_template( 'elements/authentication/2fa-field-template.php', ['secret' => $secret] );
		}
	}
}

if ( ! function_exists( 'wpj_display_phone_number_field' ) ) {
	function wpj_display_phone_number_field() {
		if ( wpj_get_option( 'wpjobster_enable_phone_number' ) == 'yes' ) {
			if ( wpj_get_option( 'wpjobster_phone_country_select' ) != 'autodetect' ) $default_country = wpj_get_option( 'wpjobster_phone_country_select' );
			else $default_country = wpj_get_country_code_by_ip( wpj_get_user_ip() );

			wpj_get_template( 'elements/authentication/phone-number-field-template.php', [
				'cell_number'     => WPJ_Form::post( 'cell_number' ),
				'default_country' => $default_country
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_company_field' ) ) {
	function wpj_display_company_field() {
		if ( wpj_get_option( 'wpjobster_enable_user_company' ) == 'yes' ) {
			wpj_get_template( 'elements/authentication/company-field-template.php', [
				'user_company' => WPJ_Form::post( 'user_company' )
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_password_field' ) ) {
	function wpj_display_password_field() {
		wpj_get_template( 'elements/authentication/password-field-template.php', [
			'user_pass'             => WPJ_Form::post( 'user_password' ),
			'user_confirm_password' => WPJ_Form::post( 'user_confirm_password' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_tos_field' ) ) {
	function wpj_display_tos_field() {
		wpj_get_template( 'elements/authentication/tos-field-template.php', [
			'tos_option'  => wpj_get_option( 'wpjobster_register_tos_and_privacy' ),
			'terms_url'   => get_permalink( wpj_get_option( 'wpjobster_terms_of_service_page_id' ) ),
			'privacy_url' => get_permalink( wpj_get_option( 'wpjobster_privacy_policy_page_id' ) )
		] );
	}
}

if ( ! function_exists( 'wpj_display_social_login_field' ) ) {
	function wpj_display_social_login_field( $provider_id, $provider_name, $authenticate_url ) {
		wpj_get_template( 'elements/authentication/social-login-field-template.php', [
			'authenticate_url' => $authenticate_url,
			'provider_name'    => $provider_name,
			'provider_id'      => $provider_id,
		] );
	}
}

if ( ! function_exists( 'wpj_display_keep_logged_in_field' ) ) {
	function wpj_display_keep_logged_in_field() {
		wpj_get_template( 'elements/authentication/keep-logged-in-field-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_forgot_password_field' ) ) {
	function wpj_display_forgot_password_field() {
		wpj_get_template( 'elements/authentication/forgot-password-field-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_or_field' ) ) {
	function wpj_display_or_field() {
		wpj_get_template( 'elements/authentication/or-field-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_already_field' ) ) {
	function wpj_display_already_field( $page = '' ) {
		$buttons_list = [];

		if ( $page == 'login' ) {
			$buttons_list = [
				'register' => [
					'label'   => __( 'Are you a member?', 'wpjobster' ),
					'url'     => wpj_get_register_link(),
					'a_class' => ''
				]
			];
		}

		if ( $page == 'register' ) {
			$buttons_list = [
				'login' => [
					'label'   => __( 'Already Registered?', 'wpjobster' ),
					'url'     => wpj_get_login_link(),
					'a_class' => ''
				],
			];
		}

		$buttons_list = apply_filters( 'wpj_header_button_filter', $buttons_list );

		if ( $buttons_list ) {
			wpj_get_template( 'elements/authentication/already-field-template.php', [
				'page'         => $page,
				'action'       => $page == 'register' ? 'login' : 'register',
				'buttons_list' => $buttons_list
			] );
		}
	}
}