<?php
if ( ! function_exists( 'wpj_display_blog_post_image' ) ) {
	function wpj_display_blog_post_image( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/blog/blog-post-image-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_blog_post_title' ) ) {
	function wpj_display_blog_post_title( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/blog/blog-post-title-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_blog_post_date' ) ) {
	function wpj_display_blog_post_date( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/blog/blog-post-date-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_blog_post_categories' ) ) {
	function wpj_display_blog_post_categories( $pid = '', $taxonomy = 'post_tag' ) {
		$pid   = wpj_get_post_id( $pid );
		$terms = get_the_terms( $pid, $taxonomy );

		wpj_get_template( 'elements/blog/blog-post-categories-template.php', [
			'pid'      => $pid,
			'taxonomy' => $taxonomy,
			'terms'    => $terms
		] );
	}
}

if ( ! function_exists( 'wpj_display_blog_post_content' ) ) {
	function wpj_display_blog_post_content( $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		wpj_get_template( 'elements/blog/blog-post-content-template.php', ['pid' => $pid] );
	}
}

if ( ! function_exists( 'wpj_display_blog_post_share' ) ) {
	function wpj_display_blog_post_share() {
		wpj_get_template( 'elements/blog/blog-post-share-template.php' );
	}
}

if ( ! function_exists( 'wpj_display_blog_post_comment_form' ) ) {
	function wpj_display_blog_post_comment_form( $pid = '' ) {
		$wpjobster_allow_comments_on_blog_news_pages = wpj_get_option( 'wpjobster_allow_comments_on_blog_news_pages' );

		if ( $wpjobster_allow_comments_on_blog_news_pages == 'yes' ) {
			if ( comments_open() ) {
				$pid = wpj_get_post_id( $pid );

				if ( is_user_logged_in() ) {
					$comment_form_args = [
						'logged_in_as'  => '',
						'class_submit'  => apply_filters( 'wpj_comment_button_classes_filter', 'ui primary button' ),
						'comment_field' => apply_filters( 'wpj_comment_form_html_filter', '<p class="comment-form-comment ui form"><textarea id="comment" name="comment" required="required" placeholder="' . __( 'Write a comment here', 'wpjobster' ) . '"></textarea></p>' ),
						'title_reply'   => __( 'Leave a Reply', 'wpjobster' ),
						'label_submit'  => __( 'Post Comment', 'wpjobster' ),
					];

					$comment_form_args = apply_filters( 'wpj_comment_form_args_filter', $comment_form_args );

					// Display comment form
					wpj_get_template( 'elements/blog/blog-post-comment-form-template.php', [
						'pid'               => $pid,
						'comment_form_args' => $comment_form_args
					] );
				}
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_blog_post_comments' ) ) {
	function wpj_display_blog_post_comments( $pid = '' ) {
		if ( wpj_get_option( 'wpjobster_allow_comments_on_blog_news_pages' ) == 'yes' ) {
			if ( comments_open() ) {
				$pid = wpj_get_post_id( $pid );

				if ( is_user_logged_in() ) {
					// Gather comments for a specific page/post
					$comments = get_comments( apply_filters( 'wpj_comments_args_filter', [
						'post_id' => $pid,
						'status'  => 'approve' // Change this to the type of comments to be displayed
					]) );

					$comments_args = [
						'style'             => 'div',
						'type'              => 'comment',
						'callback'          => 'wpj_display_comments_list_items',
						'reply_text'        => '',
						'avatar_size'       => 45,
						'reverse_top_level' => false // Show the oldest comments at the top of the list
					];

					$comments_args = apply_filters( 'wpj_comment_args_filter', $comments_args );

					// Display the list of comments
					wpj_get_template( 'elements/blog/blog-post-comments-template.php', [
						'pid'           => $pid,
						'comments'      => $comments,
						'comments_args' => $comments_args
					] );
				}
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_blog_search_form' ) ) {
	function wpj_display_blog_search_form( $post_type = '' ) {
		if ( ! $post_type ) {
			$post_type = get_post_type() != 'page' ? get_post_type() : 'post';
		}

		wpj_get_template( 'elements/blog/blog-search-form-template.php', [
			'post_type' => $post_type,
			'term'      => WPJ_Form::get( 's' )
		] );
	}
}

if ( ! function_exists( 'wpj_display_blog_categories' ) ) {
	function wpj_display_blog_categories( $taxonomy = 'category' ) {
		wpj_get_template( 'elements/blog/blog-categories-template.php', ['taxonomy' => $taxonomy] );
	}
}

if ( ! function_exists( 'wpj_display_blog_tags' ) ) {
	function wpj_display_blog_tags( $tags = '' ) {
		$term = get_queried_object();

		if ( ! $tags ) {
			if ( $term && $term->name == 'news' )
				$tags = wpj_get_tags_by_post_type( 'news' );

			elseif ( $term && $term->name == 'job' )
				$tags = wpj_get_tags_by_post_type( 'job' );

			elseif ( $term && $term->name == 'request' )
				$tags = wpj_get_tags_by_post_type( 'request' );

			elseif ( $term && $term->name == 'offer' )
				$tags = wpj_get_tags_by_post_type( 'offer' );

			else
				$tags = wpj_get_tags_by_post_type( 'post' );
		}

		wpj_get_template( 'elements/blog/blog-tags-template.php', ['tags' => $tags] );
	}
}