<?php
if ( ! function_exists( 'wpj_display_job_card_layout' ) ) {
	function wpj_display_job_card_layout( $post = '', $display_slider = 'true' ) {
		$jobster_design = wpj_get_design_option();

		if ( ! $post ) global $post;

		$pid = $post->ID;

		$userdata = wpj_get_userdata( $post->post_author );

		$home_featured_now        = get_post_meta( $pid, 'home_featured_until', true );
		$category_featured_now    = get_post_meta( $pid, 'category_featured_until', true );
		$subcategory_featured_now = get_post_meta( $pid, 'subcategory_featured_until', true );

		if ( $home_featured_now && $home_featured_now != 'z' ) {
			$job_is_featured = true;

		} elseif ( $category_featured_now && $category_featured_now != 'z' ) {
			$job_is_featured = true;

		} elseif ( $subcategory_featured_now && $subcategory_featured_now != 'z' ) {
			$job_is_featured = true;

		} else {
			$job_is_featured = false;

		}

		$postthumb_cnt_classes = '';

		$postthumb_cnt_classes .= ( $home_featured_now && $home_featured_now != 'z' ) ? ' featured_home ' : '';
		$postthumb_cnt_classes .= ( $category_featured_now && $category_featured_now != 'z' ) ? ' featured_category ' : '';
		$postthumb_cnt_classes .= ( $subcategory_featured_now && $subcategory_featured_now != 'z' ) ? ' featured_subcategory ' : '';

		$postthumb_cnt_classes .= ! empty( $jobster_design['enable_video_icon_cards'] ) && $jobster_design['enable_video_icon_cards'] == true && wpj_multidimensional_array_has_value( get_post_meta( $pid, 'video_link', true ) ) ? ' video_thumbnail ' : '';

		$ratinggrade = wpj_get_job_rating_percent( $pid );
		$ratinggrade = $ratinggrade / 20;

		$rating_count = wpj_get_option( 'wpjobster_job_min_rating' );
		$rating_count = $rating_count && is_numeric( $rating_count ) ? $rating_count : 3;

		$location_display = get_post_meta( $pid, 'location_input', true );
		$location_display = $location_display ? ' - ' . $location_display : '';

		$package_type       = get_post_meta( $pid, 'job_packages', true );
		$package_price      = get_post_meta( $pid, 'package_price', true );
		$package_price_vals = $package_type == 'yes' && $package_price ? array_diff( $package_price, [null]) : '';

		$height_class = empty( $jobster_design['wpjobster_user_level_for_thumbnails'] ) ? 'height-class' : '';

		$images_arr      = wpj_get_job_images( $pid );
		$video_arr       = get_post_meta( $pid, 'video_link', true );
		$slider_elements = $video_arr ? count( $images_arr ) + 1 : count( $images_arr );

		$review_samples = '';

		if ( wpj_get_option( 'wpjobster_enable_review_work_samples' ) == 'yes' ) {
			$review_samples  = wpj_get_job_review_images( $pid, wpj_get_option( 'wpjobster_max_review_work_samples' ) );
			$slider_elements = $slider_elements + count( $review_samples );
		}

		$icons_cnt = 0;

		if ( wpj_bool_option( 'wpjobster_enable_instant_delivery' ) && get_post_meta( $pid, "instant", true ) )
			$icons_cnt ++;

		if ( wpj_bool_option( 'wpjobster_lets_meet' ) && get_post_meta( $pid, 'lets_meet', true ) )
			$icons_cnt ++;

		if ( wpj_bool_option( 'wpjobster_html5_geolocation_enable' ) && ( $distance = wpj_get_distance_to_job_location( 'post', $pid ) ) )
			$icons_cnt ++;

		$shipping = get_post_meta( $pid, 'shipping', true );

		wpj_get_template( 'elements/card/card-' . wpj_get_job_card_style() . '-layout-template.php', [
			'pid'                   => $pid,
			'post'                  => $post,
			'userdata'              => $userdata,
			'job_is_featured'       => $job_is_featured,
			'postthumb_cnt_classes' => $postthumb_cnt_classes,
			'ratinggrade'           => $ratinggrade,
			'rating_count'          => $rating_count,
			'location_display'      => $location_display,
			'images_arr'            => $images_arr,
			'video_arr'             => $video_arr,
			'slider_elements'       => $slider_elements,
			'review_samples'        => $review_samples,
			'package_price_vals'    => $package_price_vals,
			'height_class'          => $height_class,
			'display_slider'        => $display_slider,
			'jobster_design'        => $jobster_design,
			'icons_cnt'             => $icons_cnt,
			'shipping'              => $shipping
		] );
	}
}

if ( ! function_exists( 'wpj_display_card_email_layout' ) ) {
	function wpj_display_card_email_layout( $results = [] ) {
		$count = $results ? count( $results ) : 0;

		if ( $count >= 3 ) $width_value = '33.33333333%';
		if ( $count == 2 ) $width_value = '50%';
		if ( $count == 1 ) $width_value = '100%';

		wpj_get_template( 'elements/card/card-email-layout-template.php', [
			'results'     => $results,
			'count'       => $count,
			'width_value' => isset( $width_value ) ? $width_value : 0,
			'i'           => 0
		] );
	}
}