<?php
if ( ! function_exists( 'wpj_display_job_carousel' ) ) {
	function wpj_display_job_carousel( $preview = false, $pid = '' ) {
		$pid = wpj_get_post_id( $pid );

		$video_arr       = get_post_meta( $pid, 'video_link', true );
		$images_arr      = wpj_get_job_images( $pid );
		$slider_elements = $video_arr ? count( $images_arr ) + 1 : count( $images_arr );

		if ( wpj_get_option( 'wpjobster_enable_review_work_samples' ) == 'yes' ) {
			$review_samples  = wpj_get_job_review_images( $pid, wpj_get_option( 'wpjobster_max_review_work_samples' ) );
			$slider_elements = $slider_elements + count( $review_samples );

		} else {
			$review_samples = '';

		}

		wpj_get_template( 'elements/carousel/job-carousel-template.php', [
			'pid'             => $pid,
			'preview'         => $preview,
			'video_arr'       => $video_arr,
			'images_arr'      => $images_arr,
			'slider_elements' => $slider_elements,
			'review_samples'  => $review_samples
		] );
	}
}

if ( ! function_exists( 'wpj_display_job_simplified_carousel' ) ) {
	function wpj_display_job_simplified_carousel( $dummy_content = false ) {
		$posts = get_posts(
			[
				'post_type'      => 'job',
				'post_status'    => 'publish',
				'orderby'        => [ 'meta_value' => 'ASC', 'date' => 'DESC' ],
				'posts_per_page' => 12,
				'meta_key'       => 'home_featured_now',
				'meta_query'     => [ [ 'key' => 'active', 'value' => '1', 'compare' => '=' ] ]
			]
		);

		if ( $posts ) {
			$sliders_info = [];

			foreach ( $posts as $key => $post ) {
				$sliders_info[$key] = [
					'employer_name'     => wpj_get_user_display_type( $post->post_author ),
					'employer_image'    => wpj_get_avatar( $post->post_author ),
					'category_job_name' => $post->post_title,
					'job_image'         => wpj_get_job_image( $post->ID ),
					'job_link'          => get_permalink( $post->ID )
				];
			}
		}

		if ( ! $posts || $dummy_content == true ) {
			$sliders_info = wpj_get_sliders_dummy_content();
		}

		wpj_get_template( 'elements/carousel/job-simplified-carousel-template.php', [
			'sliders_info' => $sliders_info
		] );
	}
}

if ( ! function_exists( 'wpj_display_work_sample_carousel' ) ) {
	function wpj_display_work_sample_carousel( $order = '', $user_type = 'buyer' ) {
		if ( ! $order ) {
			global $wp_query;

			if ( ! empty ( $wp_query->query_vars['oid'] ) ) {
				$order = wpj_get_job_order_by_id( $wp_query->query_vars['oid'] );
			}
		}

		if ( ! is_object( $order ) ) {
			$order = wpj_get_job_order_by_id( $order );
		}

		if ( ! empty( $order->id ) && $user_type == 'buyer' && wpj_get_option( 'wpjobster_enable_review_work_samples' ) == 'yes' ) {
			// Get all attachments by seller
			$seller_id = wpj_get_seller_id($order);

			$attachments_query = wpj_get_order_notification_message( 'attachment', ['oid' => $order->id, 'uid' => $seller_id], 'results' );

			$attachments_comma = '';

			if ( $attachments_query ) {
				foreach ( $attachments_query as $attachments_row ) {
					if ( ! empty( $attachments_row->attachment ) ) {
						$attachments_comma .= $attachments_comma ? ',' : '';
						$attachments_comma .= $attachments_row->attachment;
					}
				}
			}

			$attachments = explode( ',', $attachments_comma );
			$image_array = [];

			foreach ( $attachments as $image_id ) {
				$image_src = wpj_get_attachment_image_url( $image_id, 'job_slider_image' );

				if ( $image_src ) {
					$image_array[$image_id] = $image_src;
				}
			}

			if ( $image_array ) {
				wpj_get_template('elements/carousel/work-sample-carousel-template.php', [
					'counter' => 0,
					'image_array' => $image_array,
				] );
			}
		}
	}
}

if ( ! function_exists( 'wpj_display_posts_carousel' ) ) {
	function wpj_display_posts_carousel( $articles_no = 10, $type = 'news', $posts_only_from_category = false ) {
		$jobster_design = wpj_get_design_option();

		if ( $type == 'post' ) {
			$no_image_src = ! empty( $jobster_design['no_image_icon_options_blog']['url'] ) ? $jobster_design['no_image_icon_options_blog']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';
			$no_image_src = apply_filters( 'wpj_placeholder_image_url_filter', $no_image_src, 'blog' );

		} else {
			$no_image_src = ! empty( $jobster_design['no_image_icon_options_news']['url'] ) ? $jobster_design['no_image_icon_options_news']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';
			$no_image_src = apply_filters( 'wpj_placeholder_image_url_filter', $no_image_src, 'news' );

		}

		$args = [
			'post_type'      => $type,
			'post_status'    => 'publish',
			'posts_per_page' => $articles_no,
			'orderby'        => 'rand'
		];

		if ( $posts_only_from_category ) {
			global $post;

			$pid = $post->ID;

			if ( $type == 'post' ) $taxonomy = 'category';
			else $taxonomy = 'news_cat';

			$args['tax_query'] = [
				[
					'taxonomy' => $taxonomy,
					'field'    => 'id',
					'terms'    => wp_get_object_terms( $pid, $taxonomy, [ 'fields' => 'ids' ] )
				]
			];

			$args['post__not_in'] = [$pid];
		}

		$posts = new WP_Query( $args );

		wpj_get_template( 'elements/carousel/posts-carousel-template.php', [
			'posts'        => $posts,
			'no_image_src' => $no_image_src
		] );
	}
}

if ( ! function_exists( 'wpj_display_posts_hero_slider' ) ) {
	function wpj_display_posts_hero_slider( $articles_no = 3, $type = 'news' ) {
		$jobster_design = wpj_get_design_option();

		if ( $type == 'post' ) {
			$no_image_src = ! empty( $jobster_design['no_image_icon_options_blog']['url'] ) ? $jobster_design['no_image_icon_options_blog']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';
			$no_image_src = apply_filters( 'wpj_placeholder_image_url_filter', $no_image_src, 'blog' );

		} else {
			$no_image_src = ! empty( $jobster_design['no_image_icon_options_news']['url'] ) ? $jobster_design['no_image_icon_options_news']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';
			$no_image_src = apply_filters( 'wpj_placeholder_image_url_filter', $no_image_src, 'news' );

		}

		$args = [
			'post_type'      => $type,
			'post_status'    => 'publish',
			'posts_per_page' => $articles_no,
			'orderby'        => 'rand'
		];

		$posts = new WP_Query( $args );

		wpj_get_template( 'elements/carousel/posts-hero-slider-template.php', [
			'posts'        => $posts,
			'no_image_src' => $no_image_src
		] );
	}
}

if ( ! function_exists( 'wpj_display_home_hero_carousel' ) ) {
	function wpj_display_home_hero_carousel() {
		wpj_get_template( 'elements/carousel/home-hero-carousel-template.php', [
			'categories'     => get_categories( [ 'taxonomy' => 'job_cat', 'parent' => 0, 'hide_empty' => false ] ),
			'sliders_info'   => wpj_get_sliders_dummy_content(),
			'price_type_arr' => wpj_get_job_price_types(),
			'levels_arr'     => [ __( 'Rookie Seller', 'wpjobster' ), __( 'Master Seller', 'wpjobster' ), __( 'Top Rated Seller', 'wpjobster' ) ]
		] );
	}
}

if ( ! function_exists( 'wpj_display_category_icons_carousel' ) ) {
	function wpj_display_category_icons_carousel() {
		wpj_get_template( 'elements/carousel/category-icons-carousel-template.php', [
			'categories' => get_categories( [ 'taxonomy' => 'job_cat', 'parent' => 0, 'hide_empty' => false ] )
		] );
	}
}

if ( ! function_exists( 'wpj_display_category_images_carousel' ) ) {
	function wpj_display_category_images_carousel() {
		wpj_get_template( 'elements/carousel/category-images-carousel-template.php', [
			'categories' => get_categories( [ 'taxonomy' => 'job_cat', 'parent' => 0, 'hide_empty' => false ] )
		] );
	}
}

if ( ! function_exists( 'wpj_display_user_reviews_carousel' ) ) {
	function wpj_display_user_reviews_carousel( $uid = '' ) {
		if ( ! $uid ) $uid = wpj_get_user_id();

		wpj_get_template( 'elements/carousel/user-reviews-carousel-template.php', [
			'uid'     => $uid,
			'reviews' => wpj_get_user_reviews( $uid )
		] );
	}
}