<?php
/* Category page segment */
if ( ! function_exists( 'wpj_display_subcategories_list_of_current_category' ) ) {
	function wpj_display_subcategories_list_of_current_category( $taxonomy_name = 'job_cat' ) {
		$jobster_design = wpj_get_design_option();

		$op_name = $taxonomy_name == 'request_cat' ? 'wpjobster_display_request_empty_categories' : 'wpjobster_display_job_empty_categories';

		$hide_empty_categories = ( wpj_get_option( $op_name ) == 'yes' ) ? false : true;

		$term = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

		if ( isset( $term->term_id ) ) {
			$term_id       = $term->parent == 0 ? $term->term_id : $term->parent;
			$taxonomy_name = get_query_var( 'taxonomy' ) ? get_query_var( 'taxonomy' ) : $taxonomy_name;
			$termchildren  = get_terms( $taxonomy_name, ['child_of' => $term_id, 'hide_empty' => $hide_empty_categories]);
		}

		if ( $taxonomy_name == 'request_cat' ) {
			$enable_slider = ! empty( $jobster_design['request_subcategories_slider'] ) && $jobster_design['request_subcategories_slider'] == true;

		} else {
			$enable_slider = ! empty( $jobster_design['job_subcategories_slider'] ) && $jobster_design['job_subcategories_slider'] == true;

		}

		wpj_get_template( 'elements/category/subcategories-list-of-current-category-template.php', [
			'taxonomy_name' => isset( $taxonomy_name ) ? $taxonomy_name : '',
			'termchildren'  => isset( $termchildren ) ? $termchildren : '',
			'term'          => $term,
			'enable_slider' => $enable_slider
		] );
	}
}

if ( ! function_exists( 'wpj_display_post_category_and_subcategory' ) ) {
	function wpj_display_post_category_and_subcategory( $pid = 0, $taxonomy = 'job_cat' ) {
		$pid = wpj_get_post_id( $pid );

		if ( $pid > 0 ) {
			$post = get_post( $pid );

		} else {
			global $post;

			$post = get_post( $post->ID );
		}

		if ( ! $post ) {
			return;
		}

		$breadcrumbs = wpj_get_category_breadcrumbs( $post, $taxonomy );

		wpj_get_template('elements/category/post-category-and-subcategory-template.php', [
			'payment_type' => wpj_get_payment_info_by_url( 'payment_type' ),
			'pid'          => $pid,
			'custom_extra' => wpj_get_payment_info_by_url( 'custom_extra' ),
			'tip'          => wpj_get_payment_info_by_url( 'tip' ),
			'breadcrumbs'  => $breadcrumbs
		]);
	}
}


if ( ! function_exists( 'wpj_display_popular_categories' ) ) {
	function wpj_display_popular_categories( $taxonomy = 'job_cat', $number = 6, $display_title = 'no' ) {
		$terms = get_terms( $taxonomy, ['orderby' => 'count', 'order' => 'DESC', 'number' => $number, 'hierarchical' => false] );

		wpj_get_template( 'elements/category/popular-categories-template.php', [
			'terms'         => $terms,
			'taxonomy'      => $taxonomy,
			'display_title' => $display_title
		] );
	}
}

if ( ! function_exists( 'wpj_display_categories_and_subcategories_select' ) ) {
	function wpj_display_categories_and_subcategories_select( $taxonomy_name = '', $term_type = '', $include_empty_option = '', $select_class = '', $select_name = '', $select_id = "", $select_value = "", $select_multiple = '', $big = false ) {
		$taxonomy_name        = WPJ_Form::post( 'taxonomy_name', $taxonomy_name );
		$term_type            = WPJ_Form::post( 'term_type', $term_type );
		$include_empty_option = WPJ_Form::post( 'include_empty_option', $include_empty_option );
		$select_class         = WPJ_Form::post( 'select_class', $select_class );
		$select_name          = WPJ_Form::post( 'select_name', $select_name );
		$select_id            = WPJ_Form::post( 'select_id', $select_id );
		$select_value         = WPJ_Form::post( 'select_value', $select_value );
		$select_multiple      = WPJ_Form::post( 'select_multiple', $select_multiple );

		$args  = "orderby=name&order=ASC&hide_empty=0&parent=0";
		$terms = get_terms( $taxonomy_name, $args );

		$select_name     = $select_multiple ? $select_name . '[]' : $select_name;
		$select_multiple = $select_multiple ? 'multiple="multiple"' : '';

		if ( $include_empty_option == '1' ) {
			$include_empty_option = _( 'Select category or subcategory', 'wpjobster' );
		}

		if ( ! $select_value ) $select_value = -1;

		wpj_get_template( 'elements/category/categories-and-subcategories-select-template.php', [
			'taxonomy_name'        => $taxonomy_name,
			'term_type'            => $term_type,
			'include_empty_option' => $include_empty_option,
			'select_class'         => $select_class,
			'select_name'          => $select_name,
			'select_id'            => $select_id,
			'select_value'         => $select_value,
			'select_multiple'      => $select_multiple,
			'terms'                => $terms,
			'big'                  => $big,
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_display_categories_select' ) ) {
	function wpj_display_categories_select( $taxonomy_name = "job_cat", $term_type = "", $include_empty_option = "", $select_class = "", $select_name = "", $select_id = "", $select_value = "", $select_multiple = false, $extra_params = "" ) {
		$taxonomy_name        = WPJ_Form::post( 'taxonomy_name', $taxonomy_name );
		$term_type            = WPJ_Form::post( 'term_type', $term_type );
		$include_empty_option = WPJ_Form::post( 'include_empty_option', $include_empty_option );
		$select_class         = WPJ_Form::post( 'select_class', $select_class );
		$select_name          = WPJ_Form::post( 'select_name', $select_name );
		$select_id            = WPJ_Form::post( 'select_id', $select_id );
		$select_value         = WPJ_Form::post( 'select_value', $select_value );
		$select_multiple      = WPJ_Form::post( 'select_multiple', $select_multiple );
		$extra_params         = WPJ_Form::post( 'extra_params', $extra_params );

		$args  = "orderby=name&order=ASC&hide_empty=0&parent=0";
		$terms = get_terms( $taxonomy_name, $args );

		$select_name     = $select_multiple ? $select_name . '[]' : $select_name;
		$select_multiple = $select_multiple ? 'multiple="multiple"' : '';

		wpj_get_template( 'elements/category/categories-select-template.php', [
			'taxonomy_name'        => $taxonomy_name,
			'term_type'            => $term_type,
			'include_empty_option' => $include_empty_option,
			'select_class'         => $select_class,
			'select_name'          => $select_name,
			'select_id'            => $select_id,
			'select_value'         => $select_value,
			'select_multiple'      => $select_multiple,
			'extra_params'         => $extra_params,
			'terms'                => $terms,
		] );

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_display_subcategories_select' ) ) {
	function wpj_display_subcategories_select( $taxonomy_name = "job_cat", $term_type = "id", $include_empty_option = "", $select_class = "", $select_name = "subcat", $select_id = "subcat", $select_category_value = "", $select_subcategory_value = "", $select_multiple = false, $extra_params = "" ) {
		$taxonomy_name            = WPJ_Form::post( 'taxonomy_name', $taxonomy_name );
		$term_type                = WPJ_Form::post( 'term_type', $term_type );
		$include_empty_option     = WPJ_Form::post( 'include_empty_option', $include_empty_option );
		$select_class             = WPJ_Form::post( 'select_class', $select_class );
		$select_name              = WPJ_Form::post( 'select_name', $select_name );
		$select_id                = WPJ_Form::post( 'select_id', $select_id );
		$select_category_value    = WPJ_Form::post( 'select_category_value', $select_category_value );
		$select_subcategory_value = WPJ_Form::post( 'select_subcategory_value', $select_subcategory_value );
		$select_multiple          = WPJ_Form::post( 'select_multiple', $select_multiple );
		$extra_params             = WPJ_Form::post( 'extra_params', $extra_params );

		if ( $select_category_value ) {
			if ( $select_multiple ) {
				if ( is_array( $select_category_value ) ) {
					$select_category_value = implode( ',', $select_category_value );
				}

				$categories_id = explode( ',', $select_category_value );

				if ( $categories_id ) {
					$select_category_value = [];

					foreach ( $categories_id as $key => $value ) {
						if ( ! is_numeric( $value ) ) {
							$term_details = get_term_by( 'slug', $value, 'job_cat' );
							$value = $term_details->term_id;
						}

						$terms = get_term_children( $value, 'job_cat' );

						if ( $terms ) {
							foreach ( $terms as $term ) {
								$select_category_value[] = $term;
							}
						}
					}
				}

			} else {
				if ( is_array( $select_category_value ) ) {
					$select_category_value = $select_category_value[0];
				}

				if ( ! is_numeric( $select_category_value ) ) {
					$term_details          = get_term_by( 'slug', $select_category_value, 'job_cat' );
					$select_category_value = is_object( $term_details ) ? $term_details->term_id : '';
				}

			}

			if ( $select_category_value ) {
				$args2 = [
					'orderby'    => 'name',
					'order'      => 'ASC',
					'hide_empty' => 0,
				];

				if ( $select_multiple ) {
					$args2['include'] = $select_category_value;

				} else {
					$args2['parent'] = $select_category_value;

				}

				$sub_terms2      = get_terms( $taxonomy_name, $args2 );
				$select_name     = $select_multiple ? $select_name . '[]' : $select_name;
				$select_multiple = $select_multiple ? 'multiple="multiple"' : '';

				wpj_get_template( 'elements/category/subcategories-select-template.php', [
					'taxonomy_name'            => $taxonomy_name,
					'term_type'                => $term_type,
					'include_empty_option'     => $include_empty_option,
					'select_class'             => $select_class,
					'select_name'              => $select_name,
					'select_id'                => $select_id,
					'select_category_value'    => $select_category_value,
					'select_subcategory_value' => $select_subcategory_value,
					'select_multiple'          => $select_multiple,
					'extra_params'             => $extra_params,
					'sub_terms2'               => $sub_terms2,
				] );
			}
		}

		if ( wpj_is_ajax_call() ) wp_die();
	}
}

if ( ! function_exists( 'wpj_display_job_all_categories_and_subcategories' ) ) {
	function wpj_display_job_all_categories_and_subcategories( $include_parents_without_children = false, $parent_id = 0 ) {
		$terms = get_terms( 'job_cat', [
			'parent'     => $parent_id,
			'hide_empty' => 0,
		]);

		$count = count( $terms );
		$i     = 0;

		if ( $count > 0 ) {
			$contor      = 0;
			$nr          = 4;
			$total_count = 0;

			wpj_get_template( 'elements/category/job-all-categories-and-subcategories-template.php', [
				'terms'                    => $terms,
				'arr'                      => [],
				'count'                    => $count,
				'i'                        => $i,
				'contor'                   => $contor,
				'nr'                       => $nr,
				'total_count'              => $total_count,
				'parents_without_children' => $include_parents_without_children
			] );
		}
	}
}

if ( ! function_exists( 'wpj_display_post_category_name' ) ) {
	function wpj_display_post_category_name() {
		wpj_get_template( 'elements/category/post-category-name-template.php', ['term' => get_queried_object(), 'pid' => wpj_get_post_id()] );
	}
}

if ( ! function_exists( 'wpj_display_post_category_description' ) ) {
	function wpj_display_post_category_description() {
		wpj_get_template( 'elements/category/post-category-description-template.php', [
			'term'               => get_queried_object(),
			'hidden_description' => true
		] );
	}
}